/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.base.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.CoreBillBaseInfo;
import com.kingdee.eas.hr.base.AffairActionOperateEnum;
import com.kingdee.eas.hr.base.EmployeeTypeInfo;
import com.kingdee.eas.hr.base.HRBizDefChangeReasonCollection;
import com.kingdee.eas.hr.base.HRBizDefChangeReasonInfo;
import com.kingdee.eas.hr.base.HRBizDefEmpTypeCollection;
import com.kingdee.eas.hr.base.HRBizDefEmpTypeInfo;
import com.kingdee.eas.hr.base.HRBizDefOutEmpTypeCollection;
import com.kingdee.eas.hr.base.HRBizDefOutEmpTypeInfo;
import com.kingdee.eas.hr.base.HRBizDefVariationReasonCollection;
import com.kingdee.eas.hr.base.HRBizDefVariationReasonInfo;
import com.kingdee.eas.hr.base.HRBizDefineCollection;
import com.kingdee.eas.hr.base.HRBizDefineEntryCollection;
import com.kingdee.eas.hr.base.HRBizDefineEntryInfo;
import com.kingdee.eas.hr.base.HRBizDefineException;
import com.kingdee.eas.hr.base.HRBizDefineInfo;
import com.kingdee.eas.hr.base.StateEnum;
import com.kingdee.eas.hr.base.app.AbstractHRBizDefineControllerBean;
import com.kingdee.eas.hr.base.app.util.HRBizDefineAppUtils;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.shr.base.syssetting.util.LocaleUtils;
import com.kingdee.util.StringUtils;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Random;
import org.apache.log4j.Logger;

public class HRBizDefineControllerBean
extends AbstractHRBizDefineControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.hr.base.app.HRBizDefineControllerBean");

    @Override
    protected IObjectCollection _getHRBizDefineCollByUI(Context ctx, String uiClassName) throws BOSException, EASBizException {
        EntityViewInfo evi = new EntityViewInfo();
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("empTypeField"));
        sic.add(new SelectorItemInfo("inEmpTypes.empType.id"));
        sic.add(new SelectorItemInfo("inEmpTypes.empType.name"));
        sic.add(new SelectorItemInfo("inEmpTypes.empType.number"));
        sic.add(new SelectorItemInfo("inEmpTypes.empType.isOnTheStrength"));
        sic.add(new SelectorItemInfo("inEmpTypes.empType.inService"));
        sic.add(new SelectorItemInfo("inEmpTypes.empType.workRelation"));
        sic.add(new SelectorItemInfo("outEmpTypes.empType.id"));
        sic.add(new SelectorItemInfo("outEmpTypes.empType.name"));
        sic.add(new SelectorItemInfo("outEmpTypes.empType.number"));
        sic.add(new SelectorItemInfo("outEmpTypes.empType.isOnTheStrength"));
        sic.add(new SelectorItemInfo("outEmpTypes.empType.inService"));
        sic.add(new SelectorItemInfo("outEmpTypes.empType.workRelation"));
        sic.add(new SelectorItemInfo("outEmpTypes.empType.index"));
        sic.add(new SelectorItemInfo("outEmpTypes.empType.state"));
        sic.add(new SelectorItemInfo("actionReasons.actionReason.id"));
        sic.add(new SelectorItemInfo("actionReasons.actionReason.name"));
        sic.add(new SelectorItemInfo("actionReasons.actionReason.number"));
        sic.add(new SelectorItemInfo("actionReasons.actionReason.state"));
        sic.add(new SelectorItemInfo("variationReasons.variationReason.id"));
        sic.add(new SelectorItemInfo("variationReasons.variationReason.name"));
        sic.add(new SelectorItemInfo("variationReasons.variationReason.number"));
        sic.add(new SelectorItemInfo("variationReasons.variationReason.state"));
        sic.add(new SelectorItemInfo("employerUnit"));
        sic.add(new SelectorItemInfo("entrys.*"));
        evi.setSelector(sic);
        FilterInfo filerInfo = new FilterInfo();
        String idSql = "select FHrBizDefineID from T_HR_HRBillDefConfig where FAffairBizUI = '" + uiClassName + "'";
        filerInfo.getFilterItems().add(new FilterItemInfo("id", (Object)idSql, CompareType.INNER));
        filerInfo.getFilterItems().add(new FilterItemInfo("state", (Object)1));
        evi.setFilter(filerInfo);
        SorterItemCollection sortColl = new SorterItemCollection();
        SorterItemInfo sortItemInfo = new SorterItemInfo("number");
        sortItemInfo.setSortType(SortType.ASCEND);
        sortColl.add(sortItemInfo);
        evi.setSorter(sortColl);
        HRBizDefineCollection defConfig = this.getHRBizDefineCollection(ctx, evi);
        String sql = "select FHrBizDefineID from T_HR_HRBillDefConfig where FIsDefault = 1 and FAffairBizUI = ? ";
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{uiClassName});
        String defaultId = null;
        try {
            while (rs.next()) {
                defaultId = rs.getString("FHrBizDefineID");
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        if (StringUtils.isEmpty(defaultId)) {
            return defConfig;
        }
        HRBizDefineInfo defineInfo = null;
        for (int i = 0; i < defConfig.size(); ++i) {
            defineInfo = defConfig.get(i);
            if (!defineInfo.getId().toString().equals(defaultId)) continue;
            defineInfo.setDefault(true);
            defConfig.remove(defineInfo);
            defConfig.addObject(0, (IObjectValue)defineInfo);
            break;
        }
        return defConfig;
    }

    @Override
    protected void _setQuickAddNew(Context ctx, ArrayList idList) throws BOSException, EASBizException {
        if (idList == null || idList.size() == 0) {
            return;
        }
        HashSet<String> idSet = new HashSet<String>();
        for (int i = 0; i < idList.size(); ++i) {
            idSet.add(idList.get(i).toString());
        }
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", idSet, CompareType.INCLUDE));
        viewInfo.setFilter(filter);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("isQuickAddNew"));
        viewInfo.setSelector(sic);
        HRBizDefineCollection defineColl = this.getHRBizDefineCollection(ctx, viewInfo);
        for (int i = 0; i < defineColl.size(); ++i) {
            if (defineColl.get(i).isIsQuickAddNew()) {
                defineColl.get(i).setIsQuickAddNew(false);
            } else {
                defineColl.get(i).setIsQuickAddNew(true);
            }
            this.updatePartial(ctx, (CoreBaseInfo)defineColl.get(i), sic);
        }
    }

    @Override
    protected void _setEmpModify(Context ctx, ArrayList idList) throws BOSException, EASBizException {
        if (idList == null || idList.size() == 0) {
            return;
        }
        HashSet<String> idSet = new HashSet<String>();
        for (int i = 0; i < idList.size(); ++i) {
            idSet.add(idList.get(i).toString());
        }
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", idSet, CompareType.INCLUDE));
        viewInfo.setFilter(filter);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("isEmpModify"));
        viewInfo.setSelector(sic);
        HRBizDefineCollection defineColl = this.getHRBizDefineCollection(ctx, viewInfo);
        for (int i = 0; i < defineColl.size(); ++i) {
            if (defineColl.get(i).isIsEmpModify()) {
                defineColl.get(i).setIsEmpModify(false);
            } else {
                defineColl.get(i).setIsEmpModify(true);
            }
            this.updatePartial(ctx, (CoreBaseInfo)defineColl.get(i), sic);
        }
    }

    @Override
    protected void _copyAddNew(Context ctx, String billId) throws BOSException, EASBizException {
        HRBizDefVariationReasonCollection variationReasons;
        HRBizDefChangeReasonCollection reasons;
        HRBizDefOutEmpTypeCollection outEmpTypes;
        HRBizDefEmpTypeCollection inEmpTypes;
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("inEmpTypes.*"));
        sic.add(new SelectorItemInfo("outEmpTypes.*"));
        sic.add(new SelectorItemInfo("actionReasons.*"));
        sic.add(new SelectorItemInfo("variationReasons.*"));
        sic.add(new SelectorItemInfo("entrys.*"));
        HRBizDefineInfo oldInfo = this.getHRBizDefineInfo(ctx, (IObjectPK)new ObjectUuidPK(billId), sic);
        Random ran = new Random();
        String strHZ = "_copy";
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        String l = LocaleUtils.getShortCode((Context)ctx);
        StringBuffer filterSql = new StringBuffer("select Fid from T_HR_HRBizDefine  where Fname_" + l + " like  ").append("'%").append(oldInfo.getName()).append("%'");
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)filterSql.toString(), CompareType.INNER));
        view.setFilter(filter);
        int count = this.getCount(ctx, view);
        strHZ = count < 10 ? strHZ + "0" + count : strHZ + count;
        HRBizDefineInfo newInfo = new HRBizDefineInfo();
        newInfo.setId(BOSUuid.create((BOSObjectType)this.getBOSType()));
        newInfo.setNumber(oldInfo.getNumber() + strHZ);
        newInfo.setName(oldInfo.getName() + strHZ);
        newInfo.setIsControl(oldInfo.isIsControl());
        newInfo.setPositionStatus(oldInfo.getPositionStatus());
        newInfo.setIsQuickAddNew(oldInfo.isIsQuickAddNew());
        newInfo.setIsEmpModify(oldInfo.isIsEmpModify());
        newInfo.setAssignType(oldInfo.getAssignType());
        newInfo.setDescription(oldInfo.getDescription());
        newInfo.setBizDate(oldInfo.getBizDate());
        newInfo.setState(oldInfo.getState());
        newInfo.setOptDateField(oldInfo.getOptDateField());
        newInfo.setBizDefineType(oldInfo.getBizDefineType());
        newInfo.setEmployerUnit(oldInfo.getEmployerUnit());
        newInfo.setClassify(oldInfo.getClassify());
        newInfo.setIsPreset(false);
        newInfo.setEmpTypeField(oldInfo.getEmpTypeField());
        newInfo.setJuridicalPerson(oldInfo.getJuridicalPerson());
        HRBizDefineEntryCollection entrys = oldInfo.getEntrys();
        if (entrys != null) {
            HRBizDefineEntryInfo entryInfo = null;
            for (int i = 0; i < entrys.size(); ++i) {
                entryInfo = entrys.get(i);
                entryInfo.setId(BOSUuid.create((BOSObjectType)entryInfo.getBOSType()));
                entryInfo.setParent(newInfo);
            }
            newInfo.put("entrys", (Object)entrys);
        }
        if ((inEmpTypes = oldInfo.getInEmpTypes()) != null) {
            HRBizDefEmpTypeInfo inEmpTypeInfo = null;
            for (int i = 0; i < inEmpTypes.size(); ++i) {
                inEmpTypeInfo = inEmpTypes.get(i);
                inEmpTypeInfo.setId(BOSUuid.create((BOSObjectType)inEmpTypeInfo.getBOSType()));
                inEmpTypeInfo.setBizDefine(newInfo);
            }
            newInfo.setEmpTypes(inEmpTypes);
        }
        if ((outEmpTypes = oldInfo.getOutEmpTypes()) != null) {
            HRBizDefOutEmpTypeInfo outEmpTypeInfo = null;
            for (int i = 0; i < outEmpTypes.size(); ++i) {
                outEmpTypeInfo = outEmpTypes.get(i);
                outEmpTypeInfo.setId(BOSUuid.create((BOSObjectType)outEmpTypeInfo.getBOSType()));
                outEmpTypeInfo.setBizDefine(newInfo);
            }
            newInfo.setOutEmpTypes(outEmpTypes);
        }
        if ((reasons = oldInfo.getActionReasons()) != null) {
            HRBizDefChangeReasonInfo reasonInfo = null;
            for (int i = 0; i < reasons.size(); ++i) {
                reasonInfo = reasons.get(i);
                reasonInfo.setId(BOSUuid.create((BOSObjectType)reasonInfo.getBOSType()));
                reasonInfo.setHrBizDefine(newInfo);
            }
            newInfo.setActionReasons(reasons);
        }
        if ((variationReasons = oldInfo.getVariationReasons()) != null) {
            HRBizDefVariationReasonInfo hrBizDefVariationReasonInfo = null;
            for (int i = 0; i < variationReasons.size(); ++i) {
                hrBizDefVariationReasonInfo = variationReasons.get(i);
                hrBizDefVariationReasonInfo.setId(BOSUuid.create((BOSObjectType)hrBizDefVariationReasonInfo.getBOSType()));
                hrBizDefVariationReasonInfo.setHrbizDefine(newInfo);
            }
            newInfo.setVariationReasons(variationReasons);
        }
        this._addnew(ctx, (IObjectValue)newInfo);
    }

    @Override
    protected IObjectValue _getBizDefineQueryInfo(Context ctx, String id) throws BOSException, EASBizException {
        HRBizDefineInfo hRBizDefineInfo = this.getHRBizDefineInfo(ctx, (IObjectPK)new ObjectUuidPK(id), HRBizDefineAppUtils.getBizDefineSelector());
        return this.filterHRBizDefineInfo(hRBizDefineInfo);
    }

    public HRBizDefineInfo filterHRBizDefineInfo(HRBizDefineInfo hRBizDefineInfo) {
        HRBizDefineInfo hRBizDefineInfoCopy = (HRBizDefineInfo)hRBizDefineInfo.clone();
        HRBizDefEmpTypeCollection innerEmpTypesNewColl = new HRBizDefEmpTypeCollection();
        HRBizDefEmpTypeCollection innerEmpTypes = hRBizDefineInfo.getInEmpTypes();
        int size = innerEmpTypes.size();
        for (int i = 0; i < size; ++i) {
            HRBizDefEmpTypeInfo info = innerEmpTypes.get(i);
            EmployeeTypeInfo empType = info.getEmpType();
            if (2 == empType.getState().getValue()) continue;
            innerEmpTypesNewColl.add(info);
        }
        HRBizDefOutEmpTypeCollection outerEmpTypesNewColl = new HRBizDefOutEmpTypeCollection();
        HRBizDefOutEmpTypeCollection outEmpTypes = hRBizDefineInfo.getOutEmpTypes();
        int size2 = outEmpTypes.size();
        for (int j = 0; j < size2; ++j) {
            HRBizDefOutEmpTypeInfo info = outEmpTypes.get(j);
            EmployeeTypeInfo empType = info.getEmpType();
            if (2 == empType.getState().getValue()) continue;
            outerEmpTypesNewColl.add(info);
        }
        hRBizDefineInfoCopy.getInEmpTypes().clear();
        hRBizDefineInfoCopy.getOutEmpTypes().clear();
        hRBizDefineInfoCopy.put("inEmpTypes", (Object)innerEmpTypesNewColl);
        hRBizDefineInfoCopy.put("outEmpTypes", (Object)outerEmpTypesNewColl);
        return hRBizDefineInfoCopy;
    }

    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        this._checkNumberDup(ctx, model);
        this.verifyEntrys(ctx, model);
        return super._addnew(ctx, model);
    }

    protected void _update(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        this._checkNumberDup(ctx, model);
        this.verifyEntrys(ctx, model);
        super._update(ctx, pk, model);
    }

    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        HRBizDefineInfo hrBizDefineInfo = this.getHRBizDefineInfo(ctx, pk);
        if (1 == hrBizDefineInfo.getState().getValue()) {
            throw new HRBizDefineException(HRBizDefineException.ENABLE_CANNOT_DELETE);
        }
        if (hrBizDefineInfo.isIsPreset()) {
            throw new HRBizDefineException(HRBizDefineException.ISPRESET_CANNOT_DELETE);
        }
        hrBizDefineInfo.setIsHidden(true);
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add("isHidden");
        this.updatePartial(ctx, (CoreBaseInfo)hrBizDefineInfo, selector);
    }

    private void _checkNumberDup(Context ctx, IObjectValue model) throws EASBizException, BOSException {
        CoreBillBaseInfo coreBillBaseInfo = (CoreBillBaseInfo)model;
        FilterInfo filter = new FilterInfo();
        FilterItemInfo filterItem = new FilterItemInfo("number", (Object)coreBillBaseInfo.getString("number"), CompareType.EQUALS);
        filter.getFilterItems().add(filterItem);
        if (coreBillBaseInfo.getId() != null) {
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)coreBillBaseInfo.getId().toString(), CompareType.NOTEQUALS));
            filter.setMaskString("#0 and #1");
        }
        if (super._exists(ctx, filter)) {
            throw new HRBizDefineException(HRBizDefineException.NUMBER_IS_EXIST, new Object[]{coreBillBaseInfo.getString("number")});
        }
    }

    @Override
    protected void _enable(Context ctx, String id) throws BOSException, EASBizException {
        HRBizDefineInfo hrBizDefineInfo = this.getHRBizDefineInfo(ctx, (IObjectPK)new ObjectUuidPK(id));
        if (1 == hrBizDefineInfo.getState().getValue()) {
            throw new HRBizDefineException(HRBizDefineException.DISABLE_CAN_ENABLE);
        }
        hrBizDefineInfo.setState(StateEnum.ENABLE);
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add("state");
        this.updatePartial(ctx, (CoreBaseInfo)hrBizDefineInfo, selector);
    }

    @Override
    protected void _disable(Context ctx, String id) throws BOSException, EASBizException {
        HRBizDefineInfo hrBizDefineInfo = this.getHRBizDefineInfo(ctx, (IObjectPK)new ObjectUuidPK(id));
        if (2 == hrBizDefineInfo.getState().getValue()) {
            throw new HRBizDefineException(HRBizDefineException.ENABLE_CAN_DISABLE);
        }
        hrBizDefineInfo.setState(StateEnum.DISABLE);
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add("state");
        this.updatePartial(ctx, (CoreBaseInfo)hrBizDefineInfo, selector);
    }

    private void verifyEntrys(Context ctx, IObjectValue model) throws EASBizException {
        HRBizDefineInfo hrBizDefineInfo = (HRBizDefineInfo)model;
        HRBizDefineEntryCollection entrys = hrBizDefineInfo.getEntrys();
        if (entrys.size() < 1) {
            throw new HRBizDefineException(HRBizDefineException.ENTRYS_IS_NOT_NULL);
        }
        boolean positionTerminate = false;
        boolean positionAddNew = false;
        int positionTerminateSeq = 0;
        int positionAddNewSeq = 0;
        for (int i = 0; i < entrys.size(); ++i) {
            HRBizDefineEntryInfo hrBizDefineEntryInfo = entrys.get(i);
            AffairActionOperateEnum affairActionOperate = hrBizDefineEntryInfo.getAffairActionOperate();
            if (affairActionOperate.getValue() == 20) {
                positionTerminate = true;
                positionTerminateSeq = i;
            }
            if (affairActionOperate.getValue() != 10) continue;
            positionAddNew = true;
            positionAddNewSeq = i;
        }
        if (positionTerminate && !positionAddNew) {
            throw new HRBizDefineException(HRBizDefineException.ENTRYS_AFFAIRACTIONOPERATE_IS_ERROR);
        }
        if (positionTerminate && positionAddNew && positionTerminateSeq > positionAddNewSeq) {
            throw new HRBizDefineException(HRBizDefineException.ENTRYS_AFFAIRACTIONOPERATE_IS_ERROR);
        }
    }
}

