/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.base.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.service.ServiceStateManager;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.param.util.ParamManager;
import com.kingdee.eas.basedata.org.PositionFactory;
import com.kingdee.eas.basedata.org.PositionInfo;
import com.kingdee.eas.basedata.org.PositionMemberCollection;
import com.kingdee.eas.basedata.org.PositionMemberFactory;
import com.kingdee.eas.basedata.org.PositionMemberInfo;
import com.kingdee.eas.basedata.person.PersonFactory;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.hr.base.AffairActionLogState;
import com.kingdee.eas.hr.base.AffairActioniOperateException;
import com.kingdee.eas.hr.base.EmpHRORelationHisInfo;
import com.kingdee.eas.hr.base.EmpInfoSinglePageInfo;
import com.kingdee.eas.hr.base.EmpLaborRelationChangeInfo;
import com.kingdee.eas.hr.base.EmpLaborRelationDomainFacadeFactory;
import com.kingdee.eas.hr.base.EmpLaborRelationFactory;
import com.kingdee.eas.hr.base.EmpLaborRelationInfo;
import com.kingdee.eas.hr.base.EmpPosOrgRelationChangeInfo;
import com.kingdee.eas.hr.base.EmpPosOrgRelationCollection;
import com.kingdee.eas.hr.base.EmpPosOrgRelationInfo;
import com.kingdee.eas.hr.base.EmpPositionInfo;
import com.kingdee.eas.hr.base.EmpPostRankChangeInfo;
import com.kingdee.eas.hr.base.EmployeeTypeFactory;
import com.kingdee.eas.hr.base.EmployeeTypeInfo;
import com.kingdee.eas.hr.base.HRAffairActionTransactionLogDetailInfo;
import com.kingdee.eas.hr.base.HRAffairActionTransactionLogFactory;
import com.kingdee.eas.hr.base.HRAffairActionTransactionLogInfo;
import com.kingdee.eas.hr.base.HRBizData;
import com.kingdee.eas.hr.base.HRBizDefineEntryCollection;
import com.kingdee.eas.hr.base.HRBizDefineFactory;
import com.kingdee.eas.hr.base.HRBizDefineInfo;
import com.kingdee.eas.hr.base.HRBizDefineTypeEnum;
import com.kingdee.eas.hr.base.app.AffairActionDefManager;
import com.kingdee.eas.hr.base.app.EmpPosOrgRelationQueryHelper;
import com.kingdee.eas.hr.base.app.HRBillAppUtils;
import com.kingdee.eas.hr.base.app.IHRBizDefineProcesser;
import com.kingdee.eas.hr.base.app.PrePareHRBizDefineData;
import com.kingdee.eas.hr.base.app.plan.SHRActionVerifyByPersonPlanTool;
import com.kingdee.eas.hr.base.app.util.BusinessPluginManager;
import com.kingdee.eas.hr.base.app.util.SHREmpPosOrgRelationDomainUtil;
import com.kingdee.eas.hr.base.util.EmpEnrollUserPermHelper;
import com.kingdee.eas.hr.base.util.HRUtil;
import com.kingdee.eas.hr.emp.EmpPostRankInfo;
import com.kingdee.eas.hr.emp.EmpPostRankOptFacadeFactory;
import com.kingdee.eas.hr.emp.IPersonPosition;
import com.kingdee.eas.hr.emp.PersonPositionCollection;
import com.kingdee.eas.hr.emp.PersonPositionFactory;
import com.kingdee.eas.hr.emp.PersonPositionInfo;
import com.kingdee.eas.hr.emp.app.util.SHREmpOptBizManageTool;
import com.kingdee.eas.hr.emp.app.util.SHREmpOptEmpOrgRelationTool;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.shr.base.bizmanage.util.SHRBizManageCommonTool;
import com.kingdee.util.DateTimeUtils;
import com.kingdee.util.StringUtils;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HRBizDefineManager
implements IHRBizDefineProcesser {
    public static final Logger logger = LoggerFactory.getLogger(HRBizDefineManager.class);
    private final String PERSON_INIT_ACTION_NUMBER = "SHR24";

    @Override
    public void process(Context ctx, HRBizData bizData) throws EASBizException, BOSException {
        this.checkValid(ctx, bizData);
        Object isOverrideImportPerson = bizData.getNewPosition().getPersonInfo().get("isOverrideImportPerson");
        if (isOverrideImportPerson == null || isOverrideImportPerson != null && !((Boolean)isOverrideImportPerson).booleanValue()) {
            SHRActionVerifyByPersonPlanTool.verifyAffairActionByPersonPlan(ctx, bizData);
        }
        HRBizDefineInfo hrBizDefineInfo = bizData.getHrbizDefine();
        HRBizDefineEntryCollection defineEntryColl = hrBizDefineInfo.getEntrys();
        if (13 == hrBizDefineInfo.getBizDefineType().getValue()) {
            defineEntryColl.clear();
        }
        PrePareHRBizDefineData dataHelper = new PrePareHRBizDefineData();
        ArrayList<EmpPosOrgRelationChangeInfo> dataList = dataHelper.prepareData(ctx, bizData, defineEntryColl);
        EmpLaborRelationChangeInfo laborRelationChangeInfo = dataHelper.prepareLaborRelationChangeInfo(ctx, bizData, hrBizDefineInfo);
        EmpPostRankChangeInfo empPostRankChangeInfo = dataHelper.prepareEmpPostRankChangeInfo(bizData, hrBizDefineInfo);
        HRAffairActionTransactionLogInfo logInfo = this.assembleAffairActionLogInfo(ctx, bizData, dataList, laborRelationChangeInfo);
        IObjectPK logPK = HRAffairActionTransactionLogFactory.getLocalInstance(ctx).addnew((CoreBaseInfo)logInfo);
        bizData.setHRAffairActionTransactionLogID(logInfo.getAffairEntryID().toString());
        laborRelationChangeInfo.setEntryID(logPK.toString());
        EmpLaborRelationInfo empLaborRelationInfo = this.processLaborRelation(ctx, laborRelationChangeInfo);
        this.processAffairEntryID(bizData, logPK, empLaborRelationInfo, dataList, empPostRankChangeInfo);
        List<IObjectPK> posPKList = this.processEmpPosOrgRelation(ctx, dataList);
        this.processPositionMember(ctx, dataList);
        this.processEmpPostRank(ctx, empPostRankChangeInfo, bizData, posPKList);
        BusinessPluginManager buManager = new BusinessPluginManager(ctx, bizData);
        buManager.runPlugins();
        String entryIdForContract = bizData.getEntryID();
        if (StringUtils.isEmpty((String)bizData.getEntryID())) {
            entryIdForContract = logPK.toString();
        }
        this.doWithEmployeeContract(ctx, bizData, entryIdForContract);
        if (4 != hrBizDefineInfo.getBizDefineType().getValue() && 6 != hrBizDefineInfo.getBizDefineType().getValue() && 8 != hrBizDefineInfo.getBizDefineType().getValue()) {
            this.processUser(ctx, empLaborRelationInfo, laborRelationChangeInfo.getPersonInfo());
        }
        this.processResignPersonGKAdmin(ctx, laborRelationChangeInfo.getPersonInfo());
        if (13 != hrBizDefineInfo.getBizDefineType().getValue() && !"SHR24".equals(hrBizDefineInfo.getNumber()) && SHRBizManageCommonTool.checkHrBizDefine((Context)ctx, (String)hrBizDefineInfo.getNumber())) {
            SHREmpOptBizManageTool distributeTool = new SHREmpOptBizManageTool();
            distributeTool.writePersonEmpOrgChangeMsgData(ctx, bizData);
        }
        boolean isRealTimeSync = this.getIsRealTimeSync(ctx);
        PersonInfo pInfo = PersonFactory.getLocalInstance((Context)ctx).getPersonInfo((IObjectPK)new ObjectUuidPK(bizData.getNewPosition().getPersonInfo().getId()));
        if (isRealTimeSync) {
            logger.error("HRBizDefineManager.getIsRealTimeSync : " + isRealTimeSync);
            ServiceStateManager.getInstance().enableNextCallServices();
            pInfo.put("IS_FROM_SHR_OPTAction", (Object)Boolean.TRUE);
            if (pInfo.getGender() == null) {
                pInfo.put("gender", null);
            }
            PersonFactory.getLocalInstance((Context)ctx).update((IObjectPK)new ObjectUuidPK(pInfo.getId().toString()), (CoreBaseInfo)pInfo);
        }
        this.processPersonPositionPrimaryPosition(ctx, pInfo);
    }

    private EmpPostRankInfo processEmpPostRank(Context ctx, EmpPostRankChangeInfo empPostRankChangeInfo, HRBizData bizData, List<IObjectPK> posPKList) throws EASBizException, BOSException {
        EmpPostRankInfo empPostRankInfoProcess = null;
        empPostRankChangeInfo.setPosPKList(posPKList);
        empPostRankInfoProcess = (EmpPostRankInfo)EmpPostRankOptFacadeFactory.getLocalInstance((Context)ctx).personChangeToEmpPostRank(empPostRankChangeInfo);
        return empPostRankInfoProcess;
    }

    private EmpLaborRelationInfo processLaborRelation(Context ctx, EmpLaborRelationChangeInfo laborRelationChangeInfo) throws EASBizException, BOSException {
        EmpLaborRelationInfo laborRelationModify = EmpLaborRelationDomainFacadeFactory.getLocalInstance(ctx).laborRelationModify(laborRelationChangeInfo);
        return laborRelationModify;
    }

    private void processAffairEntryID(HRBizData bizData, IObjectPK logPK, EmpLaborRelationInfo empLaborRelationInfo, ArrayList dataList, EmpPostRankChangeInfo empPostRankChangeInfo) {
        EmpPosOrgRelationChangeInfo changeInfo;
        int i;
        if (StringUtils.isEmpty((String)bizData.getEntryID())) {
            for (i = 0; i < dataList.size(); ++i) {
                changeInfo = (EmpPosOrgRelationChangeInfo)dataList.get(i);
                changeInfo.setEntryID(logPK.toString());
            }
        }
        for (i = 0; i < dataList.size(); ++i) {
            changeInfo = (EmpPosOrgRelationChangeInfo)dataList.get(i);
            changeInfo.setLaborRelationInfo(empLaborRelationInfo);
        }
        if (empPostRankChangeInfo != null) {
            empPostRankChangeInfo.getEmpPostRankInfo().setFlowInAffairID(logPK.toString());
        }
    }

    private HRAffairActionTransactionLogInfo assembleAffairActionLogInfo(Context ctx, HRBizData bizData, ArrayList dataList, EmpLaborRelationChangeInfo laborRelationChangeInfo) throws EASBizException, BOSException {
        HRAffairActionTransactionLogInfo logInfo = new HRAffairActionTransactionLogInfo();
        if (!StringUtils.isEmpty((String)bizData.getLogPK())) {
            logInfo.setId(BOSUuid.read((String)bizData.getLogPK()));
        } else {
            logInfo.setId(BOSUuid.create((BOSObjectType)logInfo.getBOSType()));
        }
        logInfo.setPerson(bizData.getNewPosition().getPersonInfo());
        logInfo.setSourceAdmin(bizData.getOldPosition().getAdminInfo());
        logInfo.setSourcePosition(bizData.getOldPosition().getPositionInfo());
        logInfo.setSourceEmployeeType(bizData.getOldPosition().getEmployeeType());
        logInfo.setTargetAdmin(bizData.getNewPosition().getAdminInfo());
        logInfo.setTargetPosition(bizData.getNewPosition().getPositionInfo());
        logInfo.setTargetEmployeeType(bizData.getNewPosition().getEmployeeType());
        logInfo.setJobLevel(bizData.getJobLevelInfo());
        logInfo.setJobGrade(bizData.getJobGradeInfo());
        logInfo.setActionSourceReason(bizData.getActionSource());
        logInfo.setHrBizDefine(bizData.getHrbizDefine());
        logInfo.setActionType(bizData.getActionType());
        logInfo.setActionReason(bizData.getActionReason());
        logInfo.setLaborRelationState(laborRelationChangeInfo.getLaborRelationStateInfo());
        logInfo.setCorporateUnit(laborRelationChangeInfo.getCorporateUnit());
        logInfo.setSourceHrOrgUnit(bizData.getOldHrOrgUnitInfo());
        logInfo.setTargetHrOrgUnit(bizData.getHrOrgUnitInfo());
        logInfo.setSourceUseDefault(bizData.isOldUseDefault());
        logInfo.setTargetUseDefault(bizData.isUseDefault());
        if (StringUtils.isEmpty((String)bizData.getEntryID())) {
            logInfo.setAffairEntryID(logInfo.getId().toString());
        } else {
            logInfo.setAffairEntryID(bizData.getEntryID());
        }
        logInfo.setEffectDate(bizData.getStartDate());
        logInfo.setLogState(AffairActionLogState.addnew);
        if (bizData.isSupplementBill()) {
            logInfo.setNumber("SUPPLEMENT_BILL");
        } else if (bizData.isSameDatePersonChange()) {
            logInfo.setNumber("SAME_DATE_CHANGE");
        }
        for (int i = 0; i < dataList.size(); ++i) {
            EmpPosOrgRelationChangeInfo changeInfo = (EmpPosOrgRelationChangeInfo)dataList.get(i);
            HRAffairActionTransactionLogDetailInfo detailInfo = new HRAffairActionTransactionLogDetailInfo();
            detailInfo.setParent(logInfo);
            detailInfo.setActionOperate(changeInfo.getAffairOperate());
            detailInfo.setActionType(changeInfo.getActionType());
            detailInfo.setAdminorg(changeInfo.getPositionInfo().getAdminInfo());
            detailInfo.setPosition(changeInfo.getPositionInfo().getPositionInfo());
            detailInfo.setEmployeeType(changeInfo.getPositionInfo().getEmployeeType());
            detailInfo.setPositionstatu(changeInfo.getPositionInfo().getPositionStateEnum());
            detailInfo.setSeq(i + 1);
            logInfo.getDetail().add(detailInfo);
        }
        return logInfo;
    }

    private List<IObjectPK> processEmpPosOrgRelation(Context ctx, ArrayList dataList) throws EASBizException, BOSException {
        ArrayList<IObjectPK> pkList = new ArrayList<IObjectPK>();
        AffairActionDefManager manager = new AffairActionDefManager();
        EmpPosOrgRelationChangeInfo changeInfo = null;
        for (int i = 0; i < dataList.size(); ++i) {
            changeInfo = (EmpPosOrgRelationChangeInfo)dataList.get(i);
            IObjectPK positionAddNewPK = manager.operate(ctx, changeInfo);
            pkList.add(positionAddNewPK);
        }
        return pkList;
    }

    private void processPositionMember(Context ctx, ArrayList dataList) throws EASBizException, BOSException {
        EmpPosOrgRelationChangeInfo changeInfo = null;
        Boolean isSupplementPersonChange = this.IsSupplementPersonChange(ctx, dataList);
        int size = dataList.size();
        for (int i = 0; i < size; ++i) {
            int bizDefineTypeVal;
            changeInfo = (EmpPosOrgRelationChangeInfo)dataList.get(i);
            if (changeInfo.getAffairOperate().getValue() != 20 && changeInfo.getAffairOperate().getValue() != 70 && changeInfo.getAffairOperate().getValue() != 80 && changeInfo.getAffairOperate().getValue() != 100) continue;
            int n = bizDefineTypeVal = changeInfo.getActionDef() != null && changeInfo.getActionDef().getBizDefineType() != null ? changeInfo.getActionDef().getBizDefineType().getValue() : 1000;
            if (isSupplementPersonChange.booleanValue() || bizDefineTypeVal == 16 || bizDefineTypeVal == 7) continue;
            SHREmpPosOrgRelationDomainUtil.deletePositionMember(ctx, changeInfo);
        }
    }

    private Boolean IsSupplementPersonChange(Context ctx, ArrayList dataList) throws BOSException {
        EmpPosOrgRelationChangeInfo changeInfo = null;
        Boolean isSupplement = false;
        int size = dataList.size();
        for (int i = 0; i < size; ++i) {
            changeInfo = (EmpPosOrgRelationChangeInfo)dataList.get(i);
            if (changeInfo.getAffairOperate().getValue() != 10) continue;
            EmpPosOrgRelationQueryHelper queryhelper = new EmpPosOrgRelationQueryHelper();
            EmpPosOrgRelationCollection afterEmpPosOrgRelationColl = queryhelper.getAppointDateAfterPrimaryPosition(ctx, changeInfo.getPositionInfo().getPersonInfo().getId().toString(), changeInfo.getStartDate());
            isSupplement = afterEmpPosOrgRelationColl.size() > 0 && !changeInfo.isIsisSupplementAddnewPosition() ? Boolean.valueOf(true) : Boolean.valueOf(false);
        }
        return isSupplement;
    }

    private void checkValid(Context ctx, HRBizData bizData) throws EASBizException, BOSException {
        if (bizData == null || bizData.getHrbizDefine() == null || bizData.getOldPosition() == null || bizData.getNewPosition() == null) {
            throw new AffairActioniOperateException(AffairActioniOperateException.DATANOTVALID);
        }
        if (DateTimeUtils.dayAfter((Date)bizData.getStartDate(), (Date)new Date())) {
            throw new AffairActioniOperateException(AffairActioniOperateException.NOEFFECTFUTURE);
        }
        PersonInfo personInfo = bizData.getNewPosition().getPersonInfo();
        this.checkPersonInBuRelationBuilding(ctx, personInfo.getId().toString());
    }

    private void checkPersonInBuRelationBuilding(Context ctx, String personId) throws BOSException, EASBizException {
        EmpHRORelationHisInfo buInfo;
        EmpPosOrgRelationInfo info = SHREmpOptEmpOrgRelationTool.getCurrntMainEmpOrgRelationInfo((Context)ctx, (String)personId);
        if (info != null && "P/OSDCPfQXqU0TB/LQoA6uZovtk=".equals(info.getAction().getId().toString()) && (buInfo = SHREmpOptBizManageTool.getEmpHRORelationHisInfo((Context)ctx, (String)personId)) == null) {
            throw new AffairActioniOperateException(AffairActioniOperateException.ERROR_PERSONINIT_NO_EMPHRO);
        }
        StringBuilder sql = new StringBuilder("select Fid from T_HR_EmpOrgRelation eor where Fid not in (").append(" select rel.FEmpOrgRelationID  from T_HR_EmpHRORelationHis rel where eor.Fpersonid = rel.Fpersonid ) and FisInner=1 and FPersonId = '").append(personId).append("'");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        try {
            if (rs.next()) {
                throw new AffairActioniOperateException(AffairActioniOperateException.UPDATING_PERSON_BURELA);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw new BOSException((Throwable)e);
        }
    }

    private void processUser(Context ctx, EmpLaborRelationInfo empLaborRelationInfo, PersonInfo pInfo) throws EASBizException, BOSException {
        if (empLaborRelationInfo == null || empLaborRelationInfo.getLaborRelationState() == null) {
            return;
        }
        EmployeeTypeInfo empType = empLaborRelationInfo.getLaborRelationState();
        if (empType != null) {
            empType = EmployeeTypeFactory.getLocalInstance((Context)ctx).getEmployeeTypeInfo((IObjectPK)new ObjectUuidPK(empType.getId()));
        }
        if (empType != null && empType.getUserState() != null && empType.getUserState().getValue() == 2) {
            EmpEnrollUserPermHelper.autoForbidUser(ctx, pInfo);
        } else if (empType != null && empType.getUserState() != null && empType.getUserState().getValue() == 1) {
            EmpEnrollUserPermHelper.unForbidUser(ctx, pInfo);
        }
    }

    private void doWithEmployeeContract(Context ctx, HRBizData bizData, String entryId) throws BOSException, EASBizException {
        HRBizDefineInfo bizDefineInfo = bizData.getHrbizDefine();
        if (bizDefineInfo.getBizDefineType() == null) {
            bizDefineInfo = HRBizDefineFactory.getLocalInstance(ctx).getHRBizDefineInfo((IObjectPK)new ObjectUuidPK(bizData.getHrbizDefine().getId().toString()));
        }
        if (bizDefineInfo.getBizDefineType() == HRBizDefineTypeEnum.RESIGN || bizDefineInfo.getBizDefineType() == HRBizDefineTypeEnum.RETIRE || bizDefineInfo.getBizDefineType() == HRBizDefineTypeEnum.EMPHIRE || bizDefineInfo.getBizDefineType() == HRBizDefineTypeEnum.REINVITEFIRE) {
            EmpPositionInfo empPositionInfo = bizData.getNewPosition();
            Date terminateDate = bizData.getLeftCompanyDate();
            if (terminateDate == null) {
                terminateDate = HRUtil.getBeforeDate(bizData.getStartDate());
            }
            HRBillAppUtils.setContractState(ctx, empPositionInfo.getPersonInfo().getId().toString(), empPositionInfo.getEmployeeType().getId().toString(), bizDefineInfo, terminateDate, bizData.getEntryID());
        }
    }

    private void processResignPersonGKAdmin(Context ctx, PersonInfo personInfo) throws EASBizException, BOSException {
        String personId = personInfo.getId().toString();
        EmployeeTypeInfo empTypeInfo = this.getPersonCurrentEmployeeTypeInfo(ctx, personId);
        if (empTypeInfo != null && (2 == empTypeInfo.getInService().getValue() || 3 == empTypeInfo.getInService().getValue())) {
            String sql = "select FPersonDep from T_HR_PersonPosition where fpersonid='" + personId + "'";
            try {
                IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql);
                String fPersonDepId = null;
                if (rs.next()) {
                    fPersonDepId = rs.getString(1);
                }
                if (!StringUtils.isEmpty(fPersonDepId)) {
                    StringBuffer updateSql = new StringBuffer();
                    updateSql.append("update T_BD_PERSON set FGKAdmin = '").append(fPersonDepId).append("'").append(" where FID = '").append(personId).append("'");
                    DbUtil.execute((Context)ctx, (String)updateSql.toString());
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new BOSException((Throwable)e);
            }
        }
    }

    private EmployeeTypeInfo getPersonCurrentEmployeeTypeInfo(Context ctx, String personId) throws EASBizException, BOSException {
        String oql = "select laborRelationState.* where person.id='" + personId + "' and LEFFDT={ts'" + "2199-12-31" + "'}";
        EmployeeTypeInfo empTypeInfo = null;
        try {
            if (EmpLaborRelationFactory.getLocalInstance(ctx).exists(oql)) {
                empTypeInfo = EmpLaborRelationFactory.getLocalInstance(ctx).getEmpLaborRelationInfo(oql).getLaborRelationState();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BOSException((Throwable)e);
        }
        return empTypeInfo;
    }

    private void processPersonPositionPrimaryPosition(Context ctx, PersonInfo perInfo) throws EASBizException, BOSException {
        String oql = "select * where person.id='" + perInfo.getId() + "' and isPrimary=1";
        PositionMemberCollection pmColl = PositionMemberFactory.getLocalInstance((Context)ctx).getPositionMemberCollection(oql);
        if (pmColl.size() > 0) {
            PositionMemberInfo pmInfo = pmColl.get(0);
            PersonInfo personInfo = pmInfo.getPerson();
            IPersonPosition iPP = PersonPositionFactory.getLocalInstance((Context)ctx);
            PositionInfo pInfo = pmInfo.getPosition();
            pInfo = PositionFactory.getLocalInstance((Context)ctx).getPositionInfo((IObjectPK)new ObjectUuidPK(pInfo.getId()));
            if (iPP.exists("where person.id='" + personInfo.getId() + "'")) {
                PersonPositionCollection ppColl = iPP.getPersonPositionCollection("where person.id='" + personInfo.getId() + "'");
                PersonPositionInfo ppInfo = ppColl.get(0);
                ppInfo.setPrimaryPosition(pInfo);
                ppInfo.setPersonDep(pInfo.getAdminOrgUnit());
                iPP.update((IObjectPK)new ObjectUuidPK(ppInfo.getId()), (EmpInfoSinglePageInfo)ppInfo);
                iPP.reviseHistoryOnly((IObjectPK)new ObjectUuidPK(ppInfo.getId().toString()));
            } else {
                PersonPositionInfo ppInfo = new PersonPositionInfo();
                ppInfo.setPerson(pmInfo.getPerson());
                ppInfo.setPrimaryPosition(pInfo);
                ppInfo.setPersonDep(pInfo.getAdminOrgUnit());
                ppInfo.setEFFDT(perInfo.getEFFDT());
                BOSUuid ppId = BOSUuid.create((BOSObjectType)ppInfo.getBOSType());
                ppInfo.setId(ppId);
                iPP.addnew((EmpInfoSinglePageInfo)ppInfo);
            }
        }
    }

    private Boolean getIsRealTimeSync(Context ctx) {
        boolean isRealTimeSync = false;
        try {
            String isRealTimeSyncString = ParamManager.getParamValue((Context)ctx, null, (String)"SHR_EMPLOYEE_CHANGES_REAL_TIME_SYNC");
            if ("true".equals(isRealTimeSyncString)) {
                isRealTimeSync = true;
            }
        }
        catch (EASBizException e) {
            e.printStackTrace();
            logger.error(e.getMessage(), (Throwable)e);
        }
        catch (BOSException e) {
            e.printStackTrace();
            logger.error(e.getMessage(), (Throwable)e);
        }
        return isRealTimeSync;
    }
}

