/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.base.app.processor;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.eas.base.core.hr.util.HRParamUtil;
import com.kingdee.eas.basedata.person.IPerson;
import com.kingdee.eas.basedata.person.PersonCollection;
import com.kingdee.eas.basedata.person.PersonFactory;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.dynbusiness.ProcessorExecutionMode;
import com.kingdee.eas.dynbusiness.app.processor.AbstractBusinessProcessor;
import com.kingdee.eas.dynbusiness.app.processor.ProcessorConstructParam;
import com.kingdee.eas.framework.batchaction.BatchActionResults;
import com.kingdee.eas.hr.base.util.IDCardCommonUtil;
import com.kingdee.eas.hr.emp.PersonPositionCollection;
import com.kingdee.eas.hr.emp.PersonPositionFactory;
import com.kingdee.eas.hr.emp.PersonPositionInfo;
import com.kingdee.util.StringUtils;
import org.apache.log4j.Logger;

public class GetPersonByStrProcessor
extends AbstractBusinessProcessor {
    private boolean isIDCardVerify = true;
    private static final String paramNum = "IS_IDCARD_VERIFY";
    private static Logger logger = Logger.getLogger(GetPersonByStrProcessor.class);

    public GetPersonByStrProcessor(ProcessorConstructParam param) {
        super(param);
    }

    protected void doProcessing(BatchActionResults batchResults) throws BOSException, EASBizException {
        String str = (String)this.getExecuteContext().getApplicationContext().getData("str");
        String type = (String)this.getExecuteContext().getApplicationContext().getData("type");
        String hrOrgId = (String)this.getExecuteContext().getApplicationContext().getData("hrOrgId");
        PersonInfo info = null;
        FilterInfo filter = new FilterInfo();
        EntityViewInfo evi = new EntityViewInfo();
        if (type.equals("number")) {
            filter.getFilterItems().add(new FilterItemInfo("number", (Object)str));
        } else if (type.equals("idCardNumber")) {
            if (!StringUtils.isEmpty((String)hrOrgId)) {
                this.isIDCardVerify = this.isIDcardVerify(this.ctx, hrOrgId);
                new IDCardCommonUtil(str, this.isIDCardVerify);
            } else {
                new IDCardCommonUtil(str);
            }
            String _str = null;
            boolean isCheckIDCard18To15 = true;
            isCheckIDCard18To15 = HRParamUtil.getParamOfHR((Context)this.ctx, (String)"IsCheckIDCardNO18To15", null);
            _str = !isCheckIDCard18To15 ? str : (str.length() == 15 ? IDCardCommonUtil.IDCardNO15To18(str) : IDCardCommonUtil.IDCardNO18To15(str));
            filter.getFilterItems().add(new FilterItemInfo("idCardNO", (Object)str));
            filter.getFilterItems().add(new FilterItemInfo("idCardNO", (Object)_str));
            filter.setMaskString("#0 or #1");
        } else {
            filter.getFilterItems().add(new FilterItemInfo("passportNO", (Object)str));
        }
        evi.setFilter(filter);
        SelectorItemCollection selector = evi.getSelector();
        selector.add(new SelectorItemInfo("id"));
        selector.add(new SelectorItemInfo("name"));
        selector.add(new SelectorItemInfo("number"));
        selector.add(new SelectorItemInfo("idCardNO"));
        selector.add(new SelectorItemInfo("passportNO"));
        selector.add(new SelectorItemInfo("employeeType.id"));
        selector.add(new SelectorItemInfo("employeeType.number"));
        selector.add(new SelectorItemInfo("employeeType.name"));
        selector.add(new SelectorItemInfo("employeeType.inService"));
        selector.add(new SelectorItemInfo("gender"));
        selector.add(new SelectorItemInfo("birthday"));
        selector.add(new SelectorItemInfo("folk.id"));
        selector.add(new SelectorItemInfo("folk.number"));
        selector.add(new SelectorItemInfo("folk.name"));
        selector.add(new SelectorItemInfo("politicalFace.id"));
        selector.add(new SelectorItemInfo("politicalFace.number"));
        selector.add(new SelectorItemInfo("politicalFace.name"));
        selector.add(new SelectorItemInfo("homePhone"));
        selector.add(new SelectorItemInfo("homeAdress"));
        selector.add(new SelectorItemInfo("nativeAdress"));
        selector.add(new SelectorItemInfo("cell"));
        IPerson iPerson = PersonFactory.getLocalInstance((Context)this.ctx);
        PersonCollection pColl = iPerson.getPersonCollection(evi);
        if (pColl.size() > 0) {
            info = pColl.get(0);
            PersonPositionCollection ppColl = PersonPositionFactory.getLocalInstance((Context)this.ctx).getPersonPositionCollection("select *,dimissionReason.*,person.employeeType.* where person.id = '" + info.getId().toString() + "'");
            PersonPositionInfo ppInfo = null;
            if (ppColl.size() > 0) {
                ppInfo = ppColl.get(0);
                if (ppInfo.getPerson().getEmployeeType() != null && ppInfo.getPerson().getEmployeeType().getInService().getValue() == 2) {
                    info.put("DimissionReasonInfo", (Object)ppInfo.getDimissionReason());
                }
                info.put("PersonPosition", (Object)ppInfo);
            }
            info.put("type", (Object)type);
        }
        batchResults.setObjCollection((IObjectCollection)pColl);
    }

    public ProcessorExecutionMode supportExecutionMode() throws BOSException {
        return null;
    }

    public boolean isIDcardVerify(Context ctx, String hrOrgId) throws BOSException, EASBizException {
        this.isIDCardVerify = HRParamUtil.getParamOfHR((Context)ctx, (String)paramNum, (String)hrOrgId);
        logger.info((Object)("bd_personControlBean:Get isIDCardVerify Param " + this.isIDCardVerify + " From Hro " + hrOrgId));
        return this.isIDCardVerify;
    }
}

