/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.base.timezone;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.BOSObjectFactory;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.hr.base.HRCommonException;
import com.kingdee.eas.hr.base.timezone.CollectionUtil;
import com.kingdee.eas.hr.base.timezone.DataFetchModel;
import com.kingdee.eas.hr.base.timezone.Date;
import java.lang.reflect.ParameterizedType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class RangeDataFetcher<V extends CoreBaseInfo> {
    protected Logger logger = Logger.getLogger(this.getClass());
    protected Context ctx;
    protected Class<?> insClass;
    protected String effdtFieldName = "effdt";
    protected String leffdtFieldName = "leffdt";
    protected String filterObjFieldName = "person";
    protected DataFetchModel dataFetchModel;
    protected Object beginTime;
    protected Object endTime;
    protected boolean asendResult;
    protected List<Object> filterObjs;
    protected int batchIdCount;
    protected String selectSql;
    protected String filterSql;
    protected IObjectCollection resultCollection;

    public V fetchOne() throws EASBizException {
        this.innerFetch();
        if (this.resultCollection == null || this.resultCollection.size() == 0) {
            return null;
        }
        return (V)((CoreBaseInfo)this.resultCollection.iterator().next());
    }

    public IObjectCollection fetchCollection() throws EASBizException {
        this.innerFetch();
        return this.resultCollection;
    }

    public Map<String, List<V>> fetchMapData() throws EASBizException {
        this.innerFetch();
        if (this.resultCollection == null) {
            return new HashMap<String, List<V>>();
        }
        HashMap<String, List<List<V>>> returnData = new HashMap<String, List<List<V>>>();
        for (CoreBaseInfo coreBaseInfo : this.resultCollection) {
            String mapKey = String.valueOf(coreBaseInfo.getObjectValue(this.filterObjFieldName).get(this.getMapKey()));
            List<V> coreBaseList = returnData.get(mapKey);
            if (coreBaseList == null) {
                coreBaseList = new ArrayList<V>(6);
                returnData.put(mapKey, coreBaseList);
            }
            coreBaseList.add(coreBaseInfo);
        }
        return returnData;
    }

    protected String getMapKey() {
        return this.dataFetchModel == DataFetchModel.NUMBER ? "number" : "id";
    }

    protected void innerFetch() throws EASBizException {
        Set<String> allIdOrNumber = this.getFilterObjSet();
        List<String> idOrNumberList = CollectionUtil.groupToSql(allIdOrNumber, this.batchIdCount);
        StringBuffer oql = new StringBuffer();
        String selectSql = this.getSelectSql();
        oql.append("select ").append(StringUtils.isBlank((String)selectSql) ? "*" : selectSql);
        oql.append(" where ").append(this.getTimeFilter()).append(" and ");
        if (StringUtils.isNotBlank((String)this.filterSql)) {
            oql.append(this.filterSql).append(" and ");
        }
        oql.append(this.filterObjFieldName).append(".").append(this.getMapKey());
        oql.append(" in ");
        this.initInsClass();
        if (this.insClass == null) {
            throw new EASBizException(EASBizException.CHECKBLANK, new Object[]{"insClass"});
        }
        EntityObjectInfo entityObjectInfo = null;
        try {
            CoreBaseInfo instance = (CoreBaseInfo)this.insClass.newInstance();
            entityObjectInfo = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)this.ctx).getEntity(instance.getBOSType());
            Class collCls = entityObjectInfo.getObjectCollectionClazzRuntime();
            this.resultCollection = (IObjectCollection)collCls.newInstance();
            String entityName = entityObjectInfo.getFullName();
            ICoreBase iCoreBase = (ICoreBase)BOSObjectFactory.createCommonBOSObject((Context)this.ctx, (IMetaDataPK)MetaDataPK.create((String)entityName));
            for (String idOrNumbers : idOrNumberList) {
                this.logger.info((Object)(oql.toString() + idOrNumbers));
                this.resultCollection.addObjectCollection((IObjectCollection)iCoreBase.getCollection(new StringBuffer(oql).append(idOrNumbers).append(" order by ").append(this.effdtFieldName).append(this.asendResult ? " asc " : " desc ").toString()));
            }
        }
        catch (ClassNotFoundException e) {
            throw new EASBizException(EASBizException.CLASS_INIT_ERROR, (Throwable)e, new Object[]{entityObjectInfo});
        }
        catch (BOSException e) {
            throw new EASBizException(EASBizException.DBDEADLOCK, (Throwable)e);
        }
        catch (Exception e) {
            throw new HRCommonException(HRCommonException.EXCEPTION_MSG, e);
        }
    }

    protected void initInsClass() throws EASBizException {
        if (this.insClass != null) {
            return;
        }
        try {
            ParameterizedType superType = (ParameterizedType)this.getClass().getGenericSuperclass();
            this.insClass = (Class)superType.getActualTypeArguments()[0];
        }
        catch (Exception e) {
            throw new EASBizException(EASBizException.CLASS_INIT_ERROR, (Throwable)e, new Object[]{this.getClass()});
        }
    }

    protected Set<String> getFilterObjSet() throws EASBizException {
        if (this.filterObjs == null || this.filterObjs.size() == 0) {
            throw new EASBizException(EASBizException.CHECKBLANK, new Object[]{this.filterObjs});
        }
        HashSet<String> idOrNumbers = new HashSet<String>(this.filterObjs.size());
        int total = this.filterObjs.size();
        for (int i = 0; i < total; ++i) {
            Object filterObj = this.filterObjs.get(i);
            if (filterObj instanceof CoreBaseInfo) {
                CoreBaseInfo coreBaseInfo = (CoreBaseInfo)filterObj;
                if (this.dataFetchModel == DataFetchModel.NUMBER) {
                    idOrNumbers.add(String.valueOf(coreBaseInfo.get("number")));
                    continue;
                }
                idOrNumbers.add(String.valueOf(coreBaseInfo.getId()));
                continue;
            }
            if (!(filterObj instanceof String)) continue;
            idOrNumbers.add(String.valueOf(filterObj));
        }
        return idOrNumbers;
    }

    private String getTimeFilter() {
        this.beginTime = Date.getDate(this.beginTime);
        this.endTime = Date.getDate(this.endTime);
        if (this.beginTime == null && this.endTime != null) {
            return this.effdtFieldName + " <= {ts '" + this.endTime + "'}";
        }
        if (this.beginTime != null && this.endTime == null) {
            return this.leffdtFieldName + " >= {ts '" + this.beginTime + "'}";
        }
        if (this.beginTime == null) {
            this.endTime = this.beginTime = Date.getDateInst();
        }
        StringBuffer timeFilter = new StringBuffer();
        timeFilter.append(this.effdtFieldName).append(" <= {ts '").append(this.endTime).append("'} and ");
        timeFilter.append(this.leffdtFieldName).append(" >= {ts '").append(this.beginTime).append("'}");
        return timeFilter.toString();
    }

    public RangeDataFetcher<V> addFilterObj(Object filterObj) {
        if (filterObj == null) {
            return this;
        }
        if (this.filterObjs == null) {
            this.filterObjs = new ArrayList<Object>();
        }
        Iterator it = null;
        if (filterObj instanceof Collection) {
            it = ((Collection)filterObj).iterator();
        } else if (filterObj instanceof IObjectCollection) {
            it = ((IObjectCollection)filterObj).iterator();
        }
        if (it == null) {
            this.filterObjs.add(filterObj);
        } else {
            while (it.hasNext()) {
                this.filterObjs.add(it.next());
            }
        }
        return this;
    }

    public Context getCtx() {
        return this.ctx;
    }

    public RangeDataFetcher<V> setCtx(Context ctx) {
        this.ctx = ctx;
        return this;
    }

    public String getSelectSql() {
        return this.selectSql;
    }

    public RangeDataFetcher<V> setSelectSql(String selectSql) {
        this.selectSql = selectSql;
        return this;
    }

    public DataFetchModel getDataFetchModel() {
        return this.dataFetchModel;
    }

    public RangeDataFetcher<V> setDataFetchModel(DataFetchModel dataFetchModel) {
        this.dataFetchModel = dataFetchModel;
        return this;
    }

    public Object getBeginTime() {
        return this.beginTime;
    }

    public RangeDataFetcher<V> setBeginTime(Object beginTime) {
        this.beginTime = beginTime;
        return this;
    }

    public Object getEndTime() {
        return this.endTime;
    }

    public RangeDataFetcher<V> setEndTime(Object endTime) {
        this.endTime = endTime;
        return this;
    }

    public List<Object> getFilterObjs() {
        return this.filterObjs;
    }

    public RangeDataFetcher<V> setFilterObjs(List<Object> filterObjs) {
        this.filterObjs = filterObjs;
        return this;
    }

    public int getBatchIdCount() {
        return this.batchIdCount;
    }

    public Class<?> getInsClass() {
        return this.insClass;
    }

    public RangeDataFetcher<V> setInsClass(Class<?> insClass) {
        this.insClass = insClass;
        return this;
    }

    public String getEffdtFieldName() {
        return this.effdtFieldName;
    }

    public RangeDataFetcher<V> setEffdtFieldName(String effdtFieldName) {
        this.effdtFieldName = effdtFieldName;
        return this;
    }

    public String getLeffdtFieldName() {
        return this.leffdtFieldName;
    }

    public RangeDataFetcher<V> setLeffdtFieldName(String leffdtFieldName) {
        this.leffdtFieldName = leffdtFieldName;
        return this;
    }

    public String getFilterObjFieldName() {
        return this.filterObjFieldName;
    }

    public RangeDataFetcher<V> setFilterObjFieldName(String filterObjFieldName) {
        this.filterObjFieldName = filterObjFieldName;
        return this;
    }

    public RangeDataFetcher<V> setBatchIdCount(int batchIdCount) {
        this.batchIdCount = batchIdCount;
        return this;
    }

    public String getFilterSql() {
        return this.filterSql;
    }

    public RangeDataFetcher<V> setFilterSql(String filterSql) {
        this.filterSql = filterSql;
        return this;
    }

    public boolean isAsendResult() {
        return this.asendResult;
    }

    public RangeDataFetcher<V> setAsendResult(boolean asendResult) {
        this.asendResult = asendResult;
        return this;
    }

    public String toString() {
        return "RangeDataFetcher [dataFetchModel=" + (Object)((Object)this.dataFetchModel) + ", beginTime=" + this.beginTime + ", endTime=" + this.endTime + ", batchIdCount=" + this.batchIdCount + "]";
    }
}

