/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.base.timezone;

import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.assistant.TimeZoneInfo;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.hr.base.HRTimeZoneBizException;
import com.kingdee.eas.hr.base.HRTimeZoneInfo;
import com.kingdee.eas.hr.base.TimeZoneChangeEventInfo;
import com.kingdee.eas.hr.base.timezone.DataFetchModel;
import com.kingdee.eas.hr.base.timezone.Date;
import com.kingdee.eas.hr.base.timezone.RangeDataFetcher;
import com.kingdee.eas.hr.base.timezone.RangeDataUpdater;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang.StringUtils;

public class TimeZoneUpdater
extends RangeDataUpdater {
    private TimeZoneChangeEventInfo changeEvent;
    private List<PersonInfo> persons;
    private TimeZoneInfo timeZoneInfo;

    public TimeZoneUpdater addToUpdate(HRTimeZoneInfo timeZoneInfo) {
        if (timeZoneInfo != null) {
            super.addToUpdate((CoreBaseInfo)this.getDefaultTimzonInfo(timeZoneInfo));
        }
        return this;
    }

    @Override
    @Deprecated
    public TimeZoneUpdater addToUpdate(CoreBaseInfo updateInfo) {
        if (updateInfo instanceof HRTimeZoneInfo) {
            this.addToUpdate(this.getDefaultTimzonInfo((HRTimeZoneInfo)updateInfo));
        }
        return this;
    }

    public TimeZoneUpdater addToUpdate(Object person, TimeZoneInfo timeZone, TimeZoneChangeEventInfo event, Object effdt, Object leffdt) {
        HRTimeZoneInfo info = new HRTimeZoneInfo();
        info.setChangeEvent(event == null ? this.changeEvent : event);
        info.setEffdt(Date.getDate(effdt));
        info.setLeffdt(Date.getDate(leffdt));
        info.setPerson(this.getPerson(person));
        info.setTimeZone(timeZone);
        return this.addToUpdate(info);
    }

    public PersonInfo getPerson(Object person) {
        if (person == null) {
            throw new IllegalArgumentException("person is null!");
        }
        if (person instanceof PersonInfo) {
            PersonInfo personInfo = (PersonInfo)person;
            String idOrNum = personInfo.getString(this.dataFetchModel == DataFetchModel.NUMBER ? "number" : "id");
            if (StringUtils.isBlank((String)idOrNum)) {
                throw new IllegalArgumentException("null person id or person number!");
            }
            return personInfo;
        }
        PersonInfo personInfo = new PersonInfo();
        if (this.dataFetchModel == DataFetchModel.NUMBER) {
            personInfo.setNumber(person.toString());
        } else {
            personInfo.setId(BOSUuid.read((String)person.toString()));
        }
        return personInfo;
    }

    @Override
    public boolean update() throws EASBizException {
        if (this.persons != null && this.beginTime != null && this.endTime != null && this.changeEvent != null) {
            for (PersonInfo person : this.persons) {
                this.addToUpdate(person, this.timeZoneInfo, this.changeEvent, this.beginTime, this.endTime);
            }
        }
        return super.update();
    }

    public TimeZoneUpdater addPersons(Object person) {
        if (person == null) {
            return this;
        }
        if (this.persons == null) {
            this.persons = new ArrayList<PersonInfo>();
        }
        Iterator it = null;
        if (person instanceof Collection) {
            it = ((Collection)person).iterator();
        } else if (person instanceof IObjectCollection) {
            it = ((IObjectCollection)person).iterator();
        }
        if (it == null) {
            if (person instanceof PersonInfo) {
                this.persons.add((PersonInfo)person);
            }
        } else {
            while (it.hasNext()) {
                Object per = it.next();
                if (!(per instanceof PersonInfo)) continue;
                this.persons.add((PersonInfo)per);
            }
        }
        return this;
    }

    public HRTimeZoneInfo getDefaultTimzonInfo(HRTimeZoneInfo info) {
        HRTimeZoneInfo hRTimeZoneInfo = info = info == null ? new HRTimeZoneInfo() : info;
        if (info.getTimeZone() == null) {
            info.setTimeZone(this.timeZoneInfo);
        }
        if (info.getChangeEvent() == null) {
            info.setChangeEvent(this.changeEvent);
        }
        if (info.getEffdt() == null) {
            info.setEffdt(this.beginTime);
        }
        if (info.getLeffdt() == null) {
            info.setLeffdt(this.endTime);
        }
        return info;
    }

    public TimeZoneChangeEventInfo getChangeEvent() {
        return this.changeEvent;
    }

    public TimeZoneUpdater setChangeEvent(TimeZoneChangeEventInfo changeEvent) {
        this.changeEvent = changeEvent;
        return this;
    }

    public TimeZoneInfo getTimeZoneInfo() {
        return this.timeZoneInfo;
    }

    public TimeZoneUpdater setTimeZoneInfo(TimeZoneInfo timeZoneInfo) {
        this.timeZoneInfo = timeZoneInfo;
        return this;
    }

    @Override
    protected void dataFetcherProcess(RangeDataFetcher<?> fetcher) {
        super.dataFetcherProcess(fetcher);
        fetcher.setSelectSql("*,changeEvent.*");
    }

    @Override
    protected RangeDataUpdater.UpdateModel getUpdateModel(CoreBaseInfo updateInfo, CoreBaseInfo needChangeInfo, boolean throwExceptionWhenNotSatisfy) throws EASBizException {
        boolean satisfy;
        HRTimeZoneInfo update = (HRTimeZoneInfo)updateInfo;
        HRTimeZoneInfo needChange = (HRTimeZoneInfo)needChangeInfo;
        boolean bl = satisfy = Math.max(this.forceUpdateLevel, update.getChangeEvent().getLevel()) >= needChange.getChangeEvent().getLevel();
        if (!satisfy && throwExceptionWhenNotSatisfy) {
            throw new HRTimeZoneBizException(HRTimeZoneBizException.EVENT_LEVEL_LOW);
        }
        if (satisfy && this.isSameCoreBaseId((CoreBaseInfo)update.getChangeEvent(), (CoreBaseInfo)needChange.getChangeEvent()) && this.isSameCoreBaseId((CoreBaseInfo)update.getTimeZone(), (CoreBaseInfo)needChange.getTimeZone())) {
            return RangeDataUpdater.UpdateModel.UNION;
        }
        return satisfy ? RangeDataUpdater.UpdateModel.UPDATE : RangeDataUpdater.UpdateModel.NOUPDATE;
    }

    private boolean isSameCoreBaseId(CoreBaseInfo coreBaseInfo1, CoreBaseInfo coreBaseInfo2) {
        return coreBaseInfo1 != null && coreBaseInfo2 != null && StringUtils.equals((String)coreBaseInfo1.getString("id"), (String)coreBaseInfo2.getString("id"));
    }
}

