/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.base.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.HistoryConstant;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.basedata.org.PositionHierarchyCollection;
import com.kingdee.eas.basedata.org.PositionHierarchyFactory;
import com.kingdee.eas.basedata.org.PositionHierarchyInfo;
import com.kingdee.eas.basedata.org.PositionInfo;
import com.kingdee.eas.hr.base.EmpPosOrgRelationCollection;
import com.kingdee.eas.hr.base.EmpPosOrgRelationFactory;
import com.kingdee.eas.hr.base.EmpPosOrgRelationInfo;
import com.kingdee.eas.hr.base.util.HRUtil;
import com.kingdee.eas.hr.base.util.HRUtilExtend;
import com.kingdee.eas.hr.emp.EmpPostRankCollection;
import com.kingdee.eas.hr.emp.EmpPostRankFactory;
import com.kingdee.eas.hr.emp.EmpPostRankInfo;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.LocaleUtils;
import com.kingdee.util.StringUtils;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.log4j.Logger;

public class GetPersonEmpPostRankUtil {
    private static Logger logger = Logger.getLogger(GetPersonEmpPostRankUtil.class);
    private static ConcurrentHashMap<String, Map<String, Object>> map = new ConcurrentHashMap();

    public static EmpPostRankInfo getEmpPostRank(Context ctx, String personId) throws BOSException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("person", (Object)personId));
        filter.getFilterItems().add(new FilterItemInfo("isLatest", (Object)true, CompareType.EQUALS));
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("jobLevel.id"));
        sic.add(new SelectorItemInfo("jobLevel.name"));
        sic.add(new SelectorItemInfo("jobLevel.number"));
        sic.add(new SelectorItemInfo("jobLevel.index"));
        sic.add(new SelectorItemInfo("jobGrade.id"));
        sic.add(new SelectorItemInfo("jobGrade.name"));
        sic.add(new SelectorItemInfo("jobGrade.number"));
        sic.add(new SelectorItemInfo("jobGrade.index"));
        view.setSelector(sic);
        view.setFilter(filter);
        EmpPostRankCollection empPostRankCollection = EmpPostRankFactory.getLocalInstance((Context)ctx).getEmpPostRankCollection(view);
        return empPostRankCollection.get(0);
    }

    private static boolean isMapCacheTimeOut(Context ctx, String personId) {
        Long time = System.currentTimeMillis();
        Map<String, Object> positionMap = map.get(personId);
        if (positionMap != null && positionMap.get("time") != null) {
            Long timeCache = (Long)positionMap.get("time");
            Long diff = (time - timeCache) / 60000L;
            if (diff <= 10L) {
                return false;
            }
        }
        return true;
    }

    public static void initDataByPersonId(Context ctx, String personId) throws BOSException {
        try {
            WeakHashMap<String, Object> result = new WeakHashMap<String, Object>();
            Map<String, Object> positionMap = map.get(personId);
            if (!GetPersonEmpPostRankUtil.isMapCacheTimeOut(ctx, personId)) {
                return;
            }
            String positionId = GetPersonEmpPostRankUtil.getPositionIdByPersonId(ctx, personId);
            String longNumber = GetPersonEmpPostRankUtil.getLongNumberByPosition(ctx, positionId);
            result.put("downNotContainHierarchy", GetPersonEmpPostRankUtil.getPersonIdByPositionIds(ctx, GetPersonEmpPostRankUtil.getDownNotContainPositionIds(ctx, positionId)));
            result.put("downContainHierarchy", GetPersonEmpPostRankUtil.getPersonIdByPositionIds(ctx, GetPersonEmpPostRankUtil.getDownContainPositionIds(ctx, longNumber)));
            result.put("upNotContainHierarchy", GetPersonEmpPostRankUtil.getPersonIdByPositionIds(ctx, GetPersonEmpPostRankUtil.getUpNotContainPositionIds(ctx, positionId)));
            result.put("upContainHierarchy", GetPersonEmpPostRankUtil.getPersonIdByPositionIds(ctx, GetPersonEmpPostRankUtil.getUpContainPositionIds(ctx, longNumber)));
            Long time = System.currentTimeMillis();
            result.put("time", time);
            map.put(personId, result);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("map : " + map.get(personId)));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BOSException((Throwable)e);
        }
    }

    private static Set<String> getPersonIdByPositionIds(Context ctx, Set<String> downNotContainPositionIds) throws BOSException {
        HashSet<String> personIds = new HashSet<String>();
        if (downNotContainPositionIds == null || downNotContainPositionIds.size() <= 0) {
            return personIds;
        }
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("position.id", downNotContainPositionIds, CompareType.INCLUDE));
        filter.getFilterItems().add(new FilterItemInfo("person.employeeType.isInCount", (Object)1));
        filter.getFilterItems().add(new FilterItemInfo(HistoryConstant.LEFFDT, (Object)HRUtil.getMaxEndDate(), CompareType.GREATER_EQUALS));
        view.setFilter(filter);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("person.id"));
        view.setSelector(sic);
        EmpPosOrgRelationCollection empposorgRelationColl = EmpPosOrgRelationFactory.getLocalInstance(ctx).getEmpPosOrgRelationCollection(view);
        for (int i = 0; i < empposorgRelationColl.size(); ++i) {
            EmpPosOrgRelationInfo info = empposorgRelationColl.get(i);
            if (info == null || info.getPerson() == null || info.getPerson().getId() == null || StringUtils.isEmpty((String)info.getPerson().getId().toString()) || personIds.contains(info.getPerson().getId().toString())) continue;
            personIds.add(info.getPerson().getId().toString());
        }
        return personIds;
    }

    private static Set<String> getDownNotContainPositionIds(Context ctx, String positionId) throws BOSException, SQLException {
        StringBuffer downHierarchySql = new StringBuffer("select hierarchy.FChildID positionIds from T_ORG_PositionHierarchy hierarchy").append(" where hierarchy.fhierarchyid = '00000000-0000-0000-0000-000000000001396FCAD0'").append(" and hierarchy.FParentID = '").append(positionId).append("'");
        IRowSet downHierarchyrowSet = DbUtil.executeQuery((Context)ctx, (String)downHierarchySql.toString());
        HashSet<String> downNotContainPositionIds = new HashSet<String>();
        while (downHierarchyrowSet.next()) {
            if (downNotContainPositionIds.contains(downHierarchyrowSet.getString("positionIds"))) continue;
            downNotContainPositionIds.add(downHierarchyrowSet.getString("positionIds"));
        }
        return downNotContainPositionIds;
    }

    private static Set<String> getDownContainPositionIds(Context ctx, String longNumber) throws BOSException {
        String downOql = "select child  where longNumber like '" + longNumber + "!%' ";
        HashSet<String> downContainPositionIds = new HashSet<String>();
        PositionHierarchyCollection positionDownHierarchyColl = PositionHierarchyFactory.getLocalInstance((Context)ctx).getPositionHierarchyCollection(downOql);
        if (positionDownHierarchyColl != null && positionDownHierarchyColl.size() > 0) {
            for (int i = 0; i < positionDownHierarchyColl.size(); ++i) {
                if (positionDownHierarchyColl.get(i) == null || positionDownHierarchyColl.get(i).getChild() == null || downContainPositionIds.contains(positionDownHierarchyColl.get(i).getChild().getId().toString())) continue;
                downContainPositionIds.add(positionDownHierarchyColl.get(i).getChild().getId().toString());
            }
        }
        return downContainPositionIds;
    }

    private static Set<String> getUpNotContainPositionIds(Context ctx, String positionId) throws BOSException, SQLException {
        StringBuffer upHierarchySql = new StringBuffer("select hierarchy.FParentID positionIds from T_ORG_PositionHierarchy hierarchy").append(" where hierarchy.fhierarchyid = '00000000-0000-0000-0000-000000000001396FCAD0'").append(" and hierarchy.FChildID = '").append(positionId).append("'");
        IRowSet upHierarchySqlrowSet = DbUtil.executeQuery((Context)ctx, (String)upHierarchySql.toString());
        HashSet<String> upNotContainPositionIds = new HashSet<String>();
        while (upHierarchySqlrowSet.next()) {
            if (upNotContainPositionIds.contains(upHierarchySqlrowSet.getString("positionIds"))) continue;
            upNotContainPositionIds.add(upHierarchySqlrowSet.getString("positionIds"));
        }
        return upNotContainPositionIds;
    }

    private static Set<String> getUpContainPositionIds(Context ctx, String longNumber) throws BOSException {
        String[] numbers;
        HashSet<String> upContainPositionIds = new HashSet<String>();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("longNumber : " + longNumber));
        }
        if ((numbers = longNumber.split("!")).length <= 1) {
            return upContainPositionIds;
        }
        HashSet<String> upLongNumber = new HashSet<String>();
        String number = "";
        for (int j = 0; j < numbers.length - 1; ++j) {
            number = j == 0 ? numbers[j] : number + "!" + numbers[j];
            if (upLongNumber.contains(number)) continue;
            upLongNumber.add(number);
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("upLongNumber : " + upLongNumber));
        }
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("longNumber", upLongNumber, CompareType.INCLUDE));
        view.setFilter(filter);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("child"));
        view.setSelector(sic);
        PositionHierarchyCollection positionUpHierarchyColl = PositionHierarchyFactory.getLocalInstance((Context)ctx).getPositionHierarchyCollection(view);
        if (positionUpHierarchyColl != null && positionUpHierarchyColl.size() > 0) {
            for (int i = 0; i < positionUpHierarchyColl.size(); ++i) {
                if (positionUpHierarchyColl.get(i) == null || positionUpHierarchyColl.get(i).getChild() == null || upContainPositionIds.contains(positionUpHierarchyColl.get(i).getChild().getId().toString())) continue;
                upContainPositionIds.add(positionUpHierarchyColl.get(i).getChild().getId().toString());
            }
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("upContainPositionIds : " + upContainPositionIds));
        }
        return upContainPositionIds;
    }

    public static void releaseDataByPersonId(Context ctx, String personId) {
        map.remove(personId);
    }

    public static String getPositionIdByPersonId(Context ctx, String personId) throws BOSException {
        String sql = "select FPositionID positionId from t_hr_emporgrelation where FPersonID = ? and FIsInner = 1 and FAssignType = 1 and FIsLatestInAday = 1 and FLEFFDT={ts '2199-12-31'}";
        Object[] params = new Object[]{personId};
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])params);
        try {
            if (rowSet.next()) {
                String positionId = rowSet.getString("positionId");
                return positionId;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BOSException((Throwable)e);
        }
        return null;
    }

    public static PositionInfo getPositionByPersonId(Context ctx, String personId) throws BOSException {
        EmpPosOrgRelationInfo empPosOrgRelationInfo = GetPersonEmpPostRankUtil.getEmpOrgRelationByPersonId(ctx, personId);
        if (empPosOrgRelationInfo != null) {
            return empPosOrgRelationInfo.getPosition();
        }
        return null;
    }

    public static boolean isDownHierarchy(Context ctx, String personIdA, String personIdB, boolean isContainLowerOrg) throws BOSException {
        long start = System.currentTimeMillis();
        Map<String, Object> positionMap = map.get(personIdA);
        if (isContainLowerOrg) {
            if (positionMap == null || positionMap.get("downContainHierarchy") == null || GetPersonEmpPostRankUtil.isMapCacheTimeOut(ctx, personIdA)) {
                boolean result = GetPersonEmpPostRankUtil.isDownHierarchyContainLowerOrg(ctx, personIdA, personIdB);
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("isDownHierarchy isDownHierarchyContainLowerOrg consumes " + (System.currentTimeMillis() - start) + "ms"));
                }
                return result;
            }
            Set downContainHierarchy = (Set)positionMap.get("downContainHierarchy");
            return downContainHierarchy.contains(personIdB);
        }
        if (positionMap == null || positionMap.get("downNotContainHierarchy") == null || GetPersonEmpPostRankUtil.isMapCacheTimeOut(ctx, personIdA)) {
            boolean result = GetPersonEmpPostRankUtil.isDownHierarchyNotContainLowerOrg(ctx, personIdA, personIdB);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("isDownHierarchy isDownHierarchyNotContainLowerOrg consumes " + (System.currentTimeMillis() - start) + "ms"));
            }
            return result;
        }
        Set downNotContainHierarchy = (Set)positionMap.get("downNotContainHierarchy");
        return downNotContainHierarchy.contains(personIdB);
    }

    public static boolean isUpHierarchy(Context ctx, String personIdA, String personIdB, boolean isContainLowerOrg) throws BOSException {
        long start = System.currentTimeMillis();
        Map<String, Object> positionMap = map.get(personIdA);
        if (isContainLowerOrg) {
            if (positionMap == null || positionMap.get("upContainHierarchy") == null || GetPersonEmpPostRankUtil.isMapCacheTimeOut(ctx, personIdA)) {
                boolean result = GetPersonEmpPostRankUtil.isDownHierarchyContainLowerOrg(ctx, personIdB, personIdA);
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("isUpHierarchy isDownHierarchyContainLowerOrg consumes " + (System.currentTimeMillis() - start) + "ms"));
                }
                return result;
            }
            Set upContainHierarchy = (Set)positionMap.get("upContainHierarchy");
            return upContainHierarchy.contains(personIdB);
        }
        if (positionMap == null || positionMap.get("upNotContainHierarchy") == null || GetPersonEmpPostRankUtil.isMapCacheTimeOut(ctx, personIdA)) {
            boolean result = GetPersonEmpPostRankUtil.isDownHierarchyNotContainLowerOrg(ctx, personIdB, personIdA);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("isUpHierarchy isDownHierarchyNotContainLowerOrg consumes " + (System.currentTimeMillis() - start) + "ms"));
            }
            return result;
        }
        Set upNotContainHierarchy = (Set)positionMap.get("upNotContainHierarchy");
        return upNotContainHierarchy.contains(personIdB);
    }

    private static boolean isDownHierarchyContainLowerOrg(Context ctx, String personIdA, String personIdB) throws BOSException {
        try {
            long start = System.currentTimeMillis();
            String positionIdA = GetPersonEmpPostRankUtil.getPositionIdByPersonId(ctx, personIdA);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("isUpHierarchy isDownHierarchyContainLowerOrg getPositionIdByPersonId consumes " + (System.currentTimeMillis() - start) + "ms"));
            }
            String positionIdB = GetPersonEmpPostRankUtil.getPositionIdByPersonId(ctx, personIdB);
            if (!StringUtils.isEmpty((String)positionIdA) && !StringUtils.isEmpty((String)positionIdB)) {
                long start1 = System.currentTimeMillis();
                String longNumberA = GetPersonEmpPostRankUtil.getLongNumberByPosition(ctx, positionIdA);
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("isUpHierarchy isDownHierarchyContainLowerOrg getLongNumberByPosition consumes " + (System.currentTimeMillis() - start1) + "ms"));
                }
                String longNumberB = GetPersonEmpPostRankUtil.getLongNumberByPosition(ctx, positionIdB);
                if (longNumberA != null && longNumberB != null && !StringUtils.equals((String)longNumberA, (String)longNumberB) && longNumberB.contains(longNumberA + "!")) {
                    return true;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BOSException((Throwable)e);
        }
        return false;
    }

    private static String getLongNumberByPosition(Context ctx, String positionId) throws BOSException {
        String oql = "select longNumber where hierarchy = '00000000-0000-0000-0000-000000000001396FCAD0' and child = '" + positionId + "'";
        PositionHierarchyCollection positionHierarchyCollection = PositionHierarchyFactory.getLocalInstance((Context)ctx).getPositionHierarchyCollection(oql);
        PositionHierarchyInfo positionHierarchyInfo = positionHierarchyCollection.get(0);
        if (positionHierarchyInfo != null) {
            return positionHierarchyInfo.getLongNumber();
        }
        return null;
    }

    private static boolean isDownHierarchyNotContainLowerOrg(Context ctx, String personIdA, String personIdB) throws BOSException {
        try {
            long start = System.currentTimeMillis();
            String positionIdA = GetPersonEmpPostRankUtil.getPositionIdByPersonId(ctx, personIdA);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("isUpHierarchy isDownHierarchyNotContainLowerOrg getPositionIdByPersonId consumes " + (System.currentTimeMillis() - start) + "ms"));
            }
            String positionIdB = GetPersonEmpPostRankUtil.getPositionIdByPersonId(ctx, personIdB);
            if (!StringUtils.isEmpty((String)positionIdA) && !StringUtils.isEmpty((String)positionIdB)) {
                long start1 = System.currentTimeMillis();
                StringBuffer sql = new StringBuffer("select count(1) count from T_ORG_PositionHierarchy hierarchy").append(" where hierarchy.fhierarchyid = '00000000-0000-0000-0000-000000000001396FCAD0'").append(" and hierarchy.FParentID = '").append(positionIdA).append("'").append(" and hierarchy.FChildID = '").append(positionIdB).append("'");
                IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("isUpHierarchy isDownHierarchyNotContainLowerOrg executeQuery consumes " + (System.currentTimeMillis() - start1) + "ms"));
                }
                while (rowSet.next()) {
                    int count = rowSet.getInt("count");
                    if (count <= 0) continue;
                    return true;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BOSException((Throwable)e);
        }
        return false;
    }

    private static EmpPosOrgRelationInfo getEmpOrgRelationByPersonId(Context ctx, String personId) throws BOSException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("person.id", (Object)personId, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("isInner", (Object)true));
        filter.getFilterItems().add(new FilterItemInfo("assignType", (Object)1));
        filter.getFilterItems().add(new FilterItemInfo("LEFFDT", (Object)HRUtil.getMaxEndDate(), CompareType.EQUALS));
        view.setFilter(filter);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("person.id"));
        sic.add(new SelectorItemInfo("adminOrg.id"));
        sic.add(new SelectorItemInfo("adminOrg.name"));
        sic.add(new SelectorItemInfo("adminOrg.number"));
        sic.add(new SelectorItemInfo("adminOrg.displayName"));
        sic.add(new SelectorItemInfo("position.id"));
        sic.add(new SelectorItemInfo("position.name"));
        sic.add(new SelectorItemInfo("position.number"));
        sic.add(new SelectorItemInfo("id"));
        view.setSelector(sic);
        EmpPosOrgRelationCollection collection = EmpPosOrgRelationFactory.getLocalInstance(ctx).getEmpPosOrgRelationCollection(view);
        return collection.get(0);
    }

    public static Map<String, Object> getPersonEmpPostRank(Context ctx, String personId) throws BOSException {
        HashMap<String, Object> result = new HashMap<String, Object>();
        EmpPosOrgRelationInfo empPosOrgRelationInfo = GetPersonEmpPostRankUtil.getEmpOrgRelationByPersonId(ctx, personId);
        if (empPosOrgRelationInfo != null) {
            result.put("position", empPosOrgRelationInfo.getPosition());
            result.put("adminOrg", empPosOrgRelationInfo.getAdminOrg());
        } else {
            result.put("position", null);
            result.put("adminOrg", null);
        }
        EmpPostRankInfo empPostRankInfo = GetPersonEmpPostRankUtil.getEmpPostRank(ctx, personId);
        if (empPostRankInfo != null) {
            result.put("jobLevel", empPostRankInfo.getJobLevel());
            result.put("jobGrade", empPostRankInfo.getJobGrade());
        } else {
            result.put("jobLevel", null);
            result.put("jobGrade", null);
        }
        List upHierarchy = GetPersonEmpPostRankUtil.getUpHierarchy(ctx, personId);
        List downHierarchy = GetPersonEmpPostRankUtil.getDownHierarchy(ctx, personId);
        result.put("upHierarchy", upHierarchy);
        result.put("downHierarchy", downHierarchy);
        return result;
    }

    protected static List getDownHierarchy(Context ctx, String personId) throws BOSException {
        String loc = LocaleUtils.getLocaleString((Locale)ctx.getLocale());
        ArrayList list = new ArrayList();
        String mainOrgId = null;
        String mainAdminSql = "SELECT FADMINORGID adminOrg FROM t_hr_emporgrelation where FASSIGNTYPE = 1 and fisinner = 1 and fleffdt =" + HRUtilExtend.getDateStringWithoutMininuteTs(HRUtil.getMaxEndDate()) + " and  FPERSONID  ='" + personId + "'";
        IRowSet mainAdminRowSet = DbUtil.executeQuery((Context)ctx, (String)mainAdminSql);
        try {
            while (mainAdminRowSet.next()) {
                mainOrgId = mainAdminRowSet.getString("adminOrg");
            }
            StringBuffer sql = new StringBuffer("select childperson.fid personId,childperson.fname_" + loc + " personName, childperson.fnumber personNumber from T_ORG_PositionHierarchy hierarchy").append(" inner join (").append(" select emprelation.fpositionid from T_HR_EmpOrgRelation emprelation").append(" inner join T_BD_Person person on emprelation.fpersonid = person.fid").append(" inner join T_ORG_Admin child on emprelation.fadminorgid = child.fid").append(" inner join T_ORG_Admin adrange on (charindex(concat(adrange.flongnumber,'!'),child.flongnumber) = 1 or adrange.flongnumber = child.flongnumber)").append(" where emprelation.fisinner = 1").append(" and emprelation.fleffdt = ").append(HRUtilExtend.getDateStringWithoutMininuteTs(HRUtil.getMaxEndDate())).append(" and emprelation.FIsLatestInAday = 1").append(" and person.fid = '").append(personId).append("'").append(" and child.fisstartshr = 1 and child.fissealup = 0").append(" and adrange.fid = '").append(mainOrgId).append("'").append(" and emprelation.FASSIGNTYPE = 1").append(" ) position on hierarchy.fparentid = position.fpositionid and hierarchy.fchildid != position.fpositionid").append(" inner join T_HR_EmpOrgRelation downrelation on downrelation.fpositionid = hierarchy.fchildid").append(" inner join T_BD_Person childperson on downrelation.fpersonid = childperson.fid").append(" inner join T_HR_EmpLaborRelation downlaborrelation on downrelation.flaborrelationid = downlaborrelation.fid").append(" inner join T_HR_BDEmployeeType downemptype on downlaborrelation.flaborrelationstateid = downemptype.fid").append(" where hierarchy.fhierarchyid = '00000000-0000-0000-0000-000000000001396FCAD0'").append(" and downrelation.fisinner = 1").append(" and downemptype.FIsInCount = 1").append(" and downrelation.fleffdt = ").append(HRUtilExtend.getDateStringWithoutMininuteTs(HRUtil.getMaxEndDate())).append(" and downrelation.FIsLatestInAday = 1");
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            ArrayList<String> personIdList = new ArrayList<String>();
            while (rowSet.next()) {
                String personid = rowSet.getString("personid");
                if (personIdList.contains(personid)) continue;
                personIdList.add(personid);
                String personName = rowSet.getString("personName");
                String personNumber = rowSet.getString("personNumber");
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("personId", personid);
                map.put("personName", personName);
                map.put("personNumber", personNumber);
                list.add(map);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BOSException((Throwable)e);
        }
        return list;
    }

    protected static List getUpHierarchy(Context ctx, String personId) throws BOSException {
        ArrayList list = new ArrayList();
        String loc = LocaleUtils.getLocaleString((Locale)ctx.getLocale());
        StringBuffer sql = new StringBuffer("SELECT ").append(" adminOrg.fname_").append(loc).append(" orgName,").append(" position.fname_").append(loc).append(" positionName,").append(" person.fname_").append(loc).append(" personName,").append(" person.fnumber personNumber,person.fid personid,emprelation.fassigntype assigntype").append(" from T_HR_EmpOrgRelation emprelation").append(" inner join T_HR_EmpLaborRelation laborrelation on emprelation.flaborrelationid = laborrelation.fid").append(" inner join T_HR_BDEmployeeType emptype on laborrelation.flaborrelationstateid = emptype.fid").append(" inner join t_org_position position on position.fid = emprelation.fpositionid").append(" inner join t_org_admin adminOrg on adminOrg.fid = emprelation.fadminorgid").append(" inner join t_bd_person person on person.fid = emprelation.fpersonid").append(" where emprelation.fisinner = 1").append(" and emprelation.fleffdt = ").append(HRUtilExtend.getDateStringWithoutMininuteTs(HRUtil.getMaxEndDate())).append(" and emprelation.FIsLatestInAday = 1").append(" and emptype.FIsInCount = 1").append(" and adminOrg.fissealup = 0").append(" and adminOrg.fisstartshr = 1").append(" and emprelation.fpersonid in (").append(" select upperson.fid from T_HR_EmpOrgRelation emprelation").append(" inner join T_BD_Person person on emprelation.fpersonid = person.fid").append(" inner join T_ORG_PositionHierarchy hierarchy on hierarchy.fchildid = emprelation.fpositionid and hierarchy.fparentid != hierarchy.fchildid").append(" inner join T_HR_EmpOrgRelation uprelation on hierarchy.fparentid = uprelation.fpositionid").append(" inner join T_HR_EmpLaborRelation uplaborrelation on uprelation.flaborrelationid = uplaborrelation.fid").append(" inner join T_HR_BDEmployeeType upemptype on uplaborrelation.flaborrelationstateid = upemptype.fid").append(" inner join T_ORG_Admin upadmin on uprelation.fadminorgid = upadmin.fid").append(" inner join T_BD_Person upperson on uprelation.fpersonid = upperson.fid").append(" where emprelation.fisinner = 1 and emprelation.fassigntype = 1").append(" and person.fid = '").append(personId).append("'").append(" and emprelation.fleffdt = ").append(HRUtilExtend.getDateStringWithoutMininuteTs(HRUtil.getMaxEndDate())).append(" and emprelation.FIsLatestInAday = 1").append(" and uprelation.fisinner = 1").append(" and upemptype.fisonthestrength = 1").append(" and uprelation.fleffdt = ").append(HRUtilExtend.getDateStringWithoutMininuteTs(HRUtil.getMaxEndDate())).append(" and uprelation.FIsLatestInAday = 1").append(" and upadmin.fissealup = 0 and upadmin.fisstartshr = 1").append(" and hierarchy.fhierarchyid = '").append("00000000-0000-0000-0000-000000000001396FCAD0").append("')");
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        try {
            ArrayList<String> personIdList = new ArrayList<String>();
            while (rowSet.next()) {
                String personid = rowSet.getString("personid");
                if (personIdList.contains(personid)) continue;
                personIdList.add(personid);
                String personName = rowSet.getString("personName");
                String personNumber = rowSet.getString("personNumber");
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("personId", personid);
                map.put("personName", personName);
                map.put("personNumber", personNumber);
                list.add(map);
            }
            return list;
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw new BOSException((Throwable)e);
        }
    }
}

