/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.base.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTMenuManager;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDDatePicker;
import com.kingdee.bos.ctrl.swing.KDFilterTextField;
import com.kingdee.bos.ctrl.swing.KDMenuItem;
import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.dao.AbstractObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.ISQLExecutor;
import com.kingdee.bos.dao.query.SQLExecutorFactory;
import com.kingdee.bos.framework.DeployInfoManagerFactory;
import com.kingdee.bos.framework.IDeployInfoManager;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.MetaDataTypeList;
import com.kingdee.bos.metadata.MetaDataUtils;
import com.kingdee.bos.metadata.entity.DataType;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.OwnPropertyInfo;
import com.kingdee.bos.metadata.entity.PropertyInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.PropertyRefInfo;
import com.kingdee.bos.metadata.query.QueryFieldInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.metadata.resource.BizEnumInfo;
import com.kingdee.bos.metadata.ui.DataObjectCollection;
import com.kingdee.bos.metadata.ui.DataObjectInfo;
import com.kingdee.bos.metadata.ui.UIObjectInfo;
import com.kingdee.bos.metadata.util.MetaDataLoader;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.ItemAction;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.core.util.DateUtil;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.hraux.util.HRTreeUtil;
import com.kingdee.eas.basedata.org.AdminOrgUnitCollection;
import com.kingdee.eas.basedata.org.AdminOrgUnitFactory;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.HROrgUnitFactory;
import com.kingdee.eas.basedata.org.HROrgUnitInfo;
import com.kingdee.eas.basedata.org.IHROrgUnit;
import com.kingdee.eas.basedata.org.IPositionMember;
import com.kingdee.eas.basedata.org.NewOrgViewHelper;
import com.kingdee.eas.basedata.org.OrgF7InnerUtils;
import com.kingdee.eas.basedata.org.PositionMemberFactory;
import com.kingdee.eas.basedata.person.Genders;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.framework.client.OldUILifeCycleHander;
import com.kingdee.eas.hr.base.AbstractAffairActionReasonInfo;
import com.kingdee.eas.hr.base.AffairActionReasonFactory;
import com.kingdee.eas.hr.base.BaseException;
import com.kingdee.eas.hr.base.EmployeeTypeFactory;
import com.kingdee.eas.hr.base.EmployeeTypeInfo;
import com.kingdee.eas.hr.emp.EmpInnerFacadeFactory;
import com.kingdee.eas.hr.emp.EmployeeEditPageSchemeFactory;
import com.kingdee.eas.hr.emp.EmployeeException;
import com.kingdee.eas.hr.emp.IEmpInnerFacade;
import com.kingdee.eas.hr.emp.IEmployeeEditPageScheme;
import com.kingdee.eas.hr.org.HROrgUnitFacadeFactory;
import com.kingdee.eas.hr.org.IHROrgUnitFacade;
import com.kingdee.eas.hr.org.IPersonPlan;
import com.kingdee.eas.hr.org.PersonPlanFactory;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.KDTableUtil;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.ConfigurationItem;
import com.kingdee.util.DateTimeUtils;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.awt.Component;
import java.io.File;
import java.io.FileInputStream;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.DefaultComboBoxModel;
import javax.swing.tree.MutableTreeNode;
import org.apache.log4j.Logger;

public class HRUtil {
    private static final Logger logger = CoreUIObject.getLogger(HRUtil.class);
    private static long start = 0L;
    public static final String HRORG = "HRORGUNIT";
    public static final String HRORGUNITID = "hrOrgUnit.id";
    public static final String mobile = "^1\\d{10}$";
    public static final String phone = "^(\\d{3,4}-)?\\d{7,8}(-\\d{2,4})?$";
    public static final String email = "^\\w+((-\\w+)|(\\.\\w+))*\\@[A-Za-z0-9]+((\\.|-)[A-Za-z0-9]+)*\\.[A-Za-z0-9]+$";
    private static final int MAX_DATA_ROW = 8000;
    public static String EARLIEST_EFFDT = "1900-01-01";
    public static final String CHANGEENDDATE = "2199-12-31";
    public static final String IS_FROM_SHR_OPTAction = "IS_FROM_SHR_OPTAction";

    public static FilterInfo buildHROFilter(Context ctx, String columnName) throws Exception {
        FilterInfo filterInfo = new FilterInfo();
        Object iHRO = null;
        HROrgUnitInfo hroInfo = null;
        hroInfo = ctx == null ? SysContext.getSysContext().getCurrentHRUnit() : ContextUtil.getCurrentHRUnit((Context)ctx);
        if (hroInfo == null) {
            filterInfo.getFilterItems().add(new FilterItemInfo(columnName, (Object)BOSUuid.create((String)"58B332D9")));
            return filterInfo;
        }
        String sql = HRUtil.getAdminOrgRangeAndHRSql(hroInfo.getId().toString());
        filterInfo.getFilterItems().add(new FilterItemInfo(columnName, (Object)sql, CompareType.INNER));
        return filterInfo;
    }

    public static FilterInfo buildHROFilter(String columnName) throws Exception {
        return HRUtil.buildHROFilter(null, columnName);
    }

    public static FilterInfo buildHROFilter(Context ctx, String hrOrgUnitId, String columnName) throws Exception {
        FilterInfo filterInfo = new FilterInfo();
        if (hrOrgUnitId == null) {
            filterInfo.getFilterItems().add(new FilterItemInfo(columnName, (Object)BOSUuid.create((BOSObjectType)new HROrgUnitInfo().getBOSType())));
            return filterInfo;
        }
        String sql = HRUtil.getAdminOrgRangeAndHRSql(hrOrgUnitId);
        filterInfo.getFilterItems().add(new FilterItemInfo(columnName, (Object)sql, CompareType.INNER));
        return filterInfo;
    }

    public static HashMap getAdminNodeHashMap() throws Exception {
        return HRUtil.getAdminNodeHashMap(true, false);
    }

    public static HashMap getAdminNodeHashMap(boolean showVirtualOrg, boolean showSealUpOrg) throws Exception {
        HashMap nodeMap = new HashMap();
        DefaultKingdeeTreeNode root = HRUtil.getAdminRootNode(showVirtualOrg, showSealUpOrg);
        if (root != null) {
            HRUtil.getNodeHashMap(nodeMap, root);
        }
        return nodeMap;
    }

    public static HashMap getAdminRangeNodeHashMap() throws Exception {
        return HRUtil.getAdminRangeNodeHashMap(false);
    }

    public static HashMap getAdminRangeNodeHashMap(boolean includeSealUp) throws Exception {
        HashMap nodeMap = new HashMap();
        DefaultKingdeeTreeNode root = HRTreeUtil.createAdminTreeNodeByUserRange((boolean)false, (boolean)true, (boolean)true, (boolean)includeSealUp, null);
        if (root != null) {
            HRUtil.getNodeHashMap(nodeMap, root);
        }
        return nodeMap;
    }

    public static HashMap getAdminRangeNodeHashMap(boolean includeSealUp, boolean showVirtualOrg) throws Exception {
        HashMap nodeMap = new HashMap();
        DefaultKingdeeTreeNode root = HRTreeUtil.createAdminTreeNodeByUserRange((boolean)false, (boolean)showVirtualOrg, (boolean)true, (boolean)includeSealUp, null);
        if (root != null) {
            HRUtil.getNodeHashMap(nodeMap, root);
        }
        return nodeMap;
    }

    public static HashMap getAdminRangeNodeHashMapAndClearImageIcon(boolean includeSealUp, boolean showVirtualOrg) throws Exception {
        HashMap nodeMap = HRUtil.getAdminRangeNodeHashMap(includeSealUp, showVirtualOrg);
        Iterator iter = nodeMap.entrySet().iterator();
        Map.Entry entry = null;
        DefaultKingdeeTreeNode node = null;
        while (iter.hasNext()) {
            entry = iter.next();
            node = (DefaultKingdeeTreeNode)entry.getValue();
            node.setCustomIcon(null);
        }
        return nodeMap;
    }

    public static DefaultKingdeeTreeNode getAdminRootNode() throws Exception {
        return HRUtil.getAdminRootNode(true, false);
    }

    public static DefaultKingdeeTreeNode getAdminRootNode(boolean showVirtualOrg, boolean showSealUpOrg) throws Exception {
        DefaultKingdeeTreeNode root = null;
        HROrgUnitInfo hroInfo = SysContext.getSysContext().getCurrentHRUnit();
        if (hroInfo == null) {
            return null;
        }
        root = !showVirtualOrg ? HRUtil.getRootNew(hroInfo.getId().toString(), true, showSealUpOrg) : HRUtil.getRootNew2(hroInfo.getId().toString(), true, showSealUpOrg);
        return root;
    }

    public static void getNodeHashMap(HashMap nodeMap, DefaultKingdeeTreeNode root) throws Exception {
        AdminOrgUnitInfo adminInfo = (AdminOrgUnitInfo)root.getUserObject();
        if (HRTreeUtil.isTreeNodeDisable((DefaultKingdeeTreeNode)root)) {
            adminInfo.put("isEnable", (Object)false);
        } else {
            adminInfo.put("isEnable", (Object)true);
        }
        nodeMap.put(adminInfo.getId().toString(), root);
        int size = root.getChildCount();
        for (int i = 0; i < size; ++i) {
            HRUtil.getNodeHashMap(nodeMap, (DefaultKingdeeTreeNode)root.getChildAt(i));
        }
    }

    public static DefaultKingdeeTreeNode getRootNew2(String hrOrgUnitID, boolean useOrgRangeFilter, boolean showSealUpOrg) throws Exception {
        String firstLongNumber;
        IHROrgUnitFacade iHR = HROrgUnitFacadeFactory.getRemoteInstance();
        AdminOrgUnitCollection adminCol = iHR.getAdminOrgUnitCollectionWithOrgRangeFilter(hrOrgUnitID, showSealUpOrg);
        if (!useOrgRangeFilter) {
            adminCol = iHR.getAdminOrgUnitCollection(hrOrgUnitID, showSealUpOrg);
        }
        if (adminCol.size() == 0) {
            return null;
        }
        HashMap<String, DefaultKingdeeTreeNode> map = new HashMap<String, DefaultKingdeeTreeNode>();
        AdminOrgUnitInfo adminInfo = null;
        if (AdminOrgUnitFactory.getRemoteInstance().exists((IObjectPK)new ObjectUuidPK("00000000-0000-0000-0000-000000000000CCE7AED4"))) {
            adminInfo = AdminOrgUnitFactory.getRemoteInstance().getAdminOrgUnitInfo((IObjectPK)new ObjectUuidPK("00000000-0000-0000-0000-000000000000CCE7AED4"));
        }
        DefaultKingdeeTreeNode root = new DefaultKingdeeTreeNode(adminInfo);
        OrgF7InnerUtils.disableTreeNode((DefaultKingdeeTreeNode)root);
        String rootLongNumber = firstLongNumber = adminCol.get(0).getLongNumber();
        if (firstLongNumber.indexOf("!") != -1) {
            rootLongNumber = firstLongNumber.substring(0, firstLongNumber.indexOf("!"));
        }
        map.put(rootLongNumber, root);
        String longNumber = "";
        String parLongNumber = "";
        DefaultKingdeeTreeNode node = null;
        int n = adminCol.size();
        for (int i = 0; i < n; ++i) {
            parLongNumber = longNumber = adminCol.get(i).getLongNumber();
            while (!map.containsKey(parLongNumber) && parLongNumber.lastIndexOf("!") != -1) {
                parLongNumber = parLongNumber.substring(0, parLongNumber.lastIndexOf("!"));
            }
            node = new DefaultKingdeeTreeNode((Object)adminCol.get(i));
            map.put(longNumber, node);
            if (parLongNumber.equals(longNumber)) {
                root = node;
                continue;
            }
            ((DefaultKingdeeTreeNode)map.get(parLongNumber)).add((MutableTreeNode)node);
        }
        NewOrgViewHelper.reBuildAdminTreeBySortCode((DefaultKingdeeTreeNode)root);
        return root;
    }

    public static void reset() {
        start = System.currentTimeMillis();
    }

    public static void printTimeCost(String info) {
        logger.info((Object)(info + " Cost:: " + (System.currentTimeMillis() - start)));
    }

    public static String getWhereStr(Context ctx, String name) throws BOSException, EASBizException {
        IHROrgUnit iHRO = HROrgUnitFactory.getLocalInstance((Context)ctx);
        HROrgUnitInfo hrInfo = ContextUtil.getCurrentHRUnit((Context)ctx);
        AdminOrgUnitCollection adminColl = iHRO.getAdminOrgUnitCollection(hrInfo.getId().toString());
        StringBuffer whereStr = new StringBuffer(" WHERE (");
        int size = adminColl.size();
        if (size == 0) {
            whereStr.append(name).append(" IS NULL) ");
            return whereStr.toString();
        }
        for (int i = 0; i < size; ++i) {
            if (i != 0 && i < size - 1 || size > 1 && i == 0) {
                whereStr.append(name).append("='").append(adminColl.get(i).getId()).append("' OR ");
                continue;
            }
            whereStr.append(name).append("='").append(adminColl.get(i).getId()).append("' ");
        }
        whereStr.append(") ");
        return whereStr.toString();
    }

    public static byte[] convertFileTOBytes(File file) throws Exception {
        if (file != null) {
            int size = (int)file.length();
            try (FileInputStream fin = null;){
                fin = new FileInputStream(file);
                byte[] bts = null;
                if (size > 0) {
                    bts = new byte[size];
                    fin.read(bts);
                    byte[] byArray = bts;
                    return byArray;
                }
            }
        }
        return null;
    }

    public static void canEditEmployee(KDTable tblMain) throws Exception {
        String curHrId;
        String pId = null;
        int[] rowID = KDTableUtil.getSelectedRows((KDTable)tblMain);
        if (rowID.length <= 0 || tblMain.getRow(rowID[0]) == null || tblMain.getRow(rowID[0]).getCell("id") == null) {
            return;
        }
        pId = tblMain.getRow(rowID[0]).getCell("id").getValue().toString();
        IEmpInnerFacade iEmpInner = EmpInnerFacadeFactory.getRemoteInstance();
        String hrId = iEmpInner.getEmpHROrgUnitID(pId);
        if (hrId != null && SysContext.getSysContext().getCurrentHRUnit() != null && !hrId.equals(curHrId = SysContext.getSysContext().getCurrentHRUnit().getId().toString())) {
            throw new EmployeeException(EmployeeException.NOT_EDIT_EMPLOYEE);
        }
    }

    public static boolean canEditEmployee(String pId) throws Exception {
        String curHrId;
        IEmpInnerFacade iEmpInner = EmpInnerFacadeFactory.getRemoteInstance();
        String hrId = iEmpInner.getEmpHROrgUnitID(pId);
        return hrId == null || SysContext.getSysContext().getCurrentHRUnit() == null || hrId.equals(curHrId = SysContext.getSysContext().getCurrentHRUnit().getId().toString());
    }

    public static FilterInfo customMergeFilter(FilterInfo filter1, FilterInfo filter2, String mergeType) throws BOSException {
        FilterInfo filterResult = new FilterInfo();
        if (filter1 == null || filter1.getFilterItems().size() <= 0) {
            if (filter2 != null && filter2.getFilterItems().size() > 0) {
                filterResult = filter2;
            }
        } else if (filter2 == null || filter2.getFilterItems().size() <= 0) {
            filterResult = filter1;
        } else {
            filter1.mergeFilter(filter2, mergeType);
            filterResult = filter1;
        }
        return filterResult;
    }

    private static ArrayList getAdminRange(Context ctx) throws BOSException, EASBizException {
        ArrayList<String> list = new ArrayList<String>();
        UserInfo userInfo = ContextUtil.getCurrentUserInfo((Context)ctx);
        if (userInfo.getId().toString().equals("00000000-0000-0000-0000-00000000000013B7DE7F")) {
            return list;
        }
        StringBuffer sql = new StringBuffer("SELECT FORGID FROM T_PM_OrgRange WHERE FUserID='");
        sql.append(userInfo.getId().toString());
        sql.append("' AND FType = 20 ");
        try {
            IRowSet rows = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            while (rows.next()) {
                list.add(rows.getString("FORGID"));
            }
        }
        catch (SQLException ex) {
            throw new BOSException((Throwable)ex);
        }
        return list;
    }

    private static ArrayList getAdminIdsByPerson(Context ctx, String pId) throws BOSException, EASBizException {
        StringBuffer sql = new StringBuffer("SELECT T1.FID FROM T_ORG_Admin T1 ");
        sql.append("INNER JOIN T_ORG_Position T2 ON T1.FID = T2.FAdminOrgUnitID ");
        sql.append("INNER JOIN T_ORG_PositionMember T3 ON T2.FID = T3.FPositionID ");
        sql.append("INNER JOIN T_BD_Person T4 ON T3.FPersonID = T4.FID ");
        sql.append("WHERE T4.FID = ? ");
        Object[] param = new Object[]{pId};
        IRowSet rows = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])param);
        ArrayList<String> list = new ArrayList<String>();
        try {
            while (rows.next()) {
                list.add(rows.getString(1));
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return list;
    }

    private static ArrayList getAdminIdsByPersonId(Context ctx, String pId) throws BOSException, EASBizException {
        StringBuffer sql = new StringBuffer("SELECT T1.FID FROM T_ORG_Admin T1 ");
        sql.append("INNER JOIN T_ORG_Position T2 ON T1.FID = T2.FAdminOrgUnitID ");
        sql.append("INNER JOIN T_ORG_PositionMember T3 ON T2.FID = T3.FPositionID ");
        sql.append("INNER JOIN T_BD_Person T4 ON T3.FPersonID = T4.FID ");
        sql.append("WHERE T4.FID = ? ");
        Object[] param = new Object[]{pId};
        IRowSet rows = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])param);
        ArrayList<String> list = new ArrayList<String>();
        try {
            while (rows.next()) {
                list.add(rows.getString(1));
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        if (list.size() == 0) {
            sql = new StringBuffer("SELECT FPersonDep FROM T_HR_PersonPosition ");
            sql.append("WHERE FPersonID = ? ");
            rows = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])param);
            try {
                while (rows.next()) {
                    list.add(rows.getString(1));
                }
            }
            catch (SQLException e) {
                throw new BOSException((Throwable)e);
            }
        }
        return list;
    }

    @Deprecated
    public static void canUpdateEmployee(Context ctx, PersonInfo pInfo) throws BOSException, EASBizException {
        EmployeeTypeInfo empType;
        if (pInfo.get("EmployeeMainListUI") != null && "EmployeeMainListUI".equals(pInfo.get("EmployeeMainListUI")) && (empType = EmployeeTypeFactory.getLocalInstance((Context)ctx).getEmployeeTypeInfo((IObjectPK)new ObjectUuidPK(pInfo.getEmployeeType().getId()))) != null && (empType.getInService().getValue() == 0 || empType.getInService().getValue() == 2 || empType.getInService().getValue() == 3)) {
            throw new BaseException(BaseException.NOPOSITION_PERSON);
        }
        ArrayList adminRangeList = HRUtil.getAdminRange(ctx);
        ArrayList personAdminList = null;
        personAdminList = pInfo.get("EmployeeMainListUI") != null ? HRUtil.getAdminIdsByPerson(ctx, pInfo.getId().toString()) : HRUtil.getAdminIdsByPersonId(ctx, pInfo.getId().toString());
        boolean flag = true;
        for (int i = 0; i < adminRangeList.size(); ++i) {
            for (int t = 0; t < personAdminList.size(); ++t) {
                if (!adminRangeList.get(i).toString().equals(personAdminList.get(t).toString())) continue;
                flag = false;
                return;
            }
        }
        if (flag) {
            throw new BaseException(BaseException.NO_PERMISSON_MODIFY_PERSON);
        }
    }

    public static int getAdminOrgLevelCount(AdminOrgUnitInfo info) throws Exception {
        StringBuffer sql = new StringBuffer("SELECT MAX(FLevel) FLevelMax,MIN(FLevel) FLevelMin FROM T_ORG_Admin WHERE FID = '");
        sql.append(info.getId().toString());
        sql.append("' OR FLongNumber LIKE '");
        sql.append(info.getLongNumber());
        sql.append("!%'");
        ISQLExecutor iSQL = SQLExecutorFactory.getRemoteInstance((String)sql.toString());
        IRowSet rows = iSQL.executeSQL();
        if (rows.next()) {
            return rows.getInt("FLevelMax") - rows.getInt("FLevelMin");
        }
        return 0;
    }

    public static void moveTableRowToTop(KDTable tblMain) throws Exception {
        KDTSelectBlock block;
        ArrayList blocks = tblMain.getSelectManager().getBlocks();
        if (blocks == null || blocks.size() > 1) {
            MsgBox.showError((String)EASResource.getString((String)"com.kingdee.eas.hr.base.BASEAutoGenerateResource", (String)"130_HRUtil"));
            SysUtil.abort();
        }
        if ((block = tblMain.getSelectManager().get()) != null) {
            int endIndex;
            ArrayList<IRow> rowList = new ArrayList<IRow>();
            int beginIndex = block.getBeginRow();
            if (beginIndex == 0) {
                return;
            }
            for (int i = endIndex = block.getEndRow(); i >= beginIndex; --i) {
                rowList.add(tblMain.getRow(i));
                tblMain.removeRow(i);
            }
            int index = 0;
            for (int i = rowList.size() - 1; i >= 0; --i) {
                tblMain.addRow(index, (IRow)rowList.get(i));
                ++index;
            }
            tblMain.getSelectManager().select(new KDTSelectBlock(0, 0, endIndex - beginIndex, 1, 2));
            tblMain.scrollToVisible(0, 0);
        } else {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.hr.base.BASEAutoGenerateResource", (String)"131_HRUtil"));
        }
    }

    public static void moveTableRowToUp(KDTable tblMain) throws Exception {
        KDTSelectBlock block;
        ArrayList blocks = tblMain.getSelectManager().getBlocks();
        if (blocks == null || blocks.size() > 1) {
            MsgBox.showError((String)EASResource.getString((String)"com.kingdee.eas.hr.base.BASEAutoGenerateResource", (String)"130_HRUtil"));
            SysUtil.abort();
        }
        if ((block = tblMain.getSelectManager().get()) != null) {
            int endIndex;
            ArrayList<IRow> rowList = new ArrayList<IRow>();
            int beginIndex = block.getBeginRow();
            if (beginIndex == 0) {
                return;
            }
            for (int i = endIndex = block.getEndRow(); i >= beginIndex; --i) {
                rowList.add(tblMain.getRow(i));
                tblMain.removeRow(i);
            }
            int index = beginIndex - 1;
            for (int i = rowList.size() - 1; i >= 0; --i) {
                tblMain.addRow(index, (IRow)rowList.get(i));
                ++index;
            }
            tblMain.getSelectManager().select(new KDTSelectBlock(beginIndex - 1, 0, endIndex - 1, 1, 2));
            tblMain.scrollToVisible(beginIndex - 1, 0);
        } else {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.hr.base.BASEAutoGenerateResource", (String)"131_HRUtil"));
        }
    }

    public static void moveTableRowToDown(KDTable tblMain) throws Exception {
        KDTSelectBlock block;
        ArrayList blocks = tblMain.getSelectManager().getBlocks();
        if (blocks == null || blocks.size() > 1) {
            MsgBox.showError((String)EASResource.getString((String)"com.kingdee.eas.hr.base.BASEAutoGenerateResource", (String)"130_HRUtil"));
            SysUtil.abort();
        }
        if ((block = tblMain.getSelectManager().get()) != null) {
            ArrayList<IRow> rowList = new ArrayList<IRow>();
            int beginIndex = block.getBeginRow();
            int endIndex = block.getEndRow();
            if (endIndex == tblMain.getRowCount() - 1) {
                return;
            }
            for (int i = endIndex; i >= beginIndex; --i) {
                rowList.add(tblMain.getRow(i));
                tblMain.removeRow(i);
            }
            int index = beginIndex + 1;
            for (int i = rowList.size() - 1; i >= 0; --i) {
                tblMain.addRow(index, (IRow)rowList.get(i));
                ++index;
            }
            tblMain.getSelectManager().select(new KDTSelectBlock(beginIndex + 1, 0, endIndex + 1, 1, 2));
            tblMain.scrollToVisible(beginIndex + 1, 0);
        } else {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.hr.base.BASEAutoGenerateResource", (String)"131_HRUtil"));
        }
    }

    public static void moveTableRowToBottom(KDTable tblMain) throws Exception {
        KDTSelectBlock block;
        ArrayList blocks = tblMain.getSelectManager().getBlocks();
        if (blocks == null || blocks.size() > 1) {
            MsgBox.showError((String)EASResource.getString((String)"com.kingdee.eas.hr.base.BASEAutoGenerateResource", (String)"130_HRUtil"));
            SysUtil.abort();
        }
        if ((block = tblMain.getSelectManager().get()) != null) {
            ArrayList<IRow> rowList = new ArrayList<IRow>();
            int beginIndex = block.getBeginRow();
            int endIndex = block.getEndRow();
            int rowCount = tblMain.getRowCount();
            if (endIndex == tblMain.getRowCount() - 1) {
                return;
            }
            for (int i = endIndex; i >= beginIndex; --i) {
                rowList.add(tblMain.getRow(i));
                tblMain.removeRow(i);
            }
            int index = rowCount - (endIndex - beginIndex) - 1;
            for (int i = rowList.size() - 1; i >= 0; --i) {
                tblMain.addRow(index, (IRow)rowList.get(i));
                ++index;
            }
            tblMain.getSelectManager().select(new KDTSelectBlock(rowCount - (endIndex - beginIndex) - 1, 0, index, 1, 2));
            tblMain.scrollToVisible(rowCount - (endIndex - beginIndex) - 1, 0);
        } else {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.hr.base.BASEAutoGenerateResource", (String)"131_HRUtil"));
        }
    }

    public static void setBirtDayAndSexByIDCaridNO(KDTextField txtIDCardNO, KDDatePicker dateBirthday, KDComboBox comboGender) {
        String idCardNO = txtIDCardNO.getText();
        if (StringUtils.isEmpty((String)idCardNO)) {
            return;
        }
        int intIdCaridNO = idCardNO.trim().length();
        if (intIdCaridNO == 15 || intIdCaridNO == 18) {
            try {
                HRUtil.setDateBirthdayByIDCradNO(dateBirthday, idCardNO, intIdCaridNO);
                HRUtil.setSexByIDCardNO(comboGender, idCardNO, intIdCaridNO);
            }
            catch (Exception ex) {
                ExceptionHandler.handle((Throwable)ex);
            }
        }
    }

    public static void setBirtDayAndSexByIDCaridNO(KDFilterTextField txtIDCardNO, KDDatePicker dateBirthday, KDComboBox comboGender) {
        String idCardNO = txtIDCardNO.getText();
        if (StringUtils.isEmpty((String)idCardNO)) {
            return;
        }
        int intIdCaridNO = idCardNO.trim().length();
        if (intIdCaridNO == 15 || intIdCaridNO == 18) {
            try {
                HRUtil.setDateBirthdayByIDCradNO(dateBirthday, idCardNO, intIdCaridNO);
                HRUtil.setSexByIDCardNO(comboGender, idCardNO, intIdCaridNO);
            }
            catch (Exception ex) {
                ExceptionHandler.handle((Throwable)ex);
            }
        }
    }

    private static void setDateBirthdayByIDCradNO(KDDatePicker dateBirthday, String strIDCardNO, int cardType) throws ParseException {
        if (dateBirthday.getValue() != null) {
            return;
        }
        String strYear = "";
        String strMonth = "";
        String strDay = "";
        if (cardType == 15) {
            strYear = "19" + strIDCardNO.substring(6, 8);
            strMonth = strIDCardNO.substring(8, 10);
            strDay = strIDCardNO.substring(10, 12);
        } else if (cardType == 18) {
            strYear = strIDCardNO.substring(6, 10);
            strMonth = strIDCardNO.substring(10, 12);
            strDay = strIDCardNO.substring(12, 14);
        }
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        if (Integer.parseInt(strMonth) > 12 || Integer.parseInt(strMonth) < 1) {
            return;
        }
        if (Integer.parseInt(strDay) > 31 || Integer.parseInt(strDay) < 1) {
            return;
        }
        dateBirthday.setValue((Object)sdf.parse(strYear + "-" + strMonth + "-" + strDay));
    }

    private static void setSexByIDCardNO(KDComboBox comboGender, String strIDCardNO, int cardType) throws Exception {
        String lastNum = "";
        if (cardType == 15) {
            lastNum = strIDCardNO.substring(14);
        } else if (cardType == 18) {
            lastNum = strIDCardNO.substring(16, 17);
        }
        int sexNum = 0;
        try {
            sexNum = Integer.parseInt(lastNum) % 2;
        }
        catch (Exception ex) {
            throw new EmployeeException(EmployeeException.EMP_IDCARDINO_ERROR);
        }
        if (sexNum == 1) {
            comboGender.setSelectedItem((Object)Genders.Male);
        } else if (sexNum == 0) {
            comboGender.setSelectedItem((Object)Genders.Female);
        }
    }

    public static KDComboBox createBaseDataComboBox(AbstractObjectCollection coll) throws Exception {
        DefaultComboBoxModel<IObjectValue> model = new DefaultComboBoxModel<IObjectValue>();
        if (coll == null || coll.size() == 0) {
            return new KDComboBox(model);
        }
        for (int i = 0; i < coll.size(); ++i) {
            model.addElement(coll.getObject(i));
        }
        if (coll.size() != 0) {
            model.setSelectedItem(coll.getObject(0));
        }
        KDComboBox combo = new KDComboBox(model);
        return combo;
    }

    public static int getExceptionNumber() {
        int exceptionNum = Integer.MAX_VALUE;
        try {
            IDeployInfoManager manager = DeployInfoManagerFactory.getDeployInfoManager();
            ConfigurationItem debugItem = manager.getConfigItem("DebugOptions");
            exceptionNum = Integer.parseInt(debugItem.getProperty("exceptionCellNumber", "400000"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return exceptionNum;
    }

    public static BizEnumInfo getBizEnum(MetaDataPK pk) {
        return MetaDataLoader.getEnum(null, (IMetaDataPK)pk);
    }

    public static BizEnumInfo getEnum(QueryFieldInfo fld) {
        PropertyRefInfo ref;
        if (fld == null) {
            return null;
        }
        BizEnumInfo bizEnum = null;
        if (fld.getPropertyRefs().size() == 1 && (ref = fld.getPropertyRefs().get(0)).getSubEntity() != null && ref.getRefProperty() != null && ref.getRefProperty() instanceof OwnPropertyInfo && ((OwnPropertyInfo)ref.getRefProperty()).getDataType().equals((Object)DataType.ENUM)) {
            PropertyInfo prop = ref.getRefProperty();
            if (prop instanceof OwnPropertyInfo) {
                String metadataRef = ((OwnPropertyInfo)prop).getMetaDataRef();
                String className = MetaDataUtils.getClassName((String)metadataRef);
                String packageName = MetaDataUtils.getPackageName((String)metadataRef);
                try {
                    bizEnum = HRUtil.getBizEnum(new MetaDataPK(packageName, className));
                }
                catch (Exception be) {
                    return null;
                }
            } else {
                return null;
            }
        }
        if (bizEnum != null) {
            return bizEnum;
        }
        return null;
    }

    public static boolean isBoolean(QueryFieldInfo fld) {
        PropertyRefInfo ref;
        if (fld == null) {
            return false;
        }
        return fld.getPropertyRefs().size() == 1 && (ref = fld.getPropertyRefs().get(0)).getSubEntity() != null && ref.getRefProperty() != null && ref.getRefProperty() instanceof OwnPropertyInfo && ((OwnPropertyInfo)ref.getRefProperty()).getDataType().equals((Object)DataType.BOOLEAN);
    }

    public static void executeBatch(Context ctx, String sql, List paramsList) throws BOSException {
        Connection conn = null;
        PreparedStatement ps = null;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            ps = conn.prepareStatement(sql);
            Object[] params = null;
            int k = 1;
            boolean flag = false;
            for (int i = 0; i < paramsList.size(); ++i) {
                params = (Object[])paramsList.get(i);
                for (int j = 0; j < params.length; ++j) {
                    if (params[j] != null) {
                        ps.setObject(j + 1, params[j]);
                        continue;
                    }
                    ps.setNull(j + 1, 12);
                }
                ps.addBatch();
                if (i == k * 8000) {
                    flag = true;
                }
                if (i <= k * 8000 || !flag) continue;
                ps.executeBatch();
                ++k;
                flag = false;
                ps.clearBatch();
            }
            if (!flag) {
                ps.executeBatch();
            }
        }
        catch (SQLException exc) {
            try {
                Object sb = null;
                Object params = null;
                throw new BOSException("Sql222 execute exception : " + sql, (Throwable)exc);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(ps, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)ps, (Connection)conn);
    }

    public static DefaultKingdeeTreeNode getRootNew(String hrOrgUnitID, boolean useOrgRangeFilter, boolean showSealUpOrg) throws Exception {
        String firstLongNumber;
        IPositionMember iPM = PositionMemberFactory.getRemoteInstance();
        AdminOrgUnitCollection adminCol = iPM.getAdminOrgUnitCollectionWithOrgRangeFilter(hrOrgUnitID, showSealUpOrg);
        if (!useOrgRangeFilter) {
            adminCol = (AdminOrgUnitCollection)iPM.getAdminOrgUnitCollection(hrOrgUnitID, showSealUpOrg);
        }
        if (adminCol.size() == 0) {
            return null;
        }
        HashMap<String, DefaultKingdeeTreeNode> map = new HashMap<String, DefaultKingdeeTreeNode>();
        AdminOrgUnitInfo adminInfo = null;
        if (AdminOrgUnitFactory.getRemoteInstance().exists((IObjectPK)new ObjectUuidPK("00000000-0000-0000-0000-000000000000CCE7AED4"))) {
            adminInfo = AdminOrgUnitFactory.getRemoteInstance().getAdminOrgUnitInfo((IObjectPK)new ObjectUuidPK("00000000-0000-0000-0000-000000000000CCE7AED4"));
        }
        DefaultKingdeeTreeNode root = new DefaultKingdeeTreeNode(adminInfo);
        OrgF7InnerUtils.disableTreeNode((DefaultKingdeeTreeNode)root);
        String rootLongNumber = firstLongNumber = adminCol.get(0).getLongNumber();
        if (firstLongNumber.indexOf("!") != -1) {
            rootLongNumber = firstLongNumber.substring(0, firstLongNumber.indexOf("!"));
        }
        map.put(rootLongNumber, root);
        String longNumber = "";
        String parLongNumber = "";
        DefaultKingdeeTreeNode node = null;
        int n = adminCol.size();
        for (int i = 0; i < n; ++i) {
            parLongNumber = longNumber = adminCol.get(i).getLongNumber();
            while (!map.containsKey(parLongNumber) && parLongNumber.lastIndexOf("!") != -1) {
                parLongNumber = parLongNumber.substring(0, parLongNumber.lastIndexOf("!"));
            }
            node = new DefaultKingdeeTreeNode((Object)adminCol.get(i));
            map.put(longNumber, node);
            if (parLongNumber.equals(longNumber)) {
                root = node;
                continue;
            }
            ((DefaultKingdeeTreeNode)map.get(parLongNumber)).add((MutableTreeNode)node);
        }
        NewOrgViewHelper.reBuildAdminTreeBySortCode((DefaultKingdeeTreeNode)root);
        return root;
    }

    public static boolean getEmployeTypeIsOnTheStrength(Context ctx, String personNum) throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append("select t.FIsOnTheStrength from t_bd_person p inner join ").append("T_HR_BDEmployeeType t on p.FEmployeeTypeID=t.fid  where p.fNumber='").append(personNum).append("'");
        boolean result = false;
        try {
            IRowSet rs = null;
            if (ctx != null) {
                rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            } else {
                ISQLExecutor iSql = SQLExecutorFactory.getRemoteInstance((String)sql.toString());
                rs = iSql.executeSQL();
            }
            while (rs.next()) {
                int flag = rs.getInt("FIsOnTheStrength");
                if (flag == 1) {
                    result = true;
                    continue;
                }
                result = false;
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return result;
    }

    public static boolean getEmployeTypeIsOnTheStrengthById(Context ctx, String personId) throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append("select t.FIsOnTheStrength from t_bd_person p inner join ").append("T_HR_BDEmployeeType t on p.FEmployeeTypeID=t.fid  where p.fid='").append(personId).append("'");
        boolean result = false;
        try {
            IRowSet rs = null;
            if (ctx != null) {
                rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            } else {
                ISQLExecutor iSql = SQLExecutorFactory.getRemoteInstance((String)sql.toString());
                rs = iSql.executeSQL();
            }
            while (rs.next()) {
                int flag = rs.getInt("FIsOnTheStrength");
                if (flag == 1) {
                    result = true;
                    continue;
                }
                result = false;
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return result;
    }

    public static void checkCanUpdatePeronByEmpType(Context ctx, String personId, String targetEmpType) throws BOSException, EASBizException {
        boolean isOnTheStrength = HRUtil.getIsOnTheStrengthByEmployeeType(ctx, targetEmpType);
        if (isOnTheStrength) {
            StringBuffer sql = new StringBuffer();
            sql.append("select FPositionID from T_ORG_PositionMember where fPersonID='").append(personId).append("'");
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            try {
                while (rs.next()) {
                    String positionId = rs.getString("FPositionID");
                    IPersonPlan iPPlan = PersonPlanFactory.getLocalInstance((Context)ctx);
                    iPPlan.canAddPerson(positionId);
                }
            }
            catch (SQLException e) {
                throw new BOSException((Throwable)e);
            }
        }
    }

    public static boolean getIsOnTheStrengthByEmployeeType(Context ctx, String employeeType) throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append("select FIsOnTheStrength from ").append("T_HR_BDEmployeeType WHERE fid='").append(employeeType).append("'");
        boolean result = false;
        try {
            IRowSet rs = null;
            if (ctx != null) {
                rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            } else {
                ISQLExecutor iSql = SQLExecutorFactory.getRemoteInstance((String)sql.toString());
                rs = iSql.executeSQL();
            }
            while (rs.next()) {
                int flag = rs.getInt("FIsOnTheStrength");
                if (flag == 1) {
                    result = true;
                    continue;
                }
                result = false;
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return result;
    }

    public static void removePastmenu(KDTable table, KDTMenuManager tm) {
        Component[] obj = tm.getMenu().getComponents();
        Component comp2 = null;
        for (Component comp2 : obj) {
            if (comp2.getName() == null || !comp2.getName().equals("menuItemPaste")) continue;
            ((KDMenuItem)comp2).setVisible(false);
        }
    }

    public static boolean hasFunctionPermission(IObjectPK orgPK, String uiName, ItemAction action) throws Exception {
        ObjectUuidPK userPk = new ObjectUuidPK(SysContext.getSysContext().getCurrentUserInfo().getId());
        MetaDataPK uiPK = new MetaDataPK(uiName);
        IMetaDataPK actionPk = HRUtil.getActionPK(action);
        boolean isbind = PermissionFactory.getRemoteInstance().isBindPermission((IMetaDataPK)uiPK, actionPk);
        boolean hasPermission = PermissionFactory.getRemoteInstance().hasFunctionPermission((IObjectPK)userPk, orgPK, (IMetaDataPK)uiPK, actionPk);
        return isbind && hasPermission;
    }

    private static IMetaDataPK getActionPK(ItemAction action) {
        assert (action != null);
        String actoinName = action.getClass().getName();
        if (actoinName.indexOf("$") >= 0) {
            actoinName = actoinName.substring(actoinName.indexOf("$") + 1);
        }
        return new MetaDataPK(actoinName);
    }

    public static boolean useCustomizedPlatform(CoreUI coreui) {
        return !(coreui.getUILifeCycleHandler() instanceof OldUILifeCycleHander);
    }

    public static String getCurrentDate() {
        GregorianCalendar cal = new GregorianCalendar();
        SimpleDateFormat sFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        return "{ts'" + sFormat.format(cal.getTime()) + "'}";
    }

    public static void deployDynamicEmpPage(UIObjectInfo uiObj) throws Exception {
        if (uiObj == null) {
            return;
        }
        String templateClassName = uiObj.getExtendedProperty("template_ui_class");
        String entityPK = "";
        int type = 0;
        if (templateClassName.equals("com.kingdee.eas.hr.emp.client.EmpSingleInfoCustomEditUI")) {
            type = 1;
            DataObjectCollection dataObjectCollection = uiObj.getDataObjects();
            if (dataObjectCollection == null) {
                return;
            }
            for (int i = 0; i < dataObjectCollection.size(); ++i) {
                DataObjectInfo doInfo = dataObjectCollection.get(i);
                String objType = doInfo.getObjectType();
                if (!MetaDataTypeList.ENTITY.toString().equals(objType)) continue;
                entityPK = doInfo.getType();
                break;
            }
        }
        Object id = null;
        ISQLExecutor iSQL = SQLExecutorFactory.getRemoteInstance((String)("SELECT FID FROM T_HR_EMPLOYEESYSTEMPAGE WHERE FUINAME='" + uiObj.getFullName() + "$$" + templateClassName + "'"));
        IRowSet rows = iSQL.executeSQL();
        if (rows.next()) {
            id = rows.getObject(1);
        }
        if (id == null && (rows = (iSQL = SQLExecutorFactory.getRemoteInstance((String)"SELECT FID FROM T_HR_EMPLOYEESYSTEMPAGE ORDER BY FID DESC ")).executeSQL()).next()) {
            id = rows.getObject(1);
            id = Integer.parseInt(id.toString()) + 1;
        }
        HashMap<String, Object> info = new HashMap<String, Object>();
        info.put("FID", id == null ? "" : id.toString());
        info.put("FNAME", uiObj.getAlias());
        info.put("FENTITYNAME", entityPK);
        info.put("FTYPE", type);
        info.put("FUINAME", uiObj.getFullName() + "$$" + templateClassName);
        IEmployeeEditPageScheme editPage = EmployeeEditPageSchemeFactory.getRemoteInstance();
        editPage.submitSystemPage(info);
    }

    public static String getAdminOrgRangeAndHRSql(Set hrSet) {
        if (hrSet == null || hrSet.size() == 0) {
            return null;
        }
        String userID = SysContext.getSysContext().getCurrentUserInfo().getId().toString();
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT T1.fid FROM t_org_admin T1 ");
        sql.append(" inner join t_pm_orgrange T2 on T1.Fid= T2.Forgid");
        sql.append(" inner join t_org_unitrelation T3 on t3.ffromunitid = T1.fid");
        sql.append(" where T2.FUSERID= '").append(userID).append("'");
        sql.append(" AND T2.FType = 20 ");
        sql.append(" and T3.FTOUNITID in ").append(HRUtil.getStrFromSet(hrSet)).append(" ");
        sql.append(" and T3.Ftyperelationid='00000000-0000-0000-0000-0000000000100FE9F8B5' ");
        return sql.toString();
    }

    public static String getAdminOrgRangeAndHRSql(String hrOrgUnitID) {
        if (hrOrgUnitID == null) {
            hrOrgUnitID = SysContext.getSysContext().getCurrentHRUnit().getId().toString();
        }
        String userID = SysContext.getSysContext().getCurrentUserInfo().getId().toString();
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT T1.fid FROM t_org_admin T1 ");
        sql.append(" inner join t_pm_orgrange T2 on T1.Fid= T2.Forgid");
        sql.append(" inner join t_org_unitrelation T3 on t3.ffromunitid = T1.fid");
        sql.append(" where T2.FUSERID= '").append(userID).append("'");
        sql.append(" AND T2.FType = 20 ");
        sql.append(" and T3.FTOUNITID= '").append(hrOrgUnitID).append("'");
        sql.append(" and T3.Ftyperelationid='00000000-0000-0000-0000-0000000000100FE9F8B5' ");
        return sql.toString();
    }

    public static String getAdminOrgRangeSql() {
        String userID = SysContext.getSysContext().getCurrentUserInfo().getId().toString();
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT T1.fid FROM t_org_admin T1 ");
        sql.append(" inner join t_pm_orgrange T2 on T1.Fid= T2.Forgid");
        sql.append(" where T2.FUSERID= '").append(userID).append("'");
        sql.append(" AND T2.FType = 20 ");
        return sql.toString();
    }

    public static String getTypeRelaTOHRSQL(Set hrSet) {
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT T1.fid FROM t_org_admin T1 ");
        sql.append(" inner join t_org_unitrelation T3 on t3.ffromunitid = T1.fid");
        sql.append(" where  T3.FTOUNITID in ").append(HRUtil.getStrFromSet(hrSet)).append(" ");
        sql.append(" and T3.Ftyperelationid='00000000-0000-0000-0000-0000000000100FE9F8B5' ");
        return sql.toString();
    }

    public static String getTypeRelaTOHRSQL(String hrOrgUnitID) {
        if (hrOrgUnitID == null) {
            hrOrgUnitID = SysContext.getSysContext().getCurrentHRUnit().getId().toString();
        }
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT T1.fid FROM t_org_admin T1 ");
        sql.append(" inner join t_org_unitrelation T3 on t3.ffromunitid = T1.fid");
        sql.append(" where  T3.FTOUNITID ='").append(hrOrgUnitID).append("'");
        sql.append(" and T3.Ftyperelationid='00000000-0000-0000-0000-0000000000100FE9F8B5' ");
        return sql.toString();
    }

    public static String getStrFromSet(Set set) {
        StringBuffer sb = new StringBuffer();
        sb.append("(");
        Iterator ite = set.iterator();
        while (ite.hasNext()) {
            sb.append("'");
            sb.append(ite.next().toString());
            sb.append("',");
        }
        sb.append("'')");
        return sb.toString();
    }

    public static Date getBeforeDate(Date dt) {
        return DateUtil.getBeforeDay((Date)dt);
    }

    public static Date getAftereDate(Date dt) {
        return DateUtil.getAfterDay((Date)dt);
    }

    public static Date getMaxEndDate() {
        try {
            return DateTimeUtils.parseDate((String)CHANGEENDDATE);
        }
        catch (ParseException e) {
            return null;
        }
    }

    public static String getMaxEndDateTs() {
        return "{ts '2199-12-31'}";
    }

    public static Date getMinEffdtDate() {
        try {
            return DateTimeUtils.parseDate((String)EARLIEST_EFFDT);
        }
        catch (ParseException e) {
            return null;
        }
    }

    public static String getActReaLongNumberByID(Context ctx, String id) {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("longNumber"));
        AbstractAffairActionReasonInfo info = null;
        try {
            info = ctx == null ? AffairActionReasonFactory.getRemoteInstance().getAffairActionReasonInfo((IObjectPK)new ObjectUuidPK(id), sic) : AffairActionReasonFactory.getLocalInstance(ctx).getAffairActionReasonInfo((IObjectPK)new ObjectUuidPK(id), sic);
        }
        catch (EASBizException e) {
            ExceptionHandler.handle((Throwable)e);
        }
        catch (BOSException e) {
            ExceptionHandler.handle((Throwable)e);
        }
        return info == null ? "" : info.getLongNumber();
    }

    public static FilterInfo getReasonLongNumberFilter(Set reasonLongNumberSet) throws BOSException {
        FilterInfo filterInfo = new FilterInfo();
        Iterator iterator = reasonLongNumberSet.iterator();
        while (iterator.hasNext()) {
            FilterInfo retFilter = new FilterInfo();
            String reasonLongNumberStr = (String)iterator.next();
            retFilter.getFilterItems().add(new FilterItemInfo("actionReason.longNumber", (Object)(reasonLongNumberStr + "%"), CompareType.LIKE));
            filterInfo.mergeFilter(retFilter, "or");
        }
        return filterInfo;
    }

    public static String[] arrayCopy(String[] ars, int start, int length) {
        String[] newArray = new String[length];
        for (int i = 0; i < length; ++i) {
            newArray[i] = ars[i + start];
        }
        return newArray;
    }

    public static int[] arrayCopy(int[] ars, int start, int length) {
        int[] newArray = new int[length];
        for (int i = 0; i < length; ++i) {
            newArray[i] = ars[i + start];
        }
        return newArray;
    }
}

