/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.base.util;

import com.kingdee.eas.hr.base.client.DesignerPanel;
import com.kingdee.eas.hr.base.client.Node;
import java.awt.FontMetrics;
import java.util.ArrayList;
import java.util.List;

public class OrgChartUtil {
    private static boolean canAlign(DesignerPanel designer) {
        return designer.getSelectedEdges().size() <= 0 && designer.getSelectedNodes().size() >= 2;
    }

    public static void alignLeft(DesignerPanel designer) {
        if (!OrgChartUtil.canAlign(designer)) {
            return;
        }
        List nodes = OrgChartUtil.sortNodeByY(designer.getSelectedNodes());
        Node baseNode = null;
        Node node = null;
        baseNode = (Node)nodes.get(0);
        int size = nodes.size();
        for (int i = 1; i < size; ++i) {
            node = (Node)nodes.get(i);
            node.setX(baseNode.getX());
        }
        designer.repaint();
    }

    public static void alignRight(DesignerPanel designer) {
        if (!OrgChartUtil.canAlign(designer)) {
            return;
        }
        List nodes = OrgChartUtil.sortNodeByY(designer.getSelectedNodes());
        Node baseNode = null;
        Node node = null;
        baseNode = (Node)nodes.get(0);
        int size = nodes.size();
        for (int i = 1; i < size; ++i) {
            node = (Node)nodes.get(i);
            node.setX(baseNode.getX() + node.getWidth() - baseNode.getWidth());
        }
        designer.repaint();
    }

    public static void alignTop(DesignerPanel designer) {
        if (!OrgChartUtil.canAlign(designer)) {
            return;
        }
        List nodes = OrgChartUtil.sortNodeByX(designer.getSelectedNodes());
        Node baseNode = null;
        Node node = null;
        baseNode = (Node)nodes.get(0);
        int size = nodes.size();
        for (int i = 1; i < size; ++i) {
            node = (Node)nodes.get(i);
            node.setY(baseNode.getY());
        }
        designer.repaint();
    }

    public static void alignBottom(DesignerPanel designer) {
        if (!OrgChartUtil.canAlign(designer)) {
            return;
        }
        List nodes = OrgChartUtil.sortNodeByX(designer.getSelectedNodes());
        Node baseNode = null;
        Node node = null;
        baseNode = (Node)nodes.get(0);
        int size = nodes.size();
        for (int i = 1; i < size; ++i) {
            node = (Node)nodes.get(i);
            node.setY(baseNode.getY() + node.getHeight() - baseNode.getHeight());
        }
        designer.repaint();
    }

    public static void setSameWidth(DesignerPanel designer) {
        if (!OrgChartUtil.canAlign(designer)) {
            return;
        }
        List nodes = OrgChartUtil.sortNodeByX(designer.getSelectedNodes());
        Node baseNode = null;
        Node node = null;
        baseNode = (Node)nodes.get(0);
        int size = nodes.size();
        for (int i = 1; i < size; ++i) {
            node = (Node)nodes.get(i);
            node.setWidth(baseNode.getWidth());
        }
        designer.repaint();
    }

    public static void setSameHeight(DesignerPanel designer) {
        if (!OrgChartUtil.canAlign(designer)) {
            return;
        }
        List nodes = OrgChartUtil.sortNodeByX(designer.getSelectedNodes());
        Node baseNode = null;
        Node node = null;
        baseNode = (Node)nodes.get(0);
        int size = nodes.size();
        for (int i = 1; i < size; ++i) {
            node = (Node)nodes.get(i);
            node.setHeight(baseNode.getHeight());
        }
        designer.repaint();
    }

    public static void setSameWidthAndHeight(DesignerPanel designer) {
        if (!OrgChartUtil.canAlign(designer)) {
            return;
        }
        List nodes = OrgChartUtil.sortNodeByX(designer.getSelectedNodes());
        Node baseNode = null;
        Node node = null;
        baseNode = (Node)nodes.get(0);
        int size = nodes.size();
        for (int i = 1; i < size; ++i) {
            node = (Node)nodes.get(i);
            node.setWidth(baseNode.getWidth());
            node.setHeight(baseNode.getHeight());
        }
        designer.repaint();
    }

    public static void setHorizontalGapEqual(DesignerPanel designer) {
        if (!OrgChartUtil.canAlign(designer)) {
            return;
        }
        List nodes = OrgChartUtil.sortNodeByX(designer.getSelectedNodes());
        if (nodes.size() < 3) {
            return;
        }
        Node firstNode = null;
        Node lastNode = null;
        Node node = null;
        firstNode = (Node)nodes.get(0);
        lastNode = (Node)nodes.get(nodes.size() - 1);
        int totalNodeWidth = 0;
        int size = nodes.size();
        for (int i = 0; i < size; ++i) {
            node = (Node)nodes.get(i);
            totalNodeWidth += node.getWidth();
        }
        int totalWidth = lastNode.getX() + lastNode.getWidth() - firstNode.getX();
        int distance = (totalWidth - totalNodeWidth) / (nodes.size() - 1);
        Node previousNode = null;
        for (int i = 1; i < nodes.size() - 1; ++i) {
            node = (Node)nodes.get(i);
            previousNode = (Node)nodes.get(i - 1);
            node.setX(previousNode.getX() + previousNode.getWidth() + distance);
        }
        designer.repaint();
    }

    public static void setVerticalGapEqual(DesignerPanel designer) {
        if (!OrgChartUtil.canAlign(designer)) {
            return;
        }
        List nodes = OrgChartUtil.sortNodeByY(designer.getSelectedNodes());
        if (nodes.size() < 3) {
            return;
        }
        Node firstNode = null;
        Node lastNode = null;
        Node node = null;
        firstNode = (Node)nodes.get(0);
        lastNode = (Node)nodes.get(nodes.size() - 1);
        int totalNodeHeight = 0;
        int size = nodes.size();
        for (int i = 0; i < size; ++i) {
            node = (Node)nodes.get(i);
            totalNodeHeight += node.getHeight();
        }
        int totalHeight = lastNode.getY() + lastNode.getHeight() - firstNode.getY();
        int distance = (totalHeight - totalNodeHeight) / (nodes.size() - 1);
        Node previousNode = null;
        for (int i = 1; i < nodes.size() - 1; ++i) {
            node = (Node)nodes.get(i);
            previousNode = (Node)nodes.get(i - 1);
            node.setY(previousNode.getY() + previousNode.getHeight() + distance);
        }
        designer.repaint();
    }

    public static void addHorizontalGap(DesignerPanel designer) {
        if (!OrgChartUtil.canAlign(designer)) {
            return;
        }
        List nodes = OrgChartUtil.sortNodeByX(designer.getSelectedNodes());
        Node node = null;
        for (int i = 1; i < nodes.size(); ++i) {
            node = (Node)nodes.get(i);
            node.setX(node.getX() + 5 * i);
        }
        designer.repaint();
    }

    public static void reduceHorizontalGap(DesignerPanel designer) {
        if (!OrgChartUtil.canAlign(designer)) {
            return;
        }
        List nodes = OrgChartUtil.sortNodeByX(designer.getSelectedNodes());
        Node node = null;
        for (int i = 1; i < nodes.size(); ++i) {
            node = (Node)nodes.get(i);
            node.setX(node.getX() - 5 * i);
        }
        designer.repaint();
    }

    public static void addVerticalGap(DesignerPanel designer) {
        if (!OrgChartUtil.canAlign(designer)) {
            return;
        }
        List nodes = OrgChartUtil.sortNodeByY(designer.getSelectedNodes());
        Node node = null;
        for (int i = 1; i < nodes.size(); ++i) {
            node = (Node)nodes.get(i);
            node.setY(node.getY() + 5 * i);
        }
        designer.repaint();
    }

    public static void reduceVerticalGap(DesignerPanel designer) {
        if (!OrgChartUtil.canAlign(designer)) {
            return;
        }
        List nodes = OrgChartUtil.sortNodeByY(designer.getSelectedNodes());
        Node node = null;
        for (int i = 1; i < nodes.size(); ++i) {
            node = (Node)nodes.get(i);
            node.setY(node.getY() - 5 * i);
        }
        designer.repaint();
    }

    public static List sortNodeByX(List nodes) {
        ArrayList newNodes = new ArrayList(nodes.size());
        newNodes.add(nodes.get(0));
        Node node = null;
        Node newNode = null;
        boolean noFind = true;
        for (int i = 1; i < nodes.size(); ++i) {
            node = (Node)nodes.get(i);
            noFind = true;
            for (int t = 0; t < newNodes.size(); ++t) {
                newNode = (Node)newNodes.get(t);
                if (node.getX() > newNode.getX()) continue;
                newNodes.add(t, node);
                noFind = false;
                break;
            }
            if (!noFind) continue;
            newNodes.add(node);
        }
        return newNodes;
    }

    public static List sortNodeByY(List nodes) {
        ArrayList newNodes = new ArrayList(nodes.size());
        newNodes.add(nodes.get(0));
        Node node = null;
        Node newNode = null;
        boolean noFind = true;
        for (int i = 1; i < nodes.size(); ++i) {
            node = (Node)nodes.get(i);
            noFind = true;
            for (int t = 0; t < newNodes.size(); ++t) {
                newNode = (Node)newNodes.get(t);
                if (node.getY() > newNode.getY()) continue;
                newNodes.add(t, node);
                noFind = false;
                break;
            }
            if (!noFind) continue;
            newNodes.add(node);
        }
        return newNodes;
    }

    public static List getPrintScreenStr(String str, Node node, FontMetrics fm) {
        ArrayList<String> list = new ArrayList<String>();
        char[] strs = str.toCharArray();
        StringBuffer buf = new StringBuffer();
        if (node.getDisplayTextType() == 1) {
            int w = node.getRect().width - 12;
            int size = strs.length;
            for (int i = 0; i < size; ++i) {
                if (fm.stringWidth(buf.toString() + strs[i]) > w) {
                    list.add(buf.toString());
                    buf = new StringBuffer();
                }
                buf.append(strs[i]);
            }
            list.add(buf.toString());
        } else {
            int h = node.getRect().height - 12;
            int size = strs.length;
            for (int i = 0; i < size; ++i) {
                if (fm.getHeight() * (buf.length() + 1) > h) {
                    if (buf.length() > 0) {
                        list.add(buf.toString());
                    }
                    buf = new StringBuffer();
                }
                buf.append(strs[i]);
            }
            list.add(buf.toString());
        }
        return list;
    }
}

