/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.base.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.swing.StringUtils;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.base.core.hr.util.HRParamUtil;
import com.kingdee.eas.basedata.org.AdminOrgUnitCollection;
import com.kingdee.eas.basedata.org.HROrgUnitCollection;
import com.kingdee.eas.basedata.org.HROrgUnitFactory;
import com.kingdee.eas.basedata.org.HROrgUnitInfo;
import com.kingdee.eas.basedata.org.IHROrgUnit;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.hr.base.BaseInnerFacadeFactory;
import com.kingdee.eas.hr.base.IBaseInnerFacade;
import com.kingdee.eas.hr.compensation.util.CompUtils;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class PositionAdminHRsUtil {
    public static Set getHRsFromAdminSet(Context ctx, Set adminIdSet) throws BOSException {
        HashSet<String> hrSet = new HashSet<String>();
        IQueryExecutor iqec = null;
        iqec = ctx != null ? QueryExecutorFactory.getLocalInstance((Context)ctx, (IMetaDataPK)new MetaDataPK("com.kingdee.eas.hr.org.app", "AdminOfHRsQuery")) : QueryExecutorFactory.getRemoteInstance((IMetaDataPK)new MetaDataPK("com.kingdee.eas.hr.org.app", "AdminOfHRsQuery"));
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)adminIdSet, CompareType.INCLUDE));
        filter.getFilterItems().add(new FilterItemInfo("typeRelation.id", (Object)"00000000-0000-0000-0000-0000000000100FE9F8B5"));
        view.setFilter(filter);
        iqec.setObjectView(view);
        try {
            IRowSet rowSet = iqec.executeQuery();
            while (rowSet.next()) {
                hrSet.add(rowSet.getString("hro.id"));
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        if (hrSet.size() == 0) {
            String oql = "select id where id in" + CompUtils.getStrFromSet((Set)adminIdSet) + " and isHROrgUnit = 1";
            IHROrgUnit iHROrgUnit = null;
            iHROrgUnit = ctx != null ? HROrgUnitFactory.getLocalInstance((Context)ctx) : HROrgUnitFactory.getRemoteInstance();
            HROrgUnitCollection coll = iHROrgUnit.getHROrgUnitCollection(oql);
            int size = coll.size();
            for (int i = 0; i < size; ++i) {
                hrSet.add(coll.get(i).getId().toString());
            }
        }
        return hrSet;
    }

    public static Set getHRsFromAdminSet(Context ctx, Set adminIdSet, String userId) throws BOSException {
        HashSet<String> hrSet = new HashSet<String>();
        IQueryExecutor iqec = null;
        iqec = ctx != null ? QueryExecutorFactory.getLocalInstance((Context)ctx, (IMetaDataPK)new MetaDataPK("com.kingdee.eas.hr.org.app", "AdminOfHRsQuery")) : QueryExecutorFactory.getRemoteInstance((IMetaDataPK)new MetaDataPK("com.kingdee.eas.hr.org.app", "AdminOfHRsQuery"));
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)adminIdSet, CompareType.INCLUDE));
        filter.getFilterItems().add(new FilterItemInfo("user.id", (Object)userId));
        filter.getFilterItems().add(new FilterItemInfo("typeRelation.id", (Object)"00000000-0000-0000-0000-0000000000100FE9F8B5"));
        view.setFilter(filter);
        iqec.setObjectView(view);
        try {
            IRowSet rowSet = iqec.executeQuery();
            while (rowSet.next()) {
                hrSet.add(rowSet.getString("hro.id"));
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return hrSet;
    }

    public static Set getHRsFromAdminSet(Context ctx, String userId) throws BOSException {
        HashSet<String> hrSet = new HashSet<String>();
        IQueryExecutor iqec = null;
        iqec = ctx != null ? QueryExecutorFactory.getLocalInstance((Context)ctx, (IMetaDataPK)new MetaDataPK("com.kingdee.eas.hr.org.app", "AdminOfHRsQuery")) : QueryExecutorFactory.getRemoteInstance((IMetaDataPK)new MetaDataPK("com.kingdee.eas.hr.org.app", "AdminOfHRsQuery"));
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("user.id", (Object)userId));
        filter.getFilterItems().add(new FilterItemInfo("typeRelation.id", (Object)"00000000-0000-0000-0000-0000000000100FE9F8B5"));
        view.setFilter(filter);
        iqec.setObjectView(view);
        try {
            IRowSet rowSet = iqec.executeQuery();
            while (rowSet.next()) {
                hrSet.add(rowSet.getString("hro.id"));
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return hrSet;
    }

    public static Map getHRsMapFromAdminSet(Context ctx, Set adminIdSet) throws BOSException {
        HashMap<String, HashSet> hrMap = new HashMap<String, HashSet>();
        HashSet adminSet = null;
        IQueryExecutor iqec = null;
        iqec = ctx != null ? QueryExecutorFactory.getLocalInstance((Context)ctx, (IMetaDataPK)new MetaDataPK("com.kingdee.eas.hr.org.app", "AdminOfHRsQuery")) : QueryExecutorFactory.getRemoteInstance((IMetaDataPK)new MetaDataPK("com.kingdee.eas.hr.org.app", "AdminOfHRsQuery"));
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)adminIdSet, CompareType.INCLUDE));
        filter.getFilterItems().add(new FilterItemInfo("typeRelation.id", (Object)"00000000-0000-0000-0000-0000000000100FE9F8B5"));
        view.setFilter(filter);
        iqec.setObjectView(view);
        try {
            IRowSet rowSet = iqec.executeQuery();
            while (rowSet.next()) {
                if (!hrMap.containsKey(rowSet.getString("hro.id"))) {
                    adminSet = new HashSet();
                    hrMap.put(rowSet.getString("hro.id"), adminSet);
                } else {
                    adminSet = (HashSet)hrMap.get(rowSet.getString("hro.id"));
                }
                adminSet.add(rowSet.getString("id"));
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return hrMap;
    }

    public static Map getHRsMapFromAdminSet(Context ctx, Set adminIdSet, String userId) throws BOSException {
        HashMap<String, HashSet> hrMap = new HashMap<String, HashSet>();
        HashSet adminSet = null;
        IQueryExecutor iqec = null;
        iqec = ctx != null ? QueryExecutorFactory.getLocalInstance((Context)ctx, (IMetaDataPK)new MetaDataPK("com.kingdee.eas.hr.org.app", "AdminOfHRsQuery")) : QueryExecutorFactory.getRemoteInstance((IMetaDataPK)new MetaDataPK("com.kingdee.eas.hr.org.app", "AdminOfHRsQuery"));
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)adminIdSet, CompareType.INCLUDE));
        filter.getFilterItems().add(new FilterItemInfo("user.id", (Object)userId));
        filter.getFilterItems().add(new FilterItemInfo("typeRelation.id", (Object)"00000000-0000-0000-0000-0000000000100FE9F8B5"));
        view.setFilter(filter);
        iqec.setObjectView(view);
        try {
            IRowSet rowSet = iqec.executeQuery();
            while (rowSet.next()) {
                if (!hrMap.containsKey(rowSet.getString("hro.id"))) {
                    adminSet = new HashSet();
                    hrMap.put(rowSet.getString("hro.id"), adminSet);
                } else {
                    adminSet = (HashSet)hrMap.get(rowSet.getString("hro.id"));
                }
                adminSet.add(rowSet.getString("id"));
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return hrMap;
    }

    public static Map getHRsMapFromAdminSet(Context ctx, String userId) throws BOSException {
        HashMap<String, HashSet> hrMap = new HashMap<String, HashSet>();
        HashSet adminSet = null;
        IQueryExecutor iqec = null;
        iqec = ctx != null ? QueryExecutorFactory.getLocalInstance((Context)ctx, (IMetaDataPK)new MetaDataPK("com.kingdee.eas.hr.org.app", "AdminOfHRsQuery")) : QueryExecutorFactory.getRemoteInstance((IMetaDataPK)new MetaDataPK("com.kingdee.eas.hr.org.app", "AdminOfHRsQuery"));
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("user.id", (Object)userId));
        filter.getFilterItems().add(new FilterItemInfo("typeRelation.id", (Object)"00000000-0000-0000-0000-0000000000100FE9F8B5"));
        view.setFilter(filter);
        iqec.setObjectView(view);
        try {
            IRowSet rowSet = iqec.executeQuery();
            while (rowSet.next()) {
                if (!hrMap.containsKey(rowSet.getString("hro.id"))) {
                    adminSet = new HashSet();
                    hrMap.put(rowSet.getString("hro.id"), adminSet);
                } else {
                    adminSet = (HashSet)hrMap.get(rowSet.getString("hro.id"));
                }
                adminSet.add(rowSet.getString("id"));
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return hrMap;
    }

    public static Map getHRsMapFromAdminNumUserId(Context ctx, String longNumber, String userId) throws BOSException {
        IRowSet rowSet;
        HashMap<String, HashSet> hrMap = new HashMap<String, HashSet>();
        HashSet adminSet = null;
        IQueryExecutor iqec = null;
        iqec = ctx != null ? QueryExecutorFactory.getLocalInstance((Context)ctx, (IMetaDataPK)new MetaDataPK("com.kingdee.eas.hr.org.app", "AdminOfHRsQuery")) : QueryExecutorFactory.getRemoteInstance((IMetaDataPK)new MetaDataPK("com.kingdee.eas.hr.org.app", "AdminOfHRsQuery"));
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        FilterInfo filterHR = null;
        if (userId != null) {
            filter.getFilterItems().add(new FilterItemInfo("user.id", (Object)userId));
        }
        filter.getFilterItems().add(new FilterItemInfo("AdminOrgUnit.longNumber", (Object)longNumber));
        filter.getFilterItems().add(new FilterItemInfo("AdminOrgUnit.longNumber", (Object)(longNumber + "!%"), CompareType.LIKE));
        filterHR = filter;
        filter.getFilterItems().add(new FilterItemInfo("typeRelation.id", (Object)"00000000-0000-0000-0000-0000000000100FE9F8B5"));
        if (userId != null) {
            filter.setMaskString("#0 and (#1 or #2) and #3");
        } else {
            filter.setMaskString("(#0 or #1) and #2");
        }
        view.setFilter(filter);
        iqec.setObjectView(view);
        try {
            rowSet = iqec.executeQuery();
            while (rowSet.next()) {
                if (!hrMap.containsKey(rowSet.getString("hro.id"))) {
                    adminSet = new HashSet();
                    hrMap.put(rowSet.getString("hro.id"), adminSet);
                } else {
                    adminSet = (HashSet)hrMap.get(rowSet.getString("hro.id"));
                }
                adminSet.add(rowSet.getString("id"));
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        if (userId != null) {
            filterHR.setMaskString("#0 and (#1 or #2)");
        } else {
            filterHR.setMaskString("(#0 or #1)");
        }
        view.setFilter(filterHR);
        iqec.setObjectView(view);
        HashSet<String> adminAllSet = new HashSet<String>();
        try {
            rowSet = iqec.executeQuery();
            while (rowSet.next()) {
                adminAllSet.add(rowSet.getString("id"));
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        String oql = "select id where id in" + CompUtils.getStrFromSet(adminAllSet);
        IHROrgUnit iHROrgUnit = null;
        iHROrgUnit = ctx != null ? HROrgUnitFactory.getLocalInstance((Context)ctx) : HROrgUnitFactory.getRemoteInstance();
        HROrgUnitCollection hrColl = iHROrgUnit.getHROrgUnitCollection(oql);
        String hrId = null;
        int size = hrColl.size();
        for (int i = 0; i < size; ++i) {
            hrId = hrColl.get(i).getId().toString();
            if (!hrMap.containsKey(hrId)) {
                adminSet = new HashSet();
                hrMap.put(hrId, adminSet);
            } else {
                adminSet = (HashSet)hrMap.get(hrId);
            }
            adminSet.add(hrId);
        }
        return hrMap;
    }

    public static FilterInfo getFilterByHrFromAdminNumUserId(Context ctx, String longNumber, String userId) throws BOSException, EASBizException {
        FilterInfo filterInfo = new FilterInfo();
        Map adminMap = PositionAdminHRsUtil.getHRsMapFromAdminNumUserId(ctx, longNumber, userId);
        boolean isDistabled = true;
        Iterator iter = adminMap.entrySet().iterator();
        String key = null;
        int i = 0;
        StringBuffer maskString = new StringBuffer("(");
        Map.Entry entry = null;
        Set set = null;
        while (iter.hasNext()) {
            entry = iter.next();
            key = (String)entry.getKey();
            set = (Set)entry.getValue();
            isDistabled = HRParamUtil.getParamOfHR(null, (String)"IS_AFFAIR", (String)key);
            if (i != 0) {
                maskString.append(" or (");
            }
            if (isDistabled) {
                filterInfo.getFilterItems().add(new FilterItemInfo("AdminOrgUnit.id", (Object)set, CompareType.INCLUDE));
                maskString.append("#").append(filterInfo.getFilterItems().size() - 1);
            } else {
                filterInfo.getFilterItems().add(new FilterItemInfo("AdminOrgUnit.id", (Object)set, CompareType.INCLUDE));
                filterInfo.getFilterItems().add(new FilterItemInfo("deletedStatus", (Object)1));
                filterInfo.getFilterItems().add(new FilterItemInfo("deletedStatus", null));
                maskString.append("(#").append(filterInfo.getFilterItems().size() - 3);
                maskString.append(" and (#").append(filterInfo.getFilterItems().size() - 2);
                maskString.append(" or #").append(filterInfo.getFilterItems().size() - 1).append("))");
            }
            if (i != 0) {
                maskString.append(")");
            }
            ++i;
        }
        maskString.append(")");
        filterInfo.setMaskString(maskString.toString());
        return filterInfo;
    }

    public static String getWhereByHrFromUserId(Context ctx, String userId) throws BOSException, EASBizException {
        Map adminMap = PositionAdminHRsUtil.getHRsMapFromAdminSet(ctx, userId);
        if (adminMap != null && !adminMap.isEmpty()) {
            StringBuffer whereSql = new StringBuffer("(");
            boolean isDistabled = true;
            Iterator iter = adminMap.entrySet().iterator();
            String key = null;
            int i = 0;
            Map.Entry entry = null;
            Set set = null;
            while (iter.hasNext()) {
                entry = iter.next();
                key = (String)entry.getKey();
                set = (Set)entry.getValue();
                isDistabled = HRParamUtil.getParamOfHR((Context)ctx, (String)"IS_AFFAIR", (String)key);
                if (i != 0) {
                    whereSql.append(" or (");
                }
                if (isDistabled) {
                    whereSql.append(" P.FAdminOrgUnitID in");
                    whereSql.append(CompUtils.getStrFromSet((Set)set));
                } else {
                    whereSql.append(" (P.FAdminOrgUnitID in");
                    whereSql.append(CompUtils.getStrFromSet((Set)set));
                    whereSql.append(" and (P.FDeletedStatus =1 OR P.FDeletedStatus IS NULL))");
                }
                if (i != 0) {
                    whereSql.append(")");
                }
                ++i;
            }
            return whereSql.append(")").toString();
        }
        return null;
    }

    public static FilterInfo getFilterByHrFromAdmin(Context ctx, String adminId) throws BOSException, EASBizException {
        FilterInfo filterInfo = new FilterInfo();
        HashSet<String> adminSet = new HashSet<String>();
        adminSet.add(adminId);
        Set hrSet = PositionAdminHRsUtil.getHRsFromAdminSet(ctx, adminSet);
        boolean isDistabled = true;
        if (hrSet.size() > 0) {
            isDistabled = HRParamUtil.getParamOfHR((Context)ctx, (String)"IS_AFFAIR", (String)((String)hrSet.toArray()[0]));
        }
        if (isDistabled) {
            filterInfo.getFilterItems().add(new FilterItemInfo("AdminOrgUnit.id", (Object)adminId));
            return filterInfo;
        }
        filterInfo.getFilterItems().add(new FilterItemInfo("AdminOrgUnit.id", (Object)adminId));
        filterInfo.getFilterItems().add(new FilterItemInfo("deletedStatus", (Object)1));
        filterInfo.getFilterItems().add(new FilterItemInfo("deletedStatus", null));
        filterInfo.setMaskString("#0 and (#1 or #2)");
        return filterInfo;
    }

    public static FilterInfo getFilterByHrSet(Context ctx, Set hrSet) throws EASBizException, BOSException {
        FilterInfo filterInfo = new FilterInfo();
        if (hrSet == null || hrSet.size() == 0) {
            return filterInfo;
        }
        IBaseInnerFacade iBIF = BaseInnerFacadeFactory.getRemoteInstance();
        HashMap map = iBIF.getParamValueByOrg("IS_AFFAIR", hrSet);
        boolean isDistabled = true;
        Iterator iter = hrSet.iterator();
        String key = null;
        int i = 0;
        StringBuffer maskString = new StringBuffer("(");
        String paramValue = null;
        while (iter.hasNext()) {
            key = (String)iter.next();
            paramValue = map.get(key).toString();
            if (StringUtils.isEmpty((String)paramValue)) continue;
            if (paramValue.equalsIgnoreCase("true")) {
                isDistabled = true;
            } else {
                if (!paramValue.equalsIgnoreCase("false")) continue;
                isDistabled = false;
            }
            if (i != 0) {
                maskString.append(" or (");
            }
            if (isDistabled) {
                filterInfo.getFilterItems().add(new FilterItemInfo("ToUnit.id", (Object)key));
                maskString.append("#").append(filterInfo.getFilterItems().size() - 1);
            } else {
                filterInfo.getFilterItems().add(new FilterItemInfo("ToUnit.id", (Object)key));
                filterInfo.getFilterItems().add(new FilterItemInfo("Position.deletedStatus", (Object)1));
                filterInfo.getFilterItems().add(new FilterItemInfo("Position.deletedStatus", null));
                maskString.append("(#").append(filterInfo.getFilterItems().size() - 3);
                maskString.append(" and (#").append(filterInfo.getFilterItems().size() - 2);
                maskString.append(" or #").append(filterInfo.getFilterItems().size() - 1).append("))");
            }
            if (i != 0) {
                maskString.append(")");
            }
            ++i;
        }
        maskString.append(")");
        filterInfo.setMaskString(maskString.toString());
        return filterInfo;
    }

    public static String getPositionAnSql(Context ctx, String paramNum) throws EASBizException, BOSException {
        StringBuffer whereSql = new StringBuffer();
        IHROrgUnit iHRO = HROrgUnitFactory.getLocalInstance((Context)ctx);
        HROrgUnitInfo hrInfo = ContextUtil.getCurrentHRUnit((Context)ctx);
        AdminOrgUnitCollection adminColl = iHRO.getAdminOrgUnitCollection(hrInfo.getId().toString());
        HashSet<String> adminIdSet = new HashSet<String>();
        int size = adminColl.size();
        for (int i = 0; i < size; ++i) {
            adminIdSet.add(adminColl.get(i).getId().toString());
        }
        Set hrSet = PositionAdminHRsUtil.getHRsFromAdminSet(ctx, adminIdSet);
        boolean isDistabled = true;
        Iterator iter = hrSet.iterator();
        String key = null;
        int i = 0;
        whereSql.append("(");
        while (iter.hasNext()) {
            key = (String)iter.next();
            isDistabled = HRParamUtil.getParamOfHR((Context)ctx, (String)paramNum, (String)key);
            if (i != 0) {
                whereSql.append(" or (");
            }
            if (isDistabled) {
                whereSql.append(" (T_ORG_Admin.FID = '");
                whereSql.append(key);
                whereSql.append("')");
            } else {
                whereSql.append(" (T_ORG_Admin.FID = '");
                whereSql.append(key);
                whereSql.append("' and (T_ORG_PositionMember.FIsPrimary=1 ))");
            }
            if (i != 0) {
                whereSql.append(")");
            }
            ++i;
            whereSql.append(")");
        }
        return whereSql.toString();
    }

    public static String getWhereStr(Context ctx, String name, String paramNum) throws BOSException, EASBizException {
        IHROrgUnit iHRO = HROrgUnitFactory.getLocalInstance((Context)ctx);
        HROrgUnitInfo hrInfo = ContextUtil.getCurrentHRUnit((Context)ctx);
        AdminOrgUnitCollection adminColl = iHRO.getAdminOrgUnitCollection(hrInfo.getId().toString());
        StringBuffer whereStr = new StringBuffer(" WHERE (");
        int size = adminColl.size();
        if (size == 0) {
            whereStr.append(name).append(" IS NULL) ");
            return whereStr.toString();
        }
        for (int i = 0; i < size; ++i) {
            if (i != 0 && i < size - 1 || size > 1 && i == 0) {
                whereStr.append(name).append("='").append(adminColl.get(i).getId()).append("' OR ");
                continue;
            }
            whereStr.append(name).append("='").append(adminColl.get(i).getId()).append("' ");
        }
        whereStr.append(" or ").append(PositionAdminHRsUtil.getPositionAnSql(ctx, paramNum));
        whereStr.append(") ");
        return whereStr.toString();
    }
}

