/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.base.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.basedata.person.PersonCollection;
import com.kingdee.eas.basedata.person.PersonFactory;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.hr.affair.EmpEnrollBizBillEntryCollection;
import com.kingdee.eas.hr.affair.EmpEnrollBizBillEntryFactory;
import com.kingdee.eas.hr.base.ShrIDCardNOException;
import com.kingdee.eas.hr.base.util.HRUtilExtend;
import com.kingdee.eas.hr.base.util.IDCardCommonUtil;
import com.kingdee.shr.preentry.PreEntryCollection;
import com.kingdee.shr.preentry.PreEntryFactory;
import com.kingdee.util.NumericExceptionSubItem;
import com.kingdee.util.StringUtils;
import java.text.SimpleDateFormat;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;

public class ShrIDCardNOPassportCheckUtil {
    public static final String NONE = "none";
    public static final String EX_PERSONID_LIST = "exPersonIdList";
    public static final String EX_ENTRYID_LIST = "exEntryIdList";
    public static final String EX_PREENTRYID_LIST = "exPreEntryIdList";

    public static boolean checkIsIdCardNOPassportDuplicate(Context ctx, String idCardNO, String passportNO, String personId, String enrollEntryId, String preEntryId, boolean onlyInCount, String name) throws BOSException, EASBizException {
        return ShrIDCardNOPassportCheckUtil.checkIsIdCardNOPassportDuplicate(ctx, idCardNO, passportNO, personId, enrollEntryId, preEntryId, onlyInCount, name, null);
    }

    public static boolean checkIsIdCardNOPassportDuplicate(Context ctx, String idCardNO, String passportNO, String personId, String enrollEntryId, String preEntryId, boolean onlyInCount, String name, HashMap<Object, Object> excludeMap) throws BOSException, EASBizException {
        PersonCollection pCol;
        if (name == null) {
            name = "";
        }
        if ((pCol = ShrIDCardNOPassportCheckUtil.getPersonByIdCardPassPort(ctx, idCardNO, passportNO, personId, onlyInCount, name, excludeMap)).size() > 0) {
            String msgName = pCol.get(0).getNumber() + ", " + pCol.get(0).getName();
            Object[] params1 = new String[]{name, msgName, ""};
            if (!StringUtils.isEmpty((String)passportNO) && passportNO.equals(pCol.get(0).getPassportNO())) {
                throw new ShrIDCardNOException(ShrIDCardNOException.PASSNO_MUST_ONLY, params1);
            }
            throw new ShrIDCardNOException(ShrIDCardNOException.CARDNO_MUST_ONLY, params1);
        }
        EmpEnrollBizBillEntryCollection EmpCol = ShrIDCardNOPassportCheckUtil.getEmpEnrollBizBillEntryByIdentity(ctx, idCardNO, passportNO, enrollEntryId, name, excludeMap);
        if (EmpCol.size() > 0) {
            Object[] params1 = new String[]{name, EmpCol.get(0).getBill().getNumber(), ""};
            if (!StringUtils.isEmpty((String)passportNO) && passportNO.equals(EmpCol.get(0).getPassportNo())) {
                throw new ShrIDCardNOException(ShrIDCardNOException.EMP_PASSPORT_ISDUPLICATE, params1);
            }
            throw new ShrIDCardNOException(ShrIDCardNOException.EMP_IDCARDNO_ISDUPLICATE, params1);
        }
        PreEntryCollection preColl = ShrIDCardNOPassportCheckUtil.getPreEntryByIdCardNO(ctx, idCardNO, passportNO, enrollEntryId, preEntryId, name, excludeMap);
        if (preColl.size() > 0) {
            NumericExceptionSubItem expItemPP = null;
            NumericExceptionSubItem expItemId = null;
            String msgName = preColl.get(0).getNumber();
            if (!StringUtils.isEmpty((String)msgName)) {
                if (preColl.get(0).isIsSSC()) {
                    expItemPP = ShrIDCardNOException.PREENTRY_REG_PASSPORT_ISDUPLICATE;
                    expItemId = ShrIDCardNOException.PREENTRY_REG_IDCARDNO_ISDUPLICATE;
                } else {
                    expItemPP = ShrIDCardNOException.PREENTRY_PASSPORT_ISDUPLICATE;
                    expItemId = ShrIDCardNOException.PREENTRY_IDCARDNO_ISDUPLICATE;
                }
            } else {
                msgName = preColl.get(0).getName();
                expItemPP = ShrIDCardNOException.PREENTRY_PASSPORT_ISDUP_NAME;
                expItemId = ShrIDCardNOException.PREENTRY_IDCARDNO_ISDUP_NAME;
            }
            Object[] params1 = new String[]{name, msgName, ""};
            if (!StringUtils.isEmpty((String)passportNO) && passportNO.equals(preColl.get(0).getTalent().getPassportNO())) {
                throw new ShrIDCardNOException(expItemPP, params1);
            }
            throw new ShrIDCardNOException(expItemId, params1);
        }
        return true;
    }

    public static PersonCollection getPersonByIdCardPassPort(Context ctx, String idCardNO, String passportNO, String personId, boolean onlyInCount, String name, HashMap<Object, Object> excludeMap) throws BOSException, EASBizException {
        List<String> exPersonList;
        String filter = ShrIDCardNOPassportCheckUtil.assembleIdCardPassportFilter(idCardNO, passportNO, "idCardNO", "passportNO", name);
        StringBuilder oql = new StringBuilder("select id,number,name,idCardNO,passportNO where ").append(filter);
        if (onlyInCount) {
            oql.append(" and EmployeeType.isInCount=1 ");
        }
        List exPersonIdList = null;
        if (excludeMap != null && excludeMap.get(EX_PERSONID_LIST) != null) {
            exPersonIdList = (List)excludeMap.get(EX_PERSONID_LIST);
        }
        if ((exPersonList = ShrIDCardNOPassportCheckUtil.assembleExcludeIDList(personId, exPersonIdList)) != null && exPersonList.size() > 0) {
            oql.append(" and id not in ").append(HRUtilExtend.getStrFromList(exPersonList));
        }
        return PersonFactory.getLocalInstance((Context)ctx).getPersonCollection(oql.toString());
    }

    public static PersonCollection getPersonByIdCardPassPort(Context ctx, String idCardNO, String passportNO, String personId, boolean onlyInCount, String name) throws BOSException, EASBizException {
        return ShrIDCardNOPassportCheckUtil.getPersonByIdCardPassPort(ctx, idCardNO, passportNO, personId, onlyInCount, name, null);
    }

    public static EmpEnrollBizBillEntryCollection getEmpEnrollBizBillEntryByIdentity(Context ctx, String idCardNO, String passportNO, String entryId, String name, HashMap<Object, Object> excludeMap) throws BOSException, EASBizException {
        List<String> exEntryList;
        String currDate = ShrIDCardNOPassportCheckUtil.getCurrentDate();
        String filter = ShrIDCardNOPassportCheckUtil.assembleIdCardPassportFilter(idCardNO, passportNO, "idCardNO", "passportNO", name);
        StringBuilder oql = new StringBuilder("select bill.number,empName,idCardNO,passportNO where ").append(filter).append(" and (bill.billState= 0 or bill.billState = 1 or bill.billState = 2 or (bill.billState = 3 and bizDate >= ").append(currDate).append("))");
        List exEntryIdList = null;
        if (excludeMap != null && excludeMap.get(EX_ENTRYID_LIST) != null) {
            exEntryIdList = (List)excludeMap.get(EX_ENTRYID_LIST);
        }
        if ((exEntryList = ShrIDCardNOPassportCheckUtil.assembleExcludeIDList(entryId, exEntryIdList)) != null && exEntryList.size() > 0) {
            oql.append(" and id not in ").append(HRUtilExtend.getStrFromList(exEntryList));
        }
        return EmpEnrollBizBillEntryFactory.getLocalInstance((Context)ctx).getEmpEnrollBizBillEntryCollection(oql.toString());
    }

    public static EmpEnrollBizBillEntryCollection getEmpEnrollBizBillEntryByIdentity(Context ctx, String idCardNO, String passportNO, String entryId, String name) throws BOSException, EASBizException {
        return ShrIDCardNOPassportCheckUtil.getEmpEnrollBizBillEntryByIdentity(ctx, idCardNO, passportNO, entryId, name, null);
    }

    public static PreEntryCollection getPreEntryByIdCardNO(Context ctx, String idCardNO, String passportNO, String entryId, String preEntryId, String name, HashMap<Object, Object> excludeMap) throws BOSException, EASBizException {
        List<String> exPreEntryList;
        List<String> exEntryList;
        String filter = ShrIDCardNOPassportCheckUtil.assembleIdCardPassportFilter(idCardNO, passportNO, "talent.idCardNO", "talent.passportNO", name);
        StringBuilder oql = new StringBuilder("select name,number,talent.idCardNO,talent.passportNO,isSSC where ").append(filter).append(" and ((isSSC=0 and (isGenerateEntryBill<>1 or billState<>").append(3).append(") and billState<>").append(4).append(" and checkInState not in ('1','2')) or (isSSC=1 and isLatest=1))");
        List exEntryIdList = null;
        if (excludeMap != null && excludeMap.get(EX_ENTRYID_LIST) != null) {
            exEntryIdList = (List)excludeMap.get(EX_ENTRYID_LIST);
        }
        if ((exEntryList = ShrIDCardNOPassportCheckUtil.assembleExcludeIDList(entryId, exEntryIdList)) != null && exEntryList.size() > 0) {
            oql.append(" and (personBillId is null or personBillId not in ").append(HRUtilExtend.getStrFromList(exEntryList)).append(") ");
        }
        List exPreEntryIdList = null;
        if (excludeMap != null && excludeMap.get(EX_PREENTRYID_LIST) != null) {
            exPreEntryIdList = (List)excludeMap.get(EX_PREENTRYID_LIST);
        }
        if ((exPreEntryList = ShrIDCardNOPassportCheckUtil.assembleExcludeIDList(preEntryId, exPreEntryIdList)) != null && exPreEntryList.size() > 0) {
            oql.append(" and id not in ").append(HRUtilExtend.getStrFromList(exPreEntryList));
        }
        return PreEntryFactory.getLocalInstance((Context)ctx).getPreEntryCollection(oql.toString());
    }

    public static PreEntryCollection getPreEntryByIdCardNO(Context ctx, String idCardNO, String passportNO, String entryId, String preEntryId, String name) throws BOSException, EASBizException {
        return ShrIDCardNOPassportCheckUtil.getPreEntryByIdCardNO(ctx, idCardNO, passportNO, entryId, preEntryId, name, null);
    }

    public static String assembleIdCardPassportFilter(String idCardNO, String passportNO, String idCardField, String passportField, String name) throws EASBizException {
        StringBuilder filter = new StringBuilder("(");
        if (StringUtils.isEmpty((String)idCardNO) && StringUtils.isEmpty((String)passportNO)) {
            throw new ShrIDCardNOException(ShrIDCardNOException.BOTH_NO_NOT_ALL_NULL, new Object[]{name});
        }
        if (!StringUtils.isEmpty((String)idCardNO)) {
            filter.append(idCardField).append(" = '").append(idCardNO).append("' or ").append(idCardField).append(" = '").append(IDCardCommonUtil.upperIdCardNo(idCardNO)).append("'");
            String transform = ShrIDCardNOPassportCheckUtil.getIdCardTransformBetween15And18(idCardNO);
            if (!NONE.equals(transform)) {
                filter.append(" or ").append(idCardField).append(" = '").append(transform).append("'");
            }
        }
        if (!StringUtils.isEmpty((String)passportNO)) {
            if (filter.length() > 1) {
                filter.append(" or ");
            }
            filter.append(passportField).append(" = '").append(passportNO).append("'");
        }
        filter.append(")");
        return filter.toString();
    }

    public static String getIdCardTransformBetween15And18(String idCardNO) throws EASBizException {
        if (StringUtils.isEmpty((String)idCardNO)) {
            return NONE;
        }
        String result = NONE;
        if (idCardNO.length() == 18) {
            result = IDCardCommonUtil.IDCardNO18To15(idCardNO);
        } else if (idCardNO.length() == 15) {
            result = IDCardCommonUtil.IDCardNO15To18(idCardNO);
        }
        return result;
    }

    private static List<String> assembleExcludeIDList(String selfId, List<String> excludeIdList) {
        if (!StringUtils.isEmpty((String)selfId)) {
            if (excludeIdList == null) {
                excludeIdList = new LinkedList<String>();
            }
            excludeIdList.add(selfId);
        }
        return excludeIdList;
    }

    public static String getCurrentDate() {
        GregorianCalendar cal = new GregorianCalendar();
        SimpleDateFormat sFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        return "{ts'" + sFormat.format(cal.getTime()) + "'}";
    }

    public static void checkIdCardPassportIsAllNull(PersonInfo personInfo) throws ShrIDCardNOException {
        String idCardNO = personInfo.getIdCardNO();
        String passportNO = personInfo.getPassportNO();
        if (StringUtils.isEmpty((String)idCardNO) && StringUtils.isEmpty((String)passportNO)) {
            throw new ShrIDCardNOException(ShrIDCardNOException.BOTH_NO_NOT_ALL_NULL, new Object[]{personInfo.getName()});
        }
    }
}

