/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.base.web;

import com.kingdee.eas.base.permission.MainMenuItemInfo;
import com.kingdee.eas.cp.common.json.org.JSONArray;
import com.kingdee.eas.cp.common.json.org.JSONObject;
import com.kingdee.eas.hr.base.MenuTypeEnum;
import com.kingdee.eas.hr.base.WebSolutionEntryInfo;
import com.kingdee.eas.hr.base.WebSolutionInfo;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.io.File;
import java.util.LinkedList;
import org.apache.log4j.Logger;

public class JsonObjectUtil {
    private static Logger logger = Logger.getLogger(JsonObjectUtil.class);

    public static JSONObject convertSolutionForList(WebSolutionInfo WebSolutionInfo2) {
        JSONObject jsonObj = new JSONObject();
        jsonObj.put("id", (Object)WebSolutionInfo2.getId().toString());
        jsonObj.put("number", (Object)WebSolutionInfo2.getNumber());
        jsonObj.put("name", (Object)WebSolutionInfo2.getName());
        jsonObj.put("displayType", WebSolutionInfo2.getType() != null ? WebSolutionInfo2.getType().getAlias() : null);
        jsonObj.put("state", (Object)WebSolutionInfo2.getState().getAlias());
        return jsonObj;
    }

    public static JSONObject defaultJsonObj() {
        JSONObject jsonObj = new JSONObject();
        jsonObj.put("id", (Object)"root");
        jsonObj.put("text", (Object)"");
        jsonObj.put("leaf", (Object)true);
        jsonObj.put("children", (Object)new JSONArray());
        return jsonObj;
    }

    public static JSONObject convertLeftTree(WebSolutionEntryInfo WebSolutionEntryInfo2) {
        JSONObject jsonObj = new JSONObject();
        jsonObj.put("id", (Object)WebSolutionEntryInfo2.getNumber());
        jsonObj.put("text", (Object)WebSolutionEntryInfo2.getName());
        jsonObj.put("level", (Object)WebSolutionEntryInfo2.getLevel());
        jsonObj.put("leaf", (Object)WebSolutionEntryInfo2.isNodeType());
        jsonObj.put("menuType", WebSolutionEntryInfo2.getMenuType().getValue());
        jsonObj.put("allowDrag", false);
        if (WebSolutionEntryInfo2.getMenuType().equals((Object)MenuTypeEnum.URL) && !StringUtils.isEmpty((String)WebSolutionEntryInfo2.getWebUrl())) {
            jsonObj.put("href", (Object)WebSolutionEntryInfo2.getWebUrl());
        } else if (WebSolutionEntryInfo2.getMenuType().equals((Object)MenuTypeEnum.GUI) && null != WebSolutionEntryInfo2.getGuiMenu()) {
            if (null != WebSolutionEntryInfo2.getGuiMenu().getUiClassName()) {
                jsonObj.put("href", (Object)WebSolutionEntryInfo2.getGuiMenu().getUiClassName().trim());
            }
            jsonObj.put("uiClassParam", (Object)WebSolutionEntryInfo2.getGuiMenu().getUiClassParam());
            jsonObj.put("uiOprt", (Object)WebSolutionEntryInfo2.getGuiMenu().getUiOprt());
        } else if (WebSolutionEntryInfo2.getMenuType().equals((Object)MenuTypeEnum.WEB) && null != WebSolutionEntryInfo2.getWebMenu()) {
            jsonObj.put("href", (Object)WebSolutionEntryInfo2.getWebMenu().getUrl());
        }
        jsonObj.put("expanded", (Object)true);
        jsonObj.put("children", (Object)new JSONArray());
        jsonObj.put("pid", (Object)(null != WebSolutionEntryInfo2.getParent() ? WebSolutionEntryInfo2.getParent().getNumber() : ""));
        jsonObj.put("solutionType", (Object)(null != WebSolutionEntryInfo2.getSolution().getType() ? String.valueOf(WebSolutionEntryInfo2.getSolution().getType().getValue()) : ""));
        jsonObj.put("displayType", (Object)(null != WebSolutionEntryInfo2.getDisplayType() ? String.valueOf(WebSolutionEntryInfo2.getDisplayType().getValue()) : ""));
        jsonObj.put("openType", (Object)(null != WebSolutionEntryInfo2.getOpenType() ? String.valueOf(WebSolutionEntryInfo2.getOpenType().getValue()) : ""));
        jsonObj.put("mainPortlet", WebSolutionEntryInfo2.getSolution().isMain());
        return jsonObj;
    }

    public static JSONObject convertTreeNodeInfo(WebSolutionEntryInfo WebSolutionEntryInfo2) {
        JSONObject jsonObj = new JSONObject();
        jsonObj.put("id", (Object)WebSolutionEntryInfo2.getNumber());
        jsonObj.put("solutionId", (Object)WebSolutionEntryInfo2.getSolution().getId().toString());
        jsonObj.put("solutionName", (Object)WebSolutionEntryInfo2.getSolution().getName());
        jsonObj.put("parentId", (Object)(null != WebSolutionEntryInfo2.getParent() ? WebSolutionEntryInfo2.getParent().getNumber() : ""));
        jsonObj.put("parentName", (Object)(null != WebSolutionEntryInfo2.getParent() ? WebSolutionEntryInfo2.getParent().getName() : ""));
        jsonObj.put("menuName", (Object)WebSolutionEntryInfo2.getName());
        jsonObj.put("menuType", WebSolutionEntryInfo2.getMenuType().getValue());
        jsonObj.put("solutionType", (Object)(null != WebSolutionEntryInfo2.getSolution().getType() ? String.valueOf(WebSolutionEntryInfo2.getSolution().getType().getValue()) : ""));
        jsonObj.put("displayType", WebSolutionEntryInfo2.getDisplayType() != null ? WebSolutionEntryInfo2.getDisplayType().getValue() : 1);
        jsonObj.put("openType", (Object)(null != WebSolutionEntryInfo2.getOpenType() ? String.valueOf(WebSolutionEntryInfo2.getOpenType().getValue()) : ""));
        jsonObj.put("mainPortlet", WebSolutionEntryInfo2.getSolution().isMain());
        String menuUrl = "";
        if (WebSolutionEntryInfo2.getMenuType().equals((Object)MenuTypeEnum.URL)) {
            menuUrl = null != WebSolutionEntryInfo2.getWebUrl() ? "[{value:'" + WebSolutionEntryInfo2.getWebUrl() + "',text:{'id':'" + WebSolutionEntryInfo2.getWebUrl() + "','name':'" + WebSolutionEntryInfo2.getWebUrl() + "','number':'" + WebSolutionEntryInfo2.getWebUrl() + "'}}]" : "[{value:'',text:{'id':'','name':'','number':''}}]";
        } else if (WebSolutionEntryInfo2.getMenuType().equals((Object)MenuTypeEnum.GUI)) {
            menuUrl = null != WebSolutionEntryInfo2.getGuiMenu() ? "[{value:'" + WebSolutionEntryInfo2.getGuiMenu().getId().toString() + "',text:{'id':'" + WebSolutionEntryInfo2.getGuiMenu().getId().toString() + "','name':'" + WebSolutionEntryInfo2.getGuiMenu().getName() + "','number':'" + WebSolutionEntryInfo2.getGuiMenu().getNumber() + "'}}]" : "[{value:'',text:{'id':'','name':'','number':''}}]";
        } else if (WebSolutionEntryInfo2.getMenuType().equals((Object)MenuTypeEnum.WEB)) {
            menuUrl = null != WebSolutionEntryInfo2.getWebMenu() ? "[{value:'" + WebSolutionEntryInfo2.getWebMenu().getId().toString() + "',text:{'id':'" + WebSolutionEntryInfo2.getWebMenu().getId().toString() + "','name':'" + WebSolutionEntryInfo2.getWebMenu().getName() + "','number':'" + WebSolutionEntryInfo2.getWebMenu().getNumber() + "'}}]" : "[{value:'',text:{'id':'','name':'','number':''}}]";
        }
        jsonObj.put("menuUrl", (Object)menuUrl);
        jsonObj.put("menuIcon", (Object)"/html/portlet/cp/navigation/images/icon/default.jpg");
        jsonObj.put("nodeType", WebSolutionEntryInfo2.isNodeType());
        jsonObj.put("hasChild", ((Boolean)WebSolutionEntryInfo2.get("hasChild")).booleanValue());
        return jsonObj;
    }

    public static JSONObject convertExtTree(IRowSet rowset) {
        JSONObject jsonObj = new JSONObject();
        try {
            jsonObj.put("id", (Object)rowset.getString("FID"));
            jsonObj.put("text", (Object)rowset.getString("FName_L2"));
            jsonObj.put("number", (Object)rowset.getString("FNumber"));
            jsonObj.put("level", rowset.getInt("FLevel"));
            jsonObj.put("leaf", (Object)(rowset.getInt("FIsLeaf") == 1 ? 1 : 0));
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage());
        }
        return jsonObj;
    }

    public static JSONObject convertMenuItem2Json(MainMenuItemInfo menuItemInfo) {
        JSONObject jsonObj = new JSONObject();
        try {
            if (null != menuItemInfo.get("disabled")) {
                jsonObj.put("dis", true);
                jsonObj.put("text", (Object)("<font color=\"gray\">" + menuItemInfo.getName() + "</font>"));
            } else {
                jsonObj.put("text", (Object)menuItemInfo.getName());
                jsonObj.put("dis", false);
            }
            jsonObj.put("id", (Object)menuItemInfo.getId().toString());
            jsonObj.put("number", (Object)menuItemInfo.getNumber());
            jsonObj.put("level", menuItemInfo.getLevel());
            jsonObj.put("leaf", menuItemInfo.isIsLeaf());
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage());
        }
        return jsonObj;
    }

    public static JSONArray convertMenuComposite2Json(LinkedList list) {
        JSONArray jsonArray = new JSONArray();
        try {
            for (int i = 0; i < list.size(); ++i) {
                jsonArray.put((Object)JsonObjectUtil.convertMenuItem2Json((MainMenuItemInfo)list.get(i)));
            }
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage());
        }
        return jsonArray;
    }

    public static JSONObject convertMenuIcon2Json(File file) {
        JSONObject jsonObj = new JSONObject();
        try {
            String sp = System.getProperty("file.separator");
            String path = "/html/portlet/cp/navigation/images/icon/";
            jsonObj.put("name", (Object)file.getName());
            jsonObj.put("url", (Object)(path + file.getName()));
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage());
        }
        return jsonObj;
    }
}

