/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.base.web;

import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.cp.common.json.org.JSONArray;
import com.kingdee.eas.cp.common.json.org.JSONObject;
import com.kingdee.eas.cp.common.web.util.WebContextUtil;
import com.kingdee.eas.hr.base.IWebSolution;
import com.kingdee.eas.hr.base.IWebSolutionEntry;
import com.kingdee.eas.hr.base.SolutionTypeEnum;
import com.kingdee.eas.hr.base.WebMenuCollection;
import com.kingdee.eas.hr.base.WebMenuFactory;
import com.kingdee.eas.hr.base.WebSolutionCollection;
import com.kingdee.eas.hr.base.WebSolutionEntryCollection;
import com.kingdee.eas.hr.base.WebSolutionEntryFactory;
import com.kingdee.eas.hr.base.WebSolutionEntryInfo;
import com.kingdee.eas.hr.base.WebSolutionFactory;
import com.kingdee.eas.hr.base.WebSolutionInfo;
import com.kingdee.eas.hr.base.web.JsonObjectUtil;
import com.kingdee.eas.hr.base.web.MenuParamInfo;
import com.kingdee.eas.hr.base.web.WebMenuUtil;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.shr.base.syssetting.util.SHRCheck;
import com.kingdee.util.StringUtils;
import java.io.File;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.actions.DispatchAction;

public class WebSolutionAction
extends DispatchAction {
    private static Logger logger = Logger.getLogger(WebSolutionAction.class);
    private static boolean IS_ADMIN = true;
    private static String DEFAULT_MSG = "{ failure: true, infos:{info:'error'}}";

    public ActionForward getSolutionList(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        try {
            Context ctx = WebContextUtil.getEasContext((HttpServletRequest)request);
            IWebSolution menuSol = WebSolutionFactory.getLocalInstance(ctx);
            WebSolutionCollection menuCols = null;
            menuCols = menuSol.getWebSolutionCollection("where state <> 3  and (inner = 0 or inner is null) order by number");
            JSONObject jsonResult = new JSONObject();
            jsonResult.put("count", (Object)menuCols.size());
            JSONArray soluJsonArray = new JSONArray();
            Iterator it = menuCols.iterator();
            WebSolutionInfo WebSolutionInfo2 = null;
            int i = 1;
            while (it.hasNext()) {
                WebSolutionInfo2 = (WebSolutionInfo)it.next();
                JSONObject solutionJsonObj = JsonObjectUtil.convertSolutionForList(WebSolutionInfo2);
                soluJsonArray.put((Object)solutionJsonObj);
                ++i;
            }
            jsonResult.put("solution", (Object)soluJsonArray);
            String resultMsg = jsonResult.toString();
            this.handleResult(response, resultMsg);
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage());
        }
        return null;
    }

    public ActionForward addSolution(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        request.setAttribute("method", (Object)"addSolution");
        request.setAttribute("disableEditSolution", (Object)Boolean.FALSE);
        request.setAttribute("hiddenSynMenu", (Object)Boolean.TRUE);
        return mapping.findForward("toSolutionEdit");
    }

    public ActionForward editSolution(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        request.setAttribute("method", (Object)"editSolution");
        request.setAttribute("disableEditSolution", (Object)Boolean.FALSE);
        request.setAttribute("hiddenSynMenu", (Object)Boolean.TRUE);
        return mapping.findForward("toSolutionEdit");
    }

    public ActionForward delSolution(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        String solutionId = request.getParameter("recordId");
        solutionId = StringUtils.replace((String)solutionId, (String)" ", (String)"+");
        try {
            Context ctx = WebContextUtil.getEasContext((HttpServletRequest)request);
            String resultMsg = WebSolutionFactory.getLocalInstance(ctx).deleteSolution(solutionId);
            this.handleResult(response, resultMsg);
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage());
        }
        return null;
    }

    public ActionForward enableSolution(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        String solutionId = request.getParameter("recordId");
        solutionId = StringUtils.replace((String)solutionId, (String)" ", (String)"+");
        try {
            Context ctx = WebContextUtil.getEasContext((HttpServletRequest)request);
            String resultMsg = WebSolutionFactory.getLocalInstance(ctx).enableSolution(solutionId);
            this.handleResult(response, resultMsg);
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage());
        }
        return null;
    }

    public ActionForward disableSolution(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        String solutionId = request.getParameter("recordId");
        solutionId = StringUtils.replace((String)solutionId, (String)" ", (String)"+");
        try {
            Context ctx = WebContextUtil.getEasContext((HttpServletRequest)request);
            String resultMsg = WebSolutionFactory.getLocalInstance(ctx).disableSolution(solutionId);
            this.handleResult(response, resultMsg);
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage());
        }
        return null;
    }

    public ActionForward initLeftTree(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        try {
            String solutionId = request.getParameter("solutionId");
            if (null == solutionId || "null".equals(solutionId)) {
                solutionId = new ObjectUuidPK(new WebSolutionInfo().getBOSType()).toString();
            }
            solutionId = StringUtils.replace((String)solutionId, (String)" ", (String)"+");
            Context ctx = WebContextUtil.getEasContext((HttpServletRequest)request);
            JSONArray array = this.getLeftTreeJSONArray(ctx, solutionId, WebMenuUtil.getDefMap(), false);
            this.handleJSONArray(array);
            String resultMsg = array.toString();
            this.handleResult(response, resultMsg);
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage());
        }
        return null;
    }

    private void handleJSONArray(JSONArray array) {
        int length = array.length();
        for (int i = 0; i < length; ++i) {
            JSONObject obj = array.getJSONObject(i);
            if (obj.get("children") != null && obj.getJSONArray("children").length() > 0) {
                this.handleJSONArray(obj.getJSONArray("children"));
                continue;
            }
            obj.remove("href");
        }
    }

    public JSONArray getLeftTreeJSONArray(Context ctx, String solutionId, Map idMap, boolean portlet) throws Exception {
        JSONArray tree;
        block6: {
            IWebSolutionEntry WebSolutionEntry2 = WebSolutionEntryFactory.getLocalInstance(ctx);
            tree = new JSONArray();
            try {
                WebSolutionEntryCollection menuCols = this.removeAllWorkFlowCollection(ctx, WebSolutionEntry2, this.buildLeftTreeEntityView(ctx, solutionId, IS_ADMIN, portlet));
                if (null != menuCols && menuCols.size() > 0) {
                    this.putObject2Json(menuCols, tree, idMap);
                    if (SolutionTypeEnum.LIST.equals((Object)menuCols.get(0).getSolution().getType())) {
                        return tree;
                    }
                    break block6;
                }
                if (!IS_ADMIN) {
                    menuCols = this.removeAllWorkFlowCollection(ctx, WebSolutionEntry2, this.buildLeftTreeEntityView(ctx, solutionId, true, portlet));
                    if (null != menuCols && menuCols.size() > 0) {
                        this.putObject2Json(menuCols, tree, idMap);
                        break block6;
                    }
                    tree.put((Object)JsonObjectUtil.defaultJsonObj());
                    return tree;
                }
                tree.put((Object)JsonObjectUtil.defaultJsonObj());
                return tree;
            }
            catch (Exception e) {
                logger.error((Object)e.getMessage());
            }
        }
        return WebMenuUtil.toConvertJSON(tree);
    }

    private WebSolutionEntryCollection removeAllWorkFlowCollection(Context ctx, IWebSolutionEntry WebSolutionEntry2, EntityViewInfo view) {
        WebSolutionEntryCollection menuCols = null;
        WebSolutionEntryCollection newMenuCols = new WebSolutionEntryCollection();
        try {
            menuCols = WebSolutionEntry2.getWebSolutionEntryCollection(view);
            if (null != menuCols && menuCols.size() > 0) {
                return menuCols;
            }
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage());
        }
        return newMenuCols;
    }

    private void putObject2Json(WebSolutionEntryCollection menuCols, JSONArray tree, Map idMap) {
        JSONObject treeChild = null;
        WebSolutionEntryInfo WebSolutionEntryInfo2 = null;
        for (int i = 0; i < menuCols.size(); ++i) {
            WebSolutionEntryInfo2 = menuCols.get(i);
            idMap.put(WebSolutionEntryInfo2.getNumber(), WebSolutionEntryInfo2.getId().toString());
            treeChild = JsonObjectUtil.convertLeftTree(WebSolutionEntryInfo2);
            tree.put((Object)treeChild);
        }
    }

    public ActionForward loadTreeNodeInfo(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        if (null == request.getParameter("id")) {
            return null;
        }
        String nodeID = WebMenuUtil.getDefNodeID(request.getParameter("id"));
        Context ctx = WebContextUtil.getEasContext((HttpServletRequest)request);
        WebSolutionEntryInfo WebSolutionEntryInfo2 = null;
        JSONObject reply = new JSONObject();
        JSONArray records = new JSONArray();
        try {
            IWebSolutionEntry WebSolutionEntry2 = WebSolutionEntryFactory.getLocalInstance(ctx);
            nodeID = StringUtils.replace((String)nodeID, (String)" ", (String)"+");
            EntityViewInfo view = this.getDefaultEntityViewInfo();
            view.getSelector().add(new SelectorItemInfo("webUrl"));
            view.getSelector().add(new SelectorItemInfo("webMenu.id"));
            view.getSelector().add(new SelectorItemInfo("webMenu.name"));
            view.getSelector().add(new SelectorItemInfo("webMenu.number"));
            view.getSelector().add(new SelectorItemInfo("guiMenu.id"));
            view.getSelector().add(new SelectorItemInfo("guiMenu.name"));
            view.getSelector().add(new SelectorItemInfo("guiMenu.number"));
            view.getSelector().add(new SelectorItemInfo("solution.id"));
            view.getSelector().add(new SelectorItemInfo("solution.name"));
            view.getSelector().add(new SelectorItemInfo("solution.type"));
            view.getSelector().add(new SelectorItemInfo("solution.main"));
            view.getSelector().add(new SelectorItemInfo("displayType"));
            view.getSelector().add(new SelectorItemInfo("openType"));
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)nodeID));
            view.setFilter(filter);
            WebSolutionEntryInfo2 = WebSolutionEntry2.getWebSolutionEntryCollection(view).get(0);
            if (WebSolutionEntryInfo2 != null) {
                if (WebSolutionEntry2.exists("where parent='" + WebSolutionEntryInfo2.getId().toString() + "'")) {
                    WebSolutionEntryInfo2.put("hasChild", true);
                } else {
                    WebSolutionEntryInfo2.put("hasChild", false);
                }
                records.put((Object)JsonObjectUtil.convertTreeNodeInfo(WebSolutionEntryInfo2));
            }
            reply.put("records", (Object)records);
            reply.put("results", (Object)1);
            String resultMsg = reply.toString();
            this.handleResult(response, resultMsg);
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage());
        }
        return null;
    }

    public ActionForward saveTreeNodeInfo(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        MenuParamInfo paramInfo = this.initParamInfo(request);
        try {
            Context ctx = WebContextUtil.getEasContext((HttpServletRequest)request);
            if (null == paramInfo.getSolutionName() || "".equals(paramInfo.getSolutionName())) {
                WebSolutionInfo solution = (WebSolutionInfo)WebSolutionFactory.getLocalInstance(ctx).getValue((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)paramInfo.getSolutionId())));
                paramInfo.setSolutionName(solution.getName());
            }
            WebSolutionCollection cols = WebSolutionFactory.getLocalInstance(ctx).getWebSolutionCollection("where name ='" + paramInfo.getSolutionName() + "'");
            String resultMsg = null;
            resultMsg = cols.size() > 1 || cols.size() == 1 && !cols.get(0).getId().toString().equals(paramInfo.getSolutionId()) ? WebMenuUtil.getErrorMsg(new String[]{"3"}) : WebSolutionEntryFactory.getLocalInstance(ctx).save(paramInfo);
            this.handleResult(response, resultMsg);
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage());
        }
        return null;
    }

    private MenuParamInfo initParamInfo(HttpServletRequest request) {
        String menuName = request.getParameter("menuName");
        String menuType = request.getParameter("menuType");
        String solutionId = request.getParameter("solutionId");
        String solutionName = request.getParameter("solutionName");
        String menuUrl = request.getParameter("menuUrl_value");
        String menuIcon = request.getParameter("menuIcon");
        String nodeType = request.getParameter("nodeType");
        String solutionType = request.getParameter("solutionType");
        String displayType = request.getParameter("displayType");
        String mainPortlet = request.getParameter("mainPortlet");
        String openType = request.getParameter("openType");
        String parentId = null;
        String id = null;
        if (null != request.getParameter("parentId") && !"".equals(request.getParameter("parentId"))) {
            parentId = WebMenuUtil.getDefNodeID(request.getParameter("parentId"));
        }
        if (null != request.getParameter("id") && !"".equals(request.getParameter("id")) && !"root".equals(request.getParameter("id"))) {
            id = WebMenuUtil.getDefNodeID(request.getParameter("id"));
        }
        MenuParamInfo paramInfo = new MenuParamInfo();
        paramInfo.setId(id);
        paramInfo.setParentId(parentId);
        paramInfo.setSolutionId(solutionId);
        paramInfo.setSolutionName(solutionName);
        paramInfo.setMenuName(menuName);
        paramInfo.setMenuUrl(menuUrl);
        paramInfo.setMenuIcon(menuIcon);
        paramInfo.setAdmin(IS_ADMIN);
        paramInfo.setSolutionType(solutionType);
        paramInfo.setDisplayType(displayType);
        paramInfo.setMain(mainPortlet);
        paramInfo.setOpenType(openType);
        if (null == menuType) {
            paramInfo.setMenuType("0");
        } else {
            paramInfo.setMenuType(menuType);
        }
        if (null != nodeType) {
            paramInfo.setParentNode(Boolean.valueOf(nodeType));
        } else {
            paramInfo.setParentNode(false);
        }
        return paramInfo;
    }

    public ActionForward delTreeNodeInfo(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        MenuParamInfo paramInfo = this.initParamInfo(request);
        Context ctx = WebContextUtil.getEasContext((HttpServletRequest)request);
        String resultMsg = null;
        if (null != paramInfo.getId() && !"".equals(paramInfo.getId())) {
            try {
                resultMsg = WebSolutionEntryFactory.getLocalInstance(ctx).delete(paramInfo);
            }
            catch (Exception e) {
                logger.error((Object)e.getMessage());
            }
        } else {
            resultMsg = WebMenuUtil.getErrorMsg(new String[]{"3"});
        }
        if (resultMsg != null) {
            this.handleResult(response, resultMsg);
        }
        return null;
    }

    public ActionForward dragDropTreeNode(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        String type = request.getParameter("type");
        String currentNodeId = WebMenuUtil.getDefNodeID(request.getParameter("currentRootId"));
        String parentNodeId = WebMenuUtil.getDefNodeID(request.getParameter("parentRootId"));
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("currentNode", currentNodeId);
        paramMap.put("parentNode", parentNodeId);
        paramMap.put("type", type);
        paramMap.put("solutionId", StringUtils.replace((String)request.getParameter("solutionId"), (String)" ", (String)"+"));
        try {
            Context ctx = WebContextUtil.getEasContext((HttpServletRequest)request);
            String resultMsg = WebSolutionEntryFactory.getLocalInstance(ctx).dragDropTree(paramMap);
            this.handleResult(response, resultMsg);
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage());
        }
        return null;
    }

    public ActionForward checkUrlIsValid(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        String urlString = request.getParameter("url");
        SHRCheck.checkUrlParamsForSendRedirect((String)urlString);
        String resultMsg = null;
        try {
            URL url = new URL(urlString);
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            resultMsg = connection.getResponseCode() == 200 ? "{ success: true}" : DEFAULT_MSG;
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage());
            resultMsg = DEFAULT_MSG;
        }
        this.handleResult(response, resultMsg);
        return null;
    }

    public ActionForward synMenu(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        String solutionId = request.getParameter("solutionId");
        String resultMsg = null;
        try {
            Context ctx = WebContextUtil.getEasContext((HttpServletRequest)request);
            solutionId = StringUtils.replace((String)solutionId, (String)" ", (String)"+");
            WebSolutionEntryFactory.getLocalInstance(ctx).delete("where person='" + this.getCurrentPersonInfo(ctx).getId().toString() + "' and solution='" + solutionId + "'");
            resultMsg = "{ success: true}";
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage());
            resultMsg = DEFAULT_MSG;
        }
        this.handleResult(response, resultMsg);
        return null;
    }

    public ActionForward loadMenuIcon(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        JSONObject reply = new JSONObject();
        JSONArray records = new JSONArray();
        String sp = System.getProperty("file.separator");
        String prePath = request.getSession().getServletContext().getRealPath("/");
        String lstPath = "\\html\\portlet\\cp\\navigation\\images\\icon\\";
        lstPath = StringUtils.replace((String)lstPath, (String)"\\", (String)sp);
        File dir = new File(prePath + lstPath);
        File[] files = dir.listFiles();
        String name = null;
        String nameExt = null;
        for (int i = 0; i < files.length; ++i) {
            if (files[i].isDirectory() || !(nameExt = (name = files[i].getName()).substring(name.length() - 3)).equals("png") && !nameExt.equals("gif") && !nameExt.equals("jpg") && !nameExt.equals("tif")) continue;
            records.put((Object)JsonObjectUtil.convertMenuIcon2Json(files[i]));
        }
        reply.put("images", (Object)records);
        String resultMsg = reply.toString();
        this.handleResult(response, resultMsg);
        return null;
    }

    private EntityViewInfo buildLeftTreeEntityView(Context ctx, String solutionId, boolean extFliter, boolean portlet) {
        EntityViewInfo view = this.getDefaultEntityViewInfo();
        SorterItemInfo levelSortInfo = new SorterItemInfo("level");
        levelSortInfo.setSortType(SortType.ASCEND);
        view.getSorter().add(levelSortInfo);
        SorterItemInfo orderSortInfo = new SorterItemInfo("displayOrder");
        orderSortInfo.setSortType(SortType.ASCEND);
        view.getSorter().add(orderSortInfo);
        view.setFilter(this.buildLeftTreeFilterInfo(ctx, solutionId, extFliter));
        return view;
    }

    public FilterInfo buildLeftTreeFilterInfo(Context ctx, String solutionId, boolean extFliter) {
        FilterInfo filter = new FilterInfo();
        if (!extFliter) {
            filter.getFilterItems().add(new FilterItemInfo("person", (Object)this.getCurrentPersonInfo(ctx).getId()));
            filter.getFilterItems().add(new FilterItemInfo("ownerType", (Object)1));
        } else {
            filter.getFilterItems().add(new FilterItemInfo("ownerType", (Object)0));
        }
        filter.getFilterItems().add(new FilterItemInfo("state", (Object)1));
        filter.getFilterItems().add(new FilterItemInfo("solution", (Object)solutionId));
        return filter;
    }

    public EntityViewInfo getDefaultEntityViewInfo() {
        EntityViewInfo view = new EntityViewInfo();
        view.getSelector().add(new SelectorItemInfo("id"));
        view.getSelector().add(new SelectorItemInfo("name"));
        view.getSelector().add(new SelectorItemInfo("number"));
        view.getSelector().add(new SelectorItemInfo("longNumber"));
        view.getSelector().add(new SelectorItemInfo("parent.id"));
        view.getSelector().add(new SelectorItemInfo("parent.name"));
        view.getSelector().add(new SelectorItemInfo("parent.number"));
        view.getSelector().add(new SelectorItemInfo("menuType"));
        view.getSelector().add(new SelectorItemInfo("level"));
        view.getSelector().add(new SelectorItemInfo("isLeaf"));
        view.getSelector().add(new SelectorItemInfo("webUrl"));
        view.getSelector().add(new SelectorItemInfo("nodeType"));
        view.getSelector().add(new SelectorItemInfo("displayType"));
        view.getSelector().add(new SelectorItemInfo("openType"));
        view.getSelector().add(new SelectorItemInfo("webMenu.*"));
        view.getSelector().add(new SelectorItemInfo("person.id"));
        view.getSelector().add(new SelectorItemInfo("solution.type"));
        view.getSelector().add(new SelectorItemInfo("solution.main"));
        return view;
    }

    public ActionForward checkParentNodeType(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        String node = request.getParameter("nodeId");
        String resultMsg = null;
        if (node.equals("root")) {
            resultMsg = WebMenuUtil.getSuccessMsg(new String[]{"noroot"});
        } else {
            String nodeId = WebMenuUtil.getDefNodeID(node);
            try {
                Context ctx = WebContextUtil.getEasContext((HttpServletRequest)request);
                resultMsg = WebSolutionEntryFactory.getLocalInstance(ctx).exists("where id='" + nodeId + "' and nodeType = 1") ? WebMenuUtil.getSuccessMsg(new String[]{"true"}) : WebMenuUtil.getSuccessMsg(new String[]{"false"});
            }
            catch (Exception e) {
                logger.error((Object)e.getMessage());
                resultMsg = DEFAULT_MSG;
            }
        }
        this.handleResult(response, resultMsg);
        return null;
    }

    public ActionForward getWebMenuTree(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        try {
            String type = request.getParameter("type");
            String parentId = request.getParameter("node");
            Context ctx = WebContextUtil.getEasContext((HttpServletRequest)request);
            if (StringUtils.isEmpty((String)parentId) || "EAS".equalsIgnoreCase(parentId)) {
                String number = null;
                if ("biz".equalsIgnoreCase(type)) {
                    number = "HR101";
                } else if ("function".equalsIgnoreCase(type)) {
                    number = "HR102";
                } else if ("report".equalsIgnoreCase(type)) {
                    number = "HR103";
                }
                WebMenuCollection webMenuCollection = WebMenuFactory.getLocalInstance(ctx).getWebMenuCollection("where number = '" + number + "'");
                parentId = webMenuCollection.get(0).getId().toString();
            }
            JSONObject treeChild = null;
            StringBuffer sql = new StringBuffer();
            sql.append("select * from T_HR_WebMenu ");
            sql.append(" where fstate = 0 ");
            sql.append(" and fparentId = ");
            sql.append("'");
            sql.append(parentId);
            sql.append("'");
            sql.append(" order by flongnumber asc");
            JSONArray tree = new JSONArray();
            IRowSet rowset = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            while (rowset.next()) {
                treeChild = JsonObjectUtil.convertExtTree(rowset);
                tree.put((Object)treeChild);
            }
            String resultMsg = tree.toString();
            this.handleResult(response, resultMsg);
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage());
        }
        return null;
    }

    public ActionForward loadPortletContent(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        String portletId = request.getParameter("portletId");
        portletId = StringUtils.replace((String)portletId, (String)" ", (String)"+");
        try {
            Context ctx = WebContextUtil.getEasContext((HttpServletRequest)request);
            WebSolutionCollection menuSols = WebSolutionFactory.getLocalInstance(ctx).getWebSolutionCollection("where portletId='" + portletId + "'");
            WebSolutionInfo webSolutionInfo = null;
            if (null != menuSols && menuSols.size() > 0) {
                webSolutionInfo = menuSols.get(0);
            }
            if (webSolutionInfo != null) {
                JSONArray jsonArr = this.getLeftTreeJSONArray(ctx, webSolutionInfo.getId().toString(), WebMenuUtil.getInfMap(), true);
                String resultMsg = null;
                this.handleIcon(jsonArr);
                resultMsg = jsonArr.toString();
                this.handleResult(response, resultMsg);
            }
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage());
        }
        return null;
    }

    private void handleIcon(JSONArray jsonArr) {
        int length = jsonArr.length();
        for (int i = 0; i < length; ++i) {
            JSONObject obj = jsonArr.getJSONObject(i);
            if (obj.get("children") != null && obj.getJSONArray("children").length() > 0) {
                this.handleIcon(obj.getJSONArray("children"));
                continue;
            }
            if (obj.get("leaf") == null || !Boolean.TRUE.equals(Boolean.valueOf(obj.get("leaf").toString()))) continue;
            obj.put("icon", (Object)"hr/images/leaf.gif");
        }
    }

    private void handleResult(HttpServletResponse response, String resultMsg) {
        try {
            response.setContentType("text/json;charset=utf-8");
            response.getWriter().write(resultMsg);
            response.getWriter().flush();
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage());
        }
    }

    private PersonInfo getCurrentPersonInfo(Context ctx) {
        return ContextUtil.getCurrentUserInfo((Context)ctx).getPerson();
    }
}

