/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.contract.client;

import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.swing.KDFormattedTextField;
import com.kingdee.bos.ctrl.swing.util.CtrlFormatUtilities;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.HROrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.person.PersonFactory;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.hr.base.client.f7.EditorCreator;
import com.kingdee.eas.hr.contract.ContractFreeBizBillEntryInfo;
import com.kingdee.eas.hr.contract.client.ContractBillEditUIBiz;
import com.kingdee.eas.hr.contract.client.EmployeeContractF7PromptBox;
import com.kingdee.eas.hr.emp.ContractTypeFactory;
import com.kingdee.eas.hr.emp.ContractTypeInfo;
import com.kingdee.eas.hr.emp.EmployeeContractInfo;
import com.kingdee.eas.util.client.ExceptionHandler;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashSet;
import javax.swing.JTextField;

public class ContractFreeBizBillEditUIBiz
extends ContractBillEditUIBiz {
    protected IObjectValue createNewDetailData(PersonInfo pInfo) {
        ContractFreeBizBillEntryInfo entry = new ContractFreeBizBillEntryInfo();
        entry.setPerson(pInfo);
        if (pInfo.get("empContract") != null) {
            EmployeeContractInfo empContract = (EmployeeContractInfo)pInfo.get("empContract");
            AdminOrgUnitInfo admin = null;
            ContractTypeInfo cType = null;
            try {
                admin = PersonFactory.getRemoteInstance().getPrimaryAdminOrgUnit(pInfo.getId());
                cType = ContractTypeFactory.getRemoteInstance().getContractTypeInfo((IObjectPK)new ObjectUuidPK(empContract.getContractTemplet().getContractType().getId()));
            }
            catch (Exception e) {
                ExceptionHandler.handle((Throwable)e);
            }
            entry.setToUnit(empContract.getToUnit());
            entry.setIsInAdmin(empContract.isIsInAdmin());
            entry.setDelegatePerson(empContract.getDelegatePerson());
            entry.setToUnitAddress(empContract.getToUnitAddress());
            entry.setIdCardNo(empContract.getEmpIdentityNum());
            entry.setPassportNo(empContract.getEmpPassPortNum());
            entry.setAdminOrg(admin);
            entry.setAddress(empContract.getEmpAddress());
            entry.setThirdUnit(empContract.getThirdUnitName());
            entry.setThirdDelegatePerson(empContract.getThirdDelegatePerson());
            entry.setThirdUnitAddress(empContract.getThirdUnitAddress());
            entry.setContractNo(empContract.getContractNo());
            entry.setContractType(cType);
            entry.setContractTemplet(empContract.getContractTemplet());
            entry.setContractLimitType(empContract.getContractLimitType());
            entry.setEffectDate(empContract.getEffectDate());
            entry.setEndDate(empContract.getEndDate());
            entry.setTestBeginDate(empContract.getTestBeginDate());
            entry.setTestEndDate(empContract.getTestEndDate());
            if (empContract.getContractLimitAuto() != null) {
                entry.setContractLimit(empContract.getContractLimitAuto().toString());
            }
            entry.setContractServerLimit(empContract.getContSerLimit());
            entry.setPenalty(empContract.getPenalty());
            entry.setCompensation(empContract.getCompensation());
            entry.setAppraisal(empContract.getAppraisal());
            entry.setAppraDate(empContract.getAppraDate());
            entry.setSignDate(empContract.getRecordDate());
            entry.setIsContinuousSigned(empContract.isIsContinuousSigned());
            entry.setContinuousSignedCount(empContract.getContinuousSignedCount());
            entry.setFreeReason(empContract.getReason());
            entry.setDescription(empContract.getDescription());
        }
        return entry;
    }

    protected void initEditor() throws Exception {
        super.initEditor();
        String[] date = new String[]{"bizDate", "appraDate"};
        this.setDateFormat(date);
        this.setPenaltyEditor();
    }

    private void setDateFormat(String[] date) {
        int size = date.length;
        for (int i = 0; i < size; ++i) {
            this.kdtEntrys.getColumn(date[i]).setEditor(EditorCreator.getDateCellEditor());
            String format = CtrlFormatUtilities.getDateFormatString();
            this.kdtEntrys.getColumn(date[i]).getStyleAttributes().setNumberFormat(format);
        }
    }

    private void setPenaltyEditor() {
        KDFormattedTextField txtPenalty = new KDFormattedTextField();
        txtPenalty.setDataType(BigDecimal.class);
        txtPenalty.setPrecision(2);
        this.kdtEntrys.getColumn("penalty").setEditor((ICellEditor)new KDTDefaultCellEditor((JTextField)txtPenalty));
        KDFormattedTextField compensation = new KDFormattedTextField();
        compensation.setDataType(BigDecimal.class);
        compensation.setPrecision(2);
        this.kdtEntrys.getColumn("compensation").setEditor((ICellEditor)new KDTDefaultCellEditor((JTextField)compensation));
    }

    protected String[] getNotNullColumn() {
        return new String[]{"bizDate"};
    }

    public void addLine(boolean isInsert) throws Exception {
        this.contractF7(isInsert);
    }

    protected void contractF7(boolean isInsert) throws Exception {
        EmployeeContractF7PromptBox f7 = new EmployeeContractF7PromptBox();
        if (this.ctx.getMainOrgContext() == null) {
            return;
        }
        HROrgUnitInfo hrOrg = (HROrgUnitInfo)this.ctx.getMainOrgContext().get((Object)OrgType.HRO);
        HashSet<String> hroSet = new HashSet<String>();
        if (hrOrg != null) {
            hroSet.add(hrOrg.getId().toString());
        }
        f7.setIsSingleSelect(false);
        f7.setUserOrgRangeFilter(true);
        f7.setFire(true);
        f7.setHROFilter(hroSet);
        f7.show();
        if (!f7.isCanceled()) {
            ArrayList<PersonInfo> persons = new ArrayList<PersonInfo>();
            if (f7.getData() instanceof Object[]) {
                Object[] objs = (Object[])f7.getData();
                EmployeeContractInfo empContract = null;
                PersonInfo personInfo = null;
                int len = objs.length;
                for (int i = 0; i < len; ++i) {
                    empContract = (EmployeeContractInfo)objs[i];
                    personInfo = empContract.getEmployee();
                    personInfo.put("empContract", (Object)empContract);
                    persons.add(personInfo);
                }
            } else {
                EmployeeContractInfo empContract = (EmployeeContractInfo)f7.getData();
                PersonInfo personInfo = empContract.getEmployee();
                personInfo.put("empContract", (Object)empContract);
                persons.add(personInfo);
            }
            this.addLineByPersonList(persons, isInsert);
            this.kdtEntrys.getSelectManager().select(this.kdtEntrys.getRowCount(), 0);
        }
    }

    public boolean isAddPersonByF7() {
        return true;
    }
}

