/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.contract.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.IMetaDataLoader;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.multiapprove.ApproveResult;
import com.kingdee.eas.base.multiapprove.IMultiApprove;
import com.kingdee.eas.base.multiapprove.MultiApproveFactory;
import com.kingdee.eas.base.multiapprove.MultiApproveInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.hr.base.ApproveTypeEnum;
import com.kingdee.eas.hr.base.HRBillBaseEntryInfo;
import com.kingdee.eas.hr.base.HRBillBaseInfo;
import com.kingdee.eas.hr.base.HRBillStateEnum;
import com.kingdee.eas.hr.base.IHRBillBaseEntry;
import com.kingdee.eas.hr.base.app.BillExtendBeanProcess;
import com.kingdee.eas.hr.base.app.HRBillBeanBizFactory;
import com.kingdee.eas.hr.base.app.IHRBillBizBean;
import com.kingdee.eas.hr.base.app.PlugInBeanFactory;
import com.kingdee.eas.hr.base.app.PlugInBeanProxy;
import com.kingdee.eas.hr.base.util.HRUtil;
import com.kingdee.eas.hr.base.util.IReflectMethod;
import com.kingdee.eas.hr.contract.ContractBillBaseInfo;
import com.kingdee.eas.hr.contract.ContractException;
import com.kingdee.eas.hr.contract.ContractFreeBizBill;
import com.kingdee.eas.hr.contract.ContractFreeBizBillEntryFactory;
import com.kingdee.eas.hr.contract.ContractFreeBizBillEntryInfo;
import com.kingdee.eas.hr.contract.ContractFreeBizBillInfo;
import com.kingdee.eas.hr.contract.HRContractInfoCollection;
import com.kingdee.eas.hr.contract.HRContractInfoFactory;
import com.kingdee.eas.hr.contract.HRContractInfoInfo;
import com.kingdee.eas.hr.contract.app.AbstractContractFreeBizBillControllerBean;
import com.kingdee.eas.hr.contract.app.ContractFreeBillBizBean;
import com.kingdee.eas.hr.contract.util.ContractUtils;
import com.kingdee.eas.hr.contract.util.HRContractInfoUtils;
import com.kingdee.eas.hr.contract.util.SHRContractUploadAttachmentUtils;
import com.kingdee.eas.hr.emp.EmployeeContractCollection;
import com.kingdee.eas.hr.emp.EmployeeContractFactory;
import com.kingdee.eas.hr.emp.EmployeeContractInfo;
import com.kingdee.eas.hr.emp.EmployeeContractNewStateEnum;
import com.kingdee.eas.hr.emp.EmployeeContractState;
import com.kingdee.eas.hr.emp.IEmployeeContract;
import com.kingdee.eas.hr.emp.app.BillTypeEnum;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.util.DateTimeUtils;
import com.kingdee.util.StringUtils;
import java.math.BigDecimal;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.Date;
import java.util.Locale;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContractFreeBizBillControllerBean
extends AbstractContractFreeBizBillControllerBean {
    private static final Logger logger = LoggerFactory.getLogger(ContractFreeBizBillControllerBean.class);

    protected String getBillField() {
        return "bill";
    }

    protected String getEntryField() {
        return "entrys";
    }

    protected String getEntryEffectDateField() {
        return "bizDate";
    }

    protected String getEffectFunction() {
        return "com.kingdee.eas.hr.contract.app.ContractFreeBizBillEffectFunction";
    }

    protected IHRBillBaseEntry getEntryInterface(Context ctx) throws BOSException, EASBizException {
        return ContractFreeBizBillEntryFactory.getLocalInstance(ctx);
    }

    protected IHRBillBizBean getBizBean() {
        return new ContractFreeBillBizBean();
    }

    protected void _entryEffect(Context ctx, HRBillBaseEntryInfo entry) throws BOSException, EASBizException {
        EmployeeContractInfo ecInfo;
        ContractFreeBizBillEntryInfo cfbbeInfo = (ContractFreeBizBillEntryInfo)entry;
        IEmployeeContract iECF = EmployeeContractFactory.getLocalInstance((Context)ctx);
        EmployeeContractCollection ecCol = iECF.getEmployeeContractCollection("where contractNo = '" + cfbbeInfo.getContractNo() + "'");
        if (ecCol.size() > 0 && (ecInfo = ecCol.get(0)) != null) {
            ecInfo.setFreeDate(cfbbeInfo.getBizDate());
            ecInfo.setEndDateReal(cfbbeInfo.getBizDate());
            ecInfo.setAppraisal(cfbbeInfo.getAppraisal());
            ecInfo.setAppraDate(cfbbeInfo.getAppraDate());
            ecInfo.setPenalty(cfbbeInfo.getPenalty());
            ecInfo.setCompensation(cfbbeInfo.getCompensation());
            ecInfo.setReason(cfbbeInfo.getFreeReason());
            ecInfo.setDescription(cfbbeInfo.getDescription());
            ecInfo.setState(EmployeeContractState.FREE);
            ecInfo.setNewState(EmployeeContractNewStateEnum.FREED);
            ecInfo.setContractLimitAutoReal(ContractUtils.calContractLimit(cfbbeInfo.getEffectDate(), cfbbeInfo.getBizDate()));
            SelectorItemCollection selector = new SelectorItemCollection();
            selector.add(new SelectorItemInfo("freeDate"));
            selector.add(new SelectorItemInfo("endDateReal"));
            selector.add(new SelectorItemInfo("appraisal"));
            selector.add(new SelectorItemInfo("appraDate"));
            selector.add(new SelectorItemInfo("penalty"));
            selector.add(new SelectorItemInfo("compensation"));
            selector.add(new SelectorItemInfo("reason"));
            selector.add(new SelectorItemInfo("description"));
            selector.add(new SelectorItemInfo("state"));
            selector.add(new SelectorItemInfo("newState"));
            selector.add(new SelectorItemInfo("contractLimitAutoReal"));
            iECF.updatePartial((CoreBaseInfo)ecInfo, selector);
            this.reverseEmployeeContractAttachment(ctx, ecInfo, entry);
            String curDate = HRUtil.getCurrentDate();
            StringBuffer sql = new StringBuffer();
            sql.append(" update T_HR_EmployeeContract SET FNewState=5 where FEffectDate>").append(curDate).append(" and FEmployeeID='").append(ecInfo.getEmployee().getId()).append("'");
            DbUtil.execute((Context)ctx, (String)sql.toString());
            sql = new StringBuffer();
            sql.append(" update T_HR_HRContractInfo SET FNewState=5 where FEffectDate>").append(curDate).append(" and FEmployeeID='").append(ecInfo.getEmployee().getId()).append("'");
            DbUtil.execute((Context)ctx, (String)sql.toString());
        }
        super._entryEffect(ctx, entry);
        Date effectDate = cfbbeInfo.getBizDate();
        Date now = new Date();
        if (now.after(effectDate)) {
            this.updateHRContractInfo_afterEffect(ctx, cfbbeInfo);
        }
    }

    protected void updateHRContractInfo_afterEffect(Context ctx, ContractFreeBizBillEntryInfo cfbbeInfo) throws EASBizException, BOSException {
        HRContractInfoCollection coll = HRContractInfoUtils.getCurrentHRContractCollection(ctx, cfbbeInfo.getContractNo());
        BigDecimal contractLimitAutoReal = ContractUtils.calContractLimit(cfbbeInfo.getEffectDate(), cfbbeInfo.getBizDate());
        int size = coll.size();
        for (int i = 0; i < size; ++i) {
            HRContractInfoInfo hRContractInfo = coll.get(i);
            if (hRContractInfo == null) continue;
            hRContractInfo.setState(EmployeeContractState.FREE);
            hRContractInfo.setNewState(EmployeeContractNewStateEnum.FREED);
            hRContractInfo.setFreeDate(cfbbeInfo.getBizDate());
            if (!StringUtils.isEmpty((String)cfbbeInfo.getContractLimit())) {
                hRContractInfo.setContractLimitAuto(new BigDecimal(cfbbeInfo.getContractLimit()));
            } else {
                hRContractInfo.setContractLimitAuto(null);
            }
            if (cfbbeInfo.getBill() != null && hRContractInfo.getBillID() != null && cfbbeInfo.getBill().getId().toString().equals(hRContractInfo.getBillID().toString())) {
                hRContractInfo.setIsDisplay(true);
            } else {
                hRContractInfo.setIsDisplay(false);
            }
            hRContractInfo.setReason(cfbbeInfo.getFreeReason());
            hRContractInfo.setDescription(cfbbeInfo.getDescription());
            hRContractInfo.setEndDateReal(cfbbeInfo.getBizDate());
            hRContractInfo.setContractLimitAutoReal(contractLimitAutoReal);
            SelectorItemCollection selector = new SelectorItemCollection();
            selector.add(new SelectorItemInfo("state"));
            selector.add(new SelectorItemInfo("newState"));
            selector.add(new SelectorItemInfo("freeDate"));
            selector.add(new SelectorItemInfo("reason"));
            selector.add(new SelectorItemInfo("description"));
            selector.add(new SelectorItemInfo("isDisplay"));
            selector.add(new SelectorItemInfo("endDateReal"));
            selector.add(new SelectorItemInfo("contractLimitAutoReal"));
            HRContractInfoFactory.getLocalInstance(ctx).updatePartial(hRContractInfo, selector);
        }
    }

    @Override
    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        ContractFreeBizBillInfo cfbbInfo = (ContractFreeBizBillInfo)model;
        this.checkEntry(ctx, cfbbInfo);
        this.checkEntryIsInOther(ctx, cfbbInfo);
        this.checkDate(ctx, cfbbInfo);
        this.checkContractFreeException(ctx, cfbbInfo);
        IObjectPK objectPk = super._addnew(ctx, model);
        this.addNewHrContractInfo(ctx, cfbbInfo, objectPk);
        return objectPk;
    }

    @Override
    protected void _update(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        ContractFreeBizBillInfo cfbbInfo = (ContractFreeBizBillInfo)model;
        this.checkEntry(ctx, cfbbInfo);
        this.checkEntryIsInOther(ctx, cfbbInfo);
        this.checkDate(ctx, cfbbInfo);
        this.checkContractFreeException(ctx, cfbbInfo);
        super._update(ctx, pk, model);
        this.updateHrContractInfo(ctx, cfbbInfo, pk);
    }

    protected void checkContractFreeException(Context ctx, ContractFreeBizBillInfo cfbbInfo) throws EASBizException, BOSException {
        ContractFreeBizBillEntryInfo cfbbeInfo = null;
        EmployeeContractInfo contract = null;
        int size = cfbbInfo.getEntrys().size();
        for (int i = 0; i < size; ++i) {
            cfbbeInfo = cfbbInfo.getEntrys().get(i);
            contract = this.assembleContractFromEntry(cfbbeInfo, cfbbInfo);
            contract.put("entryIndex", (Object)i);
            ContractUtils.checkContractFreeException(ctx, contract, null);
        }
    }

    protected EmployeeContractInfo assembleContractFromEntry(ContractFreeBizBillEntryInfo entry, ContractFreeBizBillInfo bill) {
        EmployeeContractInfo contract = new EmployeeContractInfo();
        contract.setContractNo(entry.getContractNo());
        contract.setFreeDate(entry.getBizDate());
        contract.setHrOrgUnit(bill.getHrOrgUnit());
        return contract;
    }

    protected void checkDate(Context ctx, ContractFreeBizBillInfo cfbbInfo) throws EASBizException, BOSException {
        ContractFreeBizBillEntryInfo cfbbeInfo = null;
        int size = cfbbInfo.getEntrys().size();
        for (int i = 0; i < size; ++i) {
            cfbbeInfo = cfbbInfo.getEntrys().get(i);
            String personParm = ContractUtils.getPersonInfo(ctx, cfbbeInfo.getPerson().getId().toString());
            if (cfbbeInfo.getPenalty() != null && cfbbeInfo.getPenalty().compareTo(ContractUtils.ZERO) < 0) {
                throw new ContractException(ContractException.PENALTY_ISMINUS, new Object[]{personParm});
            }
            if (cfbbeInfo.getCompensation() == null || cfbbeInfo.getCompensation().compareTo(ContractUtils.ZERO) >= 0) continue;
            throw new ContractException(ContractException.COMPENSATION_ISMINUS, new Object[]{personParm});
        }
    }

    protected void checkEntry(Context ctx, ContractFreeBizBillInfo cfbbInfo) throws BOSException, EASBizException {
        ContractFreeBizBillEntryInfo cfbbeInfo1 = null;
        ContractFreeBizBillEntryInfo cfbbeInfo2 = null;
        int count = cfbbInfo.getEntrys().size();
        for (int i = 0; i < count; ++i) {
            cfbbeInfo1 = cfbbInfo.getEntrys().get(i);
            int size = cfbbInfo.getEntrys().size() - i;
            for (int j = i + 1; j < size; ++j) {
                cfbbeInfo2 = cfbbInfo.getEntrys().get(j);
                if (!cfbbeInfo1.getContractNo().equals(cfbbeInfo2.getContractNo())) continue;
                throw new ContractException(ContractException.CONTRACT_REPEAT, new Object[]{new Integer(i + 1), new Integer(j + 1)});
            }
            ContractUtils.checkContractInBillByType(ctx, cfbbeInfo1.getContractNo(), cfbbInfo.getId(), BillTypeEnum.FREE, i + 1);
            EmployeeContractInfo empContract = EmployeeContractFactory.getLocalInstance((Context)ctx).getEmployeeContractInfo("select id where contractNo='" + cfbbeInfo1.getContractNo() + "'");
            ContractUtils.checkContractInBillByHRContractInfo(ctx, empContract.getId().toString(), cfbbInfo.getId());
        }
    }

    protected void checkEntryIsInOther(Context ctx, ContractFreeBizBillInfo cfbbInfo) throws BOSException, EASBizException {
        ContractFreeBizBillEntryInfo cfbbeInfo = null;
        EmployeeContractInfo ecInfo = null;
        int count = cfbbInfo.getEntrys().size();
        for (int i = 0; i < count; ++i) {
            cfbbeInfo = cfbbInfo.getEntrys().get(i);
            ecInfo = new EmployeeContractInfo();
            ecInfo.setContractNo(cfbbeInfo.getContractNo());
            ecInfo.setEmployee(cfbbeInfo.getPerson());
            ContractUtils.checkContractIsInOther(ctx, ecInfo, ContractFreeBizBill.class.getName(), i + 1);
        }
    }

    @Override
    protected void setHRContractInfoInfo(Context ctx, ContractBillBaseInfo billInfo, IObjectPK billId, CoreBaseInfo entryInfo, HRContractInfoInfo contractInfo) throws EASBizException, BOSException {
        super.setHRContractInfoInfo(ctx, billInfo, billId, entryInfo, contractInfo);
        String contractNo = (String)entryInfo.get("contractNo");
        String oql = "select id where contractNo='" + contractNo + "'";
        IEmployeeContract iEmployeeContract = EmployeeContractFactory.getLocalInstance((Context)ctx);
        if (iEmployeeContract.exists(oql)) {
            EmployeeContractInfo empContract = iEmployeeContract.getEmployeeContractInfo(oql);
            contractInfo.put("employeeContract", empContract);
            contractInfo.put("sourceContract", empContract);
        }
        contractInfo.put("delegatePerson", entryInfo.get("delegatePerson"));
        contractInfo.put("reason", entryInfo.get("freeReason"));
        contractInfo.put("toUnit", entryInfo.get("toUnit"));
        contractInfo.put("freeDate", entryInfo.get("bizDate"));
        contractInfo.put("effectDate", entryInfo.get("effectDate"));
        contractInfo.setIsDisplay(false);
    }

    public void setBillRelateInfo(Context ctx, BOSUuid entryID) throws EASBizException, BOSException {
        if (entryID == null) {
            return;
        }
        HRBillBaseEntryInfo entry = null;
        HRBillBaseInfo bill = null;
        String billField = this.getBillField();
        String entryField = this.getEntryField();
        entry = this.getEntryInterface(ctx).getHRBillBaseEntryInfo((IObjectPK)new ObjectUuidPK(entryID), this.getEntrySelector());
        if (entry != null && !StringUtils.isEmpty((String)billField) && !StringUtils.isEmpty((String)entryField)) {
            IObjectCollection entries;
            bill = (HRBillBaseInfo)entry.get(billField);
            if (bill != null && (entries = (IObjectCollection)(bill = this.getHRBillBaseInfo(ctx, (IObjectPK)new ObjectUuidPK(bill.getId()), this.getBillSelector())).get(entryField)) != null) {
                entries.clear();
                entries.addObject((IObjectValue)entry);
            }
            entry.put(billField, (Object)bill);
        }
        ContractFreeBizBillEntryInfo cfbbeInfo = (ContractFreeBizBillEntryInfo)entry;
        IEmployeeContract iECF = EmployeeContractFactory.getLocalInstance((Context)ctx);
        EmployeeContractCollection ecCol = iECF.getEmployeeContractCollection("where contractNo = '" + (cfbbeInfo == null ? "" : cfbbeInfo.getContractNo()) + "'");
        if (ecCol.size() > 0) {
            EmployeeContractInfo ecInfo = ecCol.get(0);
            SelectorItemCollection selector = new SelectorItemCollection();
            if (ecInfo != null && cfbbeInfo != null) {
                ecInfo.setFreeDate(cfbbeInfo.getBizDate());
                ecInfo.setNewState(EmployeeContractNewStateEnum.FREED);
            }
            selector.add(new SelectorItemInfo("freeDate"));
            selector.add(new SelectorItemInfo("newState"));
            iECF.updatePartial((CoreBaseInfo)ecInfo, selector);
            this.updateHRContractInfo_beforeJob(ctx, cfbbeInfo);
        }
    }

    protected void updateHRContractInfo_beforeJob(Context ctx, ContractFreeBizBillEntryInfo cfbbeInfo) throws EASBizException, BOSException {
        HRContractInfoCollection coll = HRContractInfoUtils.getCurrentHRContractCollection(ctx, cfbbeInfo.getContractNo());
        HRContractInfoInfo hRContractInfo = null;
        SelectorItemCollection selector = null;
        int size = coll.size();
        for (int i = 0; i < size; ++i) {
            hRContractInfo = coll.get(i);
            if (hRContractInfo == null) continue;
            selector = new SelectorItemCollection();
            hRContractInfo.setNewState(EmployeeContractNewStateEnum.FREED);
            hRContractInfo.setFreeDate(cfbbeInfo.getBizDate());
            selector.add(new SelectorItemInfo("newState"));
            selector.add(new SelectorItemInfo("freeDate"));
            HRContractInfoFactory.getLocalInstance(ctx).updatePartial(hRContractInfo, selector);
        }
    }

    protected Date getBackGroundJobDate(IObjectValue ov) throws BOSException, EASBizException {
        SecureRandom random = null;
        try {
            random = SecureRandom.getInstance("SHA1PRNG");
        }
        catch (NoSuchAlgorithmException e) {
            throw new BOSException();
        }
        Date date = ov.getDate(this.getEntryEffectDateField());
        if (null != random) {
            date = DateTimeUtils.addMinute((Date)date, (long)(60 + random.nextInt(60)));
            date = DateTimeUtils.addSecond((Date)date, (long)random.nextInt(60));
        }
        date = DateTimeUtils.addDay((Date)date, (long)1L);
        return date;
    }

    protected void _auditEntryEffect(Context ctx, BOSUuid billID) throws BOSException, EASBizException {
        if (billID == null) {
            return;
        }
        IHRBillBizBean bizBean = this.getParentBizBean();
        HRBillBaseInfo model = this.getHRBillBaseInfo(ctx, (IObjectPK)new ObjectUuidPK(billID));
        HRBillBaseEntryInfo entry = null;
        String entryField = this.getEntryField();
        String billField = this.getBillField();
        if (bizBean != null) {
            bizBean._personPlanChek(ctx, (IObjectValue)model);
        }
        IObjectCollection entries = (IObjectCollection)model.get(entryField);
        this.initBizBean(ctx);
        if (entries != null) {
            Date now = new Date();
            Date effectDate = null;
            int size = entries.size();
            for (int i = 0; i < size; ++i) {
                entry = (HRBillBaseEntryInfo)entries.getObject(i);
                entry.put(billField, (Object)model);
                effectDate = this.getEffectDate(entry);
                if (effectDate != null && now.before(effectDate)) {
                    this._beforeEffectBeforeBackJob(ctx, entry);
                    if (bizBean != null) {
                        bizBean._beforeEffectBeforeBackJob(ctx, entry);
                    }
                    this.setBillRelateInfo(ctx, entry.getId());
                    this.createBackGroundJob(ctx, (IObjectValue)entry, "entryID");
                    continue;
                }
                this._beforeEffectOnNoJob(ctx, entry);
                if (bizBean != null) {
                    bizBean._beforeEffectOnNoJob(ctx, entry);
                }
                this._entryEffectCommon(ctx, entry.getId());
            }
        }
        this.updateBillState(ctx, billID, HRBillStateEnum.AUDITED);
        if (bizBean != null) {
            bizBean._setBillState(ctx, billID, HRBillStateEnum.AUDITED);
        }
        if (ApproveTypeEnum.DIRECT.equals((Object)model.getApproveType())) {
            this.saveMultiApproveInfo(ctx, billID);
        }
    }

    protected void initBizBean(Context ctx) throws BOSException, EASBizException {
        IHRBillBizBean bizBean = this.getParentBizBean();
        if (bizBean == null && (bizBean = this.getBizBean()) != null) {
            BillExtendBeanProcess billExtend = BillExtendBeanProcess.getInstance((String)bizBean.getExtendBillName(ctx));
            PlugInBeanProxy plugIn = null;
            IMetaDataLoader loader = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx);
            EntityObjectInfo entity = loader.getEntity(this.getBOSType());
            if (entity != null) {
                String fullName = entity.getFullName();
                try {
                    plugIn = PlugInBeanFactory.getPlugIn((Context)ctx, (String)fullName);
                }
                catch (Exception e) {
                    throw new BOSException("PlugInBean Get Error:" + e.getMessage(), e.getCause());
                }
            }
            IReflectMethod[] decorators = null;
            if (plugIn != null && billExtend != null) {
                decorators = new IReflectMethod[]{plugIn, billExtend};
            } else if (billExtend != null) {
                decorators = new IReflectMethod[]{billExtend};
            } else if (plugIn != null) {
                decorators = new IReflectMethod[]{plugIn};
            }
            if (decorators != null) {
                try {
                    bizBean = new HRBillBeanBizFactory(bizBean).getBizProxy(decorators);
                }
                catch (Throwable e) {
                    throw new BOSException("bizBean:" + bizBean.getExtendBillName(ctx) + ";plugin:" + plugIn, e);
                }
            }
        }
    }

    protected void saveMultiApproveInfo(Context ctx, BOSUuid billId) throws BOSException, EASBizException {
        IMultiApprove im = MultiApproveFactory.getLocalInstance((Context)ctx);
        MultiApproveInfo info = new MultiApproveInfo();
        info.setIsPass(ApproveResult.PASS);
        info.setOpinion(ResourceBase.getString((String)"com.kingdee.eas.hr.base.BASEAutoGenerateResource", (String)"0_HRBillBaseControllerBean", (Locale)ctx.getLocale()));
        info.setBillId(billId);
        info.setBosTypeStr(billId.getType().toString());
        im.addnew((CoreBaseInfo)info);
    }

    @Override
    protected void _untiCheckBizBill(Context ctx, String billId) throws BOSException, EASBizException {
        super._untiCheckBizBill(ctx, billId);
        String oql = "where billID = '" + billId + "'";
        HRContractInfoInfo hrContractInfo = HRContractInfoFactory.getLocalInstance(ctx).getHRContractInfoInfo(oql);
        Date curDate = DateTimeUtils.truncateDate((Date)new Date());
        if (DateTimeUtils.dayBefore((Date)curDate, (Date)hrContractInfo.getEntryBizDate())) {
            this.updateContractInfo_beforeEffect(ctx, hrContractInfo);
            this.processUnEffectUnAudit(ctx, billId);
        } else {
            this.recoveryEmployeeContract(ctx, hrContractInfo, curDate);
            this.recoveryHRContract(ctx, hrContractInfo, curDate);
        }
    }

    protected void recoveryEmployeeContract(Context ctx, HRContractInfoInfo hrContract, Date curDate) throws EASBizException, BOSException {
        EmployeeContractInfo employeeContractInfo = ContractUtils.getEmployeeContractInfo(ctx, hrContract.getEmployeeContract().getId().toString());
        employeeContractInfo.setFreeDate(null);
        employeeContractInfo.setAppraisal(null);
        employeeContractInfo.setAppraDate(null);
        employeeContractInfo.setPenalty(null);
        employeeContractInfo.setCompensation(null);
        employeeContractInfo.setReason(null);
        employeeContractInfo.setDescription(null);
        if (employeeContractInfo.getEndDate() != null && !DateTimeUtils.dayBefore((Date)curDate, (Date)employeeContractInfo.getEndDate())) {
            employeeContractInfo.setState(EmployeeContractState.END);
            employeeContractInfo.setNewState(EmployeeContractNewStateEnum.ENDED);
            employeeContractInfo.setEndDateReal(employeeContractInfo.getEndDate());
            employeeContractInfo.setContractLimitAutoReal(ContractUtils.calContractLimit(employeeContractInfo.getEffectDate(), employeeContractInfo.getEndDate()));
        } else {
            employeeContractInfo.setState(EmployeeContractState.RECORD);
            employeeContractInfo.setNewState(EmployeeContractNewStateEnum.RECORDED);
            employeeContractInfo.setEndDateReal(null);
            employeeContractInfo.setContractLimitAutoReal(null);
        }
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("freeDate"));
        selector.add(new SelectorItemInfo("endDateReal"));
        selector.add(new SelectorItemInfo("appraisal"));
        selector.add(new SelectorItemInfo("appraDate"));
        selector.add(new SelectorItemInfo("penalty"));
        selector.add(new SelectorItemInfo("compensation"));
        selector.add(new SelectorItemInfo("reason"));
        selector.add(new SelectorItemInfo("description"));
        selector.add(new SelectorItemInfo("state"));
        selector.add(new SelectorItemInfo("newState"));
        selector.add(new SelectorItemInfo("contractLimitAutoReal"));
        EmployeeContractFactory.getLocalInstance((Context)ctx).updatePartial((CoreBaseInfo)employeeContractInfo, selector);
    }

    protected void recoveryHRContract(Context ctx, HRContractInfoInfo hrContract, Date curDate) throws EASBizException, BOSException {
        HRContractInfoCollection coll = HRContractInfoFactory.getLocalInstance(ctx).getHRContractInfoCollection("where contractNo = '" + hrContract.getContractNo() + "'");
        int size = coll.size();
        for (int i = 0; i < size; ++i) {
            SelectorItemCollection selector;
            HRContractInfoInfo hRContractInfo = coll.get(i);
            if (hRContractInfo == null) continue;
            if (hrContract.getBillID() != null && hRContractInfo.getBillID() != null && hrContract.getBillID().toString().equals(hRContractInfo.getBillID().toString())) {
                selector = new SelectorItemCollection();
                hRContractInfo.setState(EmployeeContractState.NEW);
                hRContractInfo.setNewState(EmployeeContractNewStateEnum.ADDED);
                hRContractInfo.setBillState(HRBillStateEnum.SAVED);
                hRContractInfo.setIsDisplay(false);
                selector.add(new SelectorItemInfo("state"));
                selector.add(new SelectorItemInfo("newState"));
                selector.add(new SelectorItemInfo("billState"));
                selector.add(new SelectorItemInfo("isDisplay"));
                HRContractInfoFactory.getLocalInstance(ctx).updatePartial(hRContractInfo, selector);
                continue;
            }
            if (hRContractInfo.getEndDate() != null && !DateTimeUtils.dayBefore((Date)curDate, (Date)hRContractInfo.getEndDate())) {
                hRContractInfo.setState(EmployeeContractState.END);
                hRContractInfo.setNewState(EmployeeContractNewStateEnum.ENDED);
                hRContractInfo.setEndDateReal(hRContractInfo.getEndDate());
                hRContractInfo.setContractLimitAutoReal(ContractUtils.calContractLimit(hRContractInfo.getEffectDate(), hRContractInfo.getEndDate()));
            } else {
                hRContractInfo.setState(EmployeeContractState.RECORD);
                hRContractInfo.setNewState(EmployeeContractNewStateEnum.RECORDED);
                hRContractInfo.setEndDateReal(null);
                hRContractInfo.setContractLimitAutoReal(null);
            }
            hRContractInfo.setFreeDate(null);
            hRContractInfo.setIsDisplay(true);
            hRContractInfo.setReason(null);
            hRContractInfo.setDescription(null);
            selector = new SelectorItemCollection();
            selector.add(new SelectorItemInfo("state"));
            selector.add(new SelectorItemInfo("newState"));
            selector.add(new SelectorItemInfo("freeDate"));
            selector.add(new SelectorItemInfo("reason"));
            selector.add(new SelectorItemInfo("description"));
            selector.add(new SelectorItemInfo("isDisplay"));
            selector.add(new SelectorItemInfo("endDateReal"));
            selector.add(new SelectorItemInfo("contractLimitAutoReal"));
            HRContractInfoFactory.getLocalInstance(ctx).updatePartial(hRContractInfo, selector);
        }
    }

    protected void updateContractInfo_beforeEffect(Context ctx, HRContractInfoInfo hrContractInfoInfo) throws EASBizException, BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append(" update T_HR_EmployeeContract SET FNewState=FState,FToDate = null where  fid='").append(hrContractInfoInfo.getEmployeeContract().getId().toString()).append("'");
        DbUtil.execute((Context)ctx, (String)sql.toString());
        HRContractInfoCollection coll = HRContractInfoFactory.getLocalInstance(ctx).getHRContractInfoCollection("where contractNo = '" + hrContractInfoInfo.getContractNo() + "'");
        HRContractInfoInfo hRContractInfo = null;
        SelectorItemCollection selector = null;
        int size = coll.size();
        for (int i = 0; i < size; ++i) {
            hRContractInfo = coll.get(i);
            if (hRContractInfo == null) continue;
            if (hrContractInfoInfo.getBillID() != null && hRContractInfo.getBillID() != null && hrContractInfoInfo.getBillID().toString().equals(hRContractInfo.getBillID().toString())) {
                selector = new SelectorItemCollection();
                hRContractInfo.setNewState(EmployeeContractNewStateEnum.ADDED);
                hRContractInfo.setBillState(HRBillStateEnum.SAVED);
                selector.add(new SelectorItemInfo("newState"));
                selector.add(new SelectorItemInfo("billState"));
                HRContractInfoFactory.getLocalInstance(ctx).updatePartial(hRContractInfo, selector);
                continue;
            }
            selector = new SelectorItemCollection();
            hRContractInfo.setNewState(EmployeeContractNewStateEnum.RECORDED);
            hRContractInfo.setFreeDate(null);
            selector.add(new SelectorItemInfo("newState"));
            selector.add(new SelectorItemInfo("freeDate"));
            HRContractInfoFactory.getLocalInstance(ctx).updatePartial(hRContractInfo, selector);
        }
    }

    protected void createBackGroundJob(Context ctx, IObjectValue ov, String jobKey) throws EASBizException, BOSException {
        super.createBackGroundJob(ctx, ov, jobKey);
        String enrtryID = ov.get("id").toString();
        SHRContractUploadAttachmentUtils.saveContractAttachmentReverse(ctx, enrtryID);
    }
}

