/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.elecontract.service;

import com.alibaba.fastjson.JSONObject;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.hr.contract.ElectronicContractRelationCollection;
import com.kingdee.eas.hr.contract.ElectronicContractRelationFactory;
import com.kingdee.eas.hr.contract.ElectronicContractRelationInfo;
import com.kingdee.eas.hr.contract.IElectronicContractRelation;
import com.kingdee.shr.elecontract.KDContractConfigInfo;
import com.kingdee.util.StringUtils;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EmpSyncSaveEContractInfoRunnable
implements Runnable {
    private static final Logger logger = LoggerFactory.getLogger(EmpSyncSaveEContractInfoRunnable.class);
    private Context ctx;
    private String contractId;
    private Map<String, Object> dataMap;
    private JSONObject jsonObject;
    private KDContractConfigInfo kdContractConfigInfo;
    private int pageCount = 1;

    public EmpSyncSaveEContractInfoRunnable(Context ctx, String contractId, Map<String, Object> dataMap, JSONObject jsonObject, KDContractConfigInfo kdContractConfigInfo, int pageCount) {
        this.ctx = ctx;
        this.contractId = contractId;
        this.dataMap = dataMap;
        this.jsonObject = jsonObject;
        this.kdContractConfigInfo = kdContractConfigInfo;
        this.pageCount = pageCount;
    }

    public EmpSyncSaveEContractInfoRunnable(Context ctx, String contractId, Map<String, Object> dataMap, JSONObject jsonObject, KDContractConfigInfo kdContractConfigInfo) {
        this.ctx = ctx;
        this.contractId = contractId;
        this.dataMap = dataMap;
        this.jsonObject = jsonObject;
        this.kdContractConfigInfo = kdContractConfigInfo;
    }

    @Override
    public void run() {
        try {
            if (this.jsonObject.getIntValue("code") == 0 && !StringUtils.isEmpty((String)this.contractId)) {
                String contractNo = (String)this.dataMap.get("contractNo");
                IElectronicContractRelation electronicContractRelation = ElectronicContractRelationFactory.getLocalInstance(this.ctx);
                ElectronicContractRelationCollection coll = electronicContractRelation.getElectronicContractRelationCollection("where contractId = '" + contractNo + "'");
                ElectronicContractRelationInfo relation = coll.size() > 0 ? coll.get(0) : new ElectronicContractRelationInfo();
                relation.setEmpContractId(BOSUuid.read((String)this.contractId));
                relation.setContractId(contractNo);
                relation.setSimpleName(this.kdContractConfigInfo.getId().toString());
                logger.error("EmpSyncSaveEContractInfoRunnable.run relation.getSimpleName() : " + relation.getSimpleName());
                relation.setContractState(Short.parseShort("0"));
                relation.setPageCount(this.pageCount);
                electronicContractRelation.save((CoreBaseInfo)relation);
                logger.error("EmpSyncSaveEContractInfoRunnable.run relation : " + relation);
            }
        }
        catch (EASBizException e) {
            logger.error("EmpSyncSaveEContractInfoRunnable EASBizException : " + e.getMessage(), (Throwable)e);
        }
        catch (BOSException e) {
            logger.error("EmpSyncSaveEContractInfoRunnable BOSException : " + e.getMessage(), (Throwable)e);
        }
        catch (Exception e) {
            logger.error("EmpSyncSaveEContractInfoRunnable Exception : " + e.getMessage(), (Throwable)e);
        }
        catch (Throwable e) {
            logger.error("EmpSyncSaveEContractInfoRunnable Throwable : " + e.getMessage(), e);
        }
    }
}

