/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.emp.client;

import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ObjectNotFoundException;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.ui.face.IUIFactory;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIException;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.hr.emp.AirDutyEmployeeGradeFactory;
import com.kingdee.eas.hr.emp.EmployeeException;
import com.kingdee.eas.hr.emp.client.AbstractAirDutyEmployeeGradeMainListUI;
import com.kingdee.eas.hr.emp.client.AirDutyEmpGradeBatchAddUI;
import com.kingdee.eas.hr.emp.client.AirDutyEmployeeGradeEditUI;
import com.kingdee.eas.hr.org.JobGradeInfo;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.event.ActionEvent;
import java.util.Arrays;
import java.util.Map;
import org.apache.log4j.Logger;

public class AirDutyEmployeeGradeMainListUI
extends AbstractAirDutyEmployeeGradeMainListUI {
    private static Logger logger = Logger.getLogger(AirDutyEmployeeGradeMainListUI.class);

    protected String getEditUIName() {
        return AirDutyEmployeeGradeEditUI.class.getName();
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.tblMain.setColumnMoveable(true);
        this.btnBatchAdd.setIcon(EASResource.getIcon((String)"imgTbtn_newbatch"));
        this.menuItemBatchAdd.setIcon(EASResource.getIcon((String)"imgTbtn_newbatch"));
    }

    protected FilterInfo getDefaultFilterForQuery() {
        FilterInfo filter = new FilterInfo();
        return filter;
    }

    protected ICoreBase getBizInterface() throws Exception {
        return AirDutyEmployeeGradeFactory.getRemoteInstance();
    }

    @Override
    public void actionBatchAdd_actionPerformed(ActionEvent e) throws Exception {
        super.actionBatchAdd_actionPerformed(e);
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"Owner", (Object)this);
        IUIFactory uiFactory = null;
        try {
            uiFactory = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory");
            IUIWindow curDialog = uiFactory.create(AirDutyEmpGradeBatchAddUI.class.getName(), (Map)uiContext);
            curDialog.show();
        }
        catch (UIException ex1) {
            this.handleException((Exception)((Object)ex1));
        }
        this.tblMain.removeRows();
    }

    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        int i;
        this.checkSelected();
        if (this.tblMain.getSelectManager().size() > 1) {
            throw new EmployeeException(EmployeeException.MUST_DEL_LAST_GRADE);
        }
        KDTSelectBlock sb = this.tblMain.getSelectManager().get();
        Object[] infos = new JobGradeInfo[sb.getBottom() - sb.getTop() + 1];
        for (int j = sb.getTop(); j <= sb.getBottom(); ++j) {
            infos[j - sb.getTop()] = new JobGradeInfo();
            infos[j - sb.getTop()].setId(BOSUuid.read((String)this.getColumnValue(j, this.getKeyFieldName())));
            infos[j - sb.getTop()].setGrade(Integer.parseInt(this.getColumnValue(j, "grade")));
        }
        Arrays.sort(infos);
        for (i = 0; i < infos.length - 1; ++i) {
            if (infos[i].getGrade() + 1 == infos[i + 1].getGrade()) continue;
            throw new EmployeeException(EmployeeException.MUST_DEL_LAST_GRADE);
        }
        if (this.confirmRemove()) {
            for (i = infos.length - 1; i >= 0; --i) {
                try {
                    this.getBizInterface().delete((IObjectPK)new ObjectUuidPK(infos[i].getId()));
                    this.refresh(e);
                    continue;
                }
                catch (ObjectNotFoundException onfe) {
                    logger.error((Object)onfe.getMessage());
                    this.refreshList();
                    throw new EASBizException(EASBizException.CHECKEXIST);
                }
            }
        }
    }

    protected String getColumnValue(int rowIndex, String columnName) {
        Object keyValue;
        IRow row = this.tblMain.getRow(rowIndex);
        if (row == null) {
            return null;
        }
        ICell cell = row.getCell(columnName);
        if (cell == null) {
            MsgBox.showError((String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Error_KeyField_Fail"));
            SysUtil.abort();
        }
        if ((keyValue = cell.getValue()) != null) {
            return keyValue.toString();
        }
        return null;
    }

    protected SystemEnum getSystemEnumForOA() {
        return SystemEnum.PEOPLE_ORGANIZATION;
    }
}

