/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.emp.client;

import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.hr.emp.EmpBatchException;
import com.kingdee.eas.hr.emp.EmployeeException;
import com.kingdee.eas.hr.emp.client.EmpBatchDataVerifyInputInit;
import com.kingdee.util.DateTimeUtils;
import com.kingdee.util.StringUtils;
import java.util.Date;
import java.util.Iterator;
import java.util.Map;

public class EmpBatchDataVerifyInputControl {
    public static void verifyInput(CoreBaseInfo info, String entityName) throws EASBizException {
        Map needVerifyMap = EmpBatchDataVerifyInputInit.getNeedVerifyMap(entityName);
        if (needVerifyMap == null || needVerifyMap.size() == 0) {
            return;
        }
        Iterator it = needVerifyMap.entrySet().iterator();
        Map.Entry entry = null;
        String key = null;
        Object value = null;
        while (it.hasNext()) {
            entry = it.next();
            key = (String)entry.getKey();
            value = entry.getValue();
            if ("0".equals(key)) {
                EmpBatchDataVerifyInputControl.composeDateType(info, value);
                continue;
            }
            if (!"1".equals(key)) continue;
            EmpBatchDataVerifyInputControl.composeNotNullType(info, value);
        }
    }

    private static void composeDateType(CoreBaseInfo info, Map date_verfiyM) throws EmployeeException {
        java.sql.Date beginDate = info.getDate((String)date_verfiyM.get("begin"));
        java.sql.Date endDate = info.getDate((String)date_verfiyM.get("end"));
        if (beginDate == null || endDate == null) {
            return;
        }
        if (DateTimeUtils.dayBefore((Date)endDate, (Date)beginDate)) {
            throw new EmployeeException(EmployeeException.EMP_BATCH_DATE_VERIFY);
        }
    }

    private static void composeNotNullType(CoreBaseInfo info, Map notNull_verfiyM) throws EmpBatchException {
        boolean errorFlag = true;
        boolean is_must_one_not_null = notNull_verfiyM.containsKey("MUST_ONE_NOT_NULL_FLAG");
        Map.Entry entry2 = null;
        String key = null;
        String value = null;
        for (Map.Entry entry2 : notNull_verfiyM.entrySet()) {
            key = (String)entry2.getKey();
            value = (String)entry2.getValue();
            if ("MUST_ONE_NOT_NULL_FLAG".equals(key)) continue;
            if (info.get(key) == null || StringUtils.isEmpty((String)info.get(key).toString())) {
                errorFlag = true;
            } else {
                errorFlag = false;
                if (is_must_one_not_null) break;
            }
            if (is_must_one_not_null || !errorFlag) continue;
            throw new EmpBatchException(EmpBatchException.NOT_NULL, new String[]{value});
        }
        if (is_must_one_not_null && errorFlag) {
            throw new EmpBatchException(EmpBatchException.ONE_NOT_NULL, new Object[]{notNull_verfiyM.get("MUST_ONE_NOT_NULL_FLAG")});
        }
    }
}

