/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.emp.client;

import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.ui.util.IUIActionPostman;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.commonquery.client.CustomerParams;
import com.kingdee.eas.basedata.org.AdminOrgUnitFactory;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.batchHandler.RequestContext;
import com.kingdee.eas.framework.batchHandler.client.UIActionPostman;
import com.kingdee.eas.hr.base.util.OrgStringUtil;
import com.kingdee.eas.hr.emp.client.AbstractEmpDynamicScheduleFilterUI;
import com.kingdee.eas.hr.org.client.AdminByOrgRangePromptBox;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.DateTimeUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.Serializable;
import java.util.Calendar;
import java.util.Date;
import org.apache.log4j.Logger;

public class EmpDynamicScheduleFilterUI
extends AbstractEmpDynamicScheduleFilterUI {
    private static final Logger logger = CoreUIObject.getLogger(EmpDynamicScheduleFilterUI.class);
    private final String resClass = "com.kingdee.eas.hr.org.client.PersonPlanResource.";

    public void onLoad() throws Exception {
        super.onLoad();
        this.initF7();
        this.labDisplay.setVisible(false);
        this.labOrg.setVisible(false);
    }

    public boolean verify() {
        if (this.rdOrg.isSelected() && this.bizAdminOrg.getData() == null) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.hr.org.client.PersonPlanResource.NO_SELECT_ADMINORG"));
            this.bizAdminOrg.requestFocusInWindow();
            return false;
        }
        if (this.rdOrgMult.isSelected() && this.bizAdminOrgMult.getData() == null) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.hr.org.client.PersonPlanResource.NO_SELECT_ADMINORG"));
            this.bizAdminOrgMult.requestFocusInWindow();
            return false;
        }
        if (this.kdtFrom.getValue() == null || this.kdtTo.getValue() == null) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.hr.org.client.PersonPlanResource.DATE_SCOPE_ERROR"));
            this.kdtFrom.requestFocusInWindow();
            return false;
        }
        if (DateTimeUtils.dayAfter((Date)((Date)this.kdtFrom.getValue()), (Date)((Date)this.kdtTo.getValue()))) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.hr.org.client.PersonPlanResource.FROMDATE_BIGGER_TODATE"));
            this.kdtFrom.requestFocusInWindow();
            return false;
        }
        return true;
    }

    public void clear() {
        super.clear();
        this.rdOrg.setSelected(true);
        this.setOrgCommentEnabled();
        this.bizAdminOrg.setData(null);
        this.bizAdminOrgMult.setData(null);
        this.chkShowSealUp.setSelected(false);
        this.chkShowVirtualOrg.setSelected(false);
    }

    @Override
    protected void rdOrg_actionPerformed(ActionEvent e) throws Exception {
        this.setOrgCommentEnabled();
        super.rdOrg_actionPerformed(e);
    }

    @Override
    protected void rdOrgMult_actionPerformed(ActionEvent e) throws Exception {
        this.setOrgCommentEnabled();
        super.rdOrgMult_actionPerformed(e);
    }

    private void setOrgCommentEnabled() {
        boolean isRdOrgSelected = this.rdOrg.isSelected();
        boolean isRdOrgMultSelected = this.rdOrgMult.isSelected();
        this.bizAdminOrgMult.setEnabled(isRdOrgMultSelected);
        this.bizAdminOrg.setEnabled(isRdOrgSelected);
        this.chkShowSealUp.setEnabled(isRdOrgSelected);
        this.chkShowVirtualOrg.setEnabled(isRdOrgSelected);
        this.cboLevel.setEnabled(isRdOrgSelected);
    }

    public void setCustomerParams(CustomerParams param) {
        this.clear();
        super.setCustomerParams(param);
        if (param == null) {
            return;
        }
        ObjectUuidPK pk = null;
        this.rdOrg.setSelected(param.getBoolean(this.rdOrg.getName()));
        this.rdOrgMult.setSelected(param.getBoolean(this.rdOrgMult.getName()));
        String orgIds = param.getCustomerParam(this.bizAdminOrgMult.getName());
        if (orgIds != null) {
            Object[] orgs = OrgStringUtil.string2OrgInfoArr((String)orgIds);
            this.bizAdminOrgMult.setData((Object)orgs);
        }
        if (param.getCustomerParam("SelectOrg") != null) {
            pk = new ObjectUuidPK(BOSUuid.read((String)param.getCustomerParam("SelectOrg")));
            AdminOrgUnitInfo adminInfo = null;
            try {
                if (this.isPrepareChooseAdmin()) {
                    this.prepareChooseAdmin((IObjectPK)pk).callHandler();
                }
                adminInfo = AdminOrgUnitFactory.getRemoteInstance().getAdminOrgUnitInfo((IObjectPK)pk);
                this.bizAdminOrg.setData((Object)adminInfo);
            }
            catch (Exception e) {
                ExceptionHandler.handle((Throwable)e);
            }
        }
        if (param.getDate("startDate") != null) {
            this.kdtFrom.setValue((Object)param.getDate("startDate"));
        } else {
            Calendar now = Calendar.getInstance(SysContext.getSysContext().getLocale());
            now.add(1, -1);
            this.kdtFrom.setValue((Object)now.getTime());
        }
        if (param.getDate("endDate") != null) {
            this.kdtTo.setValue((Object)param.getDate("endDate"));
        }
        this.chkShowSealUp.setSelected(param.getBoolean("sealUp"));
        this.chkShowVirtualOrg.setSelected(param.getBoolean("ShowVirtualOrg"));
        this.setOrgCommentEnabled();
    }

    public CustomerParams getCustomerParams() {
        CustomerParams params = new CustomerParams();
        params.putBoolean(this.rdOrg.getName(), this.rdOrg.isSelected());
        params.putBoolean(this.rdOrgMult.getName(), this.rdOrgMult.isSelected());
        if (this.rdOrgMult.isSelected()) {
            if (this.bizAdminOrgMult.getData() != null) {
                params.addCustomerParam(this.bizAdminOrgMult.getName(), OrgStringUtil.orgInfoArr2String((Object[])((Object[])this.bizAdminOrgMult.getData())));
            }
            params.putBoolean("ShowVirtualOrg", this.chkShowVirtualOrg.isSelected());
            params.putBoolean("sealUp", this.chkShowSealUp.isSelected());
        }
        if (this.rdOrg.isSelected()) {
            if (this.bizAdminOrg.getData() != null) {
                params.addCustomerParam("SelectOrg", ((AdminOrgUnitInfo)this.bizAdminOrg.getData()).getId().toString());
            }
            params.putInt("level", 100);
            params.putBoolean("sealUp", this.chkShowSealUp.isSelected());
            params.putBoolean("ShowVirtualOrg", this.chkShowVirtualOrg.isSelected());
        }
        params.putDate("startDate", (Date)this.kdtFrom.getValue());
        params.putDate("endDate", (Date)this.kdtTo.getValue());
        return params;
    }

    private void initF7() throws Exception {
        this.bizAdminOrg.setQueryInfo("com.kingdee.eas.basedata.org.app.AdminOrgUnitQuery");
        this.bizAdminOrg.setCommitFormat("$number$");
        this.bizAdminOrg.setEditFormat("$number$");
        this.bizAdminOrg.setDisplayFormat("$name$");
        this.bizAdminOrg.setEditable(false);
        AdminByOrgRangePromptBox selector = new AdminByOrgRangePromptBox();
        selector.showChkSealUp(true);
        this.bizAdminOrg.setSelector((KDPromptSelector)selector);
        AdminByOrgRangePromptBox selectorMult = new AdminByOrgRangePromptBox();
        selectorMult.showChkSealUp(true);
        selectorMult.setIsSingleSelect(false);
        this.bizAdminOrgMult.setSelector((KDPromptSelector)selectorMult);
        this.bizAdminOrgMult.setEditable(false);
        if (this.getUIContext().get("SelectOrg") != null) {
            this.bizAdminOrg.setValue((Object)((AdminOrgUnitInfo)this.getUIContext().get("SelectOrg")));
        }
    }

    public IUIActionPostman prepareChooseAdmin(IObjectPK pk) {
        IUIActionPostman handler = UIActionPostman.getInstance((IUIObject)this);
        RequestContext request = new RequestContext();
        request.setClassName(this.getUIHandlerClassName());
        request.setMethodName("_handlerChooseAdmin");
        request.put("pk", (Object)pk);
        handler.setRequestContext((Serializable)request);
        return handler;
    }

    public boolean isPrepareChooseAdmin() {
        return true;
    }
}

