/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.emp.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.basedata.org.AdminOrgUnitFactory;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.PositionInfo;
import com.kingdee.eas.basedata.org.client.PositionPromptBox2;
import com.kingdee.eas.basedata.org.client.f7.AdminByCurrentHROF7WithOrgRangeFilter;
import com.kingdee.eas.basedata.person.IPerson;
import com.kingdee.eas.basedata.person.PersonFactory;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.hr.base.EmployeeTypeFactory;
import com.kingdee.eas.hr.base.EmployeeTypeInfo;
import com.kingdee.eas.hr.base.IEmployeeType;
import com.kingdee.eas.hr.emp.EmpTypeConvertEnum;
import com.kingdee.eas.hr.emp.EmpTypeConvertException;
import com.kingdee.eas.hr.emp.EmpTypeConvertFacadeFactory;
import com.kingdee.eas.hr.emp.EmpTypeConvertHisFactory;
import com.kingdee.eas.hr.emp.EmpTypeConvertHisInfo;
import com.kingdee.eas.hr.emp.EmployeeException;
import com.kingdee.eas.hr.emp.IEmpTypeConvertFacade;
import com.kingdee.eas.hr.emp.IEmpTypeConvertHis;
import com.kingdee.eas.hr.emp.PersonPositionCollection;
import com.kingdee.eas.hr.emp.PersonPositionFactory;
import com.kingdee.eas.hr.emp.PersonPositionInfo;
import com.kingdee.eas.hr.emp.client.AbstractEmpTypeConvertEditUI;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.event.ActionEvent;
import java.util.Calendar;
import java.util.Date;
import org.apache.log4j.Logger;

public class EmpTypeConvertEditUI
extends AbstractEmpTypeConvertEditUI {
    private static final String EMPTYPERESOURCE = "com.kingdee.eas.hr.emp.EmpTypeConvertResource";
    private static final Logger logger = CoreUIObject.getLogger(EmpTypeConvertEditUI.class);
    private String curPersonId = null;
    private boolean isAudit = false;
    private String strEmpTypeConvertHisId = null;
    private PersonInfo perInfo = null;
    private final String reRetainTypeID = "00000000-0000-0000-0000-000000000015A29E85B3";
    private final String retireTypeID = "00000000-0000-0000-0000-000000000008A29E85B3";

    public void onLoad() throws Exception {
        super.onLoad();
    }

    @Override
    public void storeFields() {
        super.storeFields();
        if (this.isAudit) {
            this.editData.setAuditState(EmpTypeConvertEnum.AUDITED);
        }
    }

    @Override
    public void loadFields() {
        if (this.getUIContext().get("IsAudit") != null && this.getUIContext().get("IsAudit").toString().equals("1")) {
            this.setWidgtVisible(this.editData.getFromEmpType().getInService().getValue());
        }
        if (this.getUIContext().get("ID") != null) {
            this.setWidgtVisible(this.editData.getFromEmpType().getInService().getValue());
        }
        super.loadFields();
        if (this.perInfo != null && this.perInfo.getEmployeeType().getInService().getValue() == 3) {
            this.prmtToEmpType.setData((Object)this.getRetireOrRetainType(this.reRetainTypeID));
        } else if (this.perInfo != null && this.perInfo.getEmployeeType().getInService().getValue() == 4) {
            this.prmtToEmpType.setData((Object)this.getRetireOrRetainType(this.retireTypeID));
        }
        if (this.isAudit) {
            Date dtNow = Calendar.getInstance().getTime();
            this.pkAuditDate.setValue((Object)dtNow);
        }
        if (this.isAudit || this.getOprtState().equals(OprtState.VIEW)) {
            try {
                if (this.editData.getAuditState().equals((Object)EmpTypeConvertEnum.NOAUDIT)) {
                    PersonPositionInfo fromPerPosInfo;
                    PersonPositionCollection fromPerPosCol;
                    IPerson iper = PersonFactory.getRemoteInstance();
                    PersonInfo perInfo = this.editData.getEmployee();
                    EmployeeTypeInfo empTypeInfo = EmployeeTypeFactory.getRemoteInstance().getEmployeeTypeInfo((IObjectPK)new ObjectUuidPK(perInfo.getEmployeeType().getId()));
                    this.prmtFromEmpType.setData((Object)empTypeInfo);
                    PositionInfo fromPosInfo = iper.getPrimaryPosition(perInfo.getId());
                    if (fromPosInfo != null) {
                        this.prmtFromPosition.setData((Object)fromPosInfo);
                    }
                    if ((fromPerPosCol = PersonPositionFactory.getRemoteInstance().getPersonPositionCollection("select personDep where person = '" + perInfo.getId().toString() + "'")).size() > 0 && (fromPerPosInfo = fromPerPosCol.get(0)).getPersonDep() != null) {
                        AdminOrgUnitInfo fromUnitInfo = AdminOrgUnitFactory.getRemoteInstance().getAdminOrgUnitInfo((IObjectPK)new ObjectUuidPK(fromPerPosInfo.getPersonDep().getId()));
                        this.prmtFromUnit.setData((Object)fromUnitInfo);
                    }
                }
            }
            catch (BOSException e) {
                ExceptionHandler.handle((Throwable)e);
            }
            catch (EASBizException e) {
                ExceptionHandler.handle((Throwable)e);
            }
        }
    }

    protected void initWorkButton() {
        if (this.getUIContext().get("PersonID") != null) {
            this.curPersonId = this.getUIContext().get("PersonID").toString();
        }
        if (this.getUIContext().get("IsAudit") != null && this.getUIContext().get("IsAudit").toString().equals("1")) {
            this.isAudit = true;
            this.strEmpTypeConvertHisId = this.getUIContext().get("ID").toString();
        }
        super.initWorkButton();
        this.prmtToEmpType.setQueryInfo("com.kingdee.eas.hr.base.app.EmployeeTypeQuery");
        this.prmtToPosition.setSelector((KDPromptSelector)new PositionPromptBox2());
        this.prmtToUnit.setSelector((KDPromptSelector)new AdminByCurrentHROF7WithOrgRangeFilter());
        this.btnPass.setIcon(EASResource.getIcon((String)"imgTbtn_affirm"));
        if (this.isAudit) {
            this.prmtFromEmpType.setEnabled(false);
            this.prmtEmployee.setEnabled(false);
            this.prmtFromPosition.setEnabled(false);
            this.prmtFromUnit.setEnabled(false);
            this.comboAuditState.setEnabled(false);
            this.prmtToEmpType.setEnabled(false);
            this.prmtToPosition.setEnabled(false);
            this.prmtToUnit.setEnabled(false);
            this.txtDescription.setEditable(false);
            this.btnSubmit.setVisible(false);
        } else {
            this.prmtFromEmpType.setEnabled(false);
            this.prmtEmployee.setEnabled(false);
            this.prmtFromPosition.setEnabled(false);
            this.prmtFromUnit.setEnabled(false);
            this.comboAuditState.setEnabled(false);
            this.pkAuditDate.setEditable(false);
            this.txtAuditOpinion.setEditable(false);
            this.btnPass.setVisible(false);
        }
    }

    private void setEmpTypeF7Filter(int fromEmpTypeParent) {
        EntityViewInfo empTypeView = new EntityViewInfo();
        FilterInfo empTypeFilter = null;
        if (fromEmpTypeParent == 1) {
            empTypeFilter = new FilterInfo();
            empTypeFilter.getFilterItems().add(new FilterItemInfo("inService", (Object)0));
            empTypeView.setFilter(empTypeFilter);
        } else if (fromEmpTypeParent == 0) {
            empTypeFilter = new FilterInfo();
            empTypeFilter.getFilterItems().add(new FilterItemInfo("inService", (Object)4, CompareType.NOTEQUALS));
            empTypeView.setFilter(empTypeFilter);
        }
        this.prmtToEmpType.setEntityViewInfo(empTypeView);
    }

    protected void verifyInput(ActionEvent arg0) throws Exception {
        EmployeeTypeInfo fromEmpTypeInfo;
        super.verifyInput(arg0);
        if (this.prmtToEmpType.getValue() == null) {
            throw new EmployeeException(EmployeeException.EMPTYPECONVERT_TOTYPE_CANNOTEMPTY);
        }
        if (this.prmtFromEmpType.getValue() == this.prmtToEmpType.getValue()) {
            throw new EmployeeException(EmployeeException.EMPTYPECONVERT_SAMEFROMTO);
        }
        EmployeeTypeInfo toEmpTypeInfo = (EmployeeTypeInfo)this.prmtToEmpType.getValue();
        EmployeeTypeInfo fromEmpType = (EmployeeTypeInfo)this.prmtFromEmpType.getValue();
        if (toEmpTypeInfo.getInService().getValue() == 0 && (fromEmpTypeInfo = (EmployeeTypeInfo)this.prmtFromEmpType.getValue()).getInService().getValue() != 0 && (this.prmtToUnit.getValue() == null || this.prmtToPosition.getValue() != null)) {
            throw new EmployeeException(EmployeeException.EMPTYPECONVERT_TONOTINPOSITION);
        }
        if (toEmpTypeInfo.getInService().getValue() == 1 && this.prmtToPosition.getValue() == null) {
            throw new EmployeeException(EmployeeException.EMPTYPECONVERT_TOINPOSITION);
        }
        if (fromEmpType.getInService().getValue() == 3) {
            Date endDate;
            if (this.pkEffectDate.getValue() == null) {
                throw new EmpTypeConvertException(EmpTypeConvertException.EFFECTDATE_NOT_NULL);
            }
            if (this.prmtToPosition.getData() == null) {
                throw new EmpTypeConvertException(EmpTypeConvertException.TOPOSITION_NOT_NULL);
            }
            if (this.prmtToUnit.getData() == null) {
                throw new EmpTypeConvertException(EmpTypeConvertException.TOUNIT_NOT_NULL);
            }
            if (this.pkStartDate.getValue() == null) {
                throw new EmpTypeConvertException(EmpTypeConvertException.STARTDATE_NOT_NULL);
            }
            Date effectDate = (Date)this.pkEffectDate.getValue();
            Date startDate = (Date)this.pkStartDate.getValue();
            if (this.pkRetireDate.getValue() != null) {
                Date retireDate = (Date)this.pkRetireDate.getValue();
                if (effectDate.before(retireDate)) {
                    throw new EmpTypeConvertException(EmpTypeConvertException.DATE_NOT_INVALID);
                }
                if (startDate.before(retireDate)) {
                    throw new EmpTypeConvertException(EmpTypeConvertException.DATE_NOT_INVALID);
                }
            }
            if (this.pkEndDate.getValue() != null && (endDate = (Date)this.pkEndDate.getValue()).before(startDate)) {
                throw new EmpTypeConvertException(EmpTypeConvertException.START_NOT_END);
            }
        }
        if (fromEmpType.getInService().getValue() == 4) {
            Date retainDate;
            if (this.pkEndDate.getValue() == null) {
                throw new EmpTypeConvertException(EmpTypeConvertException.ENDDATE_NOT_NULL);
            }
            if (this.prmtToUnit.getData() == null) {
                throw new EmpTypeConvertException(EmpTypeConvertException.ADMIN_NOT_NULL);
            }
            if (this.pkRetainCancelDate.getValue() == null) {
                throw new EmpTypeConvertException(EmpTypeConvertException.RETAINCANCELDATE_NOT_NULL);
            }
            Date retainCancelDate = (Date)this.pkRetainCancelDate.getValue();
            if (this.pkRetainDate.getValue() != null && retainCancelDate.before(retainDate = (Date)this.pkRetainDate.getValue())) {
                throw new EmpTypeConvertException(EmpTypeConvertException.DATE_NOVALID);
            }
        }
        if (this.isAudit && this.pkAuditDate.getValue() == null) {
            throw new EmployeeException(EmployeeException.EMPTYPECONVERT_AUDITDATA_CANNOTEMPTY);
        }
    }

    protected IObjectValue createNewData() {
        EmpTypeConvertHisInfo info = new EmpTypeConvertHisInfo();
        if (this.curPersonId != null) {
            SelectorItemCollection sic = null;
            try {
                PersonPositionInfo fromPerPosInfo;
                PersonPositionCollection fromPerPosCol;
                sic = new SelectorItemCollection();
                sic.add(new SelectorItemInfo("*"));
                sic.add(new SelectorItemInfo("employeeType.id"));
                sic.add(new SelectorItemInfo("employeeType.name"));
                sic.add(new SelectorItemInfo("employeeType.inService"));
                IPerson iper = PersonFactory.getRemoteInstance();
                this.perInfo = iper.getPersonInfo((IObjectPK)new ObjectUuidPK(this.curPersonId), sic);
                if (this.perInfo.getEmployeeType().getInService().getValue() == 2) {
                    MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.hr.emp.EMPAutoGenerateResource", (String)"251_EmpTypeConvertEditUI"));
                    SysUtil.abort();
                }
                this.setWidgtVisible(this.perInfo.getEmployeeType().getInService().getValue());
                this.setRetireAndRetainDate(info);
                info.setEmployee(this.perInfo);
                info.setAuditState(EmpTypeConvertEnum.NOAUDIT);
                info.setFromEmpType(this.perInfo.getEmployeeType());
                PositionInfo fromPosInfo = iper.getPrimaryPosition(this.perInfo.getId());
                if (fromPosInfo != null) {
                    info.setFromPosition(fromPosInfo);
                }
                if ((fromPerPosCol = PersonPositionFactory.getRemoteInstance().getPersonPositionCollection("select personDep where person = '" + this.perInfo.getId().toString() + "'")).size() > 0 && (fromPerPosInfo = fromPerPosCol.get(0)).getPersonDep() != null) {
                    AdminOrgUnitInfo fromUnitInfo = AdminOrgUnitFactory.getRemoteInstance().getAdminOrgUnitInfo((IObjectPK)new ObjectUuidPK(fromPerPosInfo.getPersonDep().getId()));
                    info.setFromUnit(fromUnitInfo);
                }
                this.setEmpTypeF7Filter(this.perInfo.getEmployeeType().getInService().getValue());
            }
            catch (EASBizException e) {
                ExceptionHandler.handle((Throwable)e);
            }
            catch (BOSException e) {
                ExceptionHandler.handle((Throwable)e);
            }
        }
        return info;
    }

    private void setWidgtVisible(int empInService) {
        if (empInService == 0 || empInService == 1) {
            this.kDLabelContainer3.setVisible(false);
            this.pkRetainCancelDate.setVisible(false);
            this.pkEffectDate.setVisible(false);
            this.labelEffectData.setVisible(false);
            this.kDLabelContainer2.setVisible(false);
            this.pkRetireDate.setVisible(false);
            this.labelStartDate.setVisible(false);
            this.pkStartDate.setVisible(false);
            this.labelEndDate.setVisible(false);
            this.pkEndDate.setVisible(false);
            this.kDLabelContainer4.setVisible(false);
            this.pkRetainDate.setVisible(false);
        }
        if (empInService == 3) {
            this.prmtToUnit.setEnabled(false);
            this.contFromPosition.setVisible(false);
            this.prmtFromPosition.setVisible(false);
            this.kDLabelContainer3.setVisible(false);
            this.pkRetainCancelDate.setVisible(false);
            this.kDLabelContainer4.setVisible(false);
            this.pkRetainDate.setVisible(false);
            this.pkRetireDate.setEnabled(false);
            this.prmtToEmpType.setEnabled(false);
            this.contToUnit.getBoundLabel().setText(EASResource.getString((String)EMPTYPERESOURCE, (String)"TO_UNIT"));
            this.pkEffectDate.setRequired(true);
            this.prmtToPosition.setRequired(true);
            this.prmtToUnit.setRequired(true);
            this.pkStartDate.setRequired(true);
        }
        if (empInService == 4) {
            this.prmtToPosition.setEnabled(false);
            this.pkEffectDate.setVisible(false);
            this.labelEffectData.setVisible(false);
            this.kDLabelContainer2.setVisible(false);
            this.pkRetireDate.setVisible(false);
            this.pkRetainDate.setEnabled(false);
            this.labelStartDate.setVisible(false);
            this.pkStartDate.setVisible(false);
            this.prmtToEmpType.setEnabled(false);
            this.contFromUnit.getBoundLabel().setText(EASResource.getString((String)EMPTYPERESOURCE, (String)"NOW_UNIT"));
            this.pkEndDate.setRequired(true);
            this.prmtToUnit.setRequired(true);
            this.pkRetainCancelDate.setRequired(true);
        }
        this.setDefaultDataForWidgt();
    }

    private void setRetireAndRetainDate(EmpTypeConvertHisInfo info) throws BOSException, EASBizException {
        IEmpTypeConvertFacade iEmpTypeConvertFacade = EmpTypeConvertFacadeFactory.getRemoteInstance();
        Date retireDate = iEmpTypeConvertFacade.getRetireDate(this.curPersonId);
        Date retainDate = iEmpTypeConvertFacade.getReretainDate(this.curPersonId);
        info.setRetireDate(retireDate);
        info.setReretainDate(retainDate);
    }

    private void setDefaultDataForWidgt() {
        this.pkEffectDate.setValue(null);
        this.pkEndDate.setValue(null);
        this.pkStartDate.setValue(null);
        this.pkRetainCancelDate.setValue(null);
        this.pkRetireDate.setValue(null);
        this.pkRetainDate.setValue(null);
    }

    private EmployeeTypeInfo getRetireOrRetainType(String empTypeId) {
        String oql = "select id,name,number,inService where id = '" + empTypeId + "'";
        try {
            IEmployeeType iEmployeeType = EmployeeTypeFactory.getRemoteInstance();
            return iEmployeeType.getEmployeeTypeInfo(oql);
        }
        catch (BOSException e) {
            this.handleException((Exception)((Object)e));
        }
        catch (EASBizException e1) {
            this.handleException((Exception)((Object)e1));
        }
        return null;
    }

    protected void afterSubmitAddNew() {
    }

    @Override
    protected void prmtToPosition_dataChanged(DataChangeEvent e) throws Exception {
        if (e.getNewValue() != null) {
            PositionInfo positionInfo = (PositionInfo)e.getNewValue();
            this.prmtToUnit.setValue((Object)positionInfo.getAdminOrgUnit());
        }
    }

    @Override
    protected void prmtToEmpType_dataChanged(DataChangeEvent e) throws Exception {
        if (this.oprtState.equals(OprtState.ADDNEW) && e.getNewValue() != null) {
            EmployeeTypeInfo etInfo = (EmployeeTypeInfo)e.getNewValue();
            if (etInfo.getInService().getValue() == 1 || etInfo.getInService().getValue() == 4) {
                this.prmtToUnit.setEnabled(false);
                this.prmtToPosition.setEnabled(true);
                this.prmtToUnit.setValue(null);
            } else if (etInfo.getInService().getValue() == 0 || etInfo.getInService().getValue() == 3 || etInfo.getInService().getValue() == 2) {
                this.prmtToUnit.setEnabled(true);
                this.prmtToPosition.setEnabled(false);
                this.prmtToPosition.setValue(null);
            }
            if (etInfo.getInService().getValue() == 0) {
                this.prmtToUnit.setRequired(true);
                if (this.prmtFromEmpType.getValue() != null && ((EmployeeTypeInfo)this.prmtFromEmpType.getValue()).getInService().getValue() == 0) {
                    this.prmtToUnit.setValue(this.prmtFromUnit.getValue());
                }
            }
        }
    }

    @Override
    public void actionPass_actionPerformed(ActionEvent e) throws Exception {
        this.verify(null);
        ((IEmpTypeConvertHis)this.getBizInterface()).auditEmpTypeConvert((IObjectValue)this.editData);
        MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.hr.emp.EMPAutoGenerateResource", (String)"250_EmpTypeConvertBatchEditUI"));
        this.getUIWindow().close();
    }

    public boolean isModify() {
        return false;
    }

    protected ICoreBase getBizInterface() throws Exception {
        return EmpTypeConvertHisFactory.getRemoteInstance();
    }
}

