/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.emp.client;

import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.ui.face.ItemAction;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.HROrgUnitInfo;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.hr.base.CodingRuleManageFacadeFactory;
import com.kingdee.eas.hr.base.ICodingRuleManageFacade;
import com.kingdee.eas.hr.base.util.CodingRuleData;
import com.kingdee.eas.hr.emp.PersonArchivesFactory;
import com.kingdee.eas.hr.emp.PersonArchivesInfo;
import com.kingdee.eas.hr.emp.client.AbstractEmployeeArchivesEditUI;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;

public class EmployeeArchivesEditUI
extends AbstractEmployeeArchivesEditUI {
    private HROrgUnitInfo hroInfo = null;

    @Override
    public void storeFields() {
        super.storeFields();
    }

    @Override
    protected IObjectValue createNewData() {
        PersonArchivesInfo info = new PersonArchivesInfo();
        PersonInfo pInfo = new PersonInfo();
        pInfo.setId(BOSUuid.read((String)this.getUIContext().get("PersonID").toString()));
        info.setPerson(pInfo);
        try {
            ICodingRuleManageFacade icrm;
            CodingRuleData codingRuleData;
            String orgId = null;
            if (info.getCU() != null) {
                orgId = info.getCU().getId().toString();
            }
            if (info.getHrOrgUnit() == null) {
                info.setHrOrgUnit(SysContext.getSysContext().getCurrentHRUnit());
            }
            if ((codingRuleData = (icrm = CodingRuleManageFacadeFactory.getRemoteInstance()).getCodingRuleData((IObjectValue)info, orgId)).isExistRule()) {
                if (codingRuleData.isAddView()) {
                    String number = codingRuleData.getNumber();
                    info.setNumber(number);
                    this.txtNumber.setText(number);
                }
                if (codingRuleData.isModifable()) {
                    this.txtNumber.setEnabled(true);
                } else {
                    this.txtNumber.setEnabled(false);
                }
            }
        }
        catch (Exception e) {
            this.handUIException(e);
        }
        return info;
    }

    @Override
    protected ICoreBase getBizInterface() throws Exception {
        return PersonArchivesFactory.getRemoteInstance();
    }

    protected void verifyInput(ActionEvent e) throws Exception {
    }

    protected void initWorkButton() {
        super.initWorkButton();
        if (OprtState.VIEW.equals(this.getOprtState())) {
            this.actionAddNew.setVisible(false);
            this.actionEdit.setVisible(false);
            this.actionCopy.setVisible(false);
            this.actionSubmit.setVisible(false);
            this.actionRemove.setVisible(false);
        } else {
            this.actionAddNew.setVisible(true);
            this.actionEdit.setVisible(true);
            this.actionCopy.setVisible(true);
            this.actionSubmit.setVisible(true);
            this.actionRemove.setVisible(true);
        }
    }

    protected void handlePermissionForItemAction(ItemAction action) {
        if (this.getUIContext().get("NO_PERMISSION") == null) {
            super.handlePermissionForItemAction(action);
        }
    }

    private CtrlUnitInfo getCurrentCU() {
        if (this.hroInfo != null) {
            return this.hroInfo.getCU();
        }
        return SysContext.getSysContext().getCurrentCtrlUnit();
    }

    private HROrgUnitInfo getCurrentHRO() {
        if (this.hroInfo != null) {
            return this.hroInfo;
        }
        return SysContext.getSysContext().getCurrentHRUnit();
    }

    protected IObjectPK getOrgPK(ItemAction action) {
        return new ObjectUuidPK(this.getCurrentHRO().getId());
    }

    public IObjectPK runSubmit() throws Exception {
        this.editData.setHrOrgUnit(this.getCurrentHRO());
        return super.runSubmit();
    }

    protected void afterOnLoad() throws Exception {
        super.afterOnLoad();
    }

    protected void beforeOnLoad() throws Exception {
        super.beforeOnLoad();
        this.hroInfo = (HROrgUnitInfo)this.getUIContext().get("currentHRO");
    }

    protected void beforeStoreFields(ActionEvent e) throws Exception {
        if (this.pkInDate.getTimestamp() != null && this.pkOutDate.getTimestamp() != null && this.pkInDate.getTimestamp().after(this.pkOutDate.getTimestamp())) {
            MsgBox.showError((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.hr.emp.EmployeeResource", (String)"INDATE_AFTER_OUTDATE"));
            this.pkInDate.requestFocusInWindow();
            SysUtil.abort();
        }
        super.beforeStoreFields(e);
    }
}

