/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.emp.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.swing.util.CtrlFormatUtilities;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.hr.base.client.ListEditUI;
import com.kingdee.eas.hr.emp.IPersonArchives;
import com.kingdee.eas.hr.emp.PersonArchivesCollection;
import com.kingdee.eas.hr.emp.PersonArchivesFactory;
import com.kingdee.eas.hr.emp.client.AbstractEmployeeArchivesUI;
import com.kingdee.eas.hr.emp.client.EmployeeClientUtils;
import com.kingdee.eas.hr.emp.client.IEmpInfoUI;
import com.kingdee.eas.util.client.ExceptionHandler;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import javax.swing.JButton;

public class EmployeeArchivesUI
extends AbstractEmployeeArchivesUI
implements IEmpInfoUI {
    private String empId = null;
    private PersonInfo pInfo = null;
    private ArrayList delList = new ArrayList();

    private void checkInput() throws Exception {
        EmployeeClientUtils.checkTableCellIsNull(this.kdtArchives, "number");
        EmployeeClientUtils.checkHasInputRows(this.kdtArchives, this.delList);
    }

    @Override
    public void submit() throws Exception {
        this.checkInput();
        IObjectPK[] delArray = new IObjectPK[this.delList.size()];
        for (int i = 0; i < this.delList.size(); ++i) {
            delArray[i] = new ObjectUuidPK((BOSUuid)this.delList.get(i));
        }
        IPersonArchives ipr = PersonArchivesFactory.getRemoteInstance();
        ipr.saveAll(EmployeeClientUtils.getArchivesCollectionByKDTable(this.kdtArchives, EmployeeClientUtils.getPersonInfo(this.empId)), delArray);
        ListEditUI listEditUI = (ListEditUI)this.getUIContext().get("ListEditUI");
        listEditUI.setStatusBarMessage();
        this.refresh();
    }

    private void setDateEditor() {
        this.kdtArchives.getColumn("inDate").setEditor(EmployeeClientUtils.getStartDateCellEditor());
        this.kdtArchives.getColumn("inDate").getStyleAttributes().setNumberFormat(CtrlFormatUtilities.getDateFormatString());
        this.kdtArchives.getColumn("outDate").setEditor(EmployeeClientUtils.getEndDateCellEditor());
        this.kdtArchives.getColumn("outDate").getStyleAttributes().setNumberFormat(CtrlFormatUtilities.getDateFormatString());
    }

    public void firstOnLoad() throws Exception {
        this.refresh();
    }

    private PersonArchivesCollection getArchColl(String empId) throws BOSException {
        IPersonArchives ipr = PersonArchivesFactory.getRemoteInstance();
        String oql = "select * where person.id = '" + empId + "'";
        return ipr.getPersonArchivesCollection(oql);
    }

    private void refresh() throws Exception {
        this.kdtArchives.removeRows();
        this.loadRecords();
    }

    @Override
    public void secondLoad() throws Exception {
        this.firstOnLoad();
    }

    public void onLoad() throws Exception {
        this.empId = (String)this.getUIContext().get("ID");
        super.onLoad();
        EmployeeClientUtils.initTableBtn((JButton)this.btnArchAddNew, (JButton)this.btnArchDelete);
        this.kdtArchives.checkParsed();
        this.setDateEditor();
        if (this.getOprtState().equals(OprtState.VIEW)) {
            EmployeeClientUtils.setKDTableViewState(this.kdtArchives);
            this.btnArchAddNew.setEnabled(false);
            this.btnArchDelete.setEnabled(false);
        }
        EmployeeClientUtils.setColumnBackColor(this.kdtArchives, "number");
        this.kdtArchives.getStyleAttributes().setWrapText(true);
        this.firstOnLoad();
        this.initCellEditLength();
    }

    void initCellEditLength() {
        EmployeeClientUtils.setCellEditor(this.kdtArchives, "number");
        EmployeeClientUtils.setCellEditor(this.kdtArchives, "type");
        EmployeeClientUtils.setCellEditor(this.kdtArchives, "archivesPlace");
        EmployeeClientUtils.setCellEditor(this.kdtArchives, "source");
        EmployeeClientUtils.setCellEditor(this.kdtArchives, "destination");
        EmployeeClientUtils.setCellEditor(this.kdtArchives, "remark");
    }

    private void loadRecords() throws Exception {
        if (this.getUIContext().get("ID") != null) {
            this.empId = this.getUIContext().get("ID").toString();
        }
        PersonArchivesCollection c = this.getArchColl(this.empId);
        Object row = null;
        for (int i = 0; i < c.size(); ++i) {
            EmployeeClientUtils.setTableCellValueByInfo(this.kdtArchives.addRow(), c.get(i));
        }
    }

    @Override
    public void loadFields() {
        super.loadFields();
        try {
            this.refresh();
        }
        catch (Exception e) {
            ExceptionHandler.handle((Component)((Object)this), (Throwable)e);
        }
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    @Override
    public void actionArchAddNew_actionPerformed(ActionEvent e) throws Exception {
        EmployeeClientUtils.addNewKDTableRow(this.kdtArchives);
    }

    @Override
    public void actionArchDelete_actionPerformed(ActionEvent e) throws Exception {
        EmployeeClientUtils.deleteKDTableRow(this.kdtArchives, this.delList);
    }

    @Override
    public void setAddNewState() throws Exception {
        EmployeeClientUtils.setAddNewState((CoreUI)this);
        this.refresh();
    }

    @Override
    public void setEmpID(String empId) {
        this.empId = empId;
    }

    @Override
    public void setEnabled(boolean isArchives) {
        if (!isArchives) {
            this.kdtArchives.setEnabled(false);
            this.btnArchAddNew.setEnabled(false);
            this.btnArchDelete.setEnabled(false);
        }
    }

    protected IObjectValue createNewData() {
        return null;
    }

    protected ICoreBase getBizInterface() throws Exception {
        return null;
    }

    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        this.submit();
    }

    protected void inOnload() throws Exception {
    }
}

