/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.emp.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditAdapter;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditListener;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ctrl.swing.IKDEditor;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDFormattedTextField;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.PreChangeEvent;
import com.kingdee.bos.ctrl.swing.event.PreChangeListener;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.dao.AbstractObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.IPosition;
import com.kingdee.eas.basedata.org.PositionCollection;
import com.kingdee.eas.basedata.org.PositionFactory;
import com.kingdee.eas.basedata.org.PositionInfo;
import com.kingdee.eas.basedata.org.PositionMemberCollection;
import com.kingdee.eas.basedata.org.PositionMemberInfo;
import com.kingdee.eas.basedata.org.client.JobPromptBox;
import com.kingdee.eas.basedata.org.client.PositionPromptBox2;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.hr.base.EmployeeTypeCollection;
import com.kingdee.eas.hr.base.EmployeeTypeInfo;
import com.kingdee.eas.hr.base.HRInitFactory;
import com.kingdee.eas.hr.base.IHRInit;
import com.kingdee.eas.hr.base.client.ListEditUI;
import com.kingdee.eas.hr.emp.EmployeeException;
import com.kingdee.eas.hr.emp.IPersonEnrollHistory;
import com.kingdee.eas.hr.emp.IPersonWorkExpCur;
import com.kingdee.eas.hr.emp.PersonEnrollHistoryCollection;
import com.kingdee.eas.hr.emp.PersonEnrollHistoryFactory;
import com.kingdee.eas.hr.emp.PersonEnrollHistoryInfo;
import com.kingdee.eas.hr.emp.PersonPositionCollection;
import com.kingdee.eas.hr.emp.PersonPositionFactory;
import com.kingdee.eas.hr.emp.PersonPositionInfo;
import com.kingdee.eas.hr.emp.PersonWorkExpCurCollection;
import com.kingdee.eas.hr.emp.PersonWorkExpCurFactory;
import com.kingdee.eas.hr.emp.PersonWorkExpCurInfo;
import com.kingdee.eas.hr.emp.client.AbstractEmployeePositionUI;
import com.kingdee.eas.hr.emp.client.EmployeeClientUtils;
import com.kingdee.eas.hr.emp.client.IEmpInfoUI;
import com.kingdee.eas.hr.org.JobGradeInfo;
import com.kingdee.eas.hr.org.JobLevelCollection;
import com.kingdee.eas.hr.org.JobLevelInfo;
import com.kingdee.eas.hr.org.client.JobGradePromptBox;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.DateTimeUtils;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Iterator;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;

public class EmployeePositionUI
extends AbstractEmployeePositionUI
implements IEmpInfoUI {
    private String empId = null;
    private int rowID = 0;
    private int rowPosID = 0;
    private IRowSet posRows = null;
    private PersonPositionInfo editdata = null;
    private String hierarchyId = null;
    private PersonInfo pInfo = null;
    private ArrayList delList = new ArrayList();
    private ArrayList delListCur = new ArrayList();
    private ArrayList delListEnter = new ArrayList();
    private PositionMemberCollection pmColl = null;
    private PositionMemberInfo pmInfo = null;
    GregorianCalendar cal = new GregorianCalendar(2199, 11, 31);
    private EmployeeTypeInfo employeeTypeInfo = null;
    DefaultKingdeeTreeNode findTreeNode = null;
    private boolean firstLoad = true;
    private boolean levelLoaded = false;

    private String getDefaultHierarchy() throws Exception {
        return "00000000-0000-0000-0000-000000000001396FCAD0";
    }

    private IRowSet getPosRows(String hierarchyId, String empId) throws Exception {
        MetaDataPK qryPk = new MetaDataPK("com.kingdee.eas.hr.emp.app.PostMemberExtendQuery");
        IQueryExecutor iqryEx = QueryExecutorFactory.getRemoteInstance((IMetaDataPK)qryPk);
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("Person.id", (Object)empId));
        filter.getFilterItems().add(new FilterItemInfo("Hierarchy.id", (Object)hierarchyId));
        filter.setMaskString("#0 and #1");
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(filter);
        SorterItemInfo sorterItem = new SorterItemInfo("positionMember.isPrimary");
        sorterItem.setSortType(SortType.DESCEND);
        evi.getSorter().add(sorterItem);
        iqryEx.setObjectView(evi);
        return iqryEx.executeQuery();
    }

    private PersonEnrollHistoryCollection getEnRollCollection(String empId) throws Exception {
        PersonEnrollHistoryCollection c = new PersonEnrollHistoryCollection();
        MetaDataPK queryPK = new MetaDataPK("com.kingdee.eas.hr.emp.app.PersonEnrollHistoryQuery");
        IQueryExecutor queryExcu = QueryExecutorFactory.getRemoteInstance((IMetaDataPK)queryPK);
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("Person.id", (Object)empId));
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(filter);
        queryExcu.setObjectView(evi);
        IRowSet rows = queryExcu.executeQuery();
        PersonEnrollHistoryInfo info = null;
        while (rows.next()) {
            info = new PersonEnrollHistoryInfo();
            info.setId(BOSUuid.read((String)rows.getString("id")));
            info.setEnterDate(rows.getDate("enterDate"));
            info.setJoinDate(rows.getDate("joinDate"));
            info.setJoinGroupDate(rows.getDate("joinGroupDate"));
            info.setLeftDate(rows.getDate("leftDate"));
            c.add(info);
        }
        return c;
    }

    private String getSuperior(String positionId, String hierarchyId) throws Exception {
        StringBuffer superior = new StringBuffer();
        MetaDataPK qryPk = new MetaDataPK("com.kingdee.eas.hr.emp.app.SuperiorQuery");
        IQueryExecutor iqryEx = QueryExecutorFactory.getRemoteInstance((IMetaDataPK)qryPk);
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("child.id", (Object)positionId));
        filter.getFilterItems().add(new FilterItemInfo("Hierarchy.id", (Object)hierarchyId));
        filter.setMaskString("#0 and #1");
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(filter);
        iqryEx.setObjectView(evi);
        IRowSet rows = iqryEx.executeQuery();
        while (rows.next()) {
            if (superior.length() == 0) {
                superior.append(rows.getString("name"));
                continue;
            }
            superior.append(",").append(rows.getString("name"));
        }
        rows.close();
        return superior.toString();
    }

    private String getSuperPosition(String positionId, String hierarchyId) throws Exception {
        StringBuffer position = new StringBuffer();
        MetaDataPK qryPk = new MetaDataPK("com.kingdee.eas.hr.emp.app.SuperPositionQuery");
        IQueryExecutor iqryEx = QueryExecutorFactory.getRemoteInstance((IMetaDataPK)qryPk);
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("Child.id", (Object)positionId));
        filter.getFilterItems().add(new FilterItemInfo("Hierarchy.id", (Object)hierarchyId));
        filter.setMaskString("#0 and #1");
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(filter);
        iqryEx.setObjectView(evi);
        IRowSet rows = iqryEx.executeQuery();
        while (rows.next()) {
            if (position.length() == 0) {
                position.append(rows.getString("name"));
                continue;
            }
            position.append(",").append(rows.getString("name"));
        }
        rows.close();
        return position.toString();
    }

    private PositionInfo getPositionInfo(String id, String name, String number) {
        PositionInfo info = new PositionInfo();
        info.setId(BOSUuid.read((String)id));
        info.setNumber(number);
        info.setName(name);
        return info;
    }

    private JobLevelInfo getJobLevelInfo(String id, String name, String number) {
        if (id == null) {
            return null;
        }
        JobLevelInfo info = new JobLevelInfo();
        info.setId(BOSUuid.read((String)id));
        info.setNumber(number);
        info.setName(name);
        return info;
    }

    public JobLevelCollection getJobLvlsByJobId(String jobId) throws Exception {
        if (jobId == null) {
            return null;
        }
        JobLevelCollection c = new JobLevelCollection();
        MetaDataPK queryPK = new MetaDataPK("com.kingdee.eas.hr.org.app.JobLevelListQuery");
        IQueryExecutor queryExcu = QueryExecutorFactory.getRemoteInstance((IMetaDataPK)queryPK);
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("Job.id", (Object)jobId));
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(filter);
        queryExcu.setObjectView(evi);
        IRowSet rows = queryExcu.executeQuery();
        JobLevelInfo info = null;
        JobGradeInfo gradeInfo = null;
        while (rows.next()) {
            info = new JobLevelInfo();
            info.setId(BOSUuid.read((String)rows.getString("id")));
            info.setName(rows.getString("name"));
            gradeInfo = new JobGradeInfo();
            gradeInfo.setId(BOSUuid.read((String)rows.getString("JobGrade.id")));
            gradeInfo.setName(rows.getString("JobGrade.name"));
            info.setJobGrade(gradeInfo);
            c.add(info);
        }
        return c;
    }

    private PersonPositionInfo getPersonPositionInfo(String empId) throws Exception {
        String oql = "select *,jobGrade.name where person.id = '" + empId + "'";
        PersonPositionCollection c = PersonPositionFactory.getRemoteInstance().getPersonPositionCollection(oql);
        if (c.size() != 0) {
            return c.get(0);
        }
        return null;
    }

    private void setJobLevelItem(JobLevelInfo info) {
    }

    private JobGradeInfo getJobGradeInfo(IRowSet rows) throws Exception {
        JobGradeInfo jobGradeInfo = new JobGradeInfo();
        jobGradeInfo.setId(BOSUuid.read((String)rows.getString("JobGrade.id")));
        jobGradeInfo.setName(rows.getString("JobGrade.name"));
        return jobGradeInfo;
    }

    private void loadInfoByIRowSet(IRowSet rows) throws Exception {
        this.pmInfo = null;
        this.kdtPosition.removeRows();
        IRow kdRow = null;
        PositionInfo postInfo = null;
        JobLevelInfo jobLvlInfo = null;
        int i = 0;
        while (rows.next()) {
            postInfo = this.getPositionInfo(rows.getString("Position.id"), rows.getString("Position.name"), rows.getString("Position.number"));
            jobLvlInfo = this.getJobLevelInfo(rows.getString("JobLevel.id"), rows.getString("JobLevel.name"), rows.getString("JobLevel.number"));
            if (jobLvlInfo != null) {
                this.bizJobGrade.setData((Object)this.getJobGradeInfo(rows));
            }
            if (i == 0 && rows.getBoolean("PositionMember.isPrimary")) {
                this.f7Position.setData((Object)postInfo);
                this.loadJobLevel(rows.getString("Job.id"));
                this.setJobLevelItem(jobLvlInfo);
                this.txtJob.setText(rows.getString("Job.name"));
                this.txtDept.setText(rows.getString("AdminOrgUnit.displayName"));
                this.txtSuperior.setText(this.getSuperior(rows.getString("Position.id"), this.hierarchyId));
                this.txtSuperPosition.setText(this.getSuperPosition(rows.getString("Position.id"), this.hierarchyId));
                this.kdpBeginDate.setValue((Object)rows.getDate("beginDate"));
                this.kdpEndDate.setValue((Object)rows.getDate("endDate"));
                if (rows.getString("PositionMember.id") != null) {
                    this.pmInfo = new PositionMemberInfo();
                    this.pmInfo.setId(BOSUuid.read((String)rows.getString("PositionMember.id")));
                }
            } else {
                kdRow = this.kdtPosition.addRow();
                kdRow.getCell("id").setValue((Object)rows.getString("PositionMember.id"));
                kdRow.getCell("position").setValue((Object)postInfo);
                kdRow.getCell("job.name").setValue((Object)rows.getString("Job.name"));
                kdRow.getCell("dept").setValue((Object)rows.getString("AdminOrgUnit.displayName"));
                KDComboBox combo = new KDComboBox();
                kdRow.getCell("jobLevel").setEditor((ICellEditor)new KDTDefaultCellEditor((JComboBox)combo));
                if (rows.getString("Job.id") != null) {
                    combo.setModel((ComboBoxModel)this.getComboModelByColl((AbstractObjectCollection)this.getJobLvlsByJobId(rows.getString("Job.id"))));
                }
                kdRow.getCell("jobLevel").setValue((Object)jobLvlInfo);
                kdRow.getCell("beginDate").setValue((Object)rows.getDate("beginDate"));
                kdRow.getCell("endDate").setValue((Object)rows.getDate("endDate"));
                kdRow.getCell("pmx.id").setValue((Object)rows.getString("id"));
                this.setJobDate(kdRow, this.kdtPosition, rows.getDate("beginDate"), rows.getDate("endDate"));
            }
            ++i;
        }
    }

    public DefaultComboBoxModel getComboModelByColl(AbstractObjectCollection c) {
        DefaultComboBoxModel model = new DefaultComboBoxModel();
        if (c != null) {
            Iterator iter = c.iterator();
            while (iter.hasNext()) {
                model.addElement(iter.next());
            }
        }
        return model;
    }

    public EmployeeTypeCollection getEmployeeTypes(EmployeeTypeInfo typeInfo) throws Exception {
        EmployeeTypeCollection c = new EmployeeTypeCollection();
        MetaDataPK queryPK = new MetaDataPK("com.kingdee.eas.hr.base.app.EmployeeTypeQuery");
        IQueryExecutor queryExcu = QueryExecutorFactory.getRemoteInstance((IMetaDataPK)queryPK);
        FilterInfo filter = new FilterInfo();
        if (typeInfo != null) {
            filter.getFilterItems().add(new FilterItemInfo("inService", (Object)typeInfo.getInService().getValue()));
        } else {
            filter.getFilterItems().add(new FilterItemInfo("inService", (Object)1));
        }
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(filter);
        queryExcu.setObjectView(evi);
        IRowSet rows = queryExcu.executeQuery();
        EmployeeTypeInfo info = null;
        while (rows.next()) {
            info = new EmployeeTypeInfo();
            info.setId(BOSUuid.read((String)rows.getString("id")));
            info.setName(rows.getString("name"));
            c.add(info);
        }
        return c;
    }

    private void loadEmployeeType() throws Exception {
        if (this.employeeTypeInfo != null) {
            this.cboEmployeeType.setModel((ComboBoxModel)this.getComboModelByColl((AbstractObjectCollection)this.getEmployeeTypes(this.employeeTypeInfo)));
        } else {
            this.cboEmployeeType.setModel((ComboBoxModel)this.getComboModelByColl((AbstractObjectCollection)this.getEmployeeTypes(null)));
        }
    }

    private void loadJobLevel(String jobId) throws Exception {
    }

    private void cleanField() {
        this.txtDept.setText(null);
        this.txtJob.setText(null);
        this.txtServiceYear.setText(null);
        this.txtSuperior.setText(null);
        this.txtSuperPosition.setText(null);
        this.txtTryoutMonth.setNumberValue((Number)0);
        this.txtWorkTime.setNumberValue((Number)0);
        this.txtExtWorkTime.setNumberValue((Number)0);
        this.txtLenOfActualService.setNumberValue((Number)0);
        this.kdpEndDate.setValue(null);
        this.kdpFormalDate.setValue(null);
        this.kdpJoinDate.setValue(null);
    }

    private void setDateEditor() {
        ICellEditor cellEdit = EmployeeClientUtils.getStartDateCellEditor();
        String formatStr = EmployeeClientUtils.getDateFormatStr();
        this.kdtPosition.getColumn("beginDate").setEditor(cellEdit);
        this.kdtPosition.getColumn("beginDate").getStyleAttributes().setNumberFormat(formatStr);
        this.kdtPosition.getColumn("endDate").setEditor(cellEdit);
        this.kdtPosition.getColumn("endDate").getStyleAttributes().setNumberFormat(formatStr);
        this.kdtWorkExpCur.getColumn("beginDate").setEditor(cellEdit);
        this.kdtWorkExpCur.getColumn("beginDate").getStyleAttributes().setNumberFormat(formatStr);
        this.kdtWorkExpCur.getColumn("endDate").setEditor(cellEdit);
        this.kdtWorkExpCur.getColumn("endDate").getStyleAttributes().setNumberFormat(formatStr);
        this.tblEnter.getColumn("enterDate").setEditor(cellEdit);
        this.tblEnter.getColumn("enterDate").getStyleAttributes().setNumberFormat(formatStr);
        this.tblEnter.getColumn("joinGroupDate").setEditor(cellEdit);
        this.tblEnter.getColumn("joinGroupDate").getStyleAttributes().setNumberFormat(formatStr);
        this.tblEnter.getColumn("joinCompanyDate").setEditor(cellEdit);
        this.tblEnter.getColumn("joinCompanyDate").getStyleAttributes().setNumberFormat(formatStr);
        this.tblEnter.getColumn("leftDate").setEditor(cellEdit);
        this.tblEnter.getColumn("leftDate").getStyleAttributes().setNumberFormat(formatStr);
    }

    private void initJobGradeBizF7() throws Exception {
        IHRInit iHR = HRInitFactory.getRemoteInstance();
        int groupModel = iHR.getJobSystemScheme();
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        if (groupModel == 0) {
            filter.getFilterItems().add(new FilterItemInfo("CU.id", (Object)"00000000-0000-0000-0000-000000000000CCE7AED4", CompareType.EQUALS));
        } else {
            filter.getFilterItems().add(new FilterItemInfo("CU.id", (Object)SysContext.getSysContext().getCurrentCtrlUnit().getId().toString(), CompareType.EQUALS));
        }
        filter.getFilterItems().add(new FilterItemInfo("JobSystem.id", (Object)"00000000-0000-0000-0000-0000000000017D16BC74"));
        filter.setMaskString("(#0 and #1)");
        evi.setFilter(filter);
        JobGradePromptBox jobGradePromBox = new JobGradePromptBox((IUIObject)this);
        this.bizJobGrade.setEntityViewInfo(evi);
        this.bizJobGrade.setSelector((KDPromptSelector)jobGradePromBox);
    }

    private void beforeLoadInfo() throws Exception {
        this.initJobGradeBizF7();
        EmployeeClientUtils.initTableBtn((JButton)this.btnPMAddNew, (JButton)this.btnPMDelete);
        this.kdtWorkExpCur.checkParsed();
        this.kdtPosition.checkParsed();
        this.tblEnter.checkParsed();
        this.kDLabel1.setIcon(EASResource.getIcon((String)"imgLableword_btn"));
        this.lblTitle.setIcon(EASResource.getIcon((String)"imgLableword_btn"));
        this.txtDept.setHorizontalAlignment(4);
        EmployeeClientUtils.initTableBtn((JButton)this.btnWorkExpCurAddNew, (JButton)this.btnWorkExpCurDelete);
        EmployeeClientUtils.setColumnBackColor(this.kdtWorkExpCur, "beginDate");
        EmployeeClientUtils.setColumnBackColor(this.kdtWorkExpCur, "endDate");
        EmployeeClientUtils.setColumnBackColor(this.kdtWorkExpCur, "position");
        EmployeeClientUtils.setColumnBackColor(this.kdtPosition, "position");
        this.lblEnter.setIcon(EASResource.getIcon((String)"imgLableword_btn"));
        this.kdpEndDate.getDatePickerDownList().setNullValueEnabled(true);
        EmployeeClientUtils.initTableBtn((JButton)this.btnInsertEnter, (JButton)this.btnDeleteEnter);
        this.kdtPosition.getColumn("job.name").getStyleAttributes().setLocked(true);
        this.kdtWorkExpCur.getColumn("job").getStyleAttributes().setLocked(true);
        this.kdtPosition.getColumn("dept").getStyleAttributes().setLocked(true);
        this.kdtWorkExpCur.getColumn("dept").getStyleAttributes().setLocked(true);
        this.kdtWorkExpCur.getColumn("dept").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.LEFT);
        this.kdtWorkExpCur.getColumn("dept").getStyleAttributes().setVerticalAlign(Styles.VerticalAlignment.TOP);
        this.kdtPosition.getColumn("dept").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.LEFT);
        this.kdtPosition.getColumn("dept").getStyleAttributes().setVerticalAlign(Styles.VerticalAlignment.TOP);
        if (this.getOprtState().equals(OprtState.VIEW)) {
            EmployeeClientUtils.setKDTableViewState(this.kdtWorkExpCur);
            this.btnWorkExpCurAddNew.setEnabled(false);
            this.btnWorkExpCurDelete.setEnabled(false);
        }
        this.setTableCellEditor();
        this.f7Position.setSelector((KDPromptSelector)new PositionPromptBox2((IUIObject)this));
        KDBizPromptBox promptBox1 = new KDBizPromptBox();
        promptBox1.setSelector((KDPromptSelector)new PositionPromptBox2((IUIObject)this));
        this.kdtPosition.getColumn("position").setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)promptBox1));
        promptBox1.addPreChangeListener(new PreChangeListener(){

            public void preChange(PreChangeEvent e) {
                try {
                    EmployeePositionUI.this.initPositionAndLevel(e);
                }
                catch (Exception e1) {
                    ExceptionHandler.handle((Throwable)e1);
                }
            }
        });
        this.kdtPosition.addKDTEditListener((KDTEditListener)new KDTEditAdapter(){

            public void editStarting(KDTEditEvent e) {
                EmployeePositionUI.this.rowPosID = e.getRowIndex();
            }
        });
        this.kdtPosition.getColumn("jobLevel").setEditor((ICellEditor)new KDTDefaultCellEditor((JComboBox)new KDComboBox()));
        if (this.getOprtState().equals(OprtState.VIEW)) {
            EmployeeClientUtils.setKDTableViewState(this.kdtPosition);
            this.btnPMAddNew.setEnabled(false);
            this.btnPMDelete.setEnabled(false);
        }
        this.loadEmployeeType();
    }

    public void loadInfo() throws Exception {
        if (this.empId == null) {
            this.cleanField();
        } else {
            this.hierarchyId = this.getDefaultHierarchy();
            this.editdata = this.getPersonPositionInfo(this.empId);
            if (this.editdata == null) {
                this.cleanField();
            }
            this.posRows = this.getPosRows(this.hierarchyId, this.empId);
        }
    }

    public void firstLoad() throws Exception {
        this.loadFields();
    }

    void setEnrollInformation() throws Exception {
    }

    void loadEnRollData(String empId) throws Exception {
        PersonEnrollHistoryCollection enRollInfos = this.getEnRollCollection(empId);
        this.tblEnter.removeRows();
        int counts = enRollInfos.size();
        IRow curRow = null;
        for (int i = 0; i < counts; ++i) {
            curRow = this.tblEnter.addRow();
            curRow.getCell("enterDate").setValue((Object)enRollInfos.get(i).getEnterDate());
            curRow.getCell("joinGroupDate").setValue((Object)enRollInfos.get(i).getJoinGroupDate());
            curRow.getCell("joinCompanyDate").setValue((Object)enRollInfos.get(i).getJoinDate());
            curRow.getCell("leftDate").setValue((Object)enRollInfos.get(i).getLeftDate());
            curRow.getCell("id").setValue((Object)enRollInfos.get(i).getId());
        }
    }

    void isEnableEnRoll(boolean isVisible) {
        this.lblEnter.setVisible(isVisible);
        this.chkEnter.setEnabled(false);
        this.chkEnter.setVisible(isVisible);
        this.btnDeleteEnter.setVisible(isVisible);
        this.btnInsertEnter.setVisible(isVisible);
        this.tblEnter.setVisible(isVisible);
    }

    void moveEnRollPosition(boolean isVisible) {
        if (isVisible) {
            this.kDLabel1.setBounds(new Rectangle(10, 302, 200, 19));
            this.btnWorkExpCurDelete.setBounds(new Rectangle(604, 299, 25, 19));
            this.btnWorkExpCurAddNew.setBounds(new Rectangle(577, 299, 25, 19));
            this.kdtWorkExpCur.setBounds(new Rectangle(10, 300, 655, 120));
            this.lblTitle.setBounds(new Rectangle(10, 444, 100, 19));
            this.btnPMDelete.setBounds(new Rectangle(604, 444, 25, 19));
            this.btnPMAddNew.setBounds(new Rectangle(577, 444, 25, 19));
            this.kdtPosition.setBounds(new Rectangle(10, 454, 625, 120));
            this.lblEnter.setBounds(new Rectangle(10, 588, 107, 19));
            this.btnInsertEnter.setBounds(new Rectangle(587, 578, 22, 19));
            this.btnDeleteEnter.setBounds(new Rectangle(614, 578, 22, 19));
            this.tblEnter.setBounds(new Rectangle(10, 609, 634, 120));
        } else {
            this.kDLabel1.setBounds(new Rectangle(10, 280, 200, 19));
            this.btnWorkExpCurDelete.setBounds(new Rectangle(604, 277, 25, 19));
            this.btnWorkExpCurAddNew.setBounds(new Rectangle(577, 277, 25, 19));
            this.kdtWorkExpCur.setBounds(new Rectangle(10, 298, 625, 120));
            this.lblTitle.setBounds(new Rectangle(10, 422, 100, 19));
            this.btnPMDelete.setBounds(new Rectangle(604, 422, 25, 19));
            this.btnPMAddNew.setBounds(new Rectangle(577, 422, 25, 19));
            this.kdtPosition.setBounds(new Rectangle(10, 442, 625, 120));
        }
    }

    void initDate() {
        this.kdpJoinGroupDate.setValue((Object)new Date());
        this.kdpEnterDate.setValue((Object)new Date());
        this.kdpJoinDate.setValue((Object)new Date());
        this.kdpBeginDate.setValue((Object)new Date());
    }

    @Override
    public void secondLoad() throws Exception {
        this.firstLoad();
    }

    public void onLoad() throws Exception {
        this.empId = (String)this.getUIContext().get("ID");
        this.kdpEndDate.setValue(null);
        super.onLoad();
        this.employeeTypeInfo = (EmployeeTypeInfo)this.getUIContext().get("employeeType");
        this.txtTryoutMonth.setMaximumValue((Comparable)Integer.valueOf(100));
        this.txtWorkTime.setMinimumValue((Comparable)Integer.valueOf(0));
        this.txtWorkTime.setMaximumValue((Comparable)Integer.valueOf(99));
        this.txtExtWorkTime.setMinimumValue((Comparable)Integer.valueOf(0));
        this.txtExtWorkTime.setMaximumValue((Comparable)Integer.valueOf(99));
        this.txtLenOfActualService.setMinimumValue((Comparable)Integer.valueOf(0));
        this.txtLenOfActualService.setMaximumValue((Comparable)Integer.valueOf(99));
        this.beforeLoadInfo();
        this.kdtWorkExpCur.getStyleAttributes().setWrapText(true);
        this.kdtPosition.getStyleAttributes().setWrapText(true);
        this.loadFields();
        this.kdtWorkExpCur.addKDTEditListener((KDTEditListener)new KDTEditAdapter(){

            public void editStopped(KDTEditEvent e) {
                int rowID = e.getRowIndex();
                EmployeePositionUI.this.displayJobDate(rowID, EmployeePositionUI.this.kdtWorkExpCur);
            }
        });
        this.kdtPosition.addKDTEditListener((KDTEditListener)new KDTEditAdapter(){

            public void editStopped(KDTEditEvent e) {
                int rowID = e.getRowIndex();
                EmployeePositionUI.this.displayJobDate(rowID, EmployeePositionUI.this.kdtPosition);
            }
        });
        this.setControlEnabled();
        this.firstLoad = false;
        if (this.getOprtState().equals(OprtState.VIEW)) {
            this.setEnabled(false);
        }
    }

    private void setControlEnabled() {
        if (this.employeeTypeInfo != null) {
            if (this.employeeTypeInfo.getInService().getValue() != 1) {
                this.f7Position.setEnabled(false);
                this.kdpEndDate.setEnabled(false);
                this.kdpBeginDate.setEnabled(false);
                if (this.employeeTypeInfo.getInService().getValue() == 2) {
                    this.lblLeftDate.setVisible(true);
                    this.kdpLeftDate.setVisible(true);
                } else {
                    this.lblLeftDate.setVisible(false);
                    this.kdpLeftDate.setVisible(false);
                }
            } else if (!this.getOprtState().equals(OprtState.VIEW)) {
                this.kdpEnterDate.setEnabled(true);
                this.f7Position.setEnabled(true);
                this.kdpEndDate.setEnabled(true);
                this.kdpBeginDate.setEnabled(true);
            }
        } else {
            this.lblLeftDate.setVisible(false);
            this.kdpLeftDate.setVisible(false);
        }
    }

    private void displayJobDate(int rowID, KDTable tbl) {
        Date beginDate = (Date)tbl.getRow(rowID).getCell("beginDate").getValue();
        Date endDate = (Date)tbl.getRow(rowID).getCell("endDate").getValue();
        int months = this.setJobDataValue(beginDate, endDate);
        String strJob = (months - months % 12) / 12 + EASResource.getString((String)"com.kingdee.eas.hr.emp.EmployeeResource.YEAR") + months % 12 + EASResource.getString((String)"com.kingdee.eas.hr.emp.EmployeeResource.MONTH");
        tbl.getRow(rowID).getCell("jobDate").setValue((Object)strJob);
    }

    void findTreeNode(DefaultKingdeeTreeNode parentNode, String id) {
        if (parentNode == null) {
            return;
        }
        if (parentNode.getUserObject() != null && ((AdminOrgUnitInfo)parentNode.getUserObject()).getId().toString().equals(id)) {
            this.findTreeNode = parentNode;
            return;
        }
        for (int i = 0; i < parentNode.getChildCount(); ++i) {
            DefaultKingdeeTreeNode node = (DefaultKingdeeTreeNode)parentNode.getChildAt(i);
            AdminOrgUnitInfo adminInfo = (AdminOrgUnitInfo)node.getUserObject();
            if (adminInfo.getId().toString().equals(id.trim())) {
                this.findTreeNode = node;
                return;
            }
            this.findTreeNode(node, id);
        }
    }

    private int setJobDataValue(Date beginDate, Date endDate) {
        try {
            int months = 0;
            if (beginDate != null && endDate != null && DateTimeUtils.dayBefore((Date)beginDate, (Date)endDate)) {
                months = Integer.parseInt(Long.toString(DateTimeUtils.dateDiff((String)"m", (Date)beginDate, (Date)endDate)));
                if (DateTimeUtils.getDay((Date)beginDate) == 1 && DateTimeUtils.getDay((Date)endDate) == DateTimeUtils.daysOfMonth((int)DateTimeUtils.getYear((Date)endDate), (int)DateTimeUtils.getMonth((Date)endDate)) || DateTimeUtils.getDay((Date)endDate) + 1 == DateTimeUtils.getDay((Date)beginDate)) {
                    ++months;
                }
            }
            return months;
        }
        catch (Exception e1) {
            return 0;
        }
    }

    protected void inOnload() throws Exception {
    }

    @Override
    public void loadFields() {
        this.levelLoaded = false;
        try {
            if (this.getUIContext().get("ID") != null) {
                this.empId = this.getUIContext().get("ID").toString();
            }
            this.loadInfo();
            if (this.editdata != null) {
                this.txtTryoutMonth.setNumberValue((Number)this.editdata.getTryoutMonth());
                this.txtWorkTime.setNumberValue((Number)new Float(this.editdata.getWorkTime()));
                this.txtExtWorkTime.setValue((Object)this.editdata.getExtWorkTime());
                this.txtLenOfActualService.setValue((Object)this.editdata.getLenOfActualService());
                this.kdpFormalDate.setValue((Object)this.editdata.getFormalDate());
                this.kdpJoinDate.setValue((Object)this.editdata.getJoinDate());
                this.kdpJoinGroupDate.setValue((Object)this.editdata.getJoinGroupDate());
            } else {
                this.initDate();
            }
            this.setEmployeeTypeToCombox();
            this.loadInfoByIRowSet(this.posRows);
            this.refreshWorkExpCur();
            this.setEnrollInformation();
            this.setDateStr();
            if (this.editdata != null) {
                this.bizJobGrade.setData((Object)this.editdata.getJobGrade());
            } else {
                this.bizJobGrade.setData(null);
            }
        }
        catch (Exception e) {
            this.handUIException(e);
        }
        this.levelLoaded = true;
    }

    private void setDateStr() {
    }

    private void setEmployeeTypeToCombox() {
    }

    private void checkInput() throws Exception {
        EmployeeTypeInfo typeInfo = (EmployeeTypeInfo)this.cboEmployeeType.getSelectedItem();
        if (typeInfo == null) {
            throw new EmployeeException(EmployeeException.NO_EMPLOYEE_TYPE);
        }
        if (this.employeeTypeInfo == null && this.f7Position.getValue() == null) {
            throw new EmployeeException(EmployeeException.NO_SELECT_POSITION);
        }
        String strPosFullTime = EASResource.getString((String)"com.kingdee.eas.hr.emp.EmployeeResource.POSITION_FULLTIME");
        String strPosPartime = EASResource.getString((String)"com.kingdee.eas.hr.emp.EmployeeResource.POSITION_PARTIME");
        if (this.kdpEnterDate.getValue() == null) {
            throw new EmployeeException(EmployeeException.MUST_SELECT_ENTERDATE);
        }
        if (this.kdpJoinGroupDate.getValue() == null) {
            throw new EmployeeException(EmployeeException.MUST_TYPE_JOIN_GROUP_DATE);
        }
        if (this.kdpJoinDate.getValue() == null) {
            throw new EmployeeException(EmployeeException.MUST_TYPE_JOIN_COMPANY_DATE);
        }
        if (this.kdpBeginDate.getValue() == null) {
            throw new EmployeeException(EmployeeException.MUST_TYPE_POSITION_DATE);
        }
        if (this.kdpFormalDate.getValue() != null && this.kdpEnterDate.getValue() != null && DateTimeUtils.dayBefore((Date)((Date)this.kdpFormalDate.getValue()), (Date)((Date)this.kdpEnterDate.getValue()))) {
            throw new EmployeeException(EmployeeException.FORMALDATE_NOT_DY_ENTERDATE);
        }
        if (this.kdpEndDate.getValue() != null && this.kdpEnterDate.getValue() != null && DateTimeUtils.dayBefore((Date)((Date)this.kdpEndDate.getValue()), (Date)((Date)this.kdpEnterDate.getValue()))) {
            throw new EmployeeException(EmployeeException.ENDDATE_NOT_DY_ENTERDATE);
        }
        if (this.kdpJoinGroupDate.getValue() != null && this.kdpEnterDate.getValue() != null && DateTimeUtils.dayBefore((Date)((Date)this.kdpJoinGroupDate.getValue()), (Date)((Date)this.kdpEnterDate.getValue()))) {
            throw new EmployeeException(EmployeeException.ENTERDATE_NOT_DY_JOINGROUPDATE);
        }
        if (this.kdpJoinGroupDate.getValue() != null && this.kdpJoinDate.getValue() != null && DateTimeUtils.dayBefore((Date)((Date)this.kdpJoinDate.getValue()), (Date)((Date)this.kdpJoinGroupDate.getValue()))) {
            throw new EmployeeException(EmployeeException.JOINDATE_NOT_DY_JOINGROUPDATE);
        }
        if (this.kdpBeginDate.getValue() != null && this.kdpEndDate.getValue() != null && DateTimeUtils.dayAfter((Date)((Date)this.kdpBeginDate.getValue()), (Date)((Date)this.kdpEndDate.getValue()))) {
            throw new EmployeeException(EmployeeException.ENDDATE_NOT_DY_STARTDATE);
        }
        if (this.kdpBeginDate.getValue() != null && this.kdpJoinDate.getValue() != null && DateTimeUtils.dayBefore((Date)((Date)this.kdpBeginDate.getValue()), (Date)((Date)this.kdpJoinDate.getValue()))) {
            throw new EmployeeException(EmployeeException.STARTDATE_NOT_DY_JOINDATE);
        }
        if (this.kdpBeginDate.getValue() != null && this.kdpJoinGroupDate.getValue() != null && DateTimeUtils.dayBefore((Date)((Date)this.kdpBeginDate.getValue()), (Date)((Date)this.kdpJoinGroupDate.getValue()))) {
            throw new EmployeeException(EmployeeException.STARTDATE_NOT_DY_JOINGROUPDATE);
        }
        EmployeeClientUtils.checkTableCellDup(this.kdtPosition, "position", strPosPartime);
        EmployeeClientUtils.checkTableCellDate(this.kdtPosition, "beginDate", "endDate");
        EmployeeClientUtils.checkTableCellDate(this.kdtWorkExpCur, "beginDate", "endDate");
        EmployeeClientUtils.checkTableCellIsNull(this.kdtWorkExpCur, "position");
        EmployeeClientUtils.checkTableCellIsNull(this.kdtPosition, "position");
        for (int i = 0; i < this.kdtWorkExpCur.getRowCount(); ++i) {
            Date startDate = (Date)this.kdtWorkExpCur.getRow(i).getCell("beginDate").getValue();
            Date endDate = (Date)this.kdtWorkExpCur.getRow(i).getCell("endDate").getValue();
            if (startDate == null || endDate == null) {
                throw new EmployeeException(EmployeeException.ENDDATE_AND_BEGINDATE_NOT_NULL);
            }
            if (!DateTimeUtils.dayAfter((Date)startDate, (Date)endDate)) continue;
            throw new EmployeeException(EmployeeException.EMP_POSI_ENDDATE_STARTDATE_ERROR);
        }
        EmployeeClientUtils.checkTableCellDup(this.kdtPosition, "position", this.f7Position.getValue(), strPosPartime, strPosFullTime);
    }

    private void storeEditData() {
        this.pInfo = EmployeeClientUtils.getPersonInfo(this.empId);
        if (this.editdata == null) {
            this.editdata = new PersonPositionInfo();
        }
        this.editdata.setJoinDate(DateTimeUtils.truncateDate((Date)((Date)this.kdpJoinDate.getValue(Date.class))));
        this.editdata.setJoinGroupDate(DateTimeUtils.truncateDate((Date)((Date)this.kdpJoinGroupDate.getValue(Date.class))));
        if (this.txtTryoutMonth.getNumberValue() != null) {
            this.editdata.setTryoutMonth(this.txtTryoutMonth.getNumberValue().intValue());
        }
        this.editdata.setWorkTime(this.txtWorkTime.getNumberValue().intValue());
        this.editdata.setExtWorkTime(this.txtExtWorkTime.getBigDecimalValue());
        this.editdata.setLenOfActualService(this.txtLenOfActualService.getBigDecimalValue());
        this.editdata.setFormalDate(DateTimeUtils.truncateDate((Date)((Date)this.kdpFormalDate.getValue(Date.class))));
        this.editdata.setPerson(this.pInfo);
        this.editdata.put("empTypeInfo", (EmployeeTypeInfo)this.cboEmployeeType.getSelectedItem());
        this.editdata.put("enterDate", (Date)this.kdpEnterDate.getValue());
        this.editdata.setJobGrade((JobGradeInfo)this.bizJobGrade.getData());
    }

    private void storeOtherData() {
    }

    @Override
    public void storeFields() {
        this.storeEditData();
        this.storeOtherData();
    }

    @Override
    public void submit() throws Exception {
        this.checkInput();
        this.storeFields();
        if (this.editdata.getId() == null) {
            IObjectPK pk = PersonPositionFactory.getRemoteInstance().addnew(this.editdata);
            this.editdata.setId(BOSUuid.read((String)pk.toString()));
        } else {
            PersonPositionFactory.getRemoteInstance().update((IObjectPK)new ObjectUuidPK(this.editdata.getId().toString()), this.editdata);
        }
        IObjectPK[] delArray = new IObjectPK[this.delList.size()];
        for (int i = 0; i < this.delList.size(); ++i) {
            delArray[i] = new ObjectUuidPK(BOSUuid.read((String)this.delList.get(i).toString()));
        }
        IObjectPK[] curPKArray = new IObjectPK[this.delListCur.size()];
        for (int j = 0; j < this.delListCur.size(); ++j) {
            curPKArray[j] = new ObjectUuidPK(BOSUuid.read((String)this.delListCur.get(j).toString()));
        }
        IPersonWorkExpCur ipwxc = PersonWorkExpCurFactory.getRemoteInstance();
        ipwxc.saveAll(EmployeeClientUtils.getWorkExpCurCollectionByKDTable(this.kdtWorkExpCur, EmployeeClientUtils.getPersonInfo(this.empId)), curPKArray);
        IObjectPK[] pkArray = new IObjectPK[this.delListEnter.size()];
        for (int j = 0; j < this.delListEnter.size(); ++j) {
            pkArray[j] = new ObjectUuidPK(BOSUuid.read((String)this.delListEnter.get(j).toString()));
        }
        IPersonEnrollHistory iEnroll = PersonEnrollHistoryFactory.getRemoteInstance();
        iEnroll.saveALl(EmployeeClientUtils.getPersonEnrollHistoryCollectionByKDTable(this.tblEnter, EmployeeClientUtils.getPersonInfo(this.empId)), pkArray);
        ListEditUI listEditUI = (ListEditUI)this.getUIContext().get("ListEditUI");
        listEditUI.setStatusBarMessage();
        this.loadFields();
    }

    @Override
    public void actionPMAddNew_actionPerformed(ActionEvent e) throws Exception {
        EmployeeClientUtils.addNewKDTableRow(this.kdtPosition);
    }

    @Override
    public void actionPMDelete_actionPerformed(ActionEvent e) throws Exception {
        EmployeeClientUtils.deleteKDTableRow(this.kdtPosition, this.delList);
    }

    @Override
    protected void f7Position_dataChanged(DataChangeEvent e) throws Exception {
        PositionInfo info;
        if (e.getNewValue() != null && (info = (PositionInfo)e.getNewValue()).getJob() != null && info.getJob().getId() != null) {
            this.loadJobLevel(info.getJob().getId().toString());
        }
    }

    String getAdminIdByPos(String id) throws BOSException {
        IPosition iPos = PositionFactory.getRemoteInstance();
        PositionCollection infos = iPos.getPositionCollection("Select adminOrgUnit.id Where id='" + id + "'");
        if (infos.size() > 0) {
            return infos.get(0).getAdminOrgUnit().getId().toString();
        }
        return null;
    }

    @Override
    public void setAddNewState() throws Exception {
        this.editdata = null;
        EmployeeClientUtils.setAddNewState((CoreUI)this);
    }

    @Override
    protected void kdpEndDate_dataChanged(DataChangeEvent e) throws Exception {
        super.kdpEndDate_dataChanged(e);
        this.txtServiceYear.setText(this.computeDate((Date)this.kdpBeginDate.getValue(), (Date)this.kdpEndDate.getValue()));
    }

    @Override
    protected void kdpBeginDate_dataChanged(DataChangeEvent e) throws Exception {
        super.kdpBeginDate_dataChanged(e);
        if (this.kdpEndDate.getValue() == null) {
            this.txtServiceYear.setText(this.computeDate((Date)this.kdpBeginDate.getValue(), new Date()));
        } else {
            this.txtServiceYear.setText(this.computeDate((Date)this.kdpJoinDate.getValue(), (Date)this.kdpEndDate.getValue()));
        }
    }

    @Override
    protected void kdpJoinDate_dataChanged(DataChangeEvent e) throws Exception {
        super.kdpJoinDate_dataChanged(e);
        this.txtJoinCompanyYears.setText(this.computeDate((Date)this.kdpJoinDate.getValue(), new Date()));
    }

    @Override
    protected void kdpJoinGroupDate_dataChanged(DataChangeEvent e) throws Exception {
        super.kdpJoinGroupDate_dataChanged(e);
        this.txtJoinGroupYears.setText(this.computeDate((Date)this.kdpJoinGroupDate.getValue(), new Date()));
    }

    private String computeDate(Date oldDate, Date nowDate) {
        if (oldDate == null || nowDate == null || !DateTimeUtils.dayBefore((Date)oldDate, (Date)nowDate)) {
            return 0 + EASResource.getString((String)"com.kingdee.eas.hr.emp.EmployeeResource.YEAR") + 0 + EASResource.getString((String)"com.kingdee.eas.hr.emp.EmployeeResource.MONTH");
        }
        Calendar dateCal = Calendar.getInstance();
        dateCal.setTime(oldDate);
        Calendar nowCal = Calendar.getInstance();
        nowCal.setTime(nowDate);
        nowCal.add(5, 1);
        int dateYear = dateCal.get(1);
        int nowYear = nowCal.get(1);
        int dateMonth = dateCal.get(2) + 1;
        int nowMonth = nowCal.get(2) + 1;
        int dateDay = dateCal.get(5);
        int nowDay = nowCal.get(5);
        int tempYear = nowYear - dateYear;
        int tempMonth = nowMonth - dateMonth;
        int tempDay = nowDay - dateDay;
        if (tempDay < 0) {
            --tempMonth;
        }
        int YY = (tempYear * 12 + tempMonth) / 12;
        int MM = (tempYear * 12 + tempMonth) % 12;
        return YY + EASResource.getString((String)"com.kingdee.eas.hr.emp.EmployeeResource.YEAR") + MM + EASResource.getString((String)"com.kingdee.eas.hr.emp.EmployeeResource.MONTH");
    }

    @Override
    protected void txtTryoutMonth_dataChanged(DataChangeEvent e) throws Exception {
        super.txtTryoutMonth_dataChanged(e);
        KDFormattedTextField txt = (KDFormattedTextField)e.getSource();
        Number o = txt.getNumberValue();
        if (o != null && o.toString().trim().length() > 0 && this.kdpEnterDate.getValue() != null) {
            Date newDate = DateTimeUtils.addMonth((Date)((Date)this.kdpEnterDate.getValue()), (int)Integer.parseInt(o.toString()));
            this.kdpFormalDate.setValue((Object)newDate);
        }
    }

    @Override
    public void setEmpID(String empId) throws Exception {
        this.empId = empId;
    }

    void setPositionEditor() {
        KDBizPromptBox promptBox = new KDBizPromptBox();
        promptBox.setSelector((KDPromptSelector)new PositionPromptBox2((IUIObject)this));
        this.kdtWorkExpCur.getColumn("position").setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)promptBox));
        promptBox.addPreChangeListener(new PreChangeListener(){

            public void preChange(PreChangeEvent e) {
                try {
                    EmployeePositionUI.this.initJobAndJobLevel(e);
                }
                catch (Exception e1) {
                    ExceptionHandler.handle((Throwable)e1);
                }
            }
        });
        this.kdtWorkExpCur.addKDTEditListener((KDTEditListener)new KDTEditAdapter(){

            public void editStarting(KDTEditEvent e) {
                EmployeePositionUI.this.rowID = e.getRowIndex();
            }
        });
    }

    private void initPositionAndLevel(PreChangeEvent e) throws BOSException, EASBizException, Exception {
        IRow row = this.kdtPosition.getRow(this.rowPosID);
        if (e.getData() != null) {
            PositionInfo posInfo = this.getPositionInfo((PositionInfo)e.getData());
            if (posInfo != null) {
                row.getCell("job.name").setValue((Object)posInfo.getJob());
                if (posInfo.getAdminOrgUnit() != null) {
                    row.getCell("dept").setValue((Object)posInfo.getAdminOrgUnit().getDisplayName());
                } else {
                    row.getCell("dept").setValue(null);
                }
                KDComboBox combo = new KDComboBox();
                this.kdtPosition.getRow(this.rowPosID).getCell("jobLevel").setEditor((ICellEditor)new KDTDefaultCellEditor((JComboBox)combo));
                if (posInfo.getJob() != null && posInfo.getJob().getId() != null) {
                    combo.setModel((ComboBoxModel)this.getComboModelByColl((AbstractObjectCollection)this.getJobLvlsByJobId(posInfo.getJob().getId().toString())));
                }
                row.getCell("beginDate").setValue(null);
                row.getCell("endDate").setValue(null);
            }
        } else {
            row.getCell("job.name").setValue(null);
            row.getCell("dept").setValue(null);
            row.getCell("beginDate").setValue(null);
            row.getCell("endDate").setValue(null);
            row.getCell("jobLevel").setValue(null);
        }
    }

    private PositionInfo getPositionInfo(PositionInfo pInfo) throws BOSException, EASBizException {
        IPosition ipos = PositionFactory.getRemoteInstance();
        String strQL = "Select * ,job.* ,adminOrgUnit.* Where id='" + pInfo.getId().toString() + "'";
        PositionInfo posInfo = (PositionInfo)ipos.getValue(strQL);
        return posInfo;
    }

    void initJobAndJobLevel(PreChangeEvent e) throws Exception {
        if (e.getData() != null) {
            PositionInfo posInfo = this.getPositionInfo((PositionInfo)e.getData());
            this.kdtWorkExpCur.getRow(this.rowID).getCell("job").setValue((Object)posInfo.getJob());
            if (posInfo.getAdminOrgUnit() != null) {
                this.kdtWorkExpCur.getRow(this.rowID).getCell("dept").setValue((Object)posInfo.getAdminOrgUnit().getDisplayName());
                this.kdtWorkExpCur.getRow(this.rowID).getCell("colOrgID").setValue((Object)posInfo.getAdminOrgUnit());
            } else {
                this.kdtWorkExpCur.getRow(this.rowID).getCell("dept").setValue(null);
            }
            KDComboBox combo = new KDComboBox();
            this.kdtWorkExpCur.getRow(this.rowID).getCell("jobLevel").setEditor((ICellEditor)new KDTDefaultCellEditor((JComboBox)combo));
            if (posInfo.getJob() != null && posInfo.getJob().getId() != null) {
                combo.setModel((ComboBoxModel)this.getComboModelByColl((AbstractObjectCollection)this.getJobLvlsByJobId(posInfo.getJob().getId().toString())));
            }
        } else {
            this.kdtWorkExpCur.getRow(this.rowID).getCell("job").setValue(null);
            this.kdtWorkExpCur.getRow(this.rowID).getCell("dept").setValue(null);
            this.kdtWorkExpCur.getRow(this.rowID).getCell("colOrgID").setValue(null);
            this.kdtWorkExpCur.getRow(this.rowID).getCell("jobLevel").setValue(null);
            this.kdtWorkExpCur.getRow(this.rowID).getCell("beginDate").setValue(null);
            this.kdtWorkExpCur.getRow(this.rowID).getCell("endDate").setValue(null);
        }
    }

    void setJobEditor() {
        this.kdtWorkExpCur.getColumn("job").setEditor(EmployeeClientUtils.getF7CellEditor((KDPromptSelector)new JobPromptBox((IUIObject)this)));
    }

    void setJobLevel() {
        this.kdtWorkExpCur.getColumn("jobLevel").setEditor((ICellEditor)new KDTDefaultCellEditor((JComboBox)new KDComboBox()));
    }

    private void setTableCellEditor() throws BOSException {
        this.setDateEditor();
        this.setJobLevel();
        this.setPositionEditor();
    }

    private void loadWorkExpCur() throws Exception {
        PersonWorkExpCurCollection c = this.getWXCColl(this.empId);
        PersonWorkExpCurInfo info = null;
        IRow curRow = null;
        for (int i = 0; i < c.size(); ++i) {
            curRow = this.kdtWorkExpCur.addRow();
            info = c.get(i);
            if (info.getId() != null) {
                curRow.getCell("id").setValue((Object)info.getId());
            }
            curRow.getCell("beginDate").setValue((Object)info.getBeginDate());
            curRow.getCell("endDate").setValue((Object)info.getEndDate());
            if (info.getPosition() != null) {
                curRow.getCell("dept").setValue((Object)info.getPosition().getAdminOrgUnit().getDisplayName());
            }
            curRow.getCell("position").setValue((Object)info.getPosition());
            curRow.getCell("job").setValue((Object)info.getJob());
            KDComboBox combo = new KDComboBox();
            curRow.getCell("jobLevel").setEditor((ICellEditor)new KDTDefaultCellEditor((JComboBox)combo));
            if (info.getJob() != null) {
                combo.setModel((ComboBoxModel)this.getComboModelByColl((AbstractObjectCollection)this.getJobLvlsByJobId(info.getJob().getId().toString())));
            }
            this.setJobDate(curRow, this.kdtWorkExpCur, info.getBeginDate(), info.getEndDate());
        }
    }

    private void setJobDate(IRow curRow, KDTable tbl, Date beginDate, Date endDate) {
        String strJob = this.computeDate(beginDate, endDate);
        if (curRow != null && curRow.getCell("jobDate") != null) {
            curRow.getCell("jobDate").setValue((Object)strJob);
        }
    }

    private void refreshWorkExpCur() throws Exception {
        this.kdtWorkExpCur.removeRows();
        this.loadWorkExpCur();
    }

    private PersonWorkExpCurCollection getWXCColl(String empId) throws BOSException {
        String oql = "select *,position.name,position.adminOrgUnit.displayName,job.name,jobLevel.name where person.id = '" + empId + "'";
        IPersonWorkExpCur ipwxc = PersonWorkExpCurFactory.getRemoteInstance();
        return ipwxc.getPersonWorkExpCurCollection(oql);
    }

    @Override
    protected void btnWorkExpCurAddNew_actionPerformed(ActionEvent e) throws Exception {
        EmployeeClientUtils.addNewKDTableRow(this.kdtWorkExpCur);
    }

    @Override
    protected void btnWorkExpCurDelete_actionPerformed(ActionEvent e) throws Exception {
        EmployeeClientUtils.deleteKDTableRow(this.kdtWorkExpCur, this.delListCur);
    }

    @Override
    protected void kdpEnterDate_dataChanged(DataChangeEvent e) throws Exception {
        if (this.firstLoad) {
            return;
        }
        if (this.kdpEnterDate.getValue() != null) {
            Date dateFora = (Date)this.kdpEnterDate.getValue();
            if (this.txtTryoutMonth.getNumberValue() != null) {
                GregorianCalendar cal = new GregorianCalendar(DateTimeUtils.getYear((Date)dateFora), DateTimeUtils.getMonth((Date)dateFora) + this.txtTryoutMonth.getNumberValue().intValue() - 1, DateTimeUtils.getDay((Date)dateFora));
                this.kdpFormalDate.setValue((Object)cal.getTime());
            }
        }
    }

    @Override
    protected void btnDeleteEnter_actionPerformed(ActionEvent e) throws Exception {
        EmployeeClientUtils.deleteKDTableRow(this.tblEnter, this.delListEnter);
    }

    @Override
    protected void btnInsertEnter_actionPerformed(ActionEvent e) throws Exception {
        EmployeeClientUtils.addNewKDTableRow(this.tblEnter);
    }

    @Override
    public void setEnabled(boolean isArchives) {
        this.btnDeleteEnter.setEnabled(isArchives);
        this.btnInsertEnter.setEnabled(isArchives);
        this.tblEnter.setEditable(isArchives);
        this.kdtPosition.setEditable(isArchives);
        this.f7Position.setEnabled(isArchives);
        this.kdtWorkExpCur.setEditable(isArchives);
        this.btnPMAddNew.setEnabled(isArchives);
        this.btnPMDelete.setEnabled(isArchives);
        this.btnWorkExpCurAddNew.setEnabled(isArchives);
        this.btnWorkExpCurDelete.setEnabled(isArchives);
        this.cboEmployeeType.setAccessAuthority(1);
        this.kdpBeginDate.setEnabled(isArchives);
        this.kdpEndDate.setEnabled(isArchives);
        this.kdpEnterDate.setAccessAuthority(1);
        this.kdpJoinDate.setEnabled(isArchives);
        this.kdpJoinGroupDate.setEnabled(isArchives);
        this.txtServiceYear.setEnabled(isArchives);
        this.txtDept.setEnabled(isArchives);
        this.txtTryoutMonth.setEnabled(isArchives);
        this.txtWorkTime.setEnabled(isArchives);
        this.txtExtWorkTime.setEnabled(isArchives);
        this.txtLenOfActualService.setEnabled(isArchives);
        this.kdpFormalDate.setEnabled(isArchives);
        this.f7Position.setEnabled(isArchives);
        this.bizJobGrade.setEnabled(isArchives);
    }

    @Override
    protected void comboJobLevel_itemStateChanged(ItemEvent e) throws Exception {
    }

    protected IObjectValue createNewData() {
        return null;
    }

    protected ICoreBase getBizInterface() throws Exception {
        return null;
    }

    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        this.submit();
    }
}

