/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.emp.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.commonquery.client.CustomerParams;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.client.context.OrgChangeVO;
import com.kingdee.eas.hr.base.EmployeeFenLeiFactory;
import com.kingdee.eas.hr.base.EmployeeFenLeiInfo;
import com.kingdee.eas.hr.base.EmployeeTypeCollection;
import com.kingdee.eas.hr.base.EmployeeTypeFactory;
import com.kingdee.eas.hr.base.EmployeeTypeInfo;
import com.kingdee.eas.hr.base.client.EmployeeFenLeiPromptBox;
import com.kingdee.eas.hr.base.client.IHRF7CommonRegister;
import com.kingdee.eas.hr.base.client.IHRPanelListener;
import com.kingdee.eas.hr.emp.client.AbstractEmployeeRosterFilterTypeUI;
import com.kingdee.eas.util.client.EASResource;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.HashSet;
import org.apache.log4j.Logger;

public class EmployeeRosterFilterTypeUI
extends AbstractEmployeeRosterFilterTypeUI
implements IHRPanelListener {
    private static final Logger logger = CoreUIObject.getLogger(EmployeeRosterFilterTypeUI.class);
    private final String EMPRESOURCE_CLASS = "com.kingdee.eas.hr.emp.client.EmpResource.";
    private final String EMPLOYEE_TYPE = "employeeType";
    private final String LSTFILTER = "lstFilter";

    public EmployeeRosterFilterTypeUI() throws Exception {
        this.initControl();
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public void afterMainOrgChanged(OrgChangeVO chgVo) {
    }

    public void registerF7(IHRF7CommonRegister register) {
    }

    private void showEmpTypeListNoSelect() {
        EmployeeFenLeiInfo employeeFenLeiInfo = (EmployeeFenLeiInfo)this.prmtEmployeeFenlei.getValue();
        if (employeeFenLeiInfo != null) {
            try {
                this.showEmpoyeeTypeToList(employeeFenLeiInfo);
            }
            catch (Exception e) {
                this.handUIException(e);
            }
        }
    }

    private void initControl() throws Exception {
        this.initEmpTypeCtrl();
        this.btnAddFilterAll.setIcon(EASResource.getIcon((String)"imgTbtn_moveall_right"));
        this.btnAddFilter.setIcon(EASResource.getIcon((String)"imgTbtn_move_right"));
        this.btnRemoveFilter.setIcon(EASResource.getIcon((String)"imgTbtn_move_left"));
        this.btnRemoveFilterAll.setIcon(EASResource.getIcon((String)"imgTbtn_moveall_left"));
        this.prmtEmployeeFenlei.setSelector((KDPromptSelector)new EmployeeFenLeiPromptBox());
        this.prmtEmployeeFenlei.setQueryInfo("com.kingdee.eas.hr.base.app.EmployeeFenLeiLisQuery");
        this.prmtEmployeeFenlei.setEditFormat("$number$");
        this.prmtEmployeeFenlei.setCommitFormat("$number$");
        this.prmtEmployeeFenlei.setDisplayFormat("$name$");
        this.prmtEmployeeFenlei.setEditable(true);
        this.prmtEmployeeFenlei.addDataChangeListener(new DataChangeListener(){

            public void dataChanged(DataChangeEvent eventObj) {
                if (eventObj.getNewValue() != null) {
                    EmployeeFenLeiInfo newData = (EmployeeFenLeiInfo)eventObj.getNewValue();
                    EmployeeFenLeiInfo oldData = (EmployeeFenLeiInfo)eventObj.getOldValue();
                    if (oldData == null || !newData.getId().equals((Object)oldData.getId())) {
                        EmployeeRosterFilterTypeUI.this.showEmpTypeListNoSelect();
                    }
                } else {
                    EmployeeRosterFilterTypeUI.this.lstFilter.removeAllElements();
                    EmployeeRosterFilterTypeUI.this.lstEmpType.removeAllElements();
                }
            }
        });
    }

    public void clear() {
        this.lstFilter.removeAllElements();
        this.lstEmpType.removeAllElements();
        this.prmtEmployeeFenlei.setValue(null);
    }

    private void initEmpTypeCtrl() {
        this.lstEmpType.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                try {
                    EmployeeRosterFilterTypeUI.this.lstEmpType_mouseClicked(e);
                }
                catch (Exception exc) {
                    EmployeeRosterFilterTypeUI.this.handUIException(exc);
                }
            }
        });
        this.lstFilter.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                try {
                    EmployeeRosterFilterTypeUI.this.lstFilter_mouseClicked(e);
                }
                catch (Exception exc) {
                    EmployeeRosterFilterTypeUI.this.handUIException(exc);
                }
            }
        });
    }

    public boolean verify() {
        boolean bo = true;
        return bo;
    }

    private void showEmpoyeeTypeToList(EmployeeFenLeiInfo employeeFenLeiInfo) throws Exception {
        if (employeeFenLeiInfo == null) {
            return;
        }
        FilterInfo fiEmpType = new FilterInfo();
        fiEmpType.getFilterItems().add(new FilterItemInfo("employeeFenLei.longNumber", (Object)employeeFenLeiInfo.getLongNumber()));
        fiEmpType.getFilterItems().add(new FilterItemInfo("employeeFenLei.longNumber", (Object)(employeeFenLeiInfo.getLongNumber() + "!%"), CompareType.LIKE));
        fiEmpType.getFilterItems().add(new FilterItemInfo("isEnabled", (Object)true));
        fiEmpType.setMaskString("(#0 or #1) and #2");
        EntityViewInfo eviQueryEmpType = new EntityViewInfo();
        eviQueryEmpType.setFilter(fiEmpType);
        SelectorItemCollection selector = eviQueryEmpType.getSelector();
        selector.add(new SelectorItemInfo("id"));
        selector.add(new SelectorItemInfo("name"));
        selector.add(new SelectorItemInfo("number"));
        selector.add(new SelectorItemInfo("employeeFenLei.id"));
        selector.add(new SelectorItemInfo("employeeFenLei.name"));
        EmployeeTypeCollection EmployeeTypeColl = EmployeeTypeFactory.getRemoteInstance().getEmployeeTypeCollection(eviQueryEmpType);
        this.lstEmpType.removeAllElements();
        EmployeeTypeInfo item = null;
        int j = EmployeeTypeColl.size();
        for (int i = 0; i < j; ++i) {
            item = EmployeeTypeColl.get(i);
            if (this.isExitFilterQueue(item)) continue;
            this.lstEmpType.addElement((Object)item);
        }
    }

    private boolean isExitFilterQueue(EmployeeTypeInfo item) {
        boolean ret = false;
        if (item == null) {
            return false;
        }
        EmployeeTypeInfo empFilterItem = null;
        int j = this.lstFilter.getElementCount();
        for (int i = 0; i < j; ++i) {
            empFilterItem = (EmployeeTypeInfo)this.lstFilter.getElement(i);
            if (empFilterItem == null || !empFilterItem.getId().toString().equals(item.getId().toString())) continue;
            return true;
        }
        return ret;
    }

    private void leftToRight() {
        EmployeeTypeInfo item = (EmployeeTypeInfo)this.lstEmpType.getSelectedValue();
        if (item != null) {
            this.lstFilter.addElement((Object)item);
            this.lstEmpType.removeElement((Object)item);
            this.lstFilter.setSelectedValue((Object)item, true);
        }
    }

    @Override
    public void addFilterAction_actionPerformed(ActionEvent e) throws Exception {
        this.leftToRight();
    }

    protected void lstEmpType_mouseClicked(MouseEvent e) throws Exception {
        if (e.getClickCount() == 2) {
            this.leftToRight();
        }
    }

    private void rightToLeft() {
        EmployeeTypeInfo item = (EmployeeTypeInfo)this.lstFilter.getSelectedValue();
        if (item != null) {
            this.lstFilter.removeElement((Object)item);
            this.showEmpTypeListNoSelect();
            this.lstEmpType.setSelectedValue((Object)item, true);
        }
    }

    @Override
    public void removeFilterAction_actionPerformed(ActionEvent e) throws Exception {
        this.rightToLeft();
    }

    protected void lstFilter_mouseClicked(MouseEvent e) throws Exception {
        if (e.getClickCount() == 2) {
            this.rightToLeft();
        }
    }

    @Override
    public void addFilterAllAction_actionPerformed(ActionEvent e) throws Exception {
        int j = this.lstEmpType.getElementCount();
        for (int i = 0; i < j; ++i) {
            EmployeeTypeInfo item = (EmployeeTypeInfo)this.lstEmpType.getElement(i);
            if (item == null) continue;
            this.lstFilter.addElement((Object)item);
        }
        this.lstEmpType.removeAllElements();
    }

    @Override
    public void removeFilterAllAction_actionPerformed(ActionEvent e) throws Exception {
        this.lstFilter.removeAllElements();
        this.showEmpTypeListNoSelect();
    }

    public FilterInfo getFilterInfo() {
        FilterInfo filter = new FilterInfo();
        FilterItemInfo item = null;
        item = this.getEmployeeTyepConditon();
        if (item != null) {
            filter.getFilterItems().add(item);
            filter.setMaskString(this.getAndMask(0));
        }
        return filter;
    }

    private String getAndMask(int countItem) {
        StringBuffer maskStr = new StringBuffer("");
        for (int j = 0; j <= countItem; ++j) {
            if (j == 0) {
                maskStr.append("#0");
                continue;
            }
            maskStr.append(" and #" + Integer.toString(countItem));
        }
        return maskStr.toString();
    }

    private FilterItemInfo getEmployeeTyepConditon() {
        StringBuffer filter = this.getEmpTypeListFilterStr();
        if (filter == null) {
            return null;
        }
        FilterItemInfo item = new FilterItemInfo("EMPLOYEETYPE.ID", (Object)filter.toString(), CompareType.INCLUDE);
        return item;
    }

    private StringBuffer getEmpTypeListFilterStr() {
        EmployeeTypeInfo employeeTypeInfo = null;
        StringBuffer sql = null;
        int j = this.lstFilter.getElementCount();
        for (int i = 0; i < j; ++i) {
            employeeTypeInfo = (EmployeeTypeInfo)this.lstFilter.getElement(i);
            if (employeeTypeInfo == null) continue;
            if (sql == null) {
                sql = new StringBuffer();
            } else {
                sql.append(",");
            }
            sql.append(employeeTypeInfo.getId().toString());
        }
        return sql;
    }

    public CustomerParams getCustomerParams() {
        CustomerParams cp = new CustomerParams();
        EmployeeFenLeiInfo employeeFenLeiInfo = (EmployeeFenLeiInfo)this.prmtEmployeeFenlei.getValue();
        if (employeeFenLeiInfo != null) {
            cp.addCustomerParam(this.EMPLOYEE_TYPE, employeeFenLeiInfo.getId().toString());
        }
        if (null != this.getEmpTypeListFilterStr()) {
            cp.addCustomerParam(this.LSTFILTER, this.getEmpTypeListFilterStr().toString());
        }
        return cp;
    }

    public void setCustomerParams(CustomerParams param) {
        if (param == null) {
            this.prmtEmployeeFenlei.setValue(null);
            return;
        }
        try {
            this.prmtEmployeeFenlei.setValue((Object)this.getEmployeeFenLeiInfoById(param.getCustomerParam(this.EMPLOYEE_TYPE)));
        }
        catch (Exception e) {
            logger.error((Object)e);
            return;
        }
        this.loadEmpTypeListByParam(param.getCustomerParam(this.LSTFILTER));
    }

    private EmployeeFenLeiInfo getEmployeeFenLeiInfoById(String idStr) throws EASBizException, BOSException {
        if (idStr == null) {
            return null;
        }
        EmployeeFenLeiInfo employeeFenLeiInfo = null;
        employeeFenLeiInfo = EmployeeFenLeiFactory.getRemoteInstance().getEmployeeFenLeiInfo((IObjectPK)new ObjectUuidPK(idStr));
        return employeeFenLeiInfo;
    }

    private void loadEmpTypeListByParam(String empTypeStr) {
        this.lstFilter.removeAllElements();
        if (empTypeStr != null) {
            String[] listArg = empTypeStr.split(",");
            if (listArg.length > 0) {
                HashSet<String> empTypeIds = new HashSet<String>();
                for (int i = 0; i < listArg.length; ++i) {
                    empTypeIds.add(listArg[i]);
                }
                EntityViewInfo viewInfo = new EntityViewInfo();
                FilterInfo filter = new FilterInfo();
                filter.getFilterItems().add(new FilterItemInfo("id", empTypeIds, CompareType.INCLUDE));
                viewInfo.setFilter(filter);
                SelectorItemCollection selector = viewInfo.getSelector();
                selector.add(new SelectorItemInfo("id"));
                selector.add(new SelectorItemInfo("name"));
                selector.add(new SelectorItemInfo("number"));
                selector.add(new SelectorItemInfo("employeeFenLei.id"));
                selector.add(new SelectorItemInfo("employeeFenLei.name"));
                EmployeeTypeCollection empTCol = null;
                try {
                    empTCol = EmployeeTypeFactory.getRemoteInstance().getEmployeeTypeCollection(viewInfo);
                }
                catch (Exception e) {
                    this.handUIException(e);
                }
                if (empTCol != null && empTCol.size() > 0) {
                    int size = empTCol.size();
                    for (int i = 0; i < size; ++i) {
                        this.lstFilter.addElement((Object)empTCol.get(i));
                    }
                }
            }
            try {
                this.showEmpTypeListNoSelect();
            }
            catch (Exception e) {
                this.handUIException(e);
            }
        }
    }
}

