/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.emp.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.event.PreChangeEvent;
import com.kingdee.bos.ctrl.swing.event.PreChangeListener;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.sql.ParserException;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.commonquery.client.CustomerParams;
import com.kingdee.eas.base.core.hr.util.HRParamUtil;
import com.kingdee.eas.basedata.org.AdminOrgUnitCollection;
import com.kingdee.eas.basedata.org.AdminOrgUnitFactory;
import com.kingdee.eas.basedata.org.HROrgUnitInfo;
import com.kingdee.eas.basedata.org.IAdminOrgUnit;
import com.kingdee.eas.framework.client.ListUI;
import com.kingdee.eas.hr.base.HRInitFactory;
import com.kingdee.eas.hr.base.client.IHRF7CommonRegister;
import com.kingdee.eas.hr.base.util.OrgStringUtil;
import com.kingdee.eas.hr.emp.client.AbstractEmployeeRosterQueryUI;
import com.kingdee.eas.hr.emp.client.EmployeeDetailTableUI;
import com.kingdee.eas.hr.emp.client.EmployeeRosterListUI;
import com.kingdee.eas.hr.org.client.AdminByOrgRangePromptBox;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class EmployeeRosterQueryUI
extends AbstractEmployeeRosterQueryUI {
    private static final Logger logger = CoreUIObject.getLogger(EmployeeRosterQueryUI.class);
    private final String EMPRESOURCE_CLASS = "com.kingdee.eas.hr.emp.client.EmpResource.";
    private final String RADIOBTN = "radiobtn";
    ListUI listUI;
    protected final String RES = "com.kingdee.eas.hr.base.HRBasedataResource";
    Map properties = new HashMap();

    public EmployeeRosterQueryUI(EmployeeRosterListUI rosterListUI) throws Exception {
        this.listUI = rosterListUI;
        this.initControl();
    }

    public EmployeeRosterQueryUI(EmployeeDetailTableUI detailTableUI) throws Exception {
        this.listUI = detailTableUI;
        this.initControl();
    }

    private void initControl() {
        this.radiobtn0.setSelected(true);
        this.prmtOrgMult.setEditable(false);
        this.initBizOrgPreChange();
    }

    @Override
    public void onLoad() throws Exception {
        super.onLoad();
        this.initCombox();
    }

    private void initBizOrgPreChange() {
        this.prmtHROrg.addPreChangeListener(new PreChangeListener(){

            public void preChange(PreChangeEvent e) {
                if (e.getData() != null && e.getData() instanceof HROrgUnitInfo) {
                    try {
                        HRInitFactory.getRemoteInstance().isInitFinish((HROrgUnitInfo)e.getData());
                        if (e.getOldData() != null && e.getData() != null && !e.getOldData().equals(e.getData())) {
                            KDTable selfDefTbl = EmployeeRosterQueryUI.this.listUI.getDialog().getCommonFilterPanel().getKdtTable();
                            boolean hasFilterVal = false;
                            if (selfDefTbl.getRowCount() > 0) {
                                int i;
                                int size = selfDefTbl.getRowCount();
                                for (i = 0; i < size; ++i) {
                                    if (selfDefTbl.getRow(i).getCell(1).getValue() == null) continue;
                                    hasFilterVal = true;
                                    break;
                                }
                                if (hasFilterVal) {
                                    selfDefTbl.removeRows();
                                    for (i = 0; i < 10; ++i) {
                                        selfDefTbl.addRow();
                                    }
                                    return;
                                }
                            }
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        });
    }

    @Override
    protected Map getOrgProperties() {
        if (this.properties.size() == 0) {
            this.putPersonDepOrgProperties();
        }
        return this.properties;
    }

    private void putPersonDepOrgProperties() {
        this.properties.put("id", "PersonDep.id");
        this.properties.put("longNumber", "PersonDep.longNumber");
        this.properties.put("level", "PersonDep.level");
        this.properties.put("isSealUp", "PersonDep.isSealUp");
    }

    private void putAdminOrgProperties() {
        this.properties.put("id", "AdminOrgUnit.id");
        this.properties.put("longNumber", "AdminOrgUnit.longNumber");
        this.properties.put("level", "AdminOrgUnit.level");
        this.properties.put("isSealUp", "AdminOrgUnit.isSealUp");
    }

    public boolean verify() {
        if (this.radiobtn1.isSelected() && this.prmtOrg.getValue() == null) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.hr.emp.client.EmpResource.RosterAdminNameNull"));
            return false;
        }
        if (this.rdOrgMult.isSelected() && this.prmtOrgMult.getValue() == null) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.hr.emp.client.EmpResource.RosterAdminNameNull"));
            return false;
        }
        return super.verify();
        {
        }
    }

    public KDBizPromptBox getMainBizOrgF7() {
        return this.getMainOrg();
    }

    @Override
    public CustomerParams getCustomerParams() {
        CustomerParams params;
        if (!this.rdOrg.isSelected()) {
            this.prmtOrg.setValue(null);
            this.chkShowSealUp.setSelected(false);
            this.chkShowVirtualOrg.setSelected(false);
            this.comboOrgLevel.removeAllItems();
        }
        if ((params = super.getCustomerParams()) != null) {
            if (this.radiobtn0.isSelected()) {
                params.addCustomerParam("radiobtn", "radiobtn0");
            } else if (this.radiobtn1.isSelected()) {
                params.addCustomerParam("radiobtn", "radiobtn1");
            } else if (this.radiobtn2.isSelected()) {
                params.addCustomerParam("radiobtn", "radiobtn2");
                params.addCustomerParam("level", this.levelComboBox.getSelectedItem().toString());
            } else if (this.radiobtnFrom.isSelected()) {
                params.addCustomerParam("radiobtn", "radiobtnFrom");
                params.addCustomerParam("fromlevel", this.fromComboBox.getSelectedItem().toString());
                params.addCustomerParam("tolevel", this.toComboBox.getSelectedItem().toString());
            }
            params.putBoolean("chkIsHandlePlur", this.chkIsHandlePlur.isSelected());
            params.putBoolean("chkShowSealUp", this.chkShowSealUp.isSelected());
            params.putBoolean("ShowVirtualOrg", this.chkShowVirtualOrg.isSelected());
            params.putBoolean(this.rdOrg.getName(), this.rdOrg.isSelected());
            params.putBoolean(this.rdOrgMult.getName(), this.rdOrgMult.isSelected());
            if (this.rdOrgMult.isSelected()) {
                if (this.prmtOrgMult.getData() != null) {
                    params.addCustomerParam(this.prmtOrgMult.getName(), OrgStringUtil.orgInfoArr2String((Object[])((Object[])this.prmtOrgMult.getData())));
                }
                params.putBoolean("ShowVirtualOrg", true);
                params.putBoolean("chkShowSealUp", true);
            }
        }
        return params;
    }

    @Override
    public FilterInfo getFilterInfo() {
        this.putPersonDepOrgProperties();
        FilterInfo filter = this.getOrgFilterInfo();
        if (this.chkIsHandlePlur.isSelected()) {
            try {
                FilterInfo ppFilter = new FilterInfo("AdminOrgUnit.id IS NULL");
                ppFilter.mergeFilter(filter, "and");
                this.putAdminOrgProperties();
                FilterInfo pmFilter = new FilterInfo("AdminOrgUnit.id IS Not NULL");
                pmFilter.mergeFilter(this.getOrgFilterInfo(), "and");
                ppFilter.mergeFilter(pmFilter, "or");
                filter = ppFilter;
                this.putPersonDepOrgProperties();
            }
            catch (Exception e) {
                this.handUIException(e);
            }
        }
        return filter;
    }

    private FilterInfo getOrgFilterInfo() {
        FilterInfo filter = null;
        filter = this.rdOrgMult.isSelected() ? this.getMultOrgFilterInfo() : super.getFilterInfo();
        if (filter == null) {
            filter = new FilterInfo();
        }
        if (!this.rdOrgMult.isSelected()) {
            try {
                boolean isAffair;
                if (!this.chkShowSealUp.isSelected()) {
                    FilterInfo sealUpFilter = new FilterInfo(this.properties.get("isSealUp") + " = 0");
                    filter.mergeFilter(sealUpFilter, "and");
                }
                if (!this.chkShowVirtualOrg.isSelected()) {
                    FilterInfo isVirtualFilter = new FilterInfo("PersonDep.isVirtual = 0");
                    filter.mergeFilter(isVirtualFilter, "and");
                }
                if (!(isAffair = HRParamUtil.getParamOfHR(null, (String)"IS_AFFAIR", null))) {
                    FilterInfo isVirtualFilter = new FilterInfo("(position.deletedStatus = 1 or position.deletedStatus is null)");
                    filter.mergeFilter(isVirtualFilter, "and");
                }
            }
            catch (Exception e) {
                this.handUIException(e);
            }
        }
        return filter;
    }

    private FilterInfo getMultOrgFilterInfo() {
        Object[] orgs = (Object[])this.prmtOrgMult.getValue();
        FilterInfo filter = null;
        try {
            filter = new FilterInfo(this.properties.get("id") + " in (" + OrgStringUtil.getOrgIdsSql((Object[])orgs) + ")");
        }
        catch (ParserException e) {
            this.handUIException(e);
        }
        return filter;
    }

    @Override
    public void setCustomerParams(CustomerParams param) {
        super.setCustomerParams(param);
        if (param != null) {
            if (param.getCustomerParam("radiobtn") == null || param.getCustomerParam("radiobtn").equals("radiobtn0")) {
                this.radiobtn0.setSelected(true);
            } else if (param.getCustomerParam("radiobtn").equals("radiobtn1")) {
                this.radiobtn1.setSelected(true);
            } else if (param.getCustomerParam("radiobtn").equals("radiobtn2")) {
                this.radiobtn2.setSelected(true);
                String level = param.getCustomerParam("level");
                this.levelComboBox.setSelectedIndex(Integer.parseInt(level) - 1);
            } else if (param.getCustomerParam("radiobtn").equals("radiobtnFrom")) {
                this.radiobtnFrom.setSelected(true);
                String fromlevel = param.getCustomerParam("fromlevel");
                this.fromComboBox.setSelectedIndex(Integer.parseInt(fromlevel) - 1);
                String tolevel = param.getCustomerParam("tolevel");
                this.toComboBox.setSelectedIndex(Integer.parseInt(tolevel) - 1);
            }
            if (param.getBoolean("chkIsHandlePlur")) {
                this.chkIsHandlePlur.setSelected(true);
            }
            this.chkShowSealUp.setSelected(param.getBoolean("chkShowSealUp"));
            this.chkShowVirtualOrg.setSelected(param.getBoolean("ShowVirtualOrg"));
            this.rdOrg.setSelected(param.getBoolean(this.rdOrg.getName()));
            this.rdOrgMult.setSelected(param.getBoolean(this.rdOrgMult.getName()));
            String orgIds = param.getCustomerParam(this.prmtOrgMult.getName());
            if (orgIds != null) {
                Object[] orgs = OrgStringUtil.string2OrgInfoArr((String)orgIds);
                this.prmtOrgMult.setData((Object)orgs);
            }
        }
        this.setOrgCommentEnabled();
    }

    @Override
    protected void rdOrg_actionPerformed(ActionEvent e) throws Exception {
        this.setOrgCommentEnabled();
        super.rdOrg_actionPerformed(e);
    }

    @Override
    protected void rdOrgMult_actionPerformed(ActionEvent e) throws Exception {
        this.setOrgCommentEnabled();
        super.rdOrgMult_actionPerformed(e);
    }

    @Override
    public void clear() {
        super.clear();
        this.rdOrg.setSelected(true);
        this.prmtOrgMult.setData(null);
        this.radiobtn0.setSelected(true);
        this.levelComboBox.setSelectedIndex(0);
        this.chkIsHandlePlur.setSelected(false);
        this.chkShowSealUp.setSelected(false);
        this.chkShowVirtualOrg.setSelected(false);
        this.toComboBox.setSelectedIndex(0);
        this.setOrgCommentEnabled();
    }

    private void initCombox() throws BOSException {
        IAdminOrgUnit iAdminOrgUnit = AdminOrgUnitFactory.getRemoteInstance();
        AdminOrgUnitCollection adminColl = iAdminOrgUnit.getAdminOrgUnitCollection("select Level");
        int maxLevel = 0;
        for (int j = 0; j < adminColl.size(); ++j) {
            if (maxLevel >= adminColl.get(j).getLevel()) continue;
            maxLevel = adminColl.get(j).getLevel();
        }
        for (int i = 2; i <= maxLevel; ++i) {
            this.fromComboBox.addItem((Object)Integer.toString(i));
            this.toComboBox.addItem((Object)Integer.toString(i));
            this.levelComboBox.addItem((Object)Integer.toString(i));
        }
    }

    private void setOrgCommentEnabled() {
        boolean isRdOrgSelected = this.rdOrg.isSelected();
        boolean isRdOrgMultSelected = this.rdOrgMult.isSelected();
        boolean isRdOrgHaveData = this.prmtOrg.getData() != null;
        this.prmtOrg.setEnabled(isRdOrgSelected);
        this.chkShowSealUp.setEnabled(isRdOrgSelected);
        this.chkShowVirtualOrg.setEnabled(isRdOrgSelected);
        this.rdDisplaySelf.setEnabled(isRdOrgSelected && isRdOrgHaveData);
        this.rdDisplaySub.setEnabled(isRdOrgSelected && isRdOrgHaveData);
        this.rdDisplayAll.setEnabled(isRdOrgSelected && isRdOrgHaveData);
        this.comboOrgLevel.setEnabled(isRdOrgSelected && isRdOrgHaveData);
        this.prmtOrgMult.setEnabled(isRdOrgMultSelected);
        if (this.radiobtn1.isSelected() && isRdOrgMultSelected) {
            this.radiobtn1.setSelected(false);
            this.radiobtn0.setSelected(true);
        }
        this.radiobtn1.setEnabled(!isRdOrgMultSelected);
    }

    @Override
    protected void fromComboBox_itemStateChanged(ItemEvent e) throws Exception {
        super.fromComboBox_itemStateChanged(e);
        if (this.fromComboBox.getSelectedIndex() > this.toComboBox.getSelectedIndex()) {
            this.toComboBox.setSelectedIndex(this.fromComboBox.getSelectedIndex());
        }
    }

    @Override
    protected void toComboBox_itemStateChanged(ItemEvent e) throws Exception {
        super.toComboBox_itemStateChanged(e);
        if (this.fromComboBox.getSelectedIndex() > this.toComboBox.getSelectedIndex()) {
            this.fromComboBox.setSelectedIndex(this.toComboBox.getSelectedIndex());
        }
    }

    public boolean isSupportVirturalOrgs() {
        return true;
    }

    @Override
    protected void initF7Context(IHRF7CommonRegister register) {
        register.registerAdminByOrgRangePromptBox(this.prmtOrgMult, true, this.isIncludeSealUp());
        if (this.prmtOrgMult.getSelector() instanceof AdminByOrgRangePromptBox) {
            AdminByOrgRangePromptBox adminOrgPromp = (AdminByOrgRangePromptBox)this.prmtOrgMult.getSelector();
            adminOrgPromp.setIncludeSealUp("false");
            adminOrgPromp.showChkSealUp(true);
            adminOrgPromp.setSurpotHro(true);
        }
        super.initF7Context(register);
    }

    @Override
    protected void afterInitF7Context() {
        if (this.prmtOrg.getSelector() instanceof AdminByOrgRangePromptBox) {
            AdminByOrgRangePromptBox adminOrgPromp = (AdminByOrgRangePromptBox)this.prmtOrg.getSelector();
            adminOrgPromp.setIncludeSealUp("false");
            adminOrgPromp.setSurpotHro(true);
            adminOrgPromp.showChkSealUp(true);
            this.prmtOrg.setHistoryRecordEnabled(false);
            this.prmtOrg.setSelector((KDPromptSelector)adminOrgPromp);
        }
    }
}

