/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.emp.probation.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.hr.emp.probation.IProbationAppraiseBizBill;
import com.kingdee.eas.hr.emp.probation.ProbationAppraiseBizBillEntryCollection;
import com.kingdee.eas.hr.emp.probation.ProbationAppraiseBizBillEntryFactory;
import com.kingdee.eas.hr.emp.probation.ProbationAppraiseBizBillEntryInfo;
import com.kingdee.eas.hr.emp.probation.ProbationAppraiseBizBillFactory;
import com.kingdee.eas.hr.emp.probation.ProbationAppraiseBizBillInfo;
import com.kingdee.eas.hr.emp.probation.ProbationAppraiseBizBilljudgesCollection;
import com.kingdee.eas.hr.emp.probation.ProbationAppraiseBizBilljudgesInfo;
import com.kingdee.eas.hr.emp.probation.app.ProbationAppraiseJudgeStateEnum;

public class JudgeCountUtil {
    public static void refreshCount(Context ctx, String billId) throws BOSException, EASBizException {
        IProbationAppraiseBizBill iProbationAppraiseBizBill = ProbationAppraiseBizBillFactory.getLocalInstance(ctx);
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("id"));
        selector.add(new SelectorItemInfo("entrys.id"));
        selector.add(new SelectorItemInfo("entrys.unSubmitCount"));
        selector.add(new SelectorItemInfo("entrys.judgeCount"));
        selector.add(new SelectorItemInfo("judges.id"));
        selector.add(new SelectorItemInfo("judges.state"));
        ProbationAppraiseBizBillInfo info = iProbationAppraiseBizBill.getProbationAppraiseBizBillInfo((IObjectPK)new ObjectUuidPK(billId), selector);
        ProbationAppraiseBizBilljudgesCollection judges = info.getJudges();
        int submitCount = 0;
        for (int i = 0; i < judges.size(); ++i) {
            ProbationAppraiseBizBilljudgesInfo probationAppraiseBizBilljudgesInfo = judges.get(i);
            ProbationAppraiseJudgeStateEnum state = probationAppraiseBizBilljudgesInfo.getState();
            if (state == null || state.getValue() != 3) continue;
            ++submitCount;
        }
        ProbationAppraiseBizBillEntryCollection entrys = info.getEntrys();
        if (entrys.size() > 0) {
            ProbationAppraiseBizBillEntryInfo probationAppraiseBizBillEntryInfo = entrys.get(0);
            probationAppraiseBizBillEntryInfo.setJudgeCount(judges.size());
            probationAppraiseBizBillEntryInfo.setUnSubmitCount(judges.size() - submitCount);
            selector.clear();
            selector.add(new SelectorItemInfo("unSubmitCount"));
            selector.add(new SelectorItemInfo("judgeCount"));
            ProbationAppraiseBizBillEntryFactory.getLocalInstance(ctx).updatePartial((CoreBaseInfo)probationAppraiseBizBillEntryInfo, selector);
        }
    }
}

