/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.emp.probation.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.HistoryConstant;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.base.permission.UserCollection;
import com.kingdee.eas.base.permission.UserFactory;
import com.kingdee.eas.basedata.person.PersonFactory;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.hr.base.EmpPosOrgRelationCollection;
import com.kingdee.eas.hr.base.EmpPosOrgRelationFactory;
import com.kingdee.eas.hr.base.EmpPosOrgRelationInfo;
import com.kingdee.eas.hr.base.util.HRUtil;
import com.kingdee.eas.hr.emp.probation.util.ProbationAppraiseUtil;
import com.kingdee.eas.hr.emp.probation.util.ProbationGoalUtil;
import com.kingdee.eas.hr.emp.probation.util.ProbationTrainPlanUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.shr.base.bizmanage.util.BatchPromptsInfo;
import com.kingdee.shr.ml.util.SHRServerResource;
import com.kingdee.util.StringUtils;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.HashSet;
import java.util.Set;

public class ProbationMangerUtil {
    public static String getPositionIdByPersonId(Context ctx, String personId) throws BOSException {
        String sql = "select FPositionID positionId from t_hr_emporgrelation where FPersonID = ? and FIsInner = 1 and FAssignType = 1 and FIsLatestInAday = 1 and FLEFFDT={ts '2199-12-31'}";
        Object[] params = new Object[]{personId};
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])params);
        try {
            if (rowSet.next()) {
                String positionId = rowSet.getString("positionId");
                return positionId;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BOSException((Throwable)e);
        }
        return null;
    }

    public static Set<String> getUpNotContainPositionIds(Context ctx, String positionId) throws BOSException, SQLException {
        StringBuffer upHierarchySql = new StringBuffer("select hierarchy.FParentID positionIds from T_ORG_PositionHierarchy hierarchy").append(" where hierarchy.fhierarchyid = '00000000-0000-0000-0000-000000000001396FCAD0'").append(" and hierarchy.FChildID = '").append(positionId).append("'");
        IRowSet upHierarchySqlrowSet = DbUtil.executeQuery((Context)ctx, (String)upHierarchySql.toString());
        HashSet<String> upNotContainPositionIds = new HashSet<String>();
        while (upHierarchySqlrowSet.next()) {
            if (upNotContainPositionIds.contains(upHierarchySqlrowSet.getString("positionIds"))) continue;
            upNotContainPositionIds.add(upHierarchySqlrowSet.getString("positionIds"));
        }
        return upNotContainPositionIds;
    }

    public static Set<String> getPersonIdByPositionIds(Context ctx, Set<String> downNotContainPositionIds) throws BOSException {
        HashSet<String> personIds = new HashSet<String>();
        if (downNotContainPositionIds == null || downNotContainPositionIds.size() <= 0) {
            return personIds;
        }
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("position.id", downNotContainPositionIds, CompareType.INCLUDE));
        filter.getFilterItems().add(new FilterItemInfo("person.employeeType.isInCount", (Object)1));
        filter.getFilterItems().add(new FilterItemInfo(HistoryConstant.LEFFDT, (Object)HRUtil.getMaxEndDate(), CompareType.GREATER_EQUALS));
        view.setFilter(filter);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("person.id"));
        view.setSelector(sic);
        EmpPosOrgRelationCollection empposorgRelationColl = EmpPosOrgRelationFactory.getLocalInstance((Context)ctx).getEmpPosOrgRelationCollection(view);
        for (int i = 0; i < empposorgRelationColl.size(); ++i) {
            EmpPosOrgRelationInfo info = empposorgRelationColl.get(i);
            if (info == null || info.getPerson() == null || info.getPerson().getId() == null || StringUtils.isEmpty((String)info.getPerson().getId().toString()) || personIds.contains(info.getPerson().getId().toString())) continue;
            personIds.add(info.getPerson().getId().toString());
        }
        return personIds;
    }

    public static Set<String> getNeedToSendMessageUserId(Context ctx, String personId) throws BOSException, SQLException {
        String positionId = ProbationMangerUtil.getPositionIdByPersonId(ctx, personId);
        Set<String> positionIdSet = ProbationMangerUtil.getUpNotContainPositionIds(ctx, positionId);
        Set<String> personIds = ProbationMangerUtil.getPersonIdByPositionIds(ctx, positionIdSet);
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("person.id", personIds, CompareType.INCLUDE));
        filter.getFilterItems().add(new FilterItemInfo("isDelete", (Object)false));
        filter.getFilterItems().add(new FilterItemInfo("isForbidden", (Object)false));
        view.setFilter(filter);
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("id"));
        view.setSelector(selector);
        UserCollection userCollection = UserFactory.getLocalInstance((Context)ctx).getUserCollection(view);
        HashSet<String> userIdSet = new HashSet<String>();
        for (int i = 0; i < userCollection.size(); ++i) {
            userIdSet.add(userCollection.get(i).getId().toString());
        }
        return userIdSet;
    }

    public static void abortPersonProbationBillAfterResign(Context ctx, String personId) throws EASBizException, BOSException {
        ProbationGoalUtil.abortPersonProbationBillAfterResign(ctx, personId);
        ProbationTrainPlanUtil.abortPersonProbationBillAfterResign(ctx, personId);
        ProbationAppraiseUtil.abortPersonProbationBillAfterResign(ctx, personId);
    }

    public static BatchPromptsInfo checkPersonCanDeleteForProService(Context ctx, String personId) throws EASBizException, BOSException {
        BatchPromptsInfo batchPromptsInfo = null;
        if (!(ProbationGoalUtil.checkPersonCanDelete(ctx, personId) && ProbationTrainPlanUtil.checkPersonCanDelete(ctx, personId) && ProbationAppraiseUtil.checkPersonCanDelete(ctx, personId))) {
            batchPromptsInfo = new BatchPromptsInfo();
            batchPromptsInfo.setPersonId(personId);
            batchPromptsInfo.setDomain(SHRServerResource.getString((String)"com.kingdee.eas.hr.emp.probation.ProbationEmpBizResource", (String)"label23", (Context)ctx));
            batchPromptsInfo.setModules(SHRServerResource.getString((String)"com.kingdee.eas.hr.emp.probation.ProbationEmpBizResource", (String)"label24", (Context)ctx));
            batchPromptsInfo.setOperation("");
            SelectorItemCollection selector = new SelectorItemCollection();
            selector.add(new SelectorItemInfo("id"));
            selector.add(new SelectorItemInfo("name"));
            selector.add(new SelectorItemInfo("number"));
            PersonInfo person = PersonFactory.getLocalInstance((Context)ctx).getPersonInfo((IObjectPK)new ObjectUuidPK(personId), selector);
            String desc = MessageFormat.format(SHRServerResource.getString((String)"com.kingdee.eas.hr.emp.probation.ProbationEmpBizResource", (String)"label25", (Context)ctx), person.getName());
            batchPromptsInfo.setDesc(desc);
        }
        return batchPromptsInfo;
    }
}

