/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.org.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ctrl.swing.StringUtils;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.dao.query.SQLExecutorFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIFactory;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.org.JobFamilyCollection;
import com.kingdee.eas.basedata.org.JobFamilyFactory;
import com.kingdee.eas.basedata.org.JobFamilyInfo;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.hr.base.DynamicTableInfo;
import com.kingdee.eas.hr.base.util.HRBaseDynamicTableUtils;
import com.kingdee.eas.hr.org.HRJobSystemFacadeFactory;
import com.kingdee.eas.hr.org.JobGradeInfo;
import com.kingdee.eas.hr.org.client.AbstractHRJobStatisticTableUI;
import com.kingdee.eas.hr.org.client.EmpDetailListUI;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.shr.base.syssetting.context.SHRContext;
import com.kingdee.shr.ml.util.SHRServerResource;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.DefaultComboBoxModel;
import org.apache.log4j.Logger;

public class HRJobStatisticTableUI
extends AbstractHRJobStatisticTableUI {
    private static final Logger logger = CoreUIObject.getLogger(HRJobStatisticTableUI.class);
    protected DynamicTableInfo infoDynamicTable = new DynamicTableInfo();
    private JobFamilyInfo jobFamilyInfo = null;
    private List<JobGradeInfo> jobGradeList = null;
    private Map<String, Set<String>> jobJobGradeMap = null;
    private List<JobDetailInfo> jobDetailList = null;
    private Map<String, Integer> jobFamilyMap = null;
    private Map<String, Integer> jobCategoryMap = null;
    private Map<String, Integer> jobSubCategoryMap = null;
    private Map<String, Integer> jobMap = null;
    private Map<String, Map<String, Integer>> jobPerCountMap = null;

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public void onLoad() throws Exception {
        this.initChkJobFamily();
        this.initJobGradeList();
        this.initJobDetail();
        this.initJobJobGradeMap();
        super.onLoad();
        this.tblMain.getDataRequestManager().setDataRequestMode(0);
        this.btnRefresh.setIcon(EASResource.getIcon((String)"imgTbtn_refresh"));
        this.btnRefresh.setVisible(false);
        this.createTable();
        this.loadJobData();
    }

    private void createTable() throws Exception {
        this.tblMain.removeRows();
        this.tblMain.removeColumns();
        this.tblMain.removeHeadRows();
        this.tblMain.setRefresh(false);
        this.infoDynamicTable.setCountHeadLine(2);
        List lstColumn = this.getTableColumnList();
        DynamicTableInfo.ColumnInfo[] infosColumn = new DynamicTableInfo.ColumnInfo[lstColumn.size()];
        int size = lstColumn.size();
        for (int i = 0; i < size; ++i) {
            infosColumn[i] = (DynamicTableInfo.ColumnInfo)lstColumn.get(i);
        }
        this.infoDynamicTable.setInfosColumn(infosColumn);
        HRBaseDynamicTableUtils.createTableHead((KDTable)this.tblMain, (DynamicTableInfo)this.infoDynamicTable, (boolean)false);
        this.tblMain.setEditable(false);
        this.setMerge();
        this.tblMain.setRefresh(true);
        this.tblMain.repaint();
    }

    protected List getTableColumnList() throws Exception {
        ArrayList<DynamicTableInfo.ColumnInfo> lstColumn = new ArrayList<DynamicTableInfo.ColumnInfo>();
        DynamicTableInfo.ColumnInfo infoColumn = null;
        boolean showPerson = this.chkShowPerson.isSelected();
        boolean showJobGrade = this.chkShowJobGrade.isSelected();
        infoColumn = this.addColumn("\u804c\u52a1\u65cf", "jobFamily", Styles.HorizontalAlignment.CENTER);
        infoColumn.setWidth(100);
        lstColumn.add(infoColumn);
        infoColumn = this.addColumn("\u804c\u52a1\u5206\u7c7b", "jobCategory", Styles.HorizontalAlignment.LEFT);
        if (!showJobGrade) {
            infoColumn.setWidth(200);
        } else {
            infoColumn.setWidth(120);
        }
        lstColumn.add(infoColumn);
        infoColumn = this.addColumn("\u804c\u52a1\u5b50\u7c7b", "jobSubCategory", Styles.HorizontalAlignment.LEFT);
        if (!showJobGrade) {
            infoColumn.setWidth(200);
        } else {
            infoColumn.setWidth(120);
        }
        lstColumn.add(infoColumn);
        infoColumn = this.addColumn("\u804c\u52a1", "job", Styles.HorizontalAlignment.LEFT);
        if (!showJobGrade) {
            infoColumn.setWidth(220);
        } else {
            infoColumn.setWidth(150);
        }
        lstColumn.add(infoColumn);
        if (!showPerson || showJobGrade) {
            // empty if block
        }
        if (showJobGrade && this.jobGradeList != null) {
            String jobGradeId = null;
            String jobGradeName = null;
            for (int i = 0; i < this.jobGradeList.size(); ++i) {
                jobGradeId = this.jobGradeList.get(i).getId().toString();
                jobGradeName = this.jobGradeList.get(i).getName();
                infoColumn = new DynamicTableInfo.ColumnInfo();
                infoColumn.setHide(false);
                infoColumn.setReadOnly(true);
                infoColumn.setWidth(50);
                infoColumn.setKey(jobGradeId);
                infoColumn.setColumnNumber(jobGradeId);
                infoColumn.setColumnName(jobGradeName);
                infoColumn.setAlignHor(Styles.HorizontalAlignment.CENTER);
                infoColumn.setInfosHead(new DynamicTableInfo.HeadInfo[2]);
                infoColumn.getInfosHead()[0] = new DynamicTableInfo.HeadInfo();
                infoColumn.getInfosHead()[0].setHeadName("\u804c\u7b49");
                infoColumn.getInfosHead()[0].setHeadValue("\u804c\u7b49");
                infoColumn.getInfosHead()[1] = new DynamicTableInfo.HeadInfo();
                infoColumn.getInfosHead()[1].setHeadName(jobGradeName);
                infoColumn.getInfosHead()[1].setHeadValue(jobGradeId);
                lstColumn.add(infoColumn);
            }
        }
        if (showJobGrade) {
            infoColumn = this.addColumn("\u65e0\u804c\u7b49", "noJobGrade", Styles.HorizontalAlignment.CENTER);
            infoColumn.setWidth(60);
            lstColumn.add(infoColumn);
        }
        return lstColumn;
    }

    private DynamicTableInfo.ColumnInfo addColumn(String columnName, String columnKey, Styles.HorizontalAlignment align) {
        DynamicTableInfo.ColumnInfo infoColumn = new DynamicTableInfo.ColumnInfo();
        infoColumn.setHide(false);
        infoColumn.setReadOnly(true);
        infoColumn.setKey(columnKey);
        infoColumn.setColumnNumber(columnKey);
        infoColumn.setColumnName(columnName);
        infoColumn.setAlignHor(align);
        infoColumn.setInfosHead(new DynamicTableInfo.HeadInfo[3]);
        for (int i = 0; i < 2; ++i) {
            infoColumn.getInfosHead()[i] = new DynamicTableInfo.HeadInfo();
            infoColumn.getInfosHead()[i].setHeadName(columnName);
            infoColumn.getInfosHead()[i].setHeadValue(columnKey);
        }
        return infoColumn;
    }

    private void setMerge() {
        this.tblMain.getHeadMergeManager().setMergeMode(3);
        this.tblMain.getMergeManager().setMergeMode(1);
        int count = this.tblMain.getColumnCount();
        for (int i = 0; i < count; ++i) {
            if (i >= 3) {
                this.tblMain.getColumn(i).setMergeable(false);
                continue;
            }
            this.tblMain.getColumn(i).setMergeable(true);
        }
        boolean chkShowJobGrade = this.chkShowJobGrade.isSelected();
        if (chkShowJobGrade) {
            for (int j = 4; j < count; ++j) {
                this.tblMain.getColumn(j).getStyleAttributes().setFontColor(Color.BLUE);
            }
            this.tblMain.getViewManager().setFreezeView(0, 4);
        }
    }

    private void loadJobData() throws Exception {
        this.setJobPersonCount();
        String jobFamilyId = null;
        String jobCategoryId = null;
        String jobSubCateId = null;
        String jobId = null;
        String jobGradeId = null;
        Map<String, Integer> subMap = null;
        String jobFamilyName = null;
        String jobCategoryName = null;
        String jobSubCateName = null;
        String jobName = null;
        this.tblMain.setRefresh(false);
        JobDetailInfo jobDetailInfo = null;
        IRow row = null;
        Object obj = this.chkJobFamily.getSelectedItem();
        JobFamilyInfo jobFamily = null;
        if (obj instanceof JobFamilyInfo) {
            jobFamily = (JobFamilyInfo)obj;
        }
        String key1 = null;
        String key2 = null;
        for (int i = 0; i < this.jobDetailList.size(); ++i) {
            jobDetailInfo = this.jobDetailList.get(i);
            jobFamilyName = jobDetailInfo.jobFamilyName;
            jobFamilyId = jobDetailInfo.jobFamilyId;
            if (jobFamily != null && !jobFamily.getId().toString().equals(jobFamilyId)) continue;
            row = this.tblMain.addRow();
            jobCategoryId = jobDetailInfo.jobCategoryId;
            jobCategoryName = jobDetailInfo.jobCategoryName;
            jobSubCateId = jobDetailInfo.jobSubCateId;
            jobSubCateName = jobDetailInfo.jobSubCateName;
            jobName = jobDetailInfo.jobName;
            jobId = jobDetailInfo.jobId;
            row.setUserObject((Object)jobId);
            row.getCell("jobFamily").setUserObject((Object)jobFamilyId);
            row.getCell("jobCategory").setUserObject((Object)jobCategoryId);
            row.getCell("jobSubCategory").setUserObject((Object)jobSubCateId);
            if (this.jobFamilyMap != null && this.jobFamilyMap.containsKey(jobFamilyId) && this.chkShowPerson.isSelected()) {
                row.getCell("jobFamily").setValue((Object)(jobFamilyName + "\n(" + this.jobFamilyMap.get(jobFamilyId) + ")"));
            } else {
                row.getCell("jobFamily").setValue((Object)jobFamilyName);
            }
            key1 = jobFamilyId + "~" + jobCategoryId;
            if (this.jobCategoryMap != null && this.jobCategoryMap.containsKey(key1) && this.chkShowPerson.isSelected()) {
                row.getCell("jobCategory").setValue((Object)(jobCategoryName + "\n(" + this.jobCategoryMap.get(key1) + ")"));
            } else {
                row.getCell("jobCategory").setValue((Object)jobCategoryName);
            }
            key2 = jobFamilyId + "~" + jobCategoryId + "~" + jobSubCateId;
            if (this.jobSubCategoryMap != null && this.jobSubCategoryMap.containsKey(key2) && this.chkShowPerson.isSelected()) {
                row.getCell("jobSubCategory").setValue((Object)(jobSubCateName + "\n(" + this.jobSubCategoryMap.get(key2) + ")"));
            } else {
                row.getCell("jobSubCategory").setValue((Object)jobSubCateName);
            }
            if (this.jobMap != null && this.jobMap.containsKey(jobId) && this.chkShowPerson.isSelected()) {
                row.getCell("job").setValue((Object)(jobName + "\n(" + this.jobMap.get(jobId) + ")"));
            } else {
                row.getCell("job").setValue((Object)jobName);
            }
            if (!this.chkShowJobGrade.isSelected()) continue;
            if (this.jobJobGradeMap != null) {
                Set<String> jobGradeSet = this.jobJobGradeMap.get(jobId);
                Iterator<String> iter = null;
                if (jobGradeSet != null) {
                    for (String jobGradeID : jobGradeSet) {
                        if (row.getCell(jobGradeID) == null) continue;
                        row.getCell(jobGradeID).getStyleAttributes().setBackground(new Color(181, 255, 181));
                    }
                }
            }
            if (this.jobPerCountMap == null || !this.jobPerCountMap.containsKey(jobId)) continue;
            subMap = this.jobPerCountMap.get(jobId);
            Iterator<String> iter = subMap.keySet().iterator();
            int count = 0;
            while (iter.hasNext()) {
                jobGradeId = iter.next();
                count = subMap.get(jobGradeId);
                if (row.getCell(jobGradeId) == null) continue;
                row.getCell(jobGradeId).setValue((Object)count);
            }
        }
        this.tblMain.setRefresh(true);
        this.tblMain.repaint();
    }

    @Override
    public void actionRefresh_actionPerformed(ActionEvent e) throws Exception {
    }

    private void setJobPersonCount() throws Exception {
        if (!this.chkShowPerson.isSelected() && !this.chkShowJobGrade.isSelected()) {
            return;
        }
        if (this.jobPerCountMap != null) {
            return;
        }
        IRowSet rs = HRJobSystemFacadeFactory.getRemoteInstance().getJobStatisticTableData(null);
        this.jobPerCountMap = new HashMap<String, Map<String, Integer>>();
        this.jobFamilyMap = new HashMap<String, Integer>();
        this.jobCategoryMap = new HashMap<String, Integer>();
        this.jobSubCategoryMap = new HashMap<String, Integer>();
        this.jobMap = new HashMap<String, Integer>();
        String jobId = null;
        String jobGradeId = null;
        String jobFamilyId = null;
        String jobCategoryId = null;
        String jobSubCategoryId = null;
        Map<Object, Object> subMap = null;
        int count = -1;
        while (rs.next()) {
            int categoryCount;
            int familyCount;
            jobId = rs.getString("jobID");
            jobGradeId = rs.getString("jobGradeID");
            if (StringUtils.isEmpty((String)jobGradeId)) {
                jobGradeId = "noJobGrade";
            }
            jobFamilyId = rs.getString("fjobfamilyid");
            jobCategoryId = rs.getString("fjobcategoryid");
            jobSubCategoryId = rs.getString("fjobsubcategoryid");
            count = rs.getInt("personCount");
            if (this.jobPerCountMap.containsKey(jobId)) {
                subMap = this.jobPerCountMap.get(jobId);
            } else {
                subMap = new HashMap();
                this.jobPerCountMap.put(jobId, subMap);
            }
            subMap.put(jobGradeId, count);
            if (this.jobMap.containsKey(jobId)) {
                familyCount = this.jobMap.get(jobId);
                this.jobMap.put(jobId, count + familyCount);
            } else {
                this.jobMap.put(jobId, count);
            }
            if (this.jobFamilyMap.containsKey(jobFamilyId)) {
                familyCount = this.jobFamilyMap.get(jobFamilyId);
                this.jobFamilyMap.put(jobFamilyId, count + familyCount);
            } else {
                this.jobFamilyMap.put(jobFamilyId, count);
            }
            if (this.jobCategoryMap.containsKey(jobFamilyId + "~" + jobCategoryId)) {
                categoryCount = this.jobCategoryMap.get(jobFamilyId + "~" + jobCategoryId);
                this.jobCategoryMap.put(jobFamilyId + "~" + jobCategoryId, count + categoryCount);
            } else {
                this.jobCategoryMap.put(jobFamilyId + "~" + jobCategoryId, count);
            }
            if (this.jobSubCategoryMap.containsKey(jobFamilyId + "~" + jobCategoryId + "~" + jobSubCategoryId)) {
                categoryCount = this.jobSubCategoryMap.get(jobFamilyId + "~" + jobCategoryId + "~" + jobSubCategoryId);
                this.jobSubCategoryMap.put(jobFamilyId + "~" + jobCategoryId + "~" + jobSubCategoryId, count + categoryCount);
                continue;
            }
            this.jobSubCategoryMap.put(jobFamilyId + "~" + jobCategoryId + "~" + jobSubCategoryId, count);
        }
    }

    protected void initListener() {
        this.chkShowPerson.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                HRJobStatisticTableUI.this.beforeActionPerformed(e);
                try {
                    HRJobStatisticTableUI.this.chkShowPerson_actionPerformed(e);
                }
                catch (Exception exc) {
                    HRJobStatisticTableUI.this.handUIException(exc);
                }
                finally {
                    HRJobStatisticTableUI.this.afterActionPerformed(e);
                }
            }
        });
        this.chkShowJobGrade.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                HRJobStatisticTableUI.this.beforeActionPerformed(e);
                try {
                    HRJobStatisticTableUI.this.chkShowJobGrade_actionPerformed(e);
                }
                catch (Exception exc) {
                    HRJobStatisticTableUI.this.handUIException(exc);
                }
                finally {
                    HRJobStatisticTableUI.this.afterActionPerformed(e);
                }
            }
        });
        this.chkJobFamily.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                HRJobStatisticTableUI.this.beforeActionPerformed(e);
                try {
                    HRJobStatisticTableUI.this.chkJobFamily_actionPerformed(e);
                }
                catch (Exception exc) {
                    HRJobStatisticTableUI.this.handUIException(exc);
                }
                finally {
                    HRJobStatisticTableUI.this.afterActionPerformed(e);
                }
            }
        });
    }

    protected void chkShowPerson_actionPerformed(ActionEvent e) throws Exception {
        this.tblMain.getViewManager().setFreezeView(0, 0);
        this.infoDynamicTable = new DynamicTableInfo();
        this.createTable();
        this.loadJobData();
        this.tblMain.validate();
    }

    protected void chkShowJobGrade_actionPerformed(ActionEvent e) throws Exception {
        this.tblMain.getViewManager().setFreezeView(0, 0);
        this.infoDynamicTable = new DynamicTableInfo();
        this.createTable();
        this.loadJobData();
        this.tblMain.validate();
    }

    protected void chkJobFamily_actionPerformed(ActionEvent e) throws Exception {
        this.tblMain.getViewManager().setFreezeView(0, 0);
        this.infoDynamicTable = new DynamicTableInfo();
        this.createTable();
        this.loadJobData();
        this.tblMain.validate();
    }

    @Override
    protected void tblMain_tableClicked(KDTMouseEvent e) throws Exception {
        if (e.getType() == 0) {
            return;
        }
        if (e.getType() == 1 && e.getButton() == 1 && e.getClickCount() == 2) {
            int rowIndex = e.getRowIndex();
            int colIndex = e.getColIndex();
            String key = this.tblMain.getColumnKey(colIndex);
            if ((key.equals("jobFamily") || key.equals("jobCategory") || key.equals("jobSubCategory") || key.equals("job")) && !this.chkShowPerson.isSelected()) {
                return;
            }
            IRow row = this.tblMain.getRow(rowIndex);
            String jobId = (String)row.getUserObject();
            String jobGradeId = this.tblMain.getColumn(colIndex).getKey();
            UIContext uiContext = new UIContext((Object)this);
            if ("jobCount".equals(jobGradeId) || "job".equals(jobGradeId)) {
                uiContext.put((Object)"JOBID", (Object)jobId);
                jobGradeId = null;
            } else if ("jobFamily".equals(jobGradeId)) {
                uiContext.put((Object)"JOBFAMILYID", (Object)((String)row.getCell("jobFamily").getUserObject()));
                jobGradeId = null;
            } else if ("jobCategory".equals(jobGradeId)) {
                uiContext.put((Object)"JOBFAMILYID", (Object)((String)row.getCell("jobFamily").getUserObject()));
                uiContext.put((Object)"JOBCATEGORY", (Object)((String)row.getCell("jobCategory").getUserObject()));
                jobGradeId = null;
            } else if ("jobSubCategory".equals(jobGradeId)) {
                uiContext.put((Object)"JOBFAMILYID", (Object)((String)row.getCell("jobFamily").getUserObject()));
                uiContext.put((Object)"JOBCATEGORY", (Object)((String)row.getCell("jobCategory").getUserObject()));
                uiContext.put((Object)"JOBSUBCATEGORY", (Object)((String)row.getCell("jobSubCategory").getUserObject()));
                jobGradeId = null;
            } else {
                uiContext.put((Object)"JOBID", (Object)jobId);
            }
            uiContext.put((Object)"JOBGradeID", (Object)jobGradeId);
            IUIFactory uiFactory = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory");
            IUIWindow curDialog = uiFactory.create(EmpDetailListUI.class.getName(), (Map)uiContext);
            curDialog.show();
        }
    }

    private void initJobGradeList() throws Exception {
        FilterInfo filter = new FilterInfo();
        String cuid = SysContext.getSysContext().getCurrentCtrlUnit().getId().toString();
        filter.getFilterItems().add(new FilterItemInfo("toAdminCU.id", (Object)cuid));
        filter.getFilterItems().add(new FilterItemInfo("jobGradeModuleState.enable", (Object)"1"));
        SorterItemCollection sorterCollection = new SorterItemCollection();
        sorterCollection.add(new SorterItemInfo("grade"));
        EntityViewInfo viewInfo = new EntityViewInfo();
        viewInfo.setFilter(filter);
        viewInfo.setSorter(sorterCollection);
        MetaDataPK mainQueryPK = MetaDataPK.create((String)"com.kingdee.eas.hr.org.app", (String)"JobGradeListQuery");
        IQueryExecutor exec = QueryExecutorFactory.getRemoteInstance((IMetaDataPK)mainQueryPK);
        exec.setObjectView(viewInfo);
        IRowSet rs = exec.executeQuery();
        this.jobGradeList = new ArrayList<JobGradeInfo>();
        JobGradeInfo jobGradeInfo = null;
        while (rs.next()) {
            jobGradeInfo = new JobGradeInfo();
            jobGradeInfo.setId(BOSUuid.read((String)rs.getString("id")));
            jobGradeInfo.setName(rs.getString("name"));
            jobGradeInfo.setNumber(rs.getString("number"));
            this.jobGradeList.add(jobGradeInfo);
        }
    }

    private void initJobJobGradeMap() throws Exception {
        String currCu = SysContext.getSysContext().getCurrentCtrlUnit().getId().toString();
        StringBuffer sb = new StringBuffer();
        sb.append("select fjobid,fjobgradeid ").append("from t_org_position where fjobgradeid>' '");
        IRowSet jobRS = SQLExecutorFactory.getRemoteInstance((String)sb.toString()).executeSQL();
        this.jobJobGradeMap = new HashMap<String, Set<String>>();
        Set<Object> jobGradeSet = null;
        String jobId = null;
        String jobGradeId = null;
        while (jobRS.next()) {
            jobId = jobRS.getString("fjobid");
            jobGradeId = jobRS.getString("fjobgradeid");
            if (this.jobJobGradeMap.containsKey(jobId)) {
                jobGradeSet = this.jobJobGradeMap.get(jobId);
            } else {
                jobGradeSet = new HashSet();
                this.jobJobGradeMap.put(jobId, jobGradeSet);
            }
            jobGradeSet.add(jobGradeId);
        }
    }

    private void initJobDetail() throws Exception {
        MetaDataPK mainQueryPK = MetaDataPK.create((String)"com.kingdee.eas.hr.org.app", (String)"JobSystemTableQuery");
        String currCu = SysContext.getSysContext().getCurrentCtrlUnit().getId().toString();
        EntityViewInfo viewInfo = new EntityViewInfo();
        SorterItemCollection coll = new SorterItemCollection();
        coll.add(new SorterItemInfo("jobFamily.number"));
        coll.add(new SorterItemInfo("jobCategory.number"));
        coll.add(new SorterItemInfo("jobSubCategory.number"));
        coll.add(new SorterItemInfo("number"));
        viewInfo.setSorter(coll);
        IQueryExecutor exec = QueryExecutorFactory.getRemoteInstance((IMetaDataPK)mainQueryPK);
        exec.setObjectView(viewInfo);
        IRowSet rs = exec.executeQuery();
        this.jobDetailList = new ArrayList<JobDetailInfo>();
        JobDetailInfo jobDetailInfo = null;
        while (rs.next()) {
            jobDetailInfo = new JobDetailInfo();
            jobDetailInfo.jobFamilyName = rs.getString("jobFamily.name");
            jobDetailInfo.jobFamilyId = rs.getString("jobFamily.id");
            jobDetailInfo.jobCategoryId = rs.getString("jobCategory.id");
            jobDetailInfo.jobCategoryName = rs.getString("jobCategory.name");
            jobDetailInfo.jobSubCateId = rs.getString("jobSubCategory.id");
            jobDetailInfo.jobSubCateName = rs.getString("jobSubCategory.name");
            jobDetailInfo.jobName = rs.getString("name");
            jobDetailInfo.jobId = rs.getString("id");
            this.jobDetailList.add(jobDetailInfo);
        }
    }

    private void initChkJobFamily() throws BOSException {
        JobFamilyCollection jobFamilyColl = JobFamilyFactory.getRemoteInstance().getJobFamilyCollection("order by number");
        if (jobFamilyColl != null && jobFamilyColl.size() > 0) {
            DefaultComboBoxModel<String> model = new DefaultComboBoxModel<String>();
            model.addElement(SHRServerResource.getString((String)"com.kingdee.eas.hr.org.HrOrgBizResource", (String)"label35", (Context)SHRContext.getInstance().getContext()));
            for (int i = 0; i < jobFamilyColl.size(); ++i) {
                model.addElement((String)jobFamilyColl.get(i));
            }
            this.chkJobFamily.setModel(model);
            this.chkJobFamily.setSelectedIndex(0);
        }
    }

    protected class JobDetailInfo {
        String jobFamilyId = null;
        String jobCategoryId = null;
        String jobSubCateId = null;
        String jobId = null;
        String jobGradeId = null;
        String jobFamilyName = null;
        String jobCategoryName = null;
        String jobSubCateName = null;
        String jobGradeName = null;
        String jobName = null;

        protected JobDetailInfo() {
        }
    }
}

