/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.org.client;

import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.dao.query.SQLExecutorFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.sql.KSqlUtil;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.org.HROrgUnitInfo;
import com.kingdee.eas.basedata.org.JobCategoryInfo;
import com.kingdee.eas.basedata.org.JobInfo;
import com.kingdee.eas.basedata.org.JobSystemInfo;
import com.kingdee.eas.basedata.org.client.tree.JobCategoryNodeInfo;
import com.kingdee.eas.basedata.org.client.tree.JobCategoryTreeBuilder;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.FrameWorkUtils;
import com.kingdee.eas.framework.client.tree.KDTreeNode;
import com.kingdee.eas.hr.base.HRInitFactory;
import com.kingdee.eas.hr.base.IHRInit;
import com.kingdee.eas.hr.org.IJobGrade;
import com.kingdee.eas.hr.org.JobGradeCollection;
import com.kingdee.eas.hr.org.JobGradeFactory;
import com.kingdee.eas.hr.org.JobGradeInfo;
import com.kingdee.eas.hr.org.JobLevelCollection;
import com.kingdee.eas.hr.org.JobLevelFactory;
import com.kingdee.eas.hr.org.JobLevelInfo;
import com.kingdee.eas.hr.org.client.AbstractJobSystemTableSetUI;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.swing.Action;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.tree.TreePath;
import org.apache.log4j.Logger;

public class JobSystemTableSetUI
extends AbstractJobSystemTableSetUI {
    private static final Logger logger = CoreUIObject.getLogger(JobSystemTableSetUI.class);
    private final String resClass = "com.kingdee.eas.hr.org.client.JobResource.";
    private JobCategoryNodeInfo nodeInfo = null;
    private int groupModel = 0;
    private int baseLevel = 0;
    private HashMap map = null;
    private JobCategoryTreeBuilder treeBuilder = null;
    private Set<Integer> changeCellSet = null;

    public void onLoad() throws Exception {
        IHRInit iHR = HRInitFactory.getRemoteInstance();
        this.groupModel = iHR.getJobSystemScheme();
        super.onLoad();
        this.initTree();
        this.tHelper.getDisabledTables().add(this.tblMain);
        this.tHelper.setCanSetTable(false);
        this.tblMain.getActionMap().remove("Paste");
        this.tblMain.getActionMap().remove("Cut");
        this.tblMain.getActionMap().remove("Delete");
        this.tblMain.getActionMap().put("Delete", (Action)((Object)new AbstractJobSystemTableSetUI.ActionDel((IUIObject)this)));
    }

    protected void initTree() throws Exception {
        this.treeMain.setModel(null);
        JobSystemInfo jobSystemInfo = new JobSystemInfo();
        jobSystemInfo.setId(BOSUuid.read((String)"00000000-0000-0000-0000-0000000000017D16BC74"));
        this.treeBuilder = new JobCategoryTreeBuilder(jobSystemInfo, 2, 1, SysContext.getSysContext().getCurrentCtrlUnit().getId().toString());
        this.treeBuilder.buildTree((JTree)this.treeMain);
        if (((KDTreeNode)this.treeMain.getModel().getRoot()).getChildCount() == 0) {
            this.treeMain.setSelectionNode((DefaultKingdeeTreeNode)((KDTreeNode)this.treeMain.getModel().getRoot()));
        } else {
            this.treeMain.setSelectionNode((DefaultKingdeeTreeNode)((KDTreeNode)((KDTreeNode)this.treeMain.getModel().getRoot()).getChildAt(0)));
        }
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    @Override
    protected void tblMain_editValueChanged(KDTEditEvent e) throws Exception {
    }

    @Override
    protected void tblMain_editStopped(KDTEditEvent e) throws Exception {
        Object old = e.getOldValue();
        Object newValue = e.getValue();
        boolean isChange = false;
        if (old != null || newValue != null) {
            if (old == null || newValue == null) {
                isChange = true;
            } else if (!old.toString().equals(newValue.toString())) {
                isChange = true;
            }
        }
        if (isChange) {
            int colIndex = e.getColIndex();
            int rowIndex = e.getRowIndex();
            int cols = this.tblMain.getColumnCount();
            int cellIndex = cols * rowIndex + colIndex;
            if (this.changeCellSet == null) {
                this.changeCellSet = new HashSet<Integer>();
            }
            this.changeCellSet.add(cellIndex);
        }
    }

    @Override
    protected void treeMain_valueChanged(TreeSelectionEvent e) throws Exception {
        TreePath path;
        Object obj;
        if (this.changeCellSet != null && this.changeCellSet.size() > 0) {
            int reslut = MsgBox.showConfirm3((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Confirm_Save_Check"));
            if (MsgBox.isYes((int)reslut)) {
                this.actionSave_actionPerformed(null);
            } else if (MsgBox.isNo((int)reslut)) {
                this.changeCellSet.clear();
            } else {
                return;
            }
        }
        if (!((obj = (path = e.getPath()).getLastPathComponent()) instanceof KDTreeNode)) {
            return;
        }
        KDTreeNode treenode = (KDTreeNode)obj;
        if (treenode.getUserObject() instanceof JobCategoryNodeInfo) {
            this.nodeInfo = (JobCategoryNodeInfo)treenode.getUserObject();
            this.loadTableData(this.nodeInfo.getJobCategoryInfo());
        } else {
            this.loadTableData(null);
        }
    }

    @Override
    public void actionRefresh_actionPerformed(ActionEvent e) throws Exception {
        Object obj;
        if (this.changeCellSet != null && this.changeCellSet.size() > 0) {
            int reslut = MsgBox.showConfirm3((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Confirm_Save_Check"));
            if (MsgBox.isYes((int)reslut)) {
                this.actionSave_actionPerformed(e);
            } else if (MsgBox.isNo((int)reslut)) {
                this.changeCellSet.clear();
            } else {
                return;
            }
        }
        if (!((obj = this.treeMain.getLastSelectedPathComponent()) instanceof KDTreeNode)) {
            return;
        }
        int[] rows = this.treeMain.getSelectionRows();
        if (rows != null && rows.length > 1) {
            this.treeMain.setSelectionNode((DefaultKingdeeTreeNode)((KDTreeNode)this.treeMain.getModel().getRoot()));
        } else {
            KDTreeNode treenode = (KDTreeNode)obj;
            if (treenode.getUserObject() instanceof JobCategoryNodeInfo) {
                this.nodeInfo = (JobCategoryNodeInfo)treenode.getUserObject();
                this.loadTableData(this.nodeInfo.getJobCategoryInfo());
            } else {
                this.loadTableData(null);
            }
        }
    }

    @Override
    public void actionSave_actionPerformed(ActionEvent e) throws Exception {
        if (this.changeCellSet == null || this.changeCellSet.size() == 0) {
            return;
        }
        Iterator<Integer> iter = this.changeCellSet.iterator();
        int cols = this.tblMain.getColumnCount();
        HROrgUnitInfo hrOrgInfo = SysContext.getSysContext().getCurrentHRUnit();
        JobGradeInfo jobGradeInfo = null;
        String jobID = null;
        JobLevelInfo jobLevelInfo = null;
        String jobLevelName = null;
        JobLevelCollection addLevelColl = null;
        JobLevelCollection updateLevelColl = null;
        ArrayList<String> pkList = null;
        while (iter.hasNext()) {
            int cellIndex = iter.next();
            int rowIndex = cellIndex / cols;
            int colIndex = cellIndex % cols;
            jobGradeInfo = (JobGradeInfo)this.tblMain.getRow(rowIndex).getUserObject();
            jobID = this.tblMain.getColumn(colIndex).getKey();
            jobLevelName = (String)this.tblMain.getCell(rowIndex, colIndex).getValue();
            jobLevelInfo = (JobLevelInfo)this.tblMain.getCell(rowIndex, colIndex).getUserObject();
            if (jobLevelInfo == null) {
                if (StringUtils.isEmpty((String)jobLevelName)) continue;
                jobLevelInfo = new JobLevelInfo();
                jobLevelInfo.setJobGrade(jobGradeInfo);
                jobLevelInfo.setHrOrgUnit(hrOrgInfo);
                jobLevelInfo.setCU(SysContext.getSysContext().getCurrentCtrlUnit());
                jobLevelInfo.setName(jobLevelName);
                jobLevelInfo.setNumber(jobLevelName);
                if (addLevelColl == null) {
                    addLevelColl = new JobLevelCollection();
                }
                addLevelColl.add(jobLevelInfo);
                continue;
            }
            if (!StringUtils.isEmpty((String)jobLevelName)) {
                jobLevelInfo.setName(jobLevelName);
                jobLevelInfo.setNumber(jobLevelName);
                jobLevelInfo.setJobGrade(jobGradeInfo);
                jobLevelInfo.setHrOrgUnit(hrOrgInfo);
                jobLevelInfo.setCU(SysContext.getSysContext().getCurrentCtrlUnit());
                if (updateLevelColl == null) {
                    updateLevelColl = new JobLevelCollection();
                }
                updateLevelColl.add(jobLevelInfo);
                continue;
            }
            if (pkList == null) {
                pkList = new ArrayList<String>();
            }
            pkList.add(jobLevelInfo.getId().toString());
        }
        HashMap<String, Object> jobLevelMap = new HashMap<String, Object>();
        if (addLevelColl != null) {
            jobLevelMap.put("ADDNEW", (Object)addLevelColl);
        }
        if (updateLevelColl != null) {
            jobLevelMap.put("UPDATE", (Object)updateLevelColl);
        }
        if (pkList != null) {
            jobLevelMap.put("DELETE", pkList);
        }
        JobLevelFactory.getRemoteInstance().batchSaveJobLevel(jobLevelMap);
        String res = EASResource.getString((String)"com.kingdee.eas.hr.org.ORGAutoGenerateResource", (String)"Msg_Save_OK_New");
        this.showMessage(res);
        this.changeCellSet.clear();
        this.actionRefresh_actionPerformed(e);
    }

    @Override
    public void actionDel_actionPerformed(ActionEvent e) throws Exception {
        KDTSelectBlock sb = null;
        int size = this.tblMain.getSelectManager().size();
        if (size > 0 && !MsgBox.isYes((int)MsgBox.showConfirm2((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Confirm_Delete")))) {
            return;
        }
        ICell cell = null;
        JobLevelInfo jobLevelInfo = null;
        ArrayList<String> pkList = new ArrayList<String>();
        int rows = this.tblMain.getRowCount();
        int cols = this.tblMain.getColumnCount();
        for (int i = 0; i < size; ++i) {
            sb = this.tblMain.getSelectManager().get(i);
            int left = 0;
            int right = 0;
            int top = 0;
            int bottom = 0;
            if (sb.getMode() == 1) {
                left = sb.getLeft() == 0 ? 1 : sb.getLeft();
                right = sb.getRight();
                top = sb.getTop();
                bottom = sb.getBottom();
            } else if (sb.getMode() == 2) {
                left = 1;
                right = cols - 1;
                top = sb.getTop();
                bottom = sb.getBottom();
            } else if (sb.getMode() == 4) {
                left = sb.getLeft() == 0 ? 1 : sb.getLeft();
                right = sb.getRight();
                top = 0;
                bottom = rows - 1;
            } else if (sb.getMode() == 8) {
                left = 1;
                right = cols - 1;
                top = 0;
                bottom = rows - 1;
            }
            for (int x = top; x <= bottom; ++x) {
                for (int y = left; y <= right; ++y) {
                    cell = this.tblMain.getCell(x, y);
                    jobLevelInfo = (JobLevelInfo)cell.getUserObject();
                    if (jobLevelInfo != null) {
                        pkList.add(jobLevelInfo.getId().toString());
                        cell.setUserObject(null);
                    }
                    cell.setValue(null);
                    if (this.changeCellSet == null) continue;
                    int cellIndex = cols * x + y;
                    this.changeCellSet.remove(cellIndex);
                }
            }
        }
        if (pkList != null && pkList.size() > 0) {
            HashMap<String, ArrayList<String>> jobLevelMap = new HashMap<String, ArrayList<String>>();
            jobLevelMap.put("DELETE", pkList);
            JobLevelFactory.getRemoteInstance().batchSaveJobLevel(jobLevelMap);
            this.showMessage(EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_DelVoucherSuccess"));
        }
        if (this.changeCellSet != null) {
            // empty if block
        }
    }

    private HashMap getJobLevelGradeData() throws Exception {
        HashMap<String, JobLevelInfo> mapData = new HashMap<String, JobLevelInfo>();
        MetaDataPK queryPK = new MetaDataPK("com.kingdee.eas.hr.org.app.JobGradeLevelSystemQuery");
        IQueryExecutor queryExcu = QueryExecutorFactory.getRemoteInstance((IMetaDataPK)queryPK);
        FilterInfo filter = new FilterInfo();
        EntityViewInfo eiv = new EntityViewInfo();
        filter.getFilterItems().add(new FilterItemInfo("JobGrade.grade", null, CompareType.NOTEQUALS));
        filter.getFilterItems().add(new FilterItemInfo("jobGradeModuleState.enable", (Object)"1"));
        eiv.setFilter(filter);
        queryExcu.setObjectView(eiv);
        String sql = KSqlUtil.optimize((String)queryExcu.getSQL());
        IRowSet rows = SQLExecutorFactory.getRemoteInstance((String)sql).executeSQL();
        String job = null;
        String level = null;
        String grade = null;
        JobLevelInfo jobLevelInfo = null;
        while (rows.next()) {
            job = rows.getString("id");
            grade = rows.getString("JobGrade.id");
            level = rows.getString("JobLevel.name");
            jobLevelInfo = new JobLevelInfo();
            jobLevelInfo.setId(BOSUuid.read((String)rows.getString("JobLevel.id")));
            jobLevelInfo.setName(rows.getString("JobLevel.name"));
            jobLevelInfo.setNumber(rows.getString("JobLevel.number"));
            mapData.put(job + grade, jobLevelInfo);
        }
        return mapData;
    }

    private EntityViewInfo getJobGradeEnt() {
        String cuid = SysContext.getSysContext().getCurrentCtrlUnit().getId().toString();
        EntityViewInfo env = new EntityViewInfo();
        String enableJobTable = "select FJobGradeModule from T_HR_JobGradeModuleState where FEnable='1' and FToAdminCUID='" + cuid + "'";
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("jobGradeModule.id", (Object)enableJobTable, CompareType.INNER));
        env.setFilter(filter);
        env.getSelector().add(new SelectorItemInfo("id"));
        env.getSelector().add(new SelectorItemInfo("name"));
        env.getSelector().add(new SelectorItemInfo("jobGradeModule.id"));
        env.getSorter().add(new SorterItemInfo("grade"));
        return env;
    }

    private void loadTableData(JobCategoryInfo jobCat) throws Exception {
        this.loadHeadData(jobCat);
        IJobGrade iJobGrade = JobGradeFactory.getRemoteInstance();
        JobGradeCollection gradeColl = iJobGrade.getJobGradeCollection(this.getJobGradeEnt());
        int size = gradeColl.size();
        for (int i = 0; i < size; ++i) {
            this.tblMain.addRow();
            this.tblMain.getRow(i).setUserObject((Object)gradeColl.get(i));
            this.tblMain.getRow(i).getCell(0).setValue((Object)gradeColl.get(i).getName());
        }
        this.tblMain.getColumn(0).getStyleAttributes().setBackground(new Color(217, 217, 210));
        this.tblMain.getColumn(0).getStyleAttributes().setLocked(true);
        Object obj = null;
        JobGradeInfo jobGradeInfo = null;
        HashMap mapData = this.getJobLevelGradeData();
        int length = this.tblMain.getRowCount();
        for (int i = 0; i < length; ++i) {
            jobGradeInfo = (JobGradeInfo)this.tblMain.getRow(i).getUserObject();
            int size2 = this.tblMain.getColumnCount();
            for (int j = 1; j < size2; ++j) {
                obj = mapData.get(this.tblMain.getColumn(j).getKey() + jobGradeInfo.getId().toString());
                if (obj == null) continue;
                this.tblMain.getRow(i).getCell(j).setValue((Object)((JobLevelInfo)obj).getName());
                this.tblMain.getRow(i).getCell(j).setUserObject(obj);
            }
        }
    }

    private void loadHeadData(JobCategoryInfo jobCat) throws Exception {
        this.map = new HashMap();
        DefaultKingdeeTreeNode rootNode = this.treeBuilder.buildJobSystemNode(jobCat, true);
        JobCategoryInfo jobCatInfo = (JobCategoryInfo)rootNode.getUserObject();
        this.tblMain.removeColumns();
        this.tblMain.removeHeadRows();
        this.tblMain.removeRows();
        int headRowSize = rootNode.getDepth() + 1;
        int headColumnSize = jobCatInfo.getLevel() + 1;
        this.tblMain.addHeadRows(headRowSize);
        this.tblMain.addColumns(headColumnSize);
        String headStr = EASResource.getString((String)"com.kingdee.eas.hr.org.client.JobResource.GRADE_LEVEL_JOB");
        for (int i = 0; i < headRowSize; ++i) {
            this.tblMain.getHeadRow(i).getCell(0).setValue((Object)headStr);
        }
        this.baseLevel = rootNode.getLevel();
        this.map.put(this.baseLevel, 1);
        this.buildTableHead(rootNode);
        this.tblMain.getHeadMergeManager().setMergeMode(3);
        this.tblMain.getHeadMergeManager().mergeBlockEx(0, 0, headRowSize - 1, headColumnSize - 1, 3);
    }

    private void buildTableHead(DefaultKingdeeTreeNode rootNode) {
        int i;
        int size;
        JobCategoryInfo jobCatInfo = null;
        int tempIndex = 1;
        if (rootNode.getLevel() == this.baseLevel) {
            tempIndex = Integer.valueOf(this.map.get(this.baseLevel).toString());
            if (rootNode.getUserObject() instanceof JobInfo) {
                JobInfo jobInfo = (JobInfo)rootNode.getUserObject();
                this.tblMain.getColumn(tempIndex).setKey(jobInfo.getId().toString());
                int size2 = this.tblMain.getHeadRowCount();
                for (int i2 = rootNode.getLevel(); i2 < size2; ++i2) {
                    this.tblMain.getHeadRow(i2).getCell(tempIndex).setValue((Object)jobInfo);
                    this.map.put(i2, tempIndex + 1);
                }
                return;
            }
            jobCatInfo = (JobCategoryInfo)rootNode.getUserObject();
            size = jobCatInfo.getLevel();
            for (i = 0; i < size; ++i) {
                this.tblMain.getHeadRow(rootNode.getLevel()).getCell(tempIndex + i).setValue((Object)jobCatInfo);
            }
            this.map.put(this.baseLevel, tempIndex += jobCatInfo.getLevel());
        } else {
            this.baseLevel = rootNode.getLevel();
            tempIndex = this.map.get(this.baseLevel) != null ? Integer.valueOf(this.map.get(this.baseLevel).toString()) : 1;
            if (rootNode.getUserObject() instanceof JobInfo) {
                JobInfo jobInfo = (JobInfo)rootNode.getUserObject();
                this.tblMain.getColumn(tempIndex).setKey(jobInfo.getId().toString());
                int size3 = this.tblMain.getHeadRowCount();
                for (int i3 = rootNode.getLevel(); i3 < size3; ++i3) {
                    this.tblMain.getHeadRow(i3).getCell(tempIndex).setValue((Object)jobInfo.getName());
                    this.map.put(i3, tempIndex + 1);
                }
                return;
            }
            jobCatInfo = (JobCategoryInfo)rootNode.getUserObject();
            size = jobCatInfo.getLevel();
            for (i = 0; i < size; ++i) {
                this.tblMain.getHeadRow(rootNode.getLevel()).getCell(tempIndex + i).setValue((Object)jobCatInfo);
            }
            this.map.put(this.baseLevel, tempIndex += jobCatInfo.getLevel());
        }
        for (i = 0; i < rootNode.getChildCount(); ++i) {
            this.buildTableHead((DefaultKingdeeTreeNode)rootNode.getChildAt(i));
        }
    }

    protected void showMessage(String message) {
        String entityName = FrameWorkUtils.getClassAlias((CoreBaseInfo)new JobLevelInfo());
        this.setMessageText(entityName + "" + message);
        this.setShowMessagePolicy(0);
        this.showMessage();
    }
}

