/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.org.client;

import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.commonquery.client.CustomerParams;
import com.kingdee.eas.basedata.org.HierarchyCollection;
import com.kingdee.eas.basedata.org.HierarchyFactory;
import com.kingdee.eas.basedata.org.HierarchyInfo;
import com.kingdee.eas.basedata.org.IHierarchy;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.hr.org.client.AbstractOrgCharFilterUI;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import org.apache.log4j.Logger;

public class OrgCharFilterUI
extends AbstractOrgCharFilterUI {
    private static final Logger logger = CoreUIObject.getLogger(OrgCharFilterUI.class);

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.loadHierarchyData();
    }

    public void clear() {
        super.clear();
        this.cboDisplayType.setSelectedIndex(0);
        this.cboHierarchy.setSelectedIndex(0);
        this.cboLevel.setSelectedIndex(2);
        this.chkDisplayPP.setSelected(false);
        this.chkIncludeVirtualOrg.setSelected(true);
    }

    public void setCustomerParams(CustomerParams param) {
        super.setCustomerParams(param);
        if (param == null) {
            return;
        }
        if (param.getCustomerParam("Hierarchy_ID") != null) {
            ObjectUuidPK pk = new ObjectUuidPK(BOSUuid.read((String)param.getCustomerParam("Hierarchy_ID")));
            try {
                HierarchyInfo hInfo = HierarchyFactory.getRemoteInstance().getHierarchyInfo((IObjectPK)pk);
                this.cboHierarchy.setSelectedItem((Object)hInfo);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (param.getBoolean("DisplayType")) {
            this.cboDisplayType.setSelectedIndex(0);
        } else {
            this.cboDisplayType.setSelectedIndex(1);
        }
        this.cboLevel.setSelectedIndex(param.getInt("Level") - 1);
        this.chkDisplayPP.setSelected(param.getBoolean("DisplayPP"));
        this.chkIncludeVirtualOrg.setSelected(param.getBoolean("IncludeVirtualOrg"));
    }

    public CustomerParams getCustomerParams() {
        CustomerParams params = new CustomerParams();
        if (this.cboHierarchy.getSelectedItem() != null) {
            params.addCustomerParam("Hierarchy_ID", ((HierarchyInfo)this.cboHierarchy.getSelectedItem()).getId().toString());
        }
        if (this.cboDisplayType.getSelectedItem() != null) {
            if (this.cboDisplayType.getSelectedIndex() == 0) {
                params.putBoolean("DisplayType", true);
            } else {
                params.putBoolean("DisplayType", false);
            }
        }
        if (this.cboLevel.getSelectedItem() != null) {
            params.putInt("Level", this.cboLevel.getSelectedIndex() + 1);
        }
        params.putBoolean("DisplayPP", this.chkDisplayPP.isSelected());
        params.putBoolean("IncludeVirtualOrg", this.chkIncludeVirtualOrg.isSelected());
        return params;
    }

    private void loadHierarchyData() throws Exception {
        IHierarchy iHierarchy = HierarchyFactory.getRemoteInstance();
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(this.getCUFilterForQuery());
        SorterItemInfo sortInfo = new SorterItemInfo("isDefault");
        sortInfo.setSortType(SortType.DESCEND);
        evi.getSorter().add(sortInfo);
        HierarchyCollection hierarchyCollection = iHierarchy.getHierarchyCollection(evi);
        this.cboHierarchy.removeAllItems();
        for (int i = 0; i < hierarchyCollection.size(); ++i) {
            this.cboHierarchy.addItem((Object)hierarchyCollection.get(i));
        }
        this.cboHierarchy.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                try {
                    if (OrgCharFilterUI.this.cboHierarchy.getSelectedIndex() == 0) {
                        OrgCharFilterUI.this.chkIncludeVirtualOrg.setVisible(true);
                    } else {
                        OrgCharFilterUI.this.chkIncludeVirtualOrg.setVisible(false);
                    }
                }
                catch (Exception exc) {
                    OrgCharFilterUI.this.handUIException(exc);
                }
            }
        });
    }

    protected FilterInfo getCUFilterForQuery() {
        FilterInfo filter = new FilterInfo();
        if (SysContext.getSysContext().getCurrentCtrlUnit() == null) {
            return filter;
        }
        filter.getFilterItems().add(new FilterItemInfo("CU.id", (Object)SysContext.getSysContext().getCurrentCtrlUnit().getId().toString(), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("CU.id", (Object)"11111111-1111-1111-1111-111111111111CCE7AED4", CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("CU.id", (Object)"00000000-0000-0000-0000-000000000000CCE7AED4", CompareType.EQUALS));
        filter.setMaskString("#0 or #1 or #2");
        return filter;
    }
}

