/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.org.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.KDTStyleConstants;
import com.kingdee.bos.ctrl.swing.KDDBntScrollBar;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.KDScrollPane;
import com.kingdee.bos.ctrl.swing.KDTree;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.ctrl.swing.util.CtrlSwingUtilities;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIFactory;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIException;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.base.uiframe.client.GetDataDialog;
import com.kingdee.eas.base.uiframe.client.GetDataTaskAdapter;
import com.kingdee.eas.basedata.org.CtrlUnitCollection;
import com.kingdee.eas.basedata.org.CtrlUnitFactory;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.OrgStructureFactory;
import com.kingdee.eas.basedata.org.client.OrgInnerUtils;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.DataBaseInfo;
import com.kingdee.eas.framework.DeletedStatusEnum;
import com.kingdee.eas.hr.org.AdminOrgUnitVerFactory;
import com.kingdee.eas.hr.org.AdminOrgUnitVerInfo;
import com.kingdee.eas.hr.org.EnableStateEnum;
import com.kingdee.eas.hr.org.HROrgAdjSchmFactory;
import com.kingdee.eas.hr.org.HROrgAdjSchmInfo;
import com.kingdee.eas.hr.org.HROrgVersionFacadeFactory;
import com.kingdee.eas.hr.org.IHROrgVersionFacade;
import com.kingdee.eas.hr.org.IPositionVer;
import com.kingdee.eas.hr.org.OrgAdjSchmVerException;
import com.kingdee.eas.hr.org.OrgStateTypeEnum;
import com.kingdee.eas.hr.org.PosStateTypeEnum;
import com.kingdee.eas.hr.org.PositionVerFactory;
import com.kingdee.eas.hr.org.PositionVerInfo;
import com.kingdee.eas.hr.org.client.AbstractOrgPositionVerListUI;
import com.kingdee.eas.hr.org.client.AdminOrgUnitVerEidtUI;
import com.kingdee.eas.hr.org.client.HROrgAdjSchmListUI;
import com.kingdee.eas.hr.org.client.HROrgVerSortSettingUI;
import com.kingdee.eas.hr.org.client.HRPositionVerSortUI;
import com.kingdee.eas.hr.org.client.OrgAdjSchmSaveUI;
import com.kingdee.eas.hr.org.client.OrgVerCtrlUnitF7PromptBox;
import com.kingdee.eas.hr.org.client.PositionVerEidtUI;
import com.kingdee.eas.hr.org.client.ReplaceAdminOrgVerSelectUI;
import com.kingdee.eas.hr.org.client.tree.AdminPositionVerTreeBuilder;
import com.kingdee.eas.hr.org.client.tree.HROrgVerDnDTree;
import com.kingdee.eas.hr.org.client.tree.OrgVerTreeDragSource;
import com.kingdee.eas.hr.org.client.tree.OrgVerTreeDropTarget;
import com.kingdee.eas.hr.org.client.tree.OrgVerTreeUtil;
import com.kingdee.eas.hr.org.client.tree.TableTransferHandler;
import com.kingdee.eas.hr.org.table.HRDragTable;
import com.kingdee.eas.hr.org.util.OrgUnitVerAdjConstant;
import com.kingdee.eas.hr.org.util.OrgUnitVerPositionUtil;
import com.kingdee.eas.hr.org.util.OrgVerAdjUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.ItemEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JScrollBar;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.LineBorder;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.apache.log4j.Logger;

public class OrgPositionVerListUI
extends AbstractOrgPositionVerListUI {
    private static final long serialVersionUID = -4697626733251070087L;
    private static final Logger logger = CoreUIObject.getLogger(OrgPositionVerListUI.class);
    HRDragTable tblMain;
    private DefaultKingdeeTreeNode curSelectNode;
    protected AdminOrgUnitVerInfo adminInfo = null;
    protected PositionVerInfo positionInfo = null;
    protected String currentTreeSelectId = null;
    private HROrgAdjSchmInfo curOrgAdjSchm = null;
    private CtrlUnitInfo currentCU = null;
    protected EntityViewInfo mainQuery = new EntityViewInfo();
    protected Map clickTreeNodeMap = new HashMap();
    private String quickSearchDefault = null;
    private String quickSearchStr = null;
    public static final String res = "com.kingdee.eas.hr.org.HROrgAdjSchmVerResource";
    OrgVerTreeDropTarget dropTarget = null;
    boolean isFirstEnter = false;
    boolean Permiss_OrgAdjSchm_OrgAdj = false;
    boolean Permiss_OrgAdjSchm_PostionAdj = false;
    boolean Permiss_OrgAdjSchm_PersonAdj = false;

    public OrgPositionVerListUI() throws Exception {
        this.treeMain = new HROrgVerDnDTree();
    }

    public void onLoad() throws Exception {
        super.onLoad();
        boolean hasInit = OrgStructureFactory.getRemoteInstance().hasInitSortCode();
        if (!hasInit) {
            throw new OrgAdjSchmVerException(OrgAdjSchmVerException.NO_INITORGSORTCODE_ERROR);
        }
        this.isFirstEnter = true;
        this.initTableStyle();
        this.initUserPermission();
        this.initTreeDataAndOther();
        this.isFirstEnter = false;
    }

    public void initUserPermission() throws BOSException, EASBizException {
        IHROrgVersionFacade orgVerFacade = HROrgVersionFacadeFactory.getRemoteInstance();
        Map permissionMap = orgVerFacade.getUserPermissionCase();
        this.Permiss_OrgAdjSchm_OrgAdj = (Boolean)permissionMap.get("orgAdjSchm_OrgAdj");
        this.Permiss_OrgAdjSchm_PostionAdj = (Boolean)permissionMap.get("orgAdjSchm_PositionAdj");
        this.Permiss_OrgAdjSchm_PersonAdj = (Boolean)permissionMap.get("orgAdjSchm_PersonAdj");
    }

    private void setAdjOptEntityViewInfo() {
        this.orgPosVerAdjOptQuery = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("orgAdjSchm", (Object)this.curOrgAdjSchm.getId().toString(), CompareType.EQUALS));
        filterInfo.getFilterItems().add(new FilterItemInfo("creator.id", (Object)SysContext.getSysContext().getCurrentUserInfo().getId().toString(), CompareType.EQUALS));
        this.orgPosVerAdjOptQuery.setFilter(filterInfo);
    }

    protected void initWorkButton() {
        this.quickSearchDefault = this.txtSearch.getText();
        this.btnAddNewAdjSchm.setIcon(EASResource.getIcon((String)"imgTbtn_new"));
        this.btnAddAdminOrg.setEnabled(false);
        this.btnSealUpAdminOrg.setEnabled(false);
        this.btnSortSet.setEnabled(false);
        this.btnAddPosition.setEnabled(false);
        this.btnSealUpPosition.setEnabled(false);
        this.btnSortPostion.setEnabled(false);
        this.btnQuickSearch.setIcon(EASResource.getIcon((String)"imgTbtn_find"));
        this.btnRefresh.setIcon(EASResource.getIcon((String)"imgTbtn_refresh"));
        this.txtCurrentVersion.setUnderline(true);
        this.kDBizPromptCU.setEditable(false);
        this.txtSearch.setDragEnabled(false);
    }

    private void initTreeDataAndOther() throws Exception {
        new OrgVerTreeDragSource(this.treeMain, 2);
        this.dropTarget = new OrgVerTreeDropTarget(this.treeMain, this.tblMain, this.tblOptRecoder, this);
        this.dropTarget.initPermissCase(this.Permiss_OrgAdjSchm_OrgAdj, this.Permiss_OrgAdjSchm_PostionAdj, this.Permiss_OrgAdjSchm_PersonAdj);
        this.tblMain.setDragEnabled(true);
        this.tblMain.setTransferHandler(new TableTransferHandler(this.treeMain));
        OrgVerCtrlUnitF7PromptBox prmt = new OrgVerCtrlUnitF7PromptBox((IUIObject)this);
        this.kDBizPromptCU.setSelector((KDPromptSelector)prmt);
        this.kDBizPromptCU.addDataChangeListener(new DataChangeListener(){

            public void dataChanged(DataChangeEvent eventObj) {
                try {
                    OrgPositionVerListUI.this.currentCU = (CtrlUnitInfo)OrgPositionVerListUI.this.kDBizPromptCU.getData();
                    if (OrgPositionVerListUI.this.isFirstEnter) {
                        OrgPositionVerListUI.this.initOrgVerData();
                    } else {
                        OrgPositionVerListUI.this.initTreeData();
                    }
                }
                catch (Exception e) {
                    ExceptionHandler.handle((Throwable)e);
                }
            }
        });
        this.currentCU = SysContext.getSysContext().getCurrentCtrlUnit();
        if (this.currentCU.isIsAdminOrgUnit()) {
            this.kDBizPromptCU.setData((Object)this.currentCU);
        }
        CtrlSwingUtilities.removeManagingFocusForwardTraversalKeys((JComponent)this.txtSearch, (KeyStroke)KeyStroke.getKeyStroke(10, 0));
        this.treeMain.addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2 && OrgPositionVerListUI.this.curSelectNode != null) {
                    try {
                        Object userObject = OrgPositionVerListUI.this.curSelectNode.getUserObject();
                        if (userObject instanceof AdminOrgUnitVerInfo) {
                            OrgPositionVerListUI.this.actionEditAdminOrgUnit_actionPerformed(null);
                        } else if (userObject instanceof PositionVerInfo) {
                            OrgPositionVerListUI.this.actionEditPosition_actionPerformed(null);
                        }
                    }
                    catch (Exception e1) {
                        ExceptionHandler.handle((Throwable)e1);
                    }
                }
            }

            @Override
            public void mouseEntered(MouseEvent e) {
            }

            @Override
            public void mouseExited(MouseEvent e) {
            }

            @Override
            public void mousePressed(MouseEvent e) {
            }

            @Override
            public void mouseReleased(MouseEvent e) {
            }
        });
    }

    private void initTableStyle() throws Exception {
        this.tblMain = new HRDragTable();
        KDScrollPane scrollPane = new KDScrollPane((Component)this.tblMain);
        KDDBntScrollBar kdBar = new KDDBntScrollBar();
        scrollPane.setVerticalScrollBar((JScrollBar)kdBar);
        kdBar.setUnitIncrement(20);
        this.tblMainPanel.add((Component)scrollPane, (Object)"Center");
        Color colorTemp = UIManager.getColor("KDTable.gridLineColor");
        colorTemp = colorTemp != null ? colorTemp : KDTStyleConstants.GRID_LINE_COLOR;
        scrollPane.setBorder((Border)new LineBorder(colorTemp));
        this.tblOptRecoder.getStyleAttributes().setLocked(true);
        this.tblOptRecoder.getSelectManager().setSelectMode(2);
    }

    private void initOrgVerData() throws Exception {
        final IHROrgVersionFacade orgVersionFacade = HROrgVersionFacadeFactory.getRemoteInstance();
        HROrgAdjSchmInfo orgAdjSchm = orgVersionFacade.getExistOrgAdjSchm(this.currentCU.getId().toString());
        if (orgAdjSchm == null) {
            final HashMap<String, Object> paramMap = new HashMap<String, Object>();
            paramMap.put("Current_CU", this.currentCU);
            paramMap.put("Current_OrgAdjSchm", orgAdjSchm);
            com.kingdee.eas.hr.base.client.GetDataDialog dlg = com.kingdee.eas.hr.base.client.GetDataDialog.getInstance((com.kingdee.eas.hr.base.client.GetDataTaskAdapter)new com.kingdee.eas.hr.base.client.GetDataTaskAdapter(){

                public Object exec() throws Exception {
                    OrgPositionVerListUI.this.curOrgAdjSchm = orgVersionFacade.getOrgVerInitData(paramMap);
                    OrgPositionVerListUI.this.refreshOrgAdjSchm(OrgPositionVerListUI.this.curOrgAdjSchm);
                    OrgPositionVerListUI.this.createAdminOrgPositionTree();
                    OrgPositionVerListUI.this.reValidateLayOut();
                    return null;
                }
            });
            dlg.show();
        } else {
            this.curOrgAdjSchm = orgAdjSchm;
            this.refreshOrgAdjSchm(this.curOrgAdjSchm);
            this.initTreeData();
        }
    }

    private void refreshOrgAdjSchm(HROrgAdjSchmInfo orgAdjSchm) {
        this.curOrgAdjSchm = orgAdjSchm;
        this.dropTarget.setCurOrgAdjSchm(orgAdjSchm);
        this.btnAddAdminOrg.setEnabled(false);
        this.btnSealUpAdminOrg.setEnabled(false);
        this.btnAddPosition.setEnabled(false);
        this.btnSealUpPosition.setEnabled(false);
    }

    private void initTreeData() throws Exception {
        GetDataDialog dlg = new GetDataDialog();
        dlg.setTitle(EASResource.getString((String)"com.kingdee.eas.hr.base.HRBasedataResource.GETDATA_TITLE"));
        dlg.setGetDataTask(new GetDataTaskAdapter(){

            public void exec() throws Exception {
                OrgPositionVerListUI.this.createAdminOrgPositionTree();
                OrgPositionVerListUI.this.reValidateLayOut();
            }
        });
        dlg.show();
        HROrgVersionFacadeFactory.getRemoteInstance().requestOrgAdjSchmDataLock(this.curOrgAdjSchm.getId().toString());
    }

    private void createAdminOrgPositionTree() throws Exception {
        AdminPositionVerTreeBuilder treeBuilder = new AdminPositionVerTreeBuilder(this.curOrgAdjSchm, this.currentCU, this.chkShowOrgSealUp.isSelected(), this.chkShowPosSealUp.isSelected());
        DefaultKingdeeTreeNode rootNode = null;
        treeBuilder.buildTree((JTree)this.treeMain, true, true);
        if (this.treeMain.getModel() != null) {
            rootNode = (DefaultKingdeeTreeNode)((DefaultTreeModel)this.treeMain.getModel()).getRoot();
        }
        if (rootNode == null) {
            this.treeMain.setModel(null);
            return;
        }
        if (this.treeMain.getModel() != null) {
            this.treeView.setShowButton(true);
        }
        this.txtCurrentVersion.setText(this.curOrgAdjSchm.getName());
        this.setAdjOptEntityViewInfo();
        this.tblOptRecoder.removeRows();
    }

    private void reValidateLayOut() {
        this.treeMain.revalidate();
        this.treeMain.doLayout();
        this.treeView.revalidate();
        this.treeView.doLayout();
        this.plMain.revalidate();
        this.plMain.doLayout();
    }

    protected boolean switchOrgVerData(HROrgAdjSchmInfo curOrgAdjSchm) throws Exception {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(OrgVerAdjUtil.getUserRangOrgAdjSchmCUFilter(true, curOrgAdjSchm));
        SorterItemInfo sortItem = new SorterItemInfo("longNumber");
        sortItem.setSortType(SortType.ASCEND);
        view.getSorter().add(sortItem);
        view.setFilter(filterInfo);
        CtrlUnitCollection unitInfoColl = CtrlUnitFactory.getRemoteInstance().getCtrlUnitCollection(view);
        if (unitInfoColl.size() == 0) {
            MsgBox.showInfo((String)EASResource.getString((String)res, (String)"No_Permiss_CurOrgAdjSchm_Adj"));
            return false;
        }
        this.curOrgAdjSchm = curOrgAdjSchm;
        this.kDBizPromptCU.setData((Object)unitInfoColl.get(0));
        return true;
    }

    protected void initListener() {
        super.initListener();
        this.treeMain.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                try {
                    OrgPositionVerListUI.this.treeMain_valueChanged(e);
                }
                catch (Exception exc) {
                    OrgPositionVerListUI.this.handUIException(exc);
                }
            }
        });
    }

    protected void treeMain_valueChanged(TreeSelectionEvent e) throws Exception {
        this.tblMain.setTableSeqColumnWidth(0);
        this.curSelectNode = OrgInnerUtils.getSelectTreeNode2((KDTree)this.treeMain);
        if (this.curSelectNode == null || "KDTree".equals(this.curSelectNode.getText())) {
            return;
        }
        this.clickTreeNodeMap.clear();
        if (this.curSelectNode.getUserObject() != null && this.curSelectNode.getUserObject() instanceof AdminOrgUnitVerInfo) {
            this.adminInfo = (AdminOrgUnitVerInfo)this.curSelectNode.getUserObject();
            this.currentTreeSelectId = this.adminInfo.getId().toString();
            if (this.chkOtherPerson.isSelected()) {
                this.clickTreeNodeMap.put("adminOrg", this.adminInfo.getId().toString());
            } else {
                this.clickTreeNodeMap.put("adminOrg", "nodata");
            }
            this.positionInfo = null;
        } else if (this.curSelectNode.getUserObject() != null && this.curSelectNode.getUserObject() instanceof PositionVerInfo) {
            this.positionInfo = (PositionVerInfo)this.curSelectNode.getUserObject();
            this.currentTreeSelectId = this.positionInfo.getId().toString();
            this.clickTreeNodeMap.put("position", this.currentTreeSelectId);
            this.adminInfo = null;
        }
        this.fillTableWithPersonData();
        this.doWithButtonStatus(this.adminInfo);
    }

    private void fillTableWithPersonData() throws EASBizException, BOSException {
        IHROrgVersionFacade orgVerFacade = HROrgVersionFacadeFactory.getRemoteInstance();
        HashMap<String, String> paramMap = new HashMap<String, String>();
        if (this.positionInfo != null) {
            paramMap.put("Current_SelectNode", "position");
        }
        paramMap.put("Current_OrgAdjSchm", this.curOrgAdjSchm.getId().toString());
        paramMap.putAll(this.clickTreeNodeMap);
        paramMap.put("quickSearchStr", this.quickSearchStr);
        List list = orgVerFacade.getpersonCollection(paramMap);
        IRowSet rowSet = (IRowSet)list.get(0);
        this.tblMain.setTableSeqColumnWidth(rowSet.size());
        String id = null;
        String name = null;
        String number = null;
        String positionID = null;
        String orgName = null;
        String posName = null;
        String empTyp = null;
        String orgAdjSchm = this.curOrgAdjSchm.getId().toString();
        String nameColumn = "fname_";
        nameColumn = nameColumn + SysContext.getSysContext().getLocale().toString();
        DefaultTableModel dtm = (DefaultTableModel)this.tblMain.getModel();
        dtm.setRowCount(0);
        dtm.getDataVector().clear();
        int i = 1;
        try {
            while (rowSet.next()) {
                id = rowSet.getString("fid");
                name = rowSet.getString(nameColumn);
                number = rowSet.getString("fnumber");
                positionID = rowSet.getString("fprimaryPosition");
                String personDepID = rowSet.getString("fpersonDep");
                empTyp = rowSet.getString("empTyp");
                orgName = rowSet.getString("orgName");
                posName = rowSet.getString("posName");
                dtm.addRow(new String[]{String.valueOf(i), id, name, number, positionID, personDepID, orgAdjSchm, empTyp, orgName, posName});
                ++i;
            }
        }
        catch (SQLException e) {
            ExceptionHandler.handle((Throwable)e);
        }
    }

    @Override
    public void actionAddAdminOrgUnit_actionPerformed(ActionEvent e) throws Exception {
        if (this.adminInfo != null && (this.adminInfo.getOrgStateType() == OrgStateTypeEnum.Common || this.adminInfo.getOrgStateType() == OrgStateTypeEnum.Wait_Enable)) {
            UIContext uiContext = new UIContext((Object)this);
            uiContext.put((Object)"ID", (Object)this.adminInfo.getId().toString());
            uiContext.put((Object)"Current_SelectNode", (Object)this.adminInfo);
            uiContext.put((Object)"Current_OrgAdjSchm", (Object)this.curOrgAdjSchm);
            IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create("com.kingdee.eas.hr.org.client.AdminOrgUnitVerEidtUI", (Map)uiContext, null, OprtState.ADDNEW);
            uiWindow.show();
            AdminOrgUnitVerEidtUI editUI = (AdminOrgUnitVerEidtUI)uiWindow.getUIObject();
            if (!editUI.isCanceled) {
                AdminOrgUnitVerInfo adminOrg = null;
                List newValList = editUI.getnewValList();
                int size = newValList.size();
                for (int i = 0; i < size; ++i) {
                    adminOrg = (AdminOrgUnitVerInfo)newValList.get(i);
                    if (adminOrg == null) continue;
                    this.refreshOrgTreeAfterAdd(adminOrg);
                }
                OrgVerAdjUtil.writeOptRecoder(this.tblOptRecoder, this.curOrgAdjSchm, newValList.size());
            }
        }
    }

    private void refreshOrgTreeAfterAdd(AdminOrgUnitVerInfo adminOrg) {
        DefaultKingdeeTreeNode treeNode = (DefaultKingdeeTreeNode)this.treeMain.getLastSelectedPathComponent();
        if (treeNode != null) {
            DefaultTreeModel model = (DefaultTreeModel)this.treeMain.getModel();
            DefaultKingdeeTreeNode newChildNode = null;
            Icon companyIcon = EASResource.getIcon((String)"imgTree_company");
            String additionalName = this.getAdditionalName(adminOrg.getName(), OrgUnitVerAdjConstant.Res_Wait_Enable);
            adminOrg.setName(additionalName);
            newChildNode = new DefaultKingdeeTreeNode((Object)adminOrg);
            newChildNode.setCustomIcon(companyIcon);
            model.insertNodeInto((MutableTreeNode)newChildNode, (MutableTreeNode)treeNode, treeNode.getChildCount());
        }
    }

    @Override
    public void actionEditAdminOrgUnit_actionPerformed(ActionEvent e) throws Exception {
        if (!this.Permiss_OrgAdjSchm_OrgAdj) {
            return;
        }
        if (this.adminInfo != null) {
            UIContext uiContext = new UIContext((Object)this);
            uiContext.put((Object)"ID", (Object)this.adminInfo.getId().toString());
            uiContext.put((Object)"Current_SelectNode", (Object)this.adminInfo);
            uiContext.put((Object)"Current_OrgAdjSchm", (Object)this.curOrgAdjSchm);
            uiContext.put((Object)"Current_CU", (Object)this.currentCU);
            IUIWindow uiWindow = null;
            uiWindow = this.curOrgAdjSchm.getEnableStatus() == EnableStateEnum.ENABLE ? UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create("com.kingdee.eas.hr.org.client.AdminOrgUnitVerEidtUI", (Map)uiContext, null, OprtState.VIEW) : UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create("com.kingdee.eas.hr.org.client.AdminOrgUnitVerEidtUI", (Map)uiContext, null, OprtState.EDIT);
            uiWindow.show();
            AdminOrgUnitVerEidtUI editUI = (AdminOrgUnitVerEidtUI)uiWindow.getUIObject();
            AdminOrgUnitVerInfo editAdminOrg = editUI.getEditAdminOrg();
            if (editAdminOrg != null) {
                String additionalName = null;
                if (editAdminOrg.getOrgStateType() == OrgStateTypeEnum.Wait_Enable) {
                    additionalName = this.getAdditionalName(editAdminOrg.getName(), OrgUnitVerAdjConstant.Res_Wait_Enable);
                } else if (editAdminOrg.getOrgStateType() == OrgStateTypeEnum.SealUP) {
                    additionalName = this.getAdditionalName(editAdminOrg.getName(), OrgUnitVerAdjConstant.Res_SealUP);
                } else if (editAdminOrg.getOrgStateType() == OrgStateTypeEnum.Wait_SealUP) {
                    additionalName = this.getAdditionalName(editAdminOrg.getName(), OrgUnitVerAdjConstant.Res_Wait_SealUP);
                }
                editAdminOrg.setName(additionalName);
                this.refreshOrgTreeAfterEdit(editAdminOrg, additionalName);
                OrgVerAdjUtil.writeOptRecoder(this.tblOptRecoder, this.curOrgAdjSchm);
            }
        }
    }

    private void refreshOrgTreeAfterEdit(Object objectInfo, String newName) {
        DefaultKingdeeTreeNode treeNode = (DefaultKingdeeTreeNode)this.treeMain.getLastSelectedPathComponent();
        if (treeNode != null && treeNode.getParent() != null) {
            treeNode.setUserObject(objectInfo);
            if (treeNode.getParent() != null) {
                treeNode.setText(newName);
                ((DefaultTreeModel)this.treeMain.getModel()).reload(treeNode.getParent());
                ((DefaultTreeModel)this.treeMain.getModel()).reload((TreeNode)treeNode);
            } else {
                treeNode.setText(newName);
                ((DefaultTreeModel)this.treeMain.getModel()).reload((TreeNode)treeNode);
            }
        } else if (treeNode != null && treeNode.getParent() == null) {
            treeNode.setText(newName);
            ((DefaultTreeModel)this.treeMain.getModel()).reload((TreeNode)treeNode);
        }
    }

    @Override
    public void actionViewAdminOrgUnit_actionPerformed(ActionEvent e) throws Exception {
        if (this.adminInfo != null) {
            UIContext uiContext = new UIContext((Object)this);
            uiContext.put((Object)"ID", (Object)this.adminInfo.getId().toString());
            uiContext.put((Object)"Current_SelectNode", (Object)this.adminInfo);
            IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create("com.kingdee.eas.hr.org.client.AdminOrgUnitVerEidtUI", (Map)uiContext, null, OprtState.VIEW);
            uiWindow.show();
        }
    }

    @Override
    public void actionSwitchVersion_actionPerformed(ActionEvent e) throws Exception {
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"curOrgAdjSchm", (Object)this.curOrgAdjSchm);
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create("com.kingdee.eas.hr.org.client.HROrgAdjSchmListUI", (Map)uiContext);
        uiWindow.show();
        HROrgAdjSchmListUI adjSchmListUi = (HROrgAdjSchmListUI)uiWindow.getUIObject();
        if (adjSchmListUi.getOrgVerAdjSchm() != null && !this.curOrgAdjSchm.getId().equals((Object)adjSchmListUi.getOrgVerAdjSchm().getId())) {
            boolean sucess = this.switchOrgVerData(adjSchmListUi.getOrgVerAdjSchm());
            if (sucess) {
                this.curOrgAdjSchm = adjSchmListUi.getOrgVerAdjSchm();
            } else {
                return;
            }
        }
        this.curOrgAdjSchm = HROrgAdjSchmFactory.getRemoteInstance().getHROrgAdjSchmInfo((IObjectPK)new ObjectUuidPK(this.curOrgAdjSchm.getId()));
        this.txtCurrentVersion.setText(this.curOrgAdjSchm.getName());
        this.refreshOrgAdjSchm(this.curOrgAdjSchm);
    }

    @Override
    public void actionAddNewAdjSchm_actionPerformed(ActionEvent e) throws Exception {
        String name = this.addNewOrgAdjSchmInfo();
        ((DefaultTableModel)this.tblMain.getModel()).setRowCount(0);
        this.tblOptRecoder.removeRows();
        HashMap<String, CtrlUnitInfo> paramMap = new HashMap<String, CtrlUnitInfo>();
        paramMap.put("Current_CU", this.currentCU);
        paramMap.put("Current_OrgAdjSchm", null);
        if (!StringUtils.isEmpty((String)name)) {
            this.createNewAdjSchm(paramMap, name);
            this.kDBizPromptCU.setData((Object)this.currentCU);
        }
    }

    private void createNewAdjSchm(Map paramMap, String name) {
        final Map paramMapInner = paramMap;
        final String nameInner = name;
        com.kingdee.eas.hr.base.client.GetDataDialog dlg = com.kingdee.eas.hr.base.client.GetDataDialog.getInstance((com.kingdee.eas.hr.base.client.GetDataTaskAdapter)new com.kingdee.eas.hr.base.client.GetDataTaskAdapter(){

            public Object exec() throws Exception {
                OrgPositionVerListUI.this.curOrgAdjSchm = HROrgVersionFacadeFactory.getRemoteInstance().getOrgVerInitData(paramMapInner);
                OrgPositionVerListUI.this.curOrgAdjSchm.setName(nameInner);
                OrgPositionVerListUI.this.curOrgAdjSchm.setNumber(nameInner);
                OrgPositionVerListUI.this.curOrgAdjSchm.setIsSave(1);
                HROrgAdjSchmFactory.getRemoteInstance().save((CoreBaseInfo)OrgPositionVerListUI.this.curOrgAdjSchm);
                OrgPositionVerListUI.this.refreshOrgAdjSchm(OrgPositionVerListUI.this.curOrgAdjSchm);
                OrgPositionVerListUI.this.createAdminOrgPositionTree();
                OrgPositionVerListUI.this.reValidateLayOut();
                return null;
            }
        });
        dlg.show();
    }

    private String addNewOrgAdjSchmInfo() throws UIException, BOSException, EASBizException {
        String name = OrgVerAdjUtil.getTimeName();
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"Owner", (Object)this);
        uiContext.put((Object)"Current_CU", (Object)this.currentCU);
        uiContext.put((Object)"currentAdjSchmName", (Object)name);
        uiContext.put((Object)"isAddNew", (Object)"true");
        IUIFactory uiFactory = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory");
        IUIWindow curDialog = uiFactory.create(OrgAdjSchmSaveUI.class.getName(), (Map)uiContext);
        curDialog.show();
        if (((OrgAdjSchmSaveUI)curDialog.getUIObject()).isCanceled()) {
            name = null;
        } else {
            this.currentCU = ((OrgAdjSchmSaveUI)curDialog.getUIObject()).getCurrentCU();
            name = ((OrgAdjSchmSaveUI)curDialog.getUIObject()).getName();
        }
        return name;
    }

    @Override
    protected void chkOtherPerson_itemStateChanged(ItemEvent e) throws Exception {
        this.treeMain_valueChanged(null);
    }

    @Override
    protected void txtSearch_keyReleased(KeyEvent e) throws Exception {
        if (e.getKeyCode() == 10) {
            this.actionQuickSearch_actionPerformed(null);
        }
    }

    @Override
    public void actionSealUpAdminOrgUnit_actionPerformed(ActionEvent e) throws Exception {
        if (this.adminInfo == null || this.curSelectNode == null) {
            return;
        }
        if (!this.adminInfo.isIsSealUp()) {
            boolean isSystemOrg = AdminOrgUnitVerFactory.getRemoteInstance().isSystemAdminOrg(this.adminInfo.getId().toString());
            if (!isSystemOrg) {
                int confirm = MsgBox.showConfirm2((String)EASResource.getString((String)res, (String)"Del_Org_Confirm"));
                if (confirm == 0) {
                    AdminOrgUnitVerFactory.getRemoteInstance().deleteAdminOrgVerInfo(this.adminInfo);
                    ((DefaultTreeModel)this.treeMain.getModel()).removeNodeFromParent((MutableTreeNode)this.curSelectNode);
                    this.refreshOrgTreeAfterEdit(this.adminInfo, this.adminInfo.getName());
                    OrgVerAdjUtil.writeOptRecoder(this.tblOptRecoder, this.curOrgAdjSchm);
                    this.curSelectNode = null;
                    this.adminInfo = null;
                    this.btnSealUpAdminOrg.setEnabled(false);
                }
            } else {
                UIContext uiContext = new UIContext((Object)this);
                uiContext.put((Object)"Owner", (Object)this);
                uiContext.put((Object)"Current_SelectNode", (Object)this.adminInfo);
                uiContext.put((Object)"Current_CU", (Object)this.currentCU);
                IUIWindow curDialog = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(ReplaceAdminOrgVerSelectUI.class.getName(), (Map)uiContext);
                curDialog.show();
                ReplaceAdminOrgVerSelectUI replaceOrgUI = (ReplaceAdminOrgVerSelectUI)curDialog.getUIObject();
                if (!replaceOrgUI.isCanceled) {
                    AdminOrgUnitVerFactory.getRemoteInstance().sealUp(this.adminInfo, replaceOrgUI.getAdminOrgInfo());
                    this.adminInfo.setOrgStateType(OrgStateTypeEnum.Wait_SealUP);
                    this.adminInfo.setIsSealUp(true);
                    String orgName = this.adminInfo.getName();
                    String additionalName = this.getAdditionalName(orgName, OrgUnitVerAdjConstant.Res_Wait_SealUP);
                    this.adminInfo.setName(additionalName);
                    this.refreshOrgTreeAfterEdit(this.adminInfo, additionalName);
                    OrgVerAdjUtil.writeOptRecoder(this.tblOptRecoder, this.curOrgAdjSchm);
                    this.btnSealUpAdminOrg.setText(OrgUnitVerAdjConstant.Res_Org_UnSealUP);
                }
            }
        } else if (this.adminInfo != null && this.adminInfo.isIsSealUp()) {
            AdminOrgUnitVerFactory.getRemoteInstance().unSealUP(this.adminInfo);
            this.adminInfo.setOrgStateType(OrgStateTypeEnum.Wait_Enable);
            this.adminInfo.setIsSealUp(false);
            String orgName = this.adminInfo.getName();
            String additionalName = null;
            if (orgName.indexOf("(") > 0 && orgName.indexOf(")") > 0) {
                orgName = orgName.substring(0, orgName.lastIndexOf("("));
                additionalName = orgName + "(" + OrgUnitVerAdjConstant.Res_Wait_Enable + ")";
            } else {
                additionalName = this.adminInfo.getName() + "(" + OrgUnitVerAdjConstant.Res_Wait_Enable + ")";
            }
            this.adminInfo.setName(additionalName);
            this.refreshOrgTreeAfterEdit(this.adminInfo, additionalName);
            OrgVerAdjUtil.writeOptRecoder(this.tblOptRecoder, this.curOrgAdjSchm);
            this.btnSealUpAdminOrg.setText(OrgUnitVerAdjConstant.Res_Org_SealUP);
        }
    }

    @Override
    public void actionReverseSealUP_actionPerformed(ActionEvent e) throws Exception {
        if (this.adminInfo != null && this.adminInfo.isIsSealUp()) {
            this.adminInfo.setOrgStateType(OrgStateTypeEnum.Wait_Enable);
            AdminOrgUnitVerFactory.getRemoteInstance().unSealUP(this.adminInfo);
            String orgName = this.adminInfo.getName();
            String additionalName = null;
            if (orgName.indexOf("(") > 0 && orgName.indexOf(")") > 0) {
                orgName = orgName.substring(0, orgName.lastIndexOf("("));
                additionalName = orgName + "(" + OrgUnitVerAdjConstant.Res_Wait_Enable + ")";
            } else {
                additionalName = this.adminInfo.getName() + "(" + OrgUnitVerAdjConstant.Res_Wait_Enable + ")";
            }
            this.adminInfo.setName(additionalName);
            this.refreshOrgTreeAfterEdit(this.adminInfo, additionalName);
            OrgVerAdjUtil.writeOptRecoder(this.tblOptRecoder, this.curOrgAdjSchm);
        }
    }

    public void setCurrentCU(CtrlUnitInfo currentCU) {
        this.currentCU = currentCU;
    }

    @Override
    protected void chkShowOrgSealUp_itemStateChanged(ItemEvent e) throws Exception {
        this.initTreeData();
    }

    @Override
    protected void chkShowPosSealUp_itemStateChanged(ItemEvent e) throws Exception {
        this.initTreeData();
    }

    @Override
    protected void chkParentPosition_itemStateChanged(ItemEvent e) throws Exception {
        this.initTreeData();
    }

    private String getAdditionalName(String orgName, String resouseType) {
        String additionalName = null;
        if (orgName.indexOf("(") > 0 && orgName.indexOf(")") > 0) {
            orgName = orgName.substring(0, orgName.lastIndexOf("("));
            additionalName = orgName + "(" + resouseType + ")";
        } else {
            additionalName = orgName + "(" + resouseType + ")";
        }
        return additionalName;
    }

    @Override
    public void actionQuickSearch_actionPerformed(ActionEvent e) throws Exception {
        this.quickSearchStr = this.txtSearch.getText();
        if (!this.quickSearchStr.equals(this.quickSearchDefault)) {
            this.fillTableWithPersonData();
            this.quickSearchStr = null;
        }
    }

    protected void txtSearch_mouseClicked(MouseEvent e) throws Exception {
        if (!StringUtils.isEmpty((String)this.txtSearch.getText())) {
            if (this.txtSearch.getText().equals(this.quickSearchDefault)) {
                this.txtSearch.setText(null);
            }
        } else {
            this.txtSearch.setText(null);
        }
    }

    @Override
    protected void txtSearch_focusGained(FocusEvent e) throws Exception {
        if (!StringUtils.isEmpty((String)this.txtSearch.getText())) {
            if (this.txtSearch.getText().equals(this.quickSearchDefault)) {
                this.txtSearch.setText(null);
            }
        } else {
            this.txtSearch.setText(null);
        }
    }

    @Override
    protected void txtSearch_focusLost(FocusEvent e) throws Exception {
        if (StringUtils.isEmpty((String)this.txtSearch.getText())) {
            this.txtSearch.setText(this.quickSearchDefault);
        }
    }

    @Override
    public void actionSortSet_actionPerformed(ActionEvent e) throws Exception {
        if (this.adminInfo != null) {
            Map uiContext = this.getUIContext();
            uiContext.put("ID", this.adminInfo.getId().toString());
            uiContext.put("Current_SelectNode", this.adminInfo);
            uiContext.put("Current_OrgAdjSchm", this.curOrgAdjSchm);
            IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create("com.kingdee.eas.hr.org.client.HROrgVerSortSettingUI", uiContext);
            uiWindow.show();
            DataBaseInfo baseInfo = (DataBaseInfo)this.curSelectNode.getUserObject();
            String selectId = baseInfo.getId().toString();
            if (((HROrgVerSortSettingUI)uiWindow.getUIObject()).isUpdate) {
                this.initTreeData();
                DefaultKingdeeTreeNode node = OrgVerTreeUtil.searchTreeNodeById((DefaultKingdeeTreeNode)this.treeMain.getModel().getRoot(), selectId);
                this.treeMain.expandPath(new TreePath(node.getPath()));
                this.treeMain.setSelectionNode(node);
                this.curSelectNode = node;
                OrgVerAdjUtil.writeOptRecoder(this.tblOptRecoder, this.curOrgAdjSchm);
            }
        }
    }

    @Override
    public void actionAddNewPosition_actionPerformed(ActionEvent e) throws Exception {
        if (this.adminInfo != null && (this.adminInfo.getOrgStateType() == OrgStateTypeEnum.Common || this.adminInfo.getOrgStateType() == OrgStateTypeEnum.Wait_Enable)) {
            UIContext uiContext = new UIContext((Object)this);
            uiContext.put((Object)"Current_SelectNode", (Object)this.adminInfo);
            uiContext.put((Object)"Current_OrgAdjSchm", (Object)this.curOrgAdjSchm);
            uiContext.put((Object)"Current_CU", (Object)this.currentCU);
            IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create("com.kingdee.eas.hr.org.client.PositionVerEidtUI", (Map)uiContext, null, OprtState.ADDNEW);
            uiWindow.show();
            PositionVerEidtUI editUI = (PositionVerEidtUI)uiWindow.getUIObject();
            if (!editUI.isCanceled) {
                PositionVerInfo position = null;
                List newValList = editUI.getnewValList();
                int size = newValList.size();
                for (int i = 0; i < size; ++i) {
                    position = (PositionVerInfo)newValList.get(i);
                    if (position == null) continue;
                    this.refreshPositionTreeAfterAdd(position);
                }
                OrgVerAdjUtil.writeOptRecoder(this.tblOptRecoder, this.curOrgAdjSchm, newValList.size());
            }
        }
    }

    private void refreshPositionTreeAfterAdd(PositionVerInfo adminOrg) {
        DefaultKingdeeTreeNode treeNode = (DefaultKingdeeTreeNode)this.treeMain.getLastSelectedPathComponent();
        if (treeNode != null) {
            DefaultTreeModel model = (DefaultTreeModel)this.treeMain.getModel();
            DefaultKingdeeTreeNode newChildNode = null;
            Icon positionIcon = EASResource.getIcon((String)"imgTree_position");
            String additionalName = this.getAdditionalName(adminOrg.getName(), OrgUnitVerAdjConstant.Res_Wait_Enable);
            adminOrg.setName(additionalName);
            newChildNode = new DefaultKingdeeTreeNode((Object)adminOrg);
            newChildNode.setCustomIcon(positionIcon);
            DefaultMutableTreeNode childNode = null;
            int newPosIndex = 0;
            int size = treeNode.getChildCount();
            for (int i = 0; i < size; ++i) {
                childNode = (DefaultMutableTreeNode)treeNode.getChildAt(i);
                if (!(childNode.getUserObject() instanceof PositionVerInfo)) continue;
                ++newPosIndex;
            }
            model.insertNodeInto((MutableTreeNode)newChildNode, (MutableTreeNode)treeNode, newPosIndex);
        }
    }

    @Override
    public void actionEditPosition_actionPerformed(ActionEvent e) throws Exception {
        if (!this.Permiss_OrgAdjSchm_PostionAdj) {
            return;
        }
        this.positionInfo = (PositionVerInfo)this.curSelectNode.getUserObject();
        if (this.positionInfo != null) {
            UIContext uiContext = new UIContext((Object)this);
            uiContext.put((Object)"ID", (Object)this.positionInfo.getId().toString());
            uiContext.put((Object)"Current_SelectNode", (Object)this.adminInfo);
            uiContext.put((Object)"position", (Object)this.positionInfo);
            uiContext.put((Object)"Current_OrgAdjSchm", (Object)this.curOrgAdjSchm);
            uiContext.put((Object)"Current_CU", (Object)this.currentCU);
            IUIWindow uiWindow = null;
            uiWindow = this.curOrgAdjSchm.getEnableStatus() == EnableStateEnum.ENABLE ? UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create("com.kingdee.eas.hr.org.client.PositionVerEidtUI", (Map)uiContext, null, OprtState.VIEW) : UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create("com.kingdee.eas.hr.org.client.PositionVerEidtUI", (Map)uiContext, null, OprtState.EDIT);
            uiWindow.show();
            PositionVerEidtUI editUI = (PositionVerEidtUI)uiWindow.getUIObject();
            if (!editUI.isCanceled) {
                PositionVerInfo position = null;
                position = editUI.getEditPostion();
                if (position != null) {
                    OrgUnitVerPositionUtil.refreshPositionOfOrgTreeNode(this.treeMain, position, position.getAdminOrgUnit(), this.curOrgAdjSchm, this.chkShowPosSealUp.isSelected());
                    OrgVerAdjUtil.writeOptRecoder(this.tblOptRecoder, this.curOrgAdjSchm);
                }
            }
        }
    }

    @Override
    public void actionSealUpPosition_actionPerformed(ActionEvent e) throws Exception {
        if (this.positionInfo == null || this.curSelectNode == null) {
            return;
        }
        IPositionVer iPositionVer = PositionVerFactory.getRemoteInstance();
        if (this.curSelectNode.getChildCount() == 0 && this.positionInfo.getDeletedStatus() == DeletedStatusEnum.NORMAL) {
            boolean isSystemPos = PositionVerFactory.getRemoteInstance().isSystemPosition(this.positionInfo.getId().toString());
            if (!isSystemPos) {
                int confirm = MsgBox.showConfirm2((String)EASResource.getString((String)res, (String)"Del_Pos_Confirm"));
                if (confirm == 0) {
                    iPositionVer.deletePostionVerInfo(this.positionInfo);
                    ((DefaultTreeModel)this.treeMain.getModel()).removeNodeFromParent((MutableTreeNode)this.curSelectNode);
                    this.refreshOrgTreeAfterEdit(this.positionInfo, this.positionInfo.getName());
                    this.curSelectNode = null;
                    this.adminInfo = null;
                    this.btnSealUpPosition.setEnabled(false);
                }
            } else {
                this.positionInfo.setPosStateType(PosStateTypeEnum.Wait_SealUp);
                this.positionInfo.setDeletedStatus(DeletedStatusEnum.DELETED);
                iPositionVer.sealUp(this.positionInfo);
                String orgName = this.positionInfo.getName();
                String additionalName = this.getAdditionalName(orgName, OrgUnitVerAdjConstant.Res_Wait_SealUP);
                this.refreshOrgTreeAfterEdit(this.positionInfo, additionalName);
                OrgVerAdjUtil.writeOptRecoder(this.tblOptRecoder, this.curOrgAdjSchm);
                this.btnSealUpPosition.setText(OrgUnitVerAdjConstant.Res_Pos_UnSealUP);
            }
        } else if (this.positionInfo != null && this.positionInfo.getDeletedStatus() == DeletedStatusEnum.DELETED) {
            this.positionInfo.setPosStateType(PosStateTypeEnum.Wait_Enable);
            iPositionVer.unSealUp(this.positionInfo);
            this.positionInfo.setDeletedStatus(DeletedStatusEnum.NORMAL);
            String orgName = this.positionInfo.getName();
            String additionalName = null;
            if (orgName.indexOf("(") > 0 && orgName.indexOf(")") > 0) {
                orgName = orgName.substring(0, orgName.lastIndexOf("("));
                additionalName = orgName + "(" + OrgUnitVerAdjConstant.Res_Wait_Enable + ")";
            } else {
                additionalName = this.positionInfo.getName() + "(" + OrgUnitVerAdjConstant.Res_Wait_Enable + ")";
            }
            this.refreshOrgTreeAfterEdit(this.positionInfo, additionalName);
            OrgVerAdjUtil.writeOptRecoder(this.tblOptRecoder, this.curOrgAdjSchm);
            this.btnSealUpPosition.setText(OrgUnitVerAdjConstant.Res_Pos_SealUP);
        }
    }

    @Override
    public void actionSortPosition_actionPerformed(ActionEvent e) throws Exception {
        if (this.adminInfo != null && (this.adminInfo.getOrgStateType() == OrgStateTypeEnum.Common || this.adminInfo.getOrgStateType() == OrgStateTypeEnum.Wait_Enable)) {
            UIContext uiContext = new UIContext((Object)this);
            uiContext.put((Object)"Current_SelectNode", (Object)this.adminInfo);
            uiContext.put((Object)"Current_OrgAdjSchm", (Object)this.curOrgAdjSchm);
            uiContext.put((Object)"Current_CU", (Object)this.currentCU);
            IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create("com.kingdee.eas.hr.org.client.HRPositionVerSortUI", (Map)uiContext, null, OprtState.ADDNEW);
            uiWindow.show();
            HRPositionVerSortUI editUI = (HRPositionVerSortUI)uiWindow.getUIObject();
            DataBaseInfo baseInfo = (DataBaseInfo)this.curSelectNode.getUserObject();
            String selectId = baseInfo.getId().toString();
            if (editUI.isUpdate) {
                this.initTreeData();
                DefaultKingdeeTreeNode node = OrgVerTreeUtil.searchTreeNodeById((DefaultKingdeeTreeNode)this.treeMain.getModel().getRoot(), selectId);
                this.treeMain.expandPath(new TreePath(node.getPath()));
                this.treeMain.setSelectionNode(node);
                this.curSelectNode = node;
            }
        }
    }

    @Override
    public void actionRefresh_actionPerformed(ActionEvent e) throws Exception {
        this.initTreeData();
    }

    private void doWithButtonStatus(AdminOrgUnitVerInfo adminVerInfo) {
        if (this.curOrgAdjSchm.getEnableStatus() == EnableStateEnum.ENABLE) {
            this.btnAddAdminOrg.setEnabled(false);
            this.btnSealUpAdminOrg.setEnabled(false);
            this.btnSortSet.setEnabled(false);
            this.btnAddPosition.setEnabled(false);
            this.btnSealUpPosition.setEnabled(false);
            this.btnSortPostion.setEnabled(false);
        } else {
            if (this.adminInfo == null && this.positionInfo == null || this.curSelectNode == null) {
                return;
            }
            if (this.adminInfo != null) {
                if (this.adminInfo.isIsSealUp()) {
                    this.btnAddAdminOrg.setEnabled(false);
                    this.btnSealUpAdminOrg.setEnabled(true);
                    this.btnSealUpAdminOrg.setText(OrgUnitVerAdjConstant.Res_Org_UnSealUP);
                    this.btnSortSet.setEnabled(false);
                    this.btnAddPosition.setEnabled(true);
                    this.btnSealUpPosition.setEnabled(false);
                    this.btnSortPostion.setEnabled(false);
                } else if (this.curSelectNode.getChildCount() == 0) {
                    this.btnAddAdminOrg.setEnabled(true);
                    this.btnSealUpAdminOrg.setEnabled(true);
                    this.btnSealUpAdminOrg.setText(OrgUnitVerAdjConstant.Res_Org_SealUP);
                    this.btnSortSet.setEnabled(false);
                    this.btnAddPosition.setEnabled(true);
                    this.btnSealUpPosition.setEnabled(false);
                    this.btnSortPostion.setEnabled(false);
                } else {
                    this.btnAddAdminOrg.setEnabled(true);
                    if (!this.adminInfo.isIsSealUp()) {
                        this.btnSealUpAdminOrg.setText(OrgUnitVerAdjConstant.Res_Org_SealUP);
                        this.btnSealUpAdminOrg.setEnabled(true);
                    } else {
                        this.btnSealUpAdminOrg.setText(OrgUnitVerAdjConstant.Res_Org_UnSealUP);
                        this.btnSealUpAdminOrg.setEnabled(true);
                    }
                    this.btnSortSet.setEnabled(true);
                    this.btnAddPosition.setEnabled(true);
                    this.btnSealUpPosition.setEnabled(false);
                    this.btnSortPostion.setEnabled(true);
                }
            } else if (this.positionInfo != null) {
                if (this.positionInfo.getDeletedStatus() == DeletedStatusEnum.DELETED) {
                    this.btnAddAdminOrg.setEnabled(false);
                    this.btnSealUpAdminOrg.setEnabled(false);
                    this.btnSortSet.setEnabled(false);
                    this.btnAddPosition.setEnabled(false);
                    this.btnSealUpPosition.setEnabled(true);
                    this.btnSealUpPosition.setText(OrgUnitVerAdjConstant.Res_Pos_UnSealUP);
                    this.btnSortPostion.setEnabled(false);
                } else if (this.tblMain.getRowCount() <= 0) {
                    this.btnAddAdminOrg.setEnabled(false);
                    this.btnSealUpAdminOrg.setEnabled(false);
                    this.btnSortSet.setEnabled(false);
                    this.btnAddPosition.setEnabled(false);
                    this.btnSealUpPosition.setEnabled(true);
                    if (this.positionInfo.getPosStateType() == PosStateTypeEnum.Wait_SealUp || this.positionInfo.getPosStateType() == PosStateTypeEnum.SealUp) {
                        this.btnSealUpPosition.setText(OrgUnitVerAdjConstant.Res_Pos_UnSealUP);
                    } else {
                        this.btnSealUpPosition.setText(OrgUnitVerAdjConstant.Res_Pos_SealUP);
                    }
                    this.btnSortPostion.setEnabled(false);
                } else {
                    this.btnAddAdminOrg.setEnabled(false);
                    this.btnSealUpAdminOrg.setEnabled(false);
                    this.btnSortSet.setEnabled(false);
                    this.btnAddPosition.setEnabled(false);
                    this.btnSealUpPosition.setEnabled(false);
                    this.btnSortPostion.setEnabled(false);
                }
            } else {
                this.btnAddAdminOrg.setEnabled(false);
                this.btnSealUpAdminOrg.setEnabled(false);
                this.btnSortSet.setEnabled(false);
                this.btnAddPosition.setEnabled(false);
                this.btnSealUpPosition.setEnabled(false);
                this.btnSortPostion.setEnabled(false);
            }
        }
        this.doButtonStatusWithPermission();
    }

    public void doButtonStatusWithPermission() {
        if (!this.Permiss_OrgAdjSchm_OrgAdj) {
            this.btnAddAdminOrg.setEnabled(false);
            this.btnSealUpAdminOrg.setEnabled(false);
            this.btnSortSet.setEnabled(false);
        }
        if (!this.Permiss_OrgAdjSchm_PostionAdj) {
            this.btnAddPosition.setEnabled(false);
            this.btnSealUpPosition.setEnabled(false);
            this.btnSortPostion.setEnabled(false);
        }
    }

    protected boolean checkBeforeWindowClosing() {
        try {
            DelInvalidDataThread delThread = new DelInvalidDataThread();
            delThread.start();
        }
        catch (Exception e) {
            logger.info((Object)"OrgAdjSchm-deleteRubbishDataError:");
            logger.info((Object)e);
        }
        return true;
    }

    public HROrgAdjSchmInfo getCurOrgAdjSchm() {
        return this.curOrgAdjSchm;
    }

    public void setCurOrgAdjSchm(HROrgAdjSchmInfo curOrgAdjSchm) {
        this.curOrgAdjSchm = curOrgAdjSchm;
    }

    public boolean isIncludeSealUpPosition() {
        return this.chkShowPosSealUp.isSelected();
    }

    private class DelInvalidDataThread
    extends Thread {
        private DelInvalidDataThread() {
        }

        @Override
        public void run() {
            try {
                IHROrgVersionFacade verFacade = HROrgVersionFacadeFactory.getRemoteInstance();
                verFacade.realseOrgAdjSchmDataLock(null);
                verFacade.delOrgAdjSchmDataExit();
            }
            catch (BOSException e) {
                logger.info((Object)e);
            }
        }
    }
}

