/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.org.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.table.util.KDTableUtil;
import com.kingdee.bos.ctrl.swing.util.CtrlSwingUtilities;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.basedata.org.FullOrgUnitFactory;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.hr.org.HROrgAdjSchmInfo;
import com.kingdee.eas.hr.org.client.AbstractOrgUnitListUI;
import com.kingdee.eas.hr.org.util.OrgVerAdjUtil;
import com.kingdee.util.StringUtils;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import javax.swing.JComponent;
import javax.swing.KeyStroke;
import org.apache.log4j.Logger;

public class OrgUnitListUI
extends AbstractOrgUnitListUI {
    private static final Logger logger = CoreUIObject.getLogger(OrgUnitListUI.class);
    private String quickSearchDefault = null;
    private String quickSearchStr = null;
    private String curOrgId = null;

    public String getCurOrgId() {
        return this.curOrgId;
    }

    public void setCurOrgId(String curOrgId) {
        this.curOrgId = curOrgId;
    }

    protected void initWorkButton() {
        this.getUIToolBar().setVisible(false);
        CtrlSwingUtilities.removeManagingFocusForwardTraversalKeys((JComponent)this.txtValue, (KeyStroke)KeyStroke.getKeyStroke(10, 0));
        this.quickSearchDefault = this.txtValue.getText();
    }

    @Override
    public void actionSearch_actionPerformed(ActionEvent e) throws Exception {
        this.employeeFastQuery();
    }

    @Override
    protected void txtValue_keyPressed(KeyEvent e) throws Exception {
        if (e.getKeyCode() == 10) {
            this.employeeFastQuery();
        }
    }

    private void employeeFastQuery() throws BOSException {
        this.mainQuery = new EntityViewInfo();
        this.mainQuery.setFilter(this.getDefaultFilterForQuery());
        if (StringUtils.isEmpty((String)this.txtValue.getText())) {
            return;
        }
        String param = this.txtValue.getText();
        FilterInfo filterInfo = new FilterInfo();
        if (!this.txtValue.getText().equals(this.quickSearchStr)) {
            filterInfo.getFilterItems().add(new FilterItemInfo("NUMBER", (Object)("%" + param + "%"), CompareType.LIKE));
            filterInfo.getFilterItems().add(new FilterItemInfo("NAME", (Object)("%" + param + "%"), CompareType.LIKE));
            filterInfo.setMaskString("#0 or #1");
        }
        this.mainQuery.getFilter().mergeFilter(filterInfo, "and");
        this.tblMain.removeRows();
        this.tblMain.requestFocusInWindow();
    }

    protected FilterInfo getDefaultFilterForQuery() {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("isAdminOrgUnit", (Object)false, CompareType.EQUALS));
        HROrgAdjSchmInfo orgAdjSchm = (HROrgAdjSchmInfo)this.getUIContext().get("Current_OrgAdjSchm");
        FilterItemInfo itemInfo = OrgVerAdjUtil.getUserRangOrgAdjSchmCUFilter(true, orgAdjSchm);
        itemInfo.setPropertyName("CU.id");
        filter.getFilterItems().add(itemInfo);
        StringBuffer sql = new StringBuffer();
        sql.append("select FAdminOrgUnitID from T_HR_AdminOrgUnitVer where fOrgAdjSchm='").append(orgAdjSchm.getId()).append("'");
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)sql.toString(), CompareType.NOTINNER));
        return filter;
    }

    @Override
    protected void txtValue_focusGained(FocusEvent e) throws Exception {
        if (!StringUtils.isEmpty((String)this.txtValue.getText())) {
            if (this.txtValue.getText().equals(this.quickSearchDefault)) {
                this.txtValue.setText(null);
            }
        } else {
            this.txtValue.setText(null);
        }
    }

    @Override
    protected void txtValue_focusLost(FocusEvent e) throws Exception {
        if (StringUtils.isEmpty((String)this.txtValue.getText())) {
            this.txtValue.setText(this.quickSearchDefault);
        }
    }

    @Override
    protected void txtValue_mouseClicked(MouseEvent e) throws Exception {
        if (!StringUtils.isEmpty((String)this.txtValue.getText())) {
            if (this.txtValue.getText().equals(this.quickSearchDefault)) {
                this.txtValue.setText(null);
            }
        } else {
            this.txtValue.setText(null);
        }
    }

    protected ICoreBase getBizInterface() throws Exception {
        return FullOrgUnitFactory.getRemoteInstance();
    }

    protected String getEditUIName() {
        return null;
    }

    protected void tblMain_tableClicked(KDTMouseEvent e) throws Exception {
        String id = KDTableUtil.getSelectedRow((KDTable)this.tblMain).getCell("id").getValue().toString();
        this.setCurOrgId(id);
        this.getUIWindow().close();
    }
}

