/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.org.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.core.hr.util.HRParamUtil;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.HROrgUnitInfo;
import com.kingdee.eas.basedata.org.JobInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.PositionInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.client.context.OrgChangeVO;
import com.kingdee.eas.framework.client.multiDetail.DetailPanel;
import com.kingdee.eas.hr.base.ApproveTypeEnum;
import com.kingdee.eas.hr.base.HRBillStateEnum;
import com.kingdee.eas.hr.base.client.IHRBillEditUIBiz;
import com.kingdee.eas.hr.org.AdjustPeriodInfo;
import com.kingdee.eas.hr.org.PersonPlanBizBillFactory;
import com.kingdee.eas.hr.org.PersonPlanBizBillInfo;
import com.kingdee.eas.hr.org.PersonPlanFacadeFactory;
import com.kingdee.eas.hr.org.PersonPlanSchemeInfo;
import com.kingdee.eas.hr.org.PersonPlanType;
import com.kingdee.eas.hr.org.client.AbstractPersonPlanBizBillEditUI;
import com.kingdee.eas.hr.org.client.PersonPlanEditUIBiz;
import com.kingdee.eas.hr.org.util.OrgUtils;
import com.kingdee.eas.util.client.EASResource;
import java.awt.event.ActionEvent;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class PersonPlanBizBillEditUI
extends AbstractPersonPlanBizBillEditUI {
    private static final Logger logger = CoreUIObject.getLogger(PersonPlanBizBillEditUI.class);
    public static final String COLUMN_PLAN_SCHEME = "planScheme";
    public static final String COLUMN_PLAN_TYPE = "planType";
    public static final String COLUMN_ADMINORGUNIT = "adminOrgUnit";
    public static final String COLUMN_PLAN_TYPE_LIST = "planTypeList";
    public static final String COLUMN_POSITION = "position";
    public static final String COLUMN_JOB = "job";
    public static final String COLUMN_ADJUST_PERIOD = "adjustPeriod";
    public static final String COLUMN_OLD_PCOUNT = "oldPCount";
    public static final String COLUMN_ADJUST_PCOUNT = "adjustPCount";
    public static final String COLUMN_ADJUST_CAUSE = "adjustCause";
    public static final String COLUMN_EFFECT_DATE = "bizDate";
    public static final String COLUMN_REMARK = "description";
    KDComboBox cmbAdjustPeriod = new KDComboBox();
    PersonPlanSchemeInfo schemeInfo = null;
    Map ppMap = new HashMap();
    String positionType = "POSITION";
    String jobType = "JOB";
    String adminType = "ADMIN";
    String TYPE_INSERT = "INSERT";
    String TYPE_ADDNEW = "ADDNEW";
    boolean isDefaultWorkFlow = false;
    Map relMap = new HashMap();

    protected void afterOnLoad() throws Exception {
        super.afterOnLoad();
        this.initDefaultApproveType();
        this.kdtEntrys_detailPanel.setTitle(EASResource.getString((String)"com.kingdee.eas.hr.org.JobGradeModuleResource", (String)"PersonPlanTable_label"));
        OrgUtils.setColumnDateFormat(this.kdtEntrys, COLUMN_EFFECT_DATE);
    }

    @Override
    public void loadFields() {
        super.loadFields();
        ((PersonPlanEditUIBiz)this.biz).loadFields();
        this.initDefaultApproveType();
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    protected void beforeOnLoad() throws Exception {
        super.beforeOnLoad();
    }

    public void afterMainOrgChanged(OrgChangeVO chgVo) {
        super.afterMainOrgChanged(chgVo);
        this.kdtEntrys.removeRows();
        try {
            this.isDefaultWorkFlow = HRParamUtil.getParamOfHR(null, (String)"HEADCOUNT_CHANGE_001", (String)this.getCurrentHro().getId().toString()) && OprtState.ADDNEW.equals(this.getOprtState());
            this.initDefaultApproveType();
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    @Override
    protected void kdtEntrys_editStopping(KDTEditEvent e) throws Exception {
        ((PersonPlanEditUIBiz)this.biz).kdtEntry_editStopping(e);
    }

    @Override
    protected void kdtEntrys_editStopped(KDTEditEvent e) throws Exception {
        ((PersonPlanEditUIBiz)this.biz).kdtEntry_editStopped(e);
    }

    @Override
    protected ICoreBase getBizInterface() throws Exception {
        return PersonPlanBizBillFactory.getRemoteInstance();
    }

    protected IObjectValue createNewDetailData(KDTable table) {
        return null;
    }

    @Override
    protected IObjectValue createNewData() {
        PersonPlanBizBillInfo objectValue = new PersonPlanBizBillInfo();
        UserInfo info = SysContext.getSysContext().getCurrentUserInfo();
        objectValue.setBillState(HRBillStateEnum.SAVED);
        objectValue.setApplier(info.getPerson());
        objectValue.setApplyDate(new Date());
        return objectValue;
    }

    protected IHRBillEditUIBiz getBillBiz() {
        return new PersonPlanEditUIBiz();
    }

    protected DetailPanel getIgnoredDetailPanel() {
        return this.kdtEntrys_detailPanel;
    }

    protected HROrgUnitInfo getCurrentHro() {
        HROrgUnitInfo orgUnitInfo = (HROrgUnitInfo)this.getUIContext().get(OrgType.HRO);
        if (orgUnitInfo == null) {
            orgUnitInfo = SysContext.getSysContext().getCurrentHRUnit();
        }
        return orgUnitInfo;
    }

    protected void verifyInput(ActionEvent e) throws Exception {
        super.verifyInput(e);
        ((PersonPlanEditUIBiz)this.biz).verifyInput(e);
    }

    protected void workButtonSwitch(boolean isOn) {
        this.btnAddLine.setEnabled(isOn);
        this.btnInsertLine.setEnabled(isOn);
    }

    private void initDefaultApproveType() {
        if (OprtState.ADDNEW.equals(this.getOprtState())) {
            if (this.isDefaultWorkFlow) {
                this.cbApproveType.setSelectedItem((Object)ApproveTypeEnum.WORKFLOW);
                if (this.editData != null) {
                    this.editData.setApproveType(ApproveTypeEnum.WORKFLOW);
                }
            } else {
                this.cbApproveType.setSelectedItem((Object)ApproveTypeEnum.DIRECT);
                if (this.editData != null) {
                    this.editData.setApproveType(ApproveTypeEnum.DIRECT);
                }
            }
        }
    }

    public void actionColumnCopyAll_actionPerformed(ActionEvent e) throws Exception {
        super.actionColumnCopyAll_actionPerformed(e);
        this.fillCountAfterCopy();
    }

    public void actionColumnCopySelect_actionPerformed(ActionEvent e) throws Exception {
        super.actionColumnCopySelect_actionPerformed(e);
        this.fillCountAfterCopy();
    }

    private void fillCountAfterCopy() throws EASBizException, BOSException {
        PersonPlanBizBillInfo bill = this.editData;
        this.schemeInfo = bill != null && bill.getPlanScheme() != null ? bill.getPlanScheme() : PersonPlanFacadeFactory.getRemoteInstance().getPersonPlanSchemeByHRO(this.getCurrentHro().getId());
        if (this.schemeInfo != null) {
            this.ppMap = PersonPlanFacadeFactory.getRemoteInstance().getPersonPlanListByScheme(this.schemeInfo);
        }
        ICell adjustPeirodCol = null;
        IRow row = null;
        int size = this.kdtEntrys.getRowCount();
        for (int i = 0; i < size; ++i) {
            row = this.kdtEntrys.getRow(i);
            adjustPeirodCol = row.getCell(COLUMN_ADJUST_PERIOD);
            if (adjustPeirodCol.getValue() == null) continue;
            String key = "";
            if (row.getCell(COLUMN_ADMINORGUNIT).getValue() != null) {
                key = key + ((AdminOrgUnitInfo)row.getCell(COLUMN_ADMINORGUNIT).getValue()).getId().toString();
            }
            if (PersonPlanType.JOB.equals((Object)this.schemeInfo.getPlanType())) {
                if (this.kdtEntrys.getRow(i).getCell(COLUMN_JOB).getValue() != null) {
                    key = key + ((JobInfo)row.getCell(COLUMN_JOB).getValue()).getId().toString();
                }
            } else if (PersonPlanType.POSITION.equals((Object)this.schemeInfo.getPlanType()) && this.kdtEntrys.getRow(i).getCell(COLUMN_POSITION).getValue() != null) {
                key = key + ((PositionInfo)row.getCell(COLUMN_POSITION).getValue()).getId().toString();
            }
            key = key + ((AdjustPeriodInfo)adjustPeirodCol.getValue()).getYear() + "Y";
            if (this.ppMap.get(key = key + ((AdjustPeriodInfo)adjustPeirodCol.getValue()).getMonth()) != null) {
                this.kdtEntrys.getRow(i).getCell(COLUMN_OLD_PCOUNT).setValue(this.ppMap.get(key));
                continue;
            }
            this.kdtEntrys.getRow(i).getCell(COLUMN_OLD_PCOUNT).setValue((Object)new Integer(0));
        }
    }

    @Override
    protected void setAutoNumberByOrg(String orgType) {
    }
}

