/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.org.client;

import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.util.render.IBasicRender;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.IMetaDataLoader;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.query.QueryInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.ui.util.IUIActionPostman;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.commonquery.IQuerySolutionFacade;
import com.kingdee.eas.base.commonquery.QuerySolutionFacadeFactory;
import com.kingdee.eas.base.commonquery.QuerySolutionInfo;
import com.kingdee.eas.base.commonquery.client.CommonQueryDialog;
import com.kingdee.eas.base.commonquery.client.CustomerParams;
import com.kingdee.eas.base.core.client.GetDataDialog;
import com.kingdee.eas.base.core.client.GetDataTaskAdapter;
import com.kingdee.eas.basedata.org.AdminOrgUnitFactory;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.framework.batchHandler.RequestContext;
import com.kingdee.eas.framework.batchHandler.client.UIActionPostman;
import com.kingdee.eas.hr.base.OutputExcelUtil;
import com.kingdee.eas.hr.base.util.HRResourceUtils;
import com.kingdee.eas.hr.base.util.HRUtil;
import com.kingdee.eas.hr.base.util.OrgStringUtil;
import com.kingdee.eas.hr.emp.client.HRCellTreeRenderer;
import com.kingdee.eas.hr.emp.client.HRCellUserObject;
import com.kingdee.eas.hr.emp.client.HRTreeTable;
import com.kingdee.eas.hr.org.HRPositionFacadeFactory;
import com.kingdee.eas.hr.org.IHRPositionFacade;
import com.kingdee.eas.hr.org.IPersonPlanScheme;
import com.kingdee.eas.hr.org.PersonPlanSchemeFactory;
import com.kingdee.eas.hr.org.PersonPlanSchemeInfo;
import com.kingdee.eas.hr.org.PersonPlanType;
import com.kingdee.eas.hr.org.PositionAnalysisRowInfo;
import com.kingdee.eas.hr.org.SchemeStatus;
import com.kingdee.eas.hr.org.client.AbstractPositionAnalysisReportUI;
import com.kingdee.eas.hr.org.client.PositionAnalysisFilterUI;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.ComponentUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.util.StringUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.KeyboardFocusManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class PositionAnalysisReportUI
extends AbstractPositionAnalysisReportUI {
    private static final Logger logger = CoreUIObject.getLogger(PositionAnalysisReportUI.class);
    private CustomerParams params = null;
    private boolean isFirstDefaultQuery = true;
    IMetaDataPK mainQueryPK = new MetaDataPK("com.kingdee.eas.hr.org.app", "PositionSpecDS2Query");
    private CommonQueryDialog commonQueryDialog = null;
    private PositionAnalysisFilterUI customerPanel = null;

    protected void initWorkButton() {
        super.initWorkButton();
        this.btnRefresh.setIcon(EASResource.getIcon((String)"imgTbtn_refresh"));
        this.menuItemRefresh.setIcon(EASResource.getIcon((String)"imgTbtn_refresh"));
        this.btnQuery.setIcon(EASResource.getIcon((String)"imgTbtn_filter"));
        this.menuItemQuery.setIcon(EASResource.getIcon((String)"imgTbtn_filter"));
        this.btnPrint.setIcon(EASResource.getIcon((String)"imgTbtn_print"));
        this.menuItemPrint.setIcon(EASResource.getIcon((String)"imgTbtn_print"));
        this.btnPrintPreview.setIcon(EASResource.getIcon((String)"imgTbtn_preview"));
        this.menuItemPrintPreview.setIcon(EASResource.getIcon((String)"imgTbtn_preview"));
        this.btnOutput.setEnabled(true);
        this.btnOutput.setIcon(EASResource.getIcon((String)"imgTbtn_output"));
        this.menuItemOutput.setIcon(EASResource.getIcon((String)"imgTbtn_output"));
        this.setButtonDefaultStyl(this.btnRefresh);
        this.setButtonDefaultStyl(this.btnQuery);
        this.setButtonDefaultStyl(this.btnPrint);
        this.setButtonDefaultStyl(this.btnPrintPreview);
    }

    protected SystemEnum getSystemEnumForOA() {
        return SystemEnum.PEOPLE_ORGANIZATION;
    }

    @Override
    public void actionRefresh_actionPerformed(ActionEvent e) throws Exception {
        super.actionRefresh_actionPerformed(e);
        this.loadTableData();
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.tblMain.checkParsed();
        this.tblMain.getSelectManager().setSelectMode(2);
        this.tblMain.getStyleAttributes().setLocked(true);
        HRTreeTable.setHRTreeTable((KDTable)this.tblMain, (String)"adminOrg");
        this.tblMain.getColumn(0).getStyleAttributes().setBackground(new Color(217, 217, 210));
        this.tblMain.getColumn(1).getStyleAttributes().setBackground(new Color(217, 217, 210));
        this.tblMain.getColumn(1).getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.LEFT);
        this.tblMain.getColumn(2).getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        this.tblMain.getColumn(3).getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        this.tblMain.getColumn(4).getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        this.tblMain.getColumn(5).getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        this.tblMain.getColumn(6).getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        this.tblMain.getColumn(7).getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        this.enableExportExcel(this.tblMain);
        this.showFilterUI(false);
    }

    @Override
    public void actionOutput_actionPerformed(ActionEvent e) throws Exception {
        super.actionOutput_actionPerformed(e);
        OutputExcelUtil excelUtil = new OutputExcelUtil();
        excelUtil.appendToExcel(this.tblMain, true, true, this.getUITitle());
    }

    @Override
    public void actionQuery_actionPerformed(ActionEvent e) throws Exception {
        if (this.commonQueryDialog != null && this.getUIContext() != null && "report".equals(this.getUIContext().get("UIClassParam"))) {
            this.commonQueryDialog.changeOwner((Component)((Object)this));
        }
        super.actionQuery_actionPerformed(e);
        this.showFilterUI(true);
    }

    @Override
    public void actionPrint_actionPerformed(ActionEvent e) throws Exception {
        this.preparePrintPage(this.tblMain);
        this.tblMain.getPrintManager().print();
    }

    @Override
    public void actionPrintPreview_actionPerformed(ActionEvent e) throws Exception {
        this.preparePrintPage(this.tblMain);
        this.tblMain.getPrintManager().printPreview();
    }

    protected KDTable getTableForPrintSetting() {
        return this.tblMain;
    }

    private void fillTable(PersonPlanSchemeInfo ppsInfo, List list) throws Exception {
        boolean isPositionPlan = true;
        if (ppsInfo == null || ppsInfo.getPlanType() != PersonPlanType.POSITION) {
            isPositionPlan = false;
        }
        if (ppsInfo != null && ppsInfo.getStatus() != SchemeStatus.EXECUTE) {
            ppsInfo = null;
        }
        IRow row = null;
        if (list == null) {
            return;
        }
        PositionAnalysisRowInfo rowInfo = null;
        HRCellUserObject hrObj = null;
        HRCellTreeRenderer render = new HRCellTreeRenderer();
        Color cusColor = new Color(255, 234, 103);
        int baseLevel = 0;
        int length = list.size();
        for (int i = 0; i < length; ++i) {
            row = this.tblMain.addRow();
            rowInfo = (PositionAnalysisRowInfo)list.get(i);
            hrObj = new HRCellUserObject();
            hrObj.setCompanyId(rowInfo.adminInfo.getId().toString());
            hrObj.setIsLeaf(rowInfo.adminInfo.isIsLeaf());
            if (i == 0) {
                baseLevel = rowInfo.adminInfo.getLevel();
            }
            hrObj.setLevel(rowInfo.adminInfo.getLevel() - baseLevel);
            if (rowInfo.adminInfo.get("displayName") == null) {
                hrObj.setName(rowInfo.adminInfo.getName());
            } else {
                hrObj.setName(rowInfo.adminInfo.getDisplayName());
                hrObj.setLevel(0);
            }
            hrObj.setLongNumber(rowInfo.adminInfo.getLongNumber());
            hrObj.setExpanded(true);
            row.getCell(0).setValue((Object)hrObj);
            row.getCell(0).setRenderer((IBasicRender)render);
            row.getCell(1).setValue((Object)rowInfo.positionName);
            if (rowInfo.adminInfo.get("isEnable") != null && !Boolean.valueOf(rowInfo.adminInfo.get("isEnable").toString()).booleanValue()) {
                row.getStyleAttributes().setBackground(Color.LIGHT_GRAY);
                continue;
            }
            if (rowInfo.plan != 0 && (ppsInfo == null || ppsInfo.getPlanType() != PersonPlanType.JOB)) {
                row.getCell(2).setValue((Object)rowInfo.plan);
            }
            if (rowInfo.onPlan != 0) {
                row.getCell(3).setValue((Object)rowInfo.onPlan);
            }
            if ((ppsInfo == null || ppsInfo.getPlanType() != PersonPlanType.JOB) && (rowInfo.offPlan > 0 && isPositionPlan || rowInfo.offPlan > 0 && !isPositionPlan && !hrObj.getName().equals(""))) {
                row.getCell(4).getStyleAttributes().setBackground(Color.RED);
                row.getCell(4).setValue((Object)rowInfo.offPlan);
            }
            if (rowInfo.actual != 0) {
                row.getCell(5).setValue((Object)rowInfo.actual);
            }
            if (rowInfo.plurality != 0) {
                row.getCell(6).setValue((Object)rowInfo.plurality);
            }
            if ((ppsInfo == null || ppsInfo.getPlanType() != PersonPlanType.JOB) && (isPositionPlan && rowInfo.vacancy > 0 || rowInfo.vacancy > 0 && !isPositionPlan && !hrObj.getName().equals(""))) {
                row.getCell(7).getStyleAttributes().setBackground(cusColor);
                row.getCell(7).setValue((Object)rowInfo.vacancy);
            }
            if ((ppsInfo == null || ppsInfo.getPlanType() != PersonPlanType.JOB) && (isPositionPlan && rowInfo.offPlanCollect > 0 || rowInfo.offPlanCollect > 0 && !isPositionPlan && !hrObj.getName().equals(""))) {
                row.getCell(8).getStyleAttributes().setBackground(Color.RED);
                row.getCell(8).setValue((Object)new Integer(rowInfo.offPlanCollect));
            }
            if (ppsInfo != null && ppsInfo.getPlanType() == PersonPlanType.JOB || (!isPositionPlan || rowInfo.vacancyCollect <= 0) && (rowInfo.vacancyCollect <= 0 || isPositionPlan || hrObj.getName().equals(""))) continue;
            row.getCell(9).getStyleAttributes().setBackground(cusColor);
            row.getCell(9).setValue((Object)new Integer(rowInfo.vacancyCollect));
        }
        this.fillCollectData(ppsInfo);
    }

    private void fillCollectData(PersonPlanSchemeInfo ppsInfo) {
        int i;
        int collectOff = 0;
        int collectVacancy = 0;
        int offCollect = 0;
        int vacancyCollect = 0;
        Color cusColor = new Color(255, 234, 103);
        int count = this.tblMain.getRowCount();
        for (i = count - 1; i >= 0; --i) {
            if (this.tblMain.getRow(i).getCell(0).getValue().toString().trim().equals("") && !this.tblMain.getRow(i).getCell(1).getValue().toString().trim().equals("")) {
                if (this.tblMain.getRow(i).getCell(4).getValue() != null) {
                    collectOff += Integer.parseInt(this.tblMain.getRow(i).getCell(4).getValue().toString());
                }
                if (this.tblMain.getRow(i).getCell(7).getValue() == null) continue;
                collectVacancy += Integer.parseInt(this.tblMain.getRow(i).getCell(7).getValue().toString());
                continue;
            }
            if (this.tblMain.getRow(i).getCell(0).getValue().toString().trim().equals("") || !this.tblMain.getRow(i).getCell(1).getValue().toString().trim().equals("")) continue;
            if (collectOff != 0) {
                this.tblMain.getRow(i).getCell(8).setValue((Object)new Integer(collectOff));
            }
            if (collectVacancy != 0) {
                this.tblMain.getRow(i).getCell(9).setValue((Object)new Integer(collectVacancy));
            }
            collectOff = 0;
            collectVacancy = 0;
        }
        count = this.tblMain.getRowCount();
        for (i = count - 1; i >= 0; --i) {
            if (this.tblMain.getRow(i).getCell(0).getValue().toString().trim().equals("") || !this.tblMain.getRow(i).getCell(1).getValue().toString().trim().equals("")) continue;
            if (this.tblMain.getRow(i).getCell(8).getValue() == null && this.tblMain.getRow(i).getCell(9).getValue() == null) {
                if (this.tblMain.getRow(i).getCell(4).getValue() != null) {
                    this.tblMain.getRow(i).getCell(8).setValue((Object)new Integer(this.tblMain.getRow(i).getCell(4).getValue().toString()));
                }
                if (this.tblMain.getRow(i).getCell(7).getValue() != null) {
                    this.tblMain.getRow(i).getCell(9).setValue((Object)new Integer(this.tblMain.getRow(i).getCell(7).getValue().toString()));
                }
            }
            if (this.tblMain.getRow(i).getCell(8).getValue() != null || this.tblMain.getRow(i).getCell(9).getValue() != null) {
                if (this.tblMain.getRow(i).getCell(8).getValue() != null) {
                    offCollect = Integer.parseInt(this.tblMain.getRow(i).getCell(8).getValue().toString());
                }
                if (this.tblMain.getRow(i).getCell(9).getValue() != null) {
                    vacancyCollect = Integer.parseInt(this.tblMain.getRow(i).getCell(9).getValue().toString());
                }
                if (this.tblMain.getRow(i).getCell(4).getValue() != null) {
                    if (offCollect >= vacancyCollect) {
                        if (offCollect - vacancyCollect - Integer.parseInt(this.tblMain.getRow(i).getCell(4).getValue().toString()) >= 0) {
                            vacancyCollect += offCollect - vacancyCollect - Integer.parseInt(this.tblMain.getRow(i).getCell(4).getValue().toString());
                        }
                        if (offCollect - vacancyCollect - Integer.parseInt(this.tblMain.getRow(i).getCell(4).getValue().toString()) < 0) {
                            offCollect += Integer.parseInt(this.tblMain.getRow(i).getCell(4).getValue().toString()) - (offCollect - vacancyCollect);
                        }
                    }
                    if (offCollect < vacancyCollect) {
                        offCollect += Integer.parseInt(this.tblMain.getRow(i).getCell(4).getValue().toString()) + (vacancyCollect - offCollect);
                    }
                }
                if (this.tblMain.getRow(i).getCell(7).getValue() != null) {
                    if (offCollect >= vacancyCollect) {
                        vacancyCollect += Integer.parseInt(this.tblMain.getRow(i).getCell(7).getValue().toString()) + (offCollect - vacancyCollect);
                    }
                    if (offCollect < vacancyCollect) {
                        if (vacancyCollect - offCollect - Integer.parseInt(this.tblMain.getRow(i).getCell(7).getValue().toString()) >= 0) {
                            offCollect += vacancyCollect - offCollect - Integer.parseInt(this.tblMain.getRow(i).getCell(7).getValue().toString());
                        }
                        if (vacancyCollect - offCollect - Integer.parseInt(this.tblMain.getRow(i).getCell(7).getValue().toString()) < 0) {
                            vacancyCollect += Integer.parseInt(this.tblMain.getRow(i).getCell(7).getValue().toString()) - (vacancyCollect - offCollect);
                        }
                    }
                }
                if (offCollect != 0) {
                    this.tblMain.getRow(i).getCell(8).setValue((Object)new Integer(offCollect));
                }
                if (vacancyCollect != 0) {
                    this.tblMain.getRow(i).getCell(9).setValue((Object)new Integer(vacancyCollect));
                }
                offCollect = 0;
                vacancyCollect = 0;
            }
            if (this.tblMain.getRow(i).getCell(8).getValue() == null && this.tblMain.getRow(i).getCell(9).getValue() == null) continue;
            for (int j = i; j >= 0; --j) {
                int fatherLevel;
                int level = ((HRCellUserObject)this.tblMain.getRow(i).getCell(0).getValue()).getLevel();
                if (level != (fatherLevel = ((HRCellUserObject)this.tblMain.getRow(j).getCell(0).getValue()).getLevel()) + 1) continue;
                if (this.tblMain.getRow(j).getCell(8).getValue() != null && this.tblMain.getRow(i).getCell(8).getValue() != null) {
                    this.tblMain.getRow(j).getCell(8).setValue((Object)new Integer(Integer.parseInt(this.tblMain.getRow(i).getCell(8).getValue().toString()) + Integer.parseInt(this.tblMain.getRow(j).getCell(8).getValue().toString())));
                }
                if (this.tblMain.getRow(j).getCell(8).getValue() == null && this.tblMain.getRow(i).getCell(8).getValue() != null) {
                    this.tblMain.getRow(j).getCell(8).setValue((Object)new Integer(Integer.parseInt(this.tblMain.getRow(i).getCell(8).getValue().toString())));
                }
                if (this.tblMain.getRow(j).getCell(9).getValue() != null && this.tblMain.getRow(i).getCell(9).getValue() != null) {
                    this.tblMain.getRow(j).getCell(9).setValue((Object)new Integer(Integer.parseInt(this.tblMain.getRow(i).getCell(9).getValue().toString()) + Integer.parseInt(this.tblMain.getRow(j).getCell(9).getValue().toString())));
                }
                if (this.tblMain.getRow(j).getCell(9).getValue() == null && this.tblMain.getRow(i).getCell(9).getValue() != null) {
                    this.tblMain.getRow(j).getCell(9).setValue((Object)new Integer(Integer.parseInt(this.tblMain.getRow(i).getCell(9).getValue().toString())));
                }
                j = -1;
            }
        }
        count = this.tblMain.getRowCount();
        for (i = count - 1; i >= 0; --i) {
            if (this.tblMain.getRow(i).getCell(8).getValue() != null) {
                this.tblMain.getRow(i).getCell(8).getStyleAttributes().setBackground(Color.RED);
            }
            if (this.tblMain.getRow(i).getCell(9).getValue() == null) continue;
            this.tblMain.getRow(i).getCell(9).getStyleAttributes().setBackground(cusColor);
        }
        if (ppsInfo != null && ppsInfo.getPlanType() == PersonPlanType.PERSON) {
            count = this.tblMain.getRowCount();
            for (i = count - 1; i >= 0; --i) {
                if (!this.tblMain.getRow(i).getCell(0).getValue().toString().trim().equals("") || this.tblMain.getRow(i).getCell(1).getValue().toString().trim().equals("")) continue;
                this.tblMain.getRow(i).getCell(8).setValue(null);
                this.tblMain.getRow(i).getCell(8).getStyleAttributes().setBackground(Color.white);
                this.tblMain.getRow(i).getCell(9).setValue(null);
                this.tblMain.getRow(i).getCell(9).getStyleAttributes().setBackground(Color.white);
            }
        }
        if (ppsInfo != null && ppsInfo.getPlanType() == PersonPlanType.JOB) {
            count = this.tblMain.getRowCount();
            for (i = count - 1; i >= 0; --i) {
                this.tblMain.getRow(i).getCell(8).setValue(null);
                this.tblMain.getRow(i).getCell(8).getStyleAttributes().setBackground(Color.white);
                this.tblMain.getRow(i).getCell(9).setValue(null);
                this.tblMain.getRow(i).getCell(9).getStyleAttributes().setBackground(Color.white);
            }
        }
    }

    private void loadTableData() throws Exception {
        this.tblMain.removeRows();
        GetDataDialog dlg = null;
        Window owner = KeyboardFocusManager.getCurrentKeyboardFocusManager().getActiveWindow();
        Window ownerWindow = ComponentUtil.getOwnerWindow((Component)owner);
        dlg = ownerWindow instanceof Frame ? new GetDataDialog((Frame)ownerWindow) : (ownerWindow instanceof Dialog ? new GetDataDialog((Dialog)ownerWindow) : new GetDataDialog((Frame)null));
        dlg.setGetDataTask(new GetDataTaskAdapter(){

            public Object exec() throws Exception {
                IPersonPlanScheme iPPS = PersonPlanSchemeFactory.getRemoteInstance();
                PersonPlanSchemeInfo ppsInfo = iPPS.getDefaultScheme();
                IHRPositionFacade iPosi = HRPositionFacadeFactory.getRemoteInstance();
                HashMap filter = PositionAnalysisReportUI.this.params.getCustomerParamsHashMap();
                if (filter.get("Position_Item") == null) {
                    HashMap map = HRUtil.getAdminRangeNodeHashMap((boolean)true, (boolean)PositionAnalysisReportUI.this.params.getBoolean("ShowVirtualOrg"));
                    Iterator iter = map.entrySet().iterator();
                    Map.Entry entry = null;
                    DefaultKingdeeTreeNode node = null;
                    while (iter.hasNext()) {
                        entry = iter.next();
                        node = (DefaultKingdeeTreeNode)entry.getValue();
                        node.setCustomIcon(null);
                    }
                    filter.put("NodeMap", map);
                }
                filter.put("isShowInvalidPosition", PositionAnalysisReportUI.this.params.getBoolean("isShowInvalidPosition"));
                filter.put("ShowVirtualOrg", PositionAnalysisReportUI.this.params.getBoolean("ShowVirtualOrg"));
                filter.put("level", new Integer(PositionAnalysisReportUI.this.params.getInt("comboOrgLevel")));
                List list = iPosi.getPositionAnalysisData(filter);
                PositionAnalysisReportUI.this.fillTable(ppsInfo, list);
                return null;
            }
        });
        dlg.show();
    }

    private void showFilterDialog(boolean loaded) throws Exception {
        if (this.commonQueryDialog == null) {
            this.commonQueryDialog = new CommonQueryDialog();
            this.commonQueryDialog.setHeight(400);
            this.commonQueryDialog.setWidth(505);
            if (this.getUIWindow() == null) {
                this.commonQueryDialog.setOwner((Component)this.getUIContext().get("OwnerWindow"));
            } else {
                this.commonQueryDialog.setOwner((Component)((Object)this));
            }
            this.commonQueryDialog.setParentUIClassName(this.getMetaDataPK().getFullName());
            this.commonQueryDialog.setQueryObjectPK(this.mainQueryPK);
            this.commonQueryDialog.setShowFilter(false);
            this.commonQueryDialog.setShowSorter(false);
            this.commonQueryDialog.setShowToolbar(true);
            this.commonQueryDialog.setMaxReturnCountVisible(false);
            this.customerPanel = new PositionAnalysisFilterUI();
            if (loaded) {
                this.customerPanel.setCustomerParams(this.params);
            }
            this.commonQueryDialog.addUserPanel((KDPanel)this.customerPanel);
        }
        String commonQueryRes = "com.kingdee.eas.hr.time.TimeResource";
        this.commonQueryDialog.setTitle(HRResourceUtils.getMessage((String)"com.kingdee.eas.hr.org.AdjustPeriodResource", (String)"TITLE_CONDITION_QUERY", (String[])new String[]{this.getUITitle()}));
        if (this.commonQueryDialog.show()) {
            this.params = this.customerPanel.getCustomerParams();
            if (this.isPrepareConfirm()) {
                this.prepareConfirm().callHandler();
            }
            this.loadTableData();
        } else {
            SysUtil.abort();
        }
    }

    private static QueryInfo getQueryInfo(IMetaDataPK queryPK) {
        IMetaDataLoader loader = MetaDataLoaderFactory.getRemoteMetaDataLoader();
        return loader.getQuery(queryPK);
    }

    protected Object getLastEntityViewInfo() {
        HashMap<String, HashMap> lastFilterMap = new HashMap<String, HashMap>();
        lastFilterMap.put("Params", this.params.toHashMap());
        return lastFilterMap;
    }

    private void showFilterUI(boolean loaded) throws Exception {
        IQuerySolutionFacade iQuery = QuerySolutionFacadeFactory.getRemoteInstance();
        String queryName = PositionAnalysisReportUI.getQueryInfo(this.mainQueryPK).getFullName();
        if (this.isFirstDefaultQuery && this.getUIContext().get("RPTFilter") != null && this.getUIContext().get("RPTFilter") instanceof Map) {
            Map lastFilterMap = (Map)this.getUIContext().get("RPTFilter");
            this.params = new CustomerParams();
            this.params.setHm((HashMap)lastFilterMap.get("Params"));
            ObjectUuidPK pk = null;
            if (this.params.getCustomerParam("Admin_Item") != null) {
                pk = new ObjectUuidPK(BOSUuid.read((String)this.params.getCustomerParam("Admin_Item")));
                if (pk == null || pk != null && !AdminOrgUnitFactory.getRemoteInstance().exists((IObjectPK)pk)) {
                    this.showFilterDialog(false);
                    return;
                }
            } else if (this.params.getCustomerParam("bizAdminOrgMult") != null) {
                String ids = this.params.getCustomerParam("bizAdminOrgMult");
                if (OrgStringUtil.string2OrgInfoArr((String)ids).length < 1) {
                    this.showFilterDialog(false);
                }
            } else if (this.params.getCustomerParam("Position_Item") != null) {
                String ids = this.params.getCustomerParam("bizPosition");
                if (OrgStringUtil.string2PositionInfoArr((String)ids).length < 1) {
                    this.showFilterDialog(false);
                    return;
                }
            } else {
                this.showFilterDialog(false);
                return;
            }
            this.loadTableData();
            this.isFirstDefaultQuery = false;
        } else if (this.isFirstDefaultQuery && iQuery.hasDefaultSolution(this.getMetaDataPK().getFullName(), queryName)) {
            QuerySolutionInfo solution = iQuery.getDefaultSolution(this.getMetaDataPK().getFullName(), queryName);
            if (!StringUtils.isEmpty((String)solution.getQueryPanelInfo().get(0).getCustomerParams())) {
                this.params = CustomerParams.getCustomerParams2((String)solution.getQueryPanelInfo().get(0).getCustomerParams());
                ObjectUuidPK pk = null;
                if (this.params.getCustomerParam("Admin_Item") != null) {
                    pk = new ObjectUuidPK(BOSUuid.read((String)this.params.getCustomerParam("Admin_Item")));
                    if (pk == null || pk != null && !AdminOrgUnitFactory.getRemoteInstance().exists((IObjectPK)pk)) {
                        this.showFilterDialog(false);
                        return;
                    }
                } else if (this.params.getCustomerParam("bizAdminOrgMult") != null) {
                    String ids = this.params.getCustomerParam("bizAdminOrgMult");
                    if (OrgStringUtil.string2OrgInfoArr((String)ids).length < 1) {
                        this.showFilterDialog(false);
                    }
                } else if (this.params.getCustomerParam("Position_Item") != null) {
                    String ids = this.params.getCustomerParam("bizPosition");
                    if (OrgStringUtil.string2PositionInfoArr((String)ids).length < 1) {
                        this.showFilterDialog(false);
                        return;
                    }
                } else {
                    this.showFilterDialog(false);
                    return;
                }
                this.loadTableData();
            } else {
                this.showFilterDialog(loaded);
            }
            this.isFirstDefaultQuery = false;
        } else {
            this.showFilterDialog(loaded);
        }
    }

    protected KDTable getTableForOA() {
        return this.tblMain;
    }

    @Override
    public boolean isPrepareInit() {
        return true;
    }

    @Override
    public IUIActionPostman prepareInit() {
        IUIActionPostman handler = super.prepareInit();
        RequestContext request = (RequestContext)handler.getRequestContext();
        request.put("className", (Object)this.getMetaDataPK().getFullName());
        return handler;
    }

    public boolean isPrepareConfirm() {
        return true;
    }

    public IUIActionPostman prepareConfirm() {
        IUIActionPostman handler = UIActionPostman.getInstance((IUIObject)this);
        RequestContext request = new RequestContext();
        request.setClassName(this.getUIHandlerClassName());
        request.setMethodName("_handleConfirm");
        request.put("classname", (Object)this.getMetaDataPK().getFullName());
        handler.setRequestContext((Serializable)request);
        return handler;
    }
}

