/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.org.table;

import com.kingdee.bos.ctrl.kdf.table.KDTStyleConstants;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.hr.org.AdminOrgUnitVerInfo;
import com.kingdee.eas.hr.org.PersonVerInfo;
import com.kingdee.eas.hr.org.PositionVerInfo;
import com.kingdee.eas.hr.org.table.HRDragTableCellRenderer;
import com.kingdee.eas.hr.org.table.HRDragTableHeadCellRender;
import com.kingdee.eas.hr.org.table.HRDragTableHeader;
import com.kingdee.eas.hr.org.table.HRDragTableHeaderUI;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.util.StringUtils;
import java.awt.Color;
import java.awt.Graphics;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Vector;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

public class HRDragTable
extends JTable {
    static Vector columnName = null;

    public HRDragTable() {
        super(HRDragTable.getDefaultTableModel(), null, null);
        this.doWithHideColumn();
        this.initHeader();
        this.initTableStyle();
    }

    private void initTableStyle() {
        Color colorTemp = UIManager.getColor("KDTable.gridLineColor");
        colorTemp = colorTemp != null ? colorTemp : KDTStyleConstants.GRID_LINE_COLOR;
        this.setGridColor(colorTemp);
        this.setForeground(KDTStyleConstants.TABLE_FOREGROUND);
        colorTemp = UIManager.getColor("KDTable.background");
        colorTemp = colorTemp != null ? colorTemp : KDTStyleConstants.TABLE_BACKGROUND;
        this.setBackground(colorTemp);
        this.setRowHeight(20);
        Color selectColor = UIManager.getColor("KDTable.selectionBackground");
        selectColor = selectColor != null ? selectColor : KDTStyleConstants.SELECT_COLOR;
        this.setSelectionBackground(selectColor);
        this.setSelectionForeground(KDTStyleConstants.TABLE_FOREGROUND);
        for (int i = 0; i < this.getColumnCount(); ++i) {
            this.getColumnModel().getColumn(i).setCellRenderer(new HRDragTableCellRenderer());
            if (i != 0) continue;
            this.setTableSeqColumnWidth(0);
        }
    }

    private static DefaultTableModel getDefaultTableModel() {
        if (columnName == null) {
            columnName = new Vector();
            columnName.add(" ");
            columnName.add("id");
            columnName.add(EASResource.getString((String)"com.kingdee.eas.hr.org.HROrgAdjSchmVerResource", (String)"Person_Name"));
            columnName.add(EASResource.getString((String)"com.kingdee.eas.hr.org.HROrgAdjSchmVerResource", (String)"Person_Number"));
            columnName.add("positionVer.id");
            columnName.add("personDep");
            columnName.add("orgAdjSchm");
            columnName.add(EASResource.getString((String)"com.kingdee.eas.hr.org.HROrgAdjSchmVerResource", (String)"Employee_Type"));
            columnName.add(EASResource.getString((String)"com.kingdee.eas.hr.org.HROrgAdjSchmVerResource", (String)"AdminOrgUnit"));
            columnName.add(EASResource.getString((String)"com.kingdee.eas.hr.org.HROrgAdjSchmVerResource", (String)"Position"));
        }
        Vector vetor = new Vector();
        DefaultTableModel dtm = new DefaultTableModel(vetor, columnName);
        return dtm;
    }

    private void doWithHideColumn() {
        this.hideSpecialColumn(1);
        this.hideSpecialColumn(4);
        this.hideSpecialColumn(6);
        this.hideSpecialColumn(5);
        this.getColumnModel().getColumn(1).setResizable(false);
        this.getColumnModel().getColumn(4).setResizable(false);
        this.getColumnModel().getColumn(5).setResizable(false);
        this.getColumnModel().getColumn(6).setResizable(false);
    }

    private void initHeader() {
        this.getTableHeader().setUI(new HRDragTableHeaderUI(this.getTableHeader()));
        TableColumnModel headerModel = this.tableHeader.getColumnModel();
        int size = headerModel.getColumnCount();
        for (int i = 0; i < size; ++i) {
            headerModel.getColumn(i).setHeaderRenderer(new HRDragTableHeadCellRender());
        }
    }

    @Override
    public void paint(Graphics g) {
        super.paint(g);
    }

    public List getSpecialColumnValue(int[] rows, int column) {
        ArrayList<Object> list = new ArrayList<Object>();
        for (int i = 0; i < rows.length; ++i) {
            list.add(this.getValueAt(rows[i], column));
        }
        return list;
    }

    public void removeRows(int[] rows) {
        int i;
        DefaultTableModel tableModel = (DefaultTableModel)this.getModel();
        for (i = 0; i < rows.length; ++i) {
            tableModel.removeRow(rows[i] - i);
        }
        int size = tableModel.getRowCount();
        for (i = 0; i < size; ++i) {
            tableModel.setValueAt(new Integer(i + 1), i, 0);
        }
    }

    public void hideSpecialColumn(int i) {
        TableColumn col = this.getColumnModel().getColumn(i);
        col.setMaxWidth(0);
        col.setMinWidth(0);
        col.setPreferredWidth(0);
        col.setWidth(0);
    }

    @Override
    public boolean isCellEditable(int row, int column) {
        return false;
    }

    public List getSelectPersonVerList(int[] rows) {
        ArrayList<PersonVerInfo> personVerList = new ArrayList<PersonVerInfo>();
        PersonVerInfo person = new PersonVerInfo();
        PositionVerInfo position = new PositionVerInfo();
        for (int i = 0; i < rows.length; ++i) {
            String personID = (String)this.getValueAt(rows[i], 1);
            String positionId = (String)this.getValueAt(rows[i], 4);
            String personDep = (String)this.getValueAt(rows[i], 5);
            person.setId(BOSUuid.read((String)personID));
            if (!StringUtils.isEmpty((String)positionId)) {
                position.setId(BOSUuid.read((String)positionId));
            }
            person.setPrimaryPosition(position);
            AdminOrgUnitVerInfo adminOrg = new AdminOrgUnitVerInfo();
            adminOrg.setId(BOSUuid.read((String)personDep));
            person.setPersonDep(adminOrg);
            personVerList.add(person);
        }
        return personVerList;
    }

    public boolean checkIsSelectMulTypePerson() {
        int[] rows = this.getSelectedRows();
        HashSet<String> typeSet = new HashSet<String>();
        for (int i = 0; i < rows.length; ++i) {
            String positionId = (String)this.getValueAt(rows[i], 4);
            if (!StringUtils.isEmpty((String)positionId)) {
                typeSet.add("HasPosition");
                continue;
            }
            typeSet.add("NoPosition");
        }
        return typeSet.size() == 2;
    }

    public String getSelectedColumnValue(int clumnVal) {
        Object CellVal;
        String val = null;
        int row = this.getSelectedRow();
        if (row >= 0 && (CellVal = this.getValueAt(row, clumnVal)) != null) {
            val = this.getValueAt(row, clumnVal).toString();
        }
        return val;
    }

    @Override
    protected JTableHeader createDefaultTableHeader() {
        return new HRDragTableHeader(this.columnModel);
    }

    public static boolean isJumpOver(int column) {
        return column == 1 || column == 4 || column == 6 || column == 5;
    }

    @Override
    protected void paintBorder(Graphics g) {
        Border border = this.getBorder();
        g.setColor(KDTStyleConstants.GRID_LINE_COLOR);
        if (border != null) {
            border.paintBorder(this, g, 0, 0, this.getWidth(), this.getHeight());
        }
    }

    public void setTableSeqColumnWidth(int rowSize) {
        if (rowSize > 1000) {
            this.getColumnModel().getColumn(0).setPreferredWidth(36);
            this.getColumnModel().getColumn(0).setMaxWidth(36);
            this.getColumnModel().getColumn(0).setMinWidth(36);
        } else {
            this.getColumnModel().getColumn(0).setPreferredWidth(26);
            this.getColumnModel().getColumn(0).setMaxWidth(26);
            this.getColumnModel().getColumn(0).setMinWidth(26);
        }
    }
}

