/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.org.table;

import com.kingdee.bos.ctrl.kdf.table.KDTStyleConstants;
import com.kingdee.bos.ctrl.kdf.util.render.SimpleTextRender;
import com.kingdee.eas.hr.org.table.HRDragTable;
import com.kingdee.eas.hr.org.table.HRDragTableHeader;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Rectangle;
import javax.swing.JComponent;
import javax.swing.UIManager;
import javax.swing.plaf.basic.BasicTableHeaderUI;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

public class HRDragTableHeaderUI
extends BasicTableHeaderUI {
    protected SimpleTextRender simpleRender;

    public HRDragTableHeaderUI(JTableHeader header) {
        this.header = header;
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        Color headBackColor = UIManager.getColor("KDTable.headBackground");
        headBackColor = headBackColor != null ? headBackColor : KDTStyleConstants.HEAD_BACKGROUND;
        this.fillRectWithVerge(g, headBackColor);
    }

    private void fillRectWithVerge(Graphics g, Color backColor) {
        this.fillColorAndLine(g, backColor, true);
        TableColumnModel headerModel = this.header.getColumnModel();
        int columWidth = 0;
        int num = headerModel.getColumnCount();
        for (int i = 0; i < num; ++i) {
            if (HRDragTable.isJumpOver(i)) continue;
            Rectangle cellRect = new Rectangle(columWidth, 0, headerModel.getColumn(i).getWidth(), 22);
            columWidth += headerModel.getColumn(i).getWidth();
            this.paintCell(g, cellRect, i);
        }
        this.fillColorAndLine(g, backColor, false);
    }

    private void fillColorAndLine(Graphics g, Color backColor, boolean isFillColor) {
        Rectangle rect = this.header.getBounds();
        Color[] headVerges = HRDragTableHeader.getHeadColor();
        int x = rect.x;
        int y = rect.y;
        int width = x + rect.width - 1;
        g.setColor(headVerges[0]);
        g.drawLine(x, y, width, y);
        g.setColor(headVerges[1]);
        g.drawLine(x, y + 1, width, y + 1);
        g.setColor(headVerges[2]);
        g.drawLine(x, y + 2, width, y + 2);
        if (isFillColor) {
            g.setColor(backColor);
            g.fillRect(x, 3, rect.width, rect.height - 2);
        }
        y = rect.y + rect.height - 3;
        g.setColor(headVerges[3]);
        g.drawLine(x, y, width, y);
        g.setColor(headVerges[4]);
        g.drawLine(x, y + 1, width, y + 1);
        int left = rect.x;
        int bottom = rect.y + rect.height - 1;
        int right = rect.x + rect.width - 1;
        g.setColor(KDTStyleConstants.GRID_LINE_COLOR);
        g.drawLine(left, bottom, right, bottom);
        TableColumnModel headerModel = this.header.getColumnModel();
        int columnWidth = 0;
        int size = headerModel.getColumnCount();
        for (int i = 0; i < size; ++i) {
            int top = rect.y;
            bottom = rect.y + rect.height - 1;
            right = rect.x + (columnWidth += headerModel.getColumn(i).getWidth()) - 1;
            g.setColor(KDTStyleConstants.GRID_LINE_COLOR);
            g.drawLine(right, top, right, bottom);
        }
    }

    private void paintCell(Graphics g, Rectangle cellRect, int columnIndex) {
        TableColumn aColumn = this.header.getColumnModel().getColumn(columnIndex);
        TableCellRenderer renderer = aColumn.getHeaderRenderer();
        Component component = renderer.getTableCellRendererComponent(this.header.getTable(), aColumn.getHeaderValue(), false, false, -1, columnIndex);
        this.rendererPane.add(component);
        this.rendererPane.paintComponent(g, component, this.header, cellRect.x, cellRect.y, cellRect.width, cellRect.height, true);
    }
}

