/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.org.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.org.AdminOrgUnitCollection;
import com.kingdee.eas.basedata.org.AdminOrgUnitFactory;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.HROrgUnitFactory;
import com.kingdee.eas.basedata.org.HROrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.hr.org.DepResponHisInfo;
import com.kingdee.eas.hr.org.ResponsibilityTypeFactory;
import com.kingdee.eas.hr.org.ResponsibilityTypeInfo;
import com.kingdee.eas.hr.org.app.AbstractDepResponHisControllerBean;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.shr.base.syssetting.util.LocaleUtils;
import com.kingdee.util.DateTimeUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;

public class DepResponHisControllerBean
extends AbstractDepResponHisControllerBean {
    @Override
    protected void _createDepResponHisVersion(Context ctx, IObjectValue param) throws BOSException, EASBizException {
        DepResponHisInfo drhInfo = (DepResponHisInfo)param;
        String adminId = null;
        if (drhInfo.getAdminOrgUnit() != null) {
            adminId = drhInfo.getAdminOrgUnit().getId().toString();
        }
        String changeComment = drhInfo.getChangeComment();
        String versionNumber = this.getVersionNum(ctx, adminId);
        if (adminId == null) {
            this.createAllAdminDepResponHis(ctx, changeComment);
        } else {
            this.createDepResponHisByAdminId(ctx, adminId, changeComment, versionNumber);
        }
    }

    private void createAllAdminDepResponHis(Context ctx, String changeComment) throws BOSException, EASBizException {
        HashMap map = this.getMaxNumByAdminId(ctx);
        Iterator it = map.keySet().iterator();
        while (it.hasNext()) {
            String adminId = it.next().toString();
            String versionNumber = map.get(adminId).toString();
            this.createDepResponHisByAdminId(ctx, adminId, changeComment, versionNumber);
        }
    }

    private void createDepResponHisByAdminId(Context ctx, String adminId, String changeComment, String versionNumber) throws BOSException, EASBizException {
        String l = LocaleUtils.getShortCode((Context)ctx);
        String sql = "SELECT r.FHROrgUnitID, r.FWorkTask, r.FName_" + l + ", r.FNumber, r.FDescription_" + l + ", rt.FId, os.FUnitID, a.FName_" + l + ", a.FNumber FROM T_HR_Responsibility r INNER JOIN T_HR_RespType rt ON rt.FId = r.FRespTypeID INNER JOIN T_HR_OrgResp os ON os.FRespId = r.FId INNER JOIN T_ORG_Admin a ON a.FId = os.FUnitID WHERE os.FUnitID = '" + adminId + "'";
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql);
        CoreBaseCollection drhCol = new CoreBaseCollection();
        try {
            while (rs.next()) {
                DepResponHisInfo drhInfo = new DepResponHisInfo();
                HROrgUnitInfo hrOrgUnit = HROrgUnitFactory.getLocalInstance((Context)ctx).getHROrgUnitInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)rs.getString(1))));
                drhInfo.setHrOrgUnit(hrOrgUnit);
                AdminOrgUnitInfo adminOrgUnit = AdminOrgUnitFactory.getLocalInstance((Context)ctx).getAdminOrgUnitInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)rs.getString(7))));
                drhInfo.setAdminOrgUnit(adminOrgUnit);
                drhInfo.setWorkTask(rs.getString(2));
                drhInfo.setVersionNumber(versionNumber);
                drhInfo.setChangeComment(changeComment);
                drhInfo.setName(rs.getString(3));
                drhInfo.setNumber(rs.getString(4));
                drhInfo.setDescription(rs.getString(5));
                ResponsibilityTypeInfo rtInfo = ResponsibilityTypeFactory.getLocalInstance(ctx).getResponsibilityTypeInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)rs.getString(6))));
                drhInfo.setResponType(rtInfo);
                drhInfo.setAdminName(rs.getString(8));
                drhInfo.setAdminNumber(rs.getString(9));
                drhInfo.setId(BOSUuid.create((String)"22A2362A"));
                drhCol.add((CoreBaseInfo)drhInfo);
            }
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        if (drhCol != null && !drhCol.isEmpty()) {
            super.addnew(ctx, drhCol);
        }
    }

    protected void _checkNumberDup(Context ctx, IObjectValue model) throws BOSException, EASBizException {
    }

    private String getVersionNum(Context ctx, String adminId) throws BOSException {
        String dateStr;
        int count = 1;
        Date date = new Date();
        String versionNum = dateStr = DateTimeUtils.formatDate((Date)date);
        String maxVersionNum = null;
        String sql = "SELECT TOP 1 FVersionNumber FROM T_HR_DepResponHis WHERE FAdminOrgUnitId = '" + adminId + "' AND FVersionNumber LIKE '" + dateStr + "%' ORDER BY FVersionNumber DESC";
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql);
        try {
            while (rs.next()) {
                maxVersionNum = rs.getString(1);
            }
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        if (maxVersionNum == null) {
            String countStr = this.getCountStr(count);
            versionNum = versionNum + "(" + countStr + ")";
        } else {
            versionNum = maxVersionNum.substring(0, 10);
            count = Integer.parseInt(maxVersionNum.substring(11, maxVersionNum.length() - 1));
            String countStr = this.getCountStr(++count);
            versionNum = versionNum + "(" + countStr + ")";
        }
        return versionNum;
    }

    private String getCountStr(int count) {
        StringBuffer countStr = new StringBuffer();
        int countLength = String.valueOf(count).length();
        if (countLength < 3) {
            for (int i = 3; i >= countLength; --i) {
                if (i == countLength) {
                    countStr.append(String.valueOf(count));
                    continue;
                }
                countStr.append("0");
            }
        }
        return countStr.toString();
    }

    @Override
    protected Vector _getVersionNumbers(Context ctx, String adminId) throws BOSException, EASBizException {
        Vector<String> versionNumberVec = new Vector<String>();
        String sql = "SELECT DISTINCT(FVersionNumber) FROM T_HR_DepResponHis WHERE FAdminOrgUnitId = '" + adminId + "' GROUP BY FVersionNumber";
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql);
        try {
            while (rs.next()) {
                String versionNum = rs.getString(1);
                versionNumberVec.add(versionNum);
            }
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        return versionNumberVec;
    }

    private ArrayList getAllAdminIdStr(Context ctx) throws BOSException {
        ArrayList<String> adminArr = new ArrayList<String>();
        AdminOrgUnitCollection adminCol = AdminOrgUnitFactory.getLocalInstance((Context)ctx).getAdminOrgUnitCollection();
        int size = adminCol.size();
        for (int i = 0; i < size; ++i) {
            AdminOrgUnitInfo adminInfo = adminCol.get(i);
            adminArr.add(adminInfo.getId().toString());
        }
        return adminArr;
    }

    private HashMap getMaxNumByAdminId(Context ctx) throws BOSException {
        HashMap<String, String> map = new HashMap<String, String>();
        ArrayList adminArr = this.getAllAdminIdStr(ctx);
        int size = adminArr.size();
        for (int i = 0; i < size; ++i) {
            String versionNumber = this.getVersionNum(ctx, adminArr.get(i).toString());
            map.put(adminArr.get(i).toString(), versionNumber);
        }
        return map;
    }
}

