/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.org.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.basedata.org.AdminOrgUnitCollection;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitCollection;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.PositionCollection;
import com.kingdee.eas.basedata.org.PositionFactory;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.hr.org.OrgVerAdjEnum;
import com.kingdee.eas.hr.org.OrgVerAdjRecCollection;
import com.kingdee.eas.hr.org.OrgVerAdjRecInfo;
import com.kingdee.eas.hr.org.OrgVerEffectInfo;
import com.kingdee.eas.hr.org.app.IOrgVersionChecker;
import com.kingdee.eas.hr.org.app.OrgVersionCheckOrgHelper;
import com.kingdee.eas.hr.org.app.OrgVersionUtils;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.shr.base.syssetting.util.LocaleUtils;
import com.kingdee.shr.ml.util.SHRServerResource;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;

public class OrgVersionOrgCheckHandler
implements IOrgVersionChecker {
    @Override
    public OrgVerEffectInfo check(Context ctx, OrgVerEffectInfo checkResultInfo) throws BOSException, EASBizException {
        try {
            this.checkOrg(ctx, checkResultInfo);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        return checkResultInfo;
    }

    private void checkOrg(Context ctx, OrgVerEffectInfo checkResultInfo) throws SQLException, BOSException, EASBizException {
        this.checkOrgAddNewAreadyExist(ctx, checkResultInfo);
        this.orgAddNewCheck(ctx, checkResultInfo);
        this.orgOrgResponPosition(ctx, checkResultInfo);
        this.orgMoveCheck(ctx, checkResultInfo);
    }

    private void checkOrgAddNewAreadyExist(Context ctx, OrgVerEffectInfo checkResultInfo) throws BOSException {
        int i;
        OrgVerAdjRecCollection ovColl = null;
        HashMap<String, OrgVerAdjRecInfo> addNew = new HashMap<String, OrgVerAdjRecInfo>();
        try {
            ovColl = OrgVersionUtils.getOrgVerAdjRecCollection(ctx, checkResultInfo.getAdjSchmInfo().getId().toString());
            for (int i2 = 0; i2 < ovColl.size(); ++i2) {
                if (!OrgVerAdjEnum.ADDNEW.equals((Object)ovColl.get(i2).getAdjType())) continue;
                addNew.put(ovColl.get(i2).getOrgVer().getNumber(), ovColl.get(i2));
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        if (addNew.size() == 0) {
            return;
        }
        OrgVersionCheckOrgHelper helper = new OrgVersionCheckOrgHelper();
        FullOrgUnitCollection fullOrgUnitColl = helper.getAddOrgExistSameNumberFullOrg(ctx, addNew);
        AdminOrgUnitCollection adminOrgCollection = helper.getAddOrgExistNumberOrg(ctx, addNew);
        if (fullOrgUnitColl == null || fullOrgUnitColl.size() == 0) {
            return;
        }
        if (!(adminOrgCollection != null && adminOrgCollection.size() != 0 || fullOrgUnitColl != null && fullOrgUnitColl.size() != 0)) {
            return;
        }
        AdminOrgUnitInfo adminInfo = null;
        ArrayList<FullOrgUnitInfo> replaceList = new ArrayList<FullOrgUnitInfo>();
        ArrayList<FullOrgUnitInfo> confirmList = new ArrayList<FullOrgUnitInfo>();
        OrgVerAdjRecInfo recInfo = null;
        FullOrgUnitInfo fullInfo = null;
        HashMap<String, AdminOrgUnitInfo> adminOrgMap = new HashMap<String, AdminOrgUnitInfo>();
        if (adminOrgCollection != null) {
            for (i = 0; i < adminOrgCollection.size(); ++i) {
                adminOrgMap.put(adminOrgCollection.get(i).getId().toString(), adminOrgCollection.get(i));
            }
        }
        for (i = 0; i < fullOrgUnitColl.size(); ++i) {
            fullInfo = fullOrgUnitColl.get(i);
            adminInfo = (AdminOrgUnitInfo)adminOrgMap.get(fullInfo.getId().toString());
            if (adminInfo == null) {
                confirmList.add(fullInfo);
                continue;
            }
            recInfo = (OrgVerAdjRecInfo)addNew.get(adminInfo.getNumber());
            if (adminInfo.getName().equals(recInfo.getOrgVer().getName()) && adminInfo.getLevel() == recInfo.getOrgVer().getLevel()) {
                replaceList.add(fullInfo);
                continue;
            }
            confirmList.add(fullInfo);
        }
        helper.operateReplaceOrg(ctx, replaceList, addNew, checkResultInfo);
        helper.operateManualOrg(ctx, confirmList, addNew, checkResultInfo);
    }

    private void orgMoveCheck(Context ctx, OrgVerEffectInfo checkResultInfo) throws SQLException, BOSException {
        OrgVerAdjRecCollection ovColl = OrgVersionUtils.getOrgVerAdjRecCollection(ctx, checkResultInfo.getAdjSchmInfo().getId().toString());
        HashMap<String, OrgVerAdjRecInfo> move = new HashMap<String, OrgVerAdjRecInfo>();
        for (int i = 0; i < ovColl.size(); ++i) {
            if (!OrgVerAdjEnum.MOVE.equals((Object)ovColl.get(i).getAdjType())) continue;
            move.put(ovColl.get(i).getOrgVer().getAdminOrgUnit().getId().toString(), ovColl.get(i));
        }
        if (move.size() == 0) {
            return;
        }
        HashSet orgIdSet = new HashSet();
        for (Map.Entry entry : move.entrySet()) {
            orgIdSet.add(entry.getKey());
        }
        ArrayList<OrgVerAdjRecInfo> updateList = new ArrayList<OrgVerAdjRecInfo>();
        OrgVersionCheckOrgHelper helper = new OrgVersionCheckOrgHelper();
        AdminOrgUnitCollection adminOrgColl = helper.getAddOrgExistOrg(ctx, orgIdSet);
        OrgVerAdjRecInfo orgVerAdjInfo = null;
        String parentOrgHasChange = SHRServerResource.getString((String)"com.kingdee.eas.hr.org.HROrgAdjSchmVerResource", (String)"ParentOrgHasChange", (Locale)ctx.getLocale());
        for (int i = 0; i < adminOrgColl.size(); ++i) {
            orgVerAdjInfo = (OrgVerAdjRecInfo)move.get(adminOrgColl.get(i).getId().toString());
            if (orgVerAdjInfo.getBeforeMovParentID().equals(adminOrgColl.get(i).getParent().getId().toString())) continue;
            orgVerAdjInfo.setBeforeMovParentID(adminOrgColl.get(i).getParent().getId().toString());
            updateList.add(orgVerAdjInfo);
            checkResultInfo.appendWarningMsg(adminOrgColl.get(i).getName() + parentOrgHasChange);
        }
        helper.updateMoveData(ctx, updateList);
    }

    private void orgAddNewCheck(Context ctx, OrgVerEffectInfo checkResultInfo) throws BOSException, EASBizException, SQLException {
        StringBuffer sql = new StringBuffer();
        String l = LocaleUtils.getShortCode((Context)ctx);
        sql.append(" select org.fid ,org.fname_" + l + " ,org.fnumber,org.fdisplayname_" + l + "  ").append(" from t_org_admin org where ").append(checkResultInfo.getOrgWhereStr()).append(" and not exists (select FAdminOrgUnitID from T_HR_AdminOrgUnitVer b where b.fOrgAdjSchm ='").append(checkResultInfo.getAdjSchmInfo().getId().toString()).append("'").append(" and b.FAdminOrgUnitID = org.fid )");
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        StringBuffer sb = null;
        while (rowSet.next()) {
            sb = new StringBuffer();
            sb.append(ResourceBase.getString((String)"com.kingdee.eas.hr.org.HROrgAdjSchmVerResource", (String)"AfterAdjOrgInfoNotChange", (Locale)ctx.getOriginLocale(), (Object[])new String[]{rowSet.getString("fdisplayname_" + l + "")}));
            checkResultInfo.appendWarningMsg(sb.toString());
        }
    }

    private void orgOrgResponPosition(Context ctx, OrgVerEffectInfo checkResultInfo) throws BOSException, EASBizException, SQLException {
        StringBuffer sql = new StringBuffer();
        String l = LocaleUtils.getShortCode((Context)ctx);
        sql.append(" select FAdminOrgUnitID fid,fname_" + l + ",fnumber,fdisplayname_" + l + " from T_HR_AdminOrgUnitVer b where b.fOrgAdjSchm = ? ").append(" and FIsSealUp=0 and FResponPositionID is null ");
        Object[] params = new Object[]{checkResultInfo.getAdjSchmInfo().getId().toString()};
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])params);
        if (rowSet.size() == 0) {
            return;
        }
        HashSet<String> idSet = new HashSet<String>();
        while (rowSet.next()) {
            idSet.add(rowSet.getString("fid").toString());
        }
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("adminOrgUnit.id", idSet, CompareType.INCLUDE));
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("isRespPosition"));
        sic.add(new SelectorItemInfo("adminOrgUnit.id"));
        EntityViewInfo view = new EntityViewInfo();
        view.setFilter(filterInfo);
        view.setSelector(sic);
        HashSet<String> responseSet = new HashSet<String>();
        PositionCollection pColl = PositionFactory.getLocalInstance((Context)ctx).getPositionCollection(view);
        for (int i = 0; i < pColl.size(); ++i) {
            if (pColl.get(i).isIsRespPosition()) {
                responseSet.add(pColl.get(i).getAdminOrgUnit().getId().toString());
            }
            idSet.remove(pColl.get(i).getAdminOrgUnit().getId().toString());
        }
    }
}

