/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.org.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.eas.basedata.org.AdminOrgUnitFactory;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.PositionFactory;
import com.kingdee.eas.basedata.org.PositionInfo;
import com.kingdee.eas.basedata.person.PersonFactory;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.hr.org.HRAdminOrgException;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.shr.base.syssetting.util.LocaleUtils;
import com.kingdee.util.StringUtils;
import java.sql.SQLException;

public class OrgAdjLockManager {
    public static void clearLockInstanceMap(Context ctx) {
    }

    public static void checkIfOrgLocked(Context ctx, String adminOrgID, String positionID) throws BOSException, EASBizException {
        if (!StringUtils.isEmpty((String)adminOrgID)) {
            OrgAdjLockManager.checkIfLockedByAdminID(ctx, adminOrgID);
        } else if (!StringUtils.isEmpty((String)positionID)) {
            OrgAdjLockManager.checkIfLockedByPositionID(ctx, positionID);
        }
    }

    public static void checkIfOrgLockedByInfo(Context ctx, FullOrgUnitInfo orgUnitInfo) throws BOSException, EASBizException {
        if (orgUnitInfo != null && orgUnitInfo.getId() != null) {
            String adminID = orgUnitInfo.getId().toString();
            IRowSet executeQuery = DbUtil.executeQuery((Context)ctx, (String)("SELECT FLONGNUMBER FROM T_ORG_ADMINHIS WHERE FHistoryRelateID = '" + adminID + "' AND FLEFFDT = {TS'2199-12-31'}"));
            try {
                while (executeQuery.next()) {
                    String longNumber = executeQuery.getString("FLONGNUMBER");
                    OrgAdjLockManager.checkIfLockedByLongNumber(ctx, longNumber);
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
    }

    public static synchronized void prepareLockMap(Context ctx) throws BOSException, EASBizException {
    }

    public static void checkIfNameNumberUpdate(Context ctx, AdminOrgUnitInfo adminInfo, IObjectValue adminOrgHisInfo) throws BOSException, EASBizException {
        if (adminOrgHisInfo != null) {
            String longNumber = adminInfo.getLongNumber();
            String orgFrozenLongNum = "";
            String schmName = "";
            String tackerId = "";
            String trackerName = "";
            String orgNumber = adminInfo.getNumber();
            String orgName = adminInfo.getName();
            String orgNumberHis = adminOrgHisInfo.getString("number");
            String orgNameHis = adminOrgHisInfo.getString("name");
            if (!orgNumber.equals(orgNumberHis) || !orgName.equals(orgNameHis)) {
                String l = LocaleUtils.getShortCode((Context)ctx);
                String orgFrozenSql = "SELECT adminOrg.FID adminId,adminOrg.FNumber adminNumber,adminOrg.FLongNumber adminLongNumber,schm.FName_" + l + " schmName,schm.FSchmTrackerID trackerId FROM T_HR_HROrgFrozen orgFrozen LEFT JOIN T_HR_HROrgAdjSchm schm ON orgFrozen.FOrgAdjSchmID=schm.FID LEFT JOIN T_ORG_Admin adminOrg ON orgFrozen.FAdminOrgUnitID=adminOrg.FID WHERE schm.fEnableStatus = 0 OR schm.fEnableStatus = 3 AND schm.FIsLock = 1";
                IRowSet orgFrozenQuery = DbUtil.executeQuery((Context)ctx, (String)orgFrozenSql);
                try {
                    while (orgFrozenQuery.next()) {
                        orgFrozenLongNum = orgFrozenQuery.getString("adminLongNumber");
                        if (orgFrozenLongNum.indexOf(longNumber + "!") < 0 || orgFrozenLongNum.equals(longNumber)) continue;
                        schmName = orgFrozenQuery.getString("schmName");
                        tackerId = orgFrozenQuery.getString("trackerId");
                        PersonInfo personInfo = PersonFactory.getLocalInstance((Context)ctx).getPersonInfo((IObjectPK)new ObjectUuidPK(tackerId));
                        trackerName = personInfo.getName();
                        Object[] params = new Object[]{schmName, trackerName};
                        throw new HRAdminOrgException(HRAdminOrgException.ERROR_HRORGSCHMLOCKPARENT, params);
                    }
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public static void checkIfParentUpdate(Context ctx, AdminOrgUnitInfo adminInfo) throws EASBizException, BOSException {
        String oldParentId;
        String adminId = adminInfo.getId().toString();
        AdminOrgUnitInfo oldAdminInfo = AdminOrgUnitFactory.getLocalInstance((Context)ctx).getAdminOrgUnitInfo((IObjectPK)new ObjectUuidPK(adminId));
        String string = oldParentId = oldAdminInfo.getParent() != null ? oldAdminInfo.getParent().getId().toString() : null;
        if (adminInfo.getParent() != null && !adminInfo.getParent().getId().toString().equals(oldParentId)) {
            String longNumber = oldAdminInfo.getLongNumber();
            String orgFrozenLongNum = "";
            String schmName = "";
            String tackerId = "";
            String trackerName = "";
            String l = LocaleUtils.getShortCode((Context)ctx);
            String orgFrozenSql = "SELECT adminOrg.FID adminId,adminOrg.FNumber adminNumber,adminOrg.FLongNumber adminLongNumber,schm.FName_" + l + " schmName,schm.FSchmTrackerID trackerId FROM T_HR_HROrgFrozen orgFrozen LEFT JOIN T_HR_HROrgAdjSchm schm ON orgFrozen.FOrgAdjSchmID=schm.FID LEFT JOIN T_ORG_Admin adminOrg ON orgFrozen.FAdminOrgUnitID=adminOrg.FID WHERE schm.fEnableStatus = 0 OR schm.fEnableStatus = 3 AND schm.FIsLock = 1";
            IRowSet orgFrozenQuery = DbUtil.executeQuery((Context)ctx, (String)orgFrozenSql);
            try {
                while (orgFrozenQuery.next()) {
                    orgFrozenLongNum = orgFrozenQuery.getString("adminLongNumber");
                    if (orgFrozenLongNum.indexOf(longNumber + "!") < 0 || orgFrozenLongNum.equals(longNumber)) continue;
                    schmName = orgFrozenQuery.getString("schmName");
                    tackerId = orgFrozenQuery.getString("trackerId");
                    PersonInfo personInfo = PersonFactory.getLocalInstance((Context)ctx).getPersonInfo((IObjectPK)new ObjectUuidPK(tackerId));
                    trackerName = personInfo.getName();
                    Object[] params = new Object[]{schmName, trackerName};
                    throw new HRAdminOrgException(HRAdminOrgException.ERROR_HRORGSCHMLOCKPARENT, params);
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
    }

    private static void checkIfLockedByAdminID(Context ctx, String adminOrgID) throws BOSException, EASBizException {
        AdminOrgUnitInfo adminInfo = AdminOrgUnitFactory.getLocalInstance((Context)ctx).getAdminOrgUnitInfo((IObjectPK)new ObjectUuidPK(adminOrgID));
        if (adminInfo != null) {
            OrgAdjLockManager.checkIfLockedByLongNumber(ctx, adminInfo.getLongNumber());
        }
    }

    private static void checkIfLockedByLongNumber(Context ctx, String longNumber) throws BOSException, EASBizException {
        String l = LocaleUtils.getShortCode((Context)ctx);
        String orgFrozenSql = "SELECT adminOrg.FID adminId,adminOrg.FNAME_" + l + " adminName,adminOrg.FNumber adminNumber,adminOrg.FLongNumber adminLongNumber,schm.FName_" + l + " schmName,schm.FSchmTrackerID trackerId FROM T_HR_HROrgFrozen orgFrozen LEFT JOIN T_HR_HROrgAdjSchm schm ON orgFrozen.FOrgAdjSchmID=schm.FID LEFT JOIN T_ORG_Admin adminOrg ON orgFrozen.FAdminOrgUnitID=adminOrg.FID WHERE schm.FEnableStatus IN (0,3) AND schm.FIsLock = 1";
        IRowSet orgFrozenQuery = DbUtil.executeQuery((Context)ctx, (String)orgFrozenSql);
        try {
            while (orgFrozenQuery.next()) {
                String orgFrozenLongNum = orgFrozenQuery.getString("adminLongNumber");
                if (longNumber.indexOf(orgFrozenLongNum + "!") < 0 && !longNumber.equals(orgFrozenLongNum)) continue;
                String adminName = orgFrozenQuery.getString("adminName");
                String adminNumber = orgFrozenQuery.getString("adminNumber");
                String schmName = orgFrozenQuery.getString("schmName");
                String tackerId = orgFrozenQuery.getString("trackerId");
                PersonInfo personInfo = PersonFactory.getLocalInstance((Context)ctx).getPersonInfo((IObjectPK)new ObjectUuidPK(tackerId));
                String trackerName = personInfo.getName();
                String trackerNumber = personInfo.getNumber();
                Object[] params = new Object[]{adminName, adminNumber, schmName, trackerName, trackerNumber};
                throw new HRAdminOrgException(HRAdminOrgException.ERROR_HRORGSCHMLOCK, params);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    private static void checkIfLockedByPositionID(Context ctx, String positionID) throws BOSException, EASBizException {
        PositionInfo positionInfo = PositionFactory.getLocalInstance((Context)ctx).getPositionInfo((IObjectPK)new ObjectUuidPK(positionID));
        if (positionInfo != null && positionInfo.getAdminOrgUnit() != null) {
            OrgAdjLockManager.checkIfLockedByAdminID(ctx, positionInfo.getAdminOrgUnit().getId().toString());
        }
    }
}

