/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.org.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.extendcontrols.KDBizMultiLangBox;
import com.kingdee.bos.ctrl.kdf.table.IBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.swing.LanguageInfo;
import com.kingdee.bos.ctrl.swing.MultiLangItem;
import com.kingdee.bos.ctrl.swing.util.CtrlFormatUtilities;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.ISQLExecutor;
import com.kingdee.bos.dao.query.SQLExecutorFactory;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.codingrule.CodingRuleManagerFactory;
import com.kingdee.eas.base.codingrule.ICodingRuleManager;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.org.AdminOrgUnitCollection;
import com.kingdee.eas.basedata.org.AdminOrgUnitFactory;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitFactory;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.IAdminOrgUnit;
import com.kingdee.eas.basedata.org.OrgSortCodeInfo;
import com.kingdee.eas.basedata.org.OrgUnitLayerTypeFactory;
import com.kingdee.eas.basedata.org.OrgUnitLayerTypeInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.DataBaseInfo;
import com.kingdee.eas.hr.org.HrOrgBizException;
import com.kingdee.eas.hr.org.SHRAdminOrgUnitExtendInfo;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.shr.base.syssetting.json.JSONUtils;
import com.kingdee.shr.base.syssetting.util.LocaleUtils;
import com.kingdee.util.StringUtils;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;

public class OrgUtils {
    public static int[] getSelectedRows(KDTable table) {
        if (table.getRowCount() == 0 || table.getSelectManager().size() == 0) {
            return new int[0];
        }
        TreeSet<Integer> set = new TreeSet<Integer>();
        for (int i = 0; i < table.getSelectManager().size(); ++i) {
            IBlock block = KDTBlock.change((KDTable)table, (IBlock)table.getSelectManager().get(i));
            for (int j = block.getTop(); j <= block.getBottom(); ++j) {
                if (j < 0) continue;
                set.add(new Integer(j));
            }
        }
        int[] rows = new int[set.size()];
        Iterator iter = set.iterator();
        int k = 0;
        while (iter.hasNext()) {
            rows[k++] = (Integer)iter.next();
        }
        return rows;
    }

    public static Set getHrByUserNumber() throws BOSException, SQLException {
        HashSet<String> hrIdset = new HashSet<String>();
        String l = SysContext.getSysContext().getLocale().toString();
        StringBuffer sql = new StringBuffer("SELECT adminOrg.FID, adminOrg.Fname_" + l + " FROM T_org_baseunit adminOrg ");
        sql.append("LEFT JOIN T_PM_OrgRange ORGR ON adminOrg.FID = ORGR.FORGID ");
        sql.append("LEFT JOIN T_PM_USER PUSER ON PUSER.FID = ORGR.FUSERID ");
        sql.append("WHERE ORGR.FType = 10 AND PUSER.FNUMBER = '");
        sql.append(SysContext.getSysContext().getCurrentUserInfo().getNumber());
        sql.append("'");
        ISQLExecutor iSQL = SQLExecutorFactory.getRemoteInstance((String)sql.toString());
        IRowSet rows = iSQL.executeSQL();
        while (rows.next()) {
            hrIdset.add(rows.getString(1));
        }
        return hrIdset;
    }

    public static void setColumnDateFormat(KDTable kdTable, String[] columns) {
        int len = columns.length;
        for (int i = 0; i < len; ++i) {
            OrgUtils.setColumnDateFormat(kdTable, columns[i]);
        }
    }

    public static void setColumnDateFormat(KDTable kdTable, String column) {
        String dtFormat = CtrlFormatUtilities.getDateFormatString();
        kdTable.getColumn(column).getStyleAttributes().setNumberFormat(dtFormat);
    }

    public static MultiLangItem getDefaultLangItemData(KDBizMultiLangBox editor) {
        MultiLangItem name = null;
        Locale l = SysContext.getSysContext().getLocale();
        List langList = editor.getLanguageList();
        LanguageInfo langInfo = null;
        langInfo = l.toString().equalsIgnoreCase("l1") ? (LanguageInfo)langList.get(0) : (l.toString().equalsIgnoreCase("" + l + "") ? (LanguageInfo)langList.get(1) : (LanguageInfo)langList.get(2));
        name = editor.getItemBy(langInfo);
        return name;
    }

    public static int getMaxIndex(Context ctx, String adminId) throws BOSException, EASBizException {
        IRowSet rows = DbUtil.executeQuery((Context)ctx, (String)"SELECT MAX(FIndex) FROM T_ORG_Position WHERE FAdminOrgUnitID=?", (Object[])new Object[]{adminId});
        try {
            if (rows != null && rows.size() != 0) {
                rows.next();
                return rows.getInt(1);
            }
            return 0;
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }

    public static String getAdminOrgIndexString(int index) {
        return OrgSortCodeInfo.getSortCodeSuffix((int)index);
    }

    public static void updateAdminOrgIndexAndSortCode(Context ctx, int index, String sortCode, String adminOrgId) throws BOSException {
        StringBuffer updateSql = new StringBuffer();
        updateSql.append("update t_org_admin set ").append("fsortcode='").append(sortCode).append("',findex=").append(index).append(" where fid='").append(adminOrgId).append("'");
        DbUtil.execute((Context)ctx, (String)updateSql.toString());
        StringBuffer updateOuPartAdminSql = new StringBuffer();
        updateOuPartAdminSql.append("update T_ORG_OUPartAdmin set ").append("findex=").append(index).append(" where fUnitId='").append(adminOrgId).append("'");
        DbUtil.execute((Context)ctx, (String)updateOuPartAdminSql.toString());
        StringBuffer updateHisSql = new StringBuffer();
        updateHisSql.append("update t_org_adminHis set ").append("fsortcode='").append(sortCode).append("',findex=").append(index).append(" where FHistoryRelateID='").append(adminOrgId).append("'").append(" and fleffdt={ts'2199-12-31'}");
        DbUtil.execute((Context)ctx, (String)updateHisSql.toString());
        StringBuffer updateStrucSql = new StringBuffer();
        updateStrucSql.append("update T_ORG_Structure set ").append("fsortcode='").append(sortCode).append("' where fUnitID='").append(adminOrgId).append("'");
        DbUtil.execute((Context)ctx, (String)updateStrucSql.toString());
    }

    public static boolean existSubOrgPos(Context ctx, String orgId) throws BOSException, EASBizException {
        String selectOrg = "select fid from T_ORG_Admin where  FParentID = ?";
        String selectPos = "select fid from T_ORG_Position where  FAdminOrgUnitID = ?";
        IRowSet rowSet1 = DbUtil.executeQuery((Context)ctx, (String)selectOrg, (Object[])new Object[]{orgId});
        IRowSet rowSet2 = DbUtil.executeQuery((Context)ctx, (String)selectPos, (Object[])new Object[]{orgId});
        return rowSet1.size() > 0 || rowSet2.size() > 0;
    }

    public static String getDepDisplayNameByOrgId(Context ctx, String orgId) throws BOSException {
        if (orgId == null) {
            return null;
        }
        String longNumber = null;
        String displayName = "";
        Integer level = null;
        String depDisplayNameString = null;
        String l = LocaleUtils.getShortCode((Context)ctx);
        String selectOrg = "select flongnumber,fdisplayname_" + l + ",flevel from t_org_admin where fid = ?";
        IRowSet rowSet1 = DbUtil.executeQuery((Context)ctx, (String)selectOrg, (Object[])new Object[]{orgId});
        try {
            while (rowSet1.next()) {
                longNumber = rowSet1.getString("flongnumber");
                displayName = rowSet1.getString("fdisplayname_" + l + "");
                level = rowSet1.getInt("flevel");
            }
            if (!StringUtils.isEmpty(longNumber)) {
                String admName = null;
                String admLongName = null;
                Integer levelParent = null;
                String adminTypeConpany = "US3TP3eJJgbgU0A+qMDqhoRbQ4A=";
                String adminTypeGroup = "US3TP3eIJgbgU0A+qMDqhoRbQ4A=";
                StringBuffer oqlString = new StringBuffer();
                oqlString.append("select adm.fname_" + l + " fname,adm.FDISPLAYNAME_" + l + " fdisplayname, adm.flevel flevel from t_org_admin adm left join  T_Org_LayerType olt ON ADM.FLAYERTYPEID = OLT.FID");
                oqlString.append(" where adm.FNUMBER in (").append(OrgUtils.getSqlParaStr(longNumber));
                oqlString.append(") and (olt.FAdminAffiliationType = ? or olt.FAdminAffiliationType = ?) order by adm.FLEVEL desc");
                IRowSet rowSet2 = DbUtil.executeQuery((Context)ctx, (String)oqlString.toString(), (Object[])new Object[]{adminTypeConpany, adminTypeGroup});
                if (rowSet2.next()) {
                    admName = rowSet2.getString("fname");
                    admLongName = rowSet2.getString("fdisplayname");
                    levelParent = rowSet2.getInt("flevel");
                }
                if (admLongName != null) {
                    displayName = level != null && levelParent != null && level > levelParent ? displayName.replace(admLongName + "_", "") : displayName.replace(admLongName, "");
                    depDisplayNameString = displayName;
                }
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return depDisplayNameString;
    }

    public static Map<String, String> getDepDisplayNameMultiLanMapByOrgId(Context ctx, String orgId) throws BOSException {
        if (orgId == null) {
            return null;
        }
        String longNumber = null;
        Integer level = null;
        HashMap<String, String> resultMap = new HashMap<String, String>();
        ArrayList<String> displayNameMultiLanList = new ArrayList<String>();
        String selectOrg = "select flongnumber,fdisplayname_l1,fdisplayname_l2,fdisplayname_l3,flevel from t_org_admin where fid = ?";
        IRowSet rowSet1 = DbUtil.executeQuery((Context)ctx, (String)selectOrg, (Object[])new Object[]{orgId});
        try {
            while (rowSet1.next()) {
                longNumber = rowSet1.getString("flongnumber");
                displayNameMultiLanList.add(rowSet1.getString("fdisplayname_l1"));
                displayNameMultiLanList.add(rowSet1.getString("fdisplayname_l2"));
                displayNameMultiLanList.add(rowSet1.getString("fdisplayname_l3"));
                level = rowSet1.getInt("flevel");
            }
            if (!StringUtils.isEmpty(longNumber)) {
                ArrayList<String> admNameMultiLanList = new ArrayList<String>();
                ArrayList<String> admLongNameMultiLanList = new ArrayList<String>();
                Integer levelParent = null;
                String adminTypeConpany = "US3TP3eJJgbgU0A+qMDqhoRbQ4A=";
                String adminTypeGroup = "US3TP3eIJgbgU0A+qMDqhoRbQ4A=";
                StringBuffer oqlString = new StringBuffer();
                oqlString.append("select adm.fname_l1,adm.fname_l2,adm.fname_l3,adm.FDISPLAYNAME_l1,adm.FDISPLAYNAME_l2,adm.FDISPLAYNAME_l3, adm.flevel flevel from t_org_admin adm left join  T_Org_LayerType olt ON ADM.FLAYERTYPEID = OLT.FID");
                oqlString.append(" where adm.FNUMBER in (").append(OrgUtils.getSqlParaStr(longNumber));
                oqlString.append(") and (olt.FAdminAffiliationType = ? or olt.FAdminAffiliationType = ?) order by adm.FLEVEL desc");
                IRowSet rowSet2 = DbUtil.executeQuery((Context)ctx, (String)oqlString.toString(), (Object[])new Object[]{adminTypeConpany, adminTypeGroup});
                if (rowSet2.next()) {
                    admNameMultiLanList.add(rowSet2.getString("fname_l1"));
                    admNameMultiLanList.add(rowSet2.getString("fname_l2"));
                    admNameMultiLanList.add(rowSet2.getString("fname_l3"));
                    admLongNameMultiLanList.add(rowSet2.getString("fdisplayname_l1"));
                    admLongNameMultiLanList.add(rowSet2.getString("fdisplayname_l2"));
                    admLongNameMultiLanList.add(rowSet2.getString("fdisplayname_l3"));
                    levelParent = rowSet2.getInt("flevel");
                }
                if (!admLongNameMultiLanList.isEmpty()) {
                    for (int i = 0; i < admLongNameMultiLanList.size(); ++i) {
                        String admLongName = (String)admLongNameMultiLanList.get(i);
                        if (admLongName == null) continue;
                        String displayName = (String)displayNameMultiLanList.get(i);
                        if (displayName != null && level != null && levelParent != null && level > levelParent) {
                            displayName = displayName.replace(admLongName + "_", "");
                        } else if (displayName != null) {
                            displayName = displayName.replace(admLongName, "");
                        }
                        resultMap.put("displayName_l" + (i + 1), displayName);
                    }
                }
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return resultMap;
    }

    public static SHRAdminOrgUnitExtendInfo updateDepDisplayNameMultiLan(Context ctx, SHRAdminOrgUnitExtendInfo result, String orgId) throws BOSException {
        Map<String, String> depDisplayNameStringMultiLanMap = OrgUtils.getDepDisplayNameMultiLanMapByOrgId(ctx, orgId);
        result.put("depDisplayName_l1", depDisplayNameStringMultiLanMap.get("displayName_l1"));
        result.put("depDisplayName_l2", depDisplayNameStringMultiLanMap.get("displayName_l2"));
        result.put("depDisplayName_l3", depDisplayNameStringMultiLanMap.get("displayName_l3"));
        String l = LocaleUtils.getShortCode((Context)ctx);
        result.setDepDisplayName(depDisplayNameStringMultiLanMap.get("displayName_" + l));
        return result;
    }

    public static String getSqlParaStr(String para) {
        if (para == null) {
            return null;
        }
        StringBuffer paraString = null;
        String[] strParas = para.split("!");
        for (int i = 0; i < strParas.length; ++i) {
            if (paraString == null) {
                paraString = new StringBuffer();
                paraString.append("'").append(strParas[i]).append("'");
                continue;
            }
            paraString.append(",'").append(strParas[i]).append("'");
        }
        return paraString == null ? "" : paraString.toString();
    }

    public static String[] sortIdByLongnumber(String billIds, String sortType, Context ctx) {
        if (StringUtils.isEmpty((String)billIds)) {
            return null;
        }
        String[] ids = billIds.split(",");
        String idPara = "";
        String tableName = null;
        int size = ids.length;
        for (int i = 0; i < size; ++i) {
            if (tableName == null) {
                EntityObjectInfo entitobj = MetaDataLoaderFactory.getRemoteMetaDataLoader().getEntity(BOSUuid.read((String)ids[i]).getType());
                tableName = entitobj.getTable().getName();
            }
            idPara = idPara + ",'" + ids[i] + "'";
        }
        idPara = idPara == "" ? "" : idPara.substring(1);
        StringBuffer sql = new StringBuffer();
        String ORG_Hierarchy = "00000000-0000-0000-0000-000000000001396FCAD0";
        String string = tableName = "t_org_position".equalsIgnoreCase(tableName) ? "T_ORG_PositionHierarchy" : tableName;
        if ("T_ORG_PositionHierarchy".equalsIgnoreCase(tableName)) {
            sql.append("select FChildID from ").append(tableName).append(" where ");
            sql.append(" FChildID in (").append(idPara).append(") and FHIERARCHYID='" + ORG_Hierarchy + "' order by flongnumber ").append(sortType);
        } else {
            sql.append("select fid from ").append(tableName).append(" where ");
            sql.append(" Fid in (").append(idPara).append(") order by flongnumber ").append(sortType);
        }
        String sortId = "";
        try {
            IRowSet iRowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            while (iRowSet.next()) {
                sortId = sortId + "," + iRowSet.getString(1);
            }
            sortId = sortId == "" ? "" : sortId.substring(1);
        }
        catch (Exception e) {
            e.printStackTrace();
            return billIds.split(",");
        }
        return sortId.split(",");
    }

    public static Date getSealUpDate(Context ctx) throws BOSException {
        try {
            String sql = "SELECT FVALUE FROM T_HR_HRINIT WHERE Fkey = 'disableDate'";
            IRowSet executeQuery = DbUtil.executeQuery((Context)ctx, (String)sql);
            if (executeQuery.size() > 0 && executeQuery.next()) {
                SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
                String dbDateString = executeQuery.getString("FVALUE");
                return dateFormat.parse(dbDateString);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return new Date();
    }

    public static void orgNameRepeatCheck(Context ctx, AdminOrgUnitInfo adminInfo) throws BOSException, EASBizException {
        if (!OrgUtils.orgNameRepeatParam(ctx) && adminInfo.getParent() != null) {
            OrgUtils.orgNameMutiLangRepeatCheck(ctx, adminInfo);
        }
    }

    private static void orgNameMutiLangRepeatCheck(Context ctx, AdminOrgUnitInfo adminInfo) throws BOSException, EASBizException {
        for (int l = 1; l < 4; ++l) {
            IRowSet executeQuery;
            if (adminInfo.get("name_l" + l) == null) continue;
            String name = (String)adminInfo.get("name_l" + l);
            String sql = "SELECT FID FROM T_ORG_ADMIN WHERE FNAME_l" + l + " = '" + name + "'  AND FPARENTID = '" + adminInfo.getParent().getId().toString() + "'";
            if (adminInfo.getId() != null && !"".equals(adminInfo.getId().toString())) {
                sql = sql + " AND FID <> '" + adminInfo.getId().toString() + "'";
            }
            if ((executeQuery = DbUtil.executeQuery((Context)ctx, (String)sql)).size() <= 0) continue;
            throw new HrOrgBizException(HrOrgBizException.EXCEPTION22, new Object[]{name, adminInfo.getNumber()});
        }
    }

    public static boolean orgNameRepeatParam(Context ctx) throws BOSException, EASBizException {
        IRowSet executeQuery = DbUtil.executeQuery((Context)ctx, (String)"SELECT FID FROM t_hr_hrinit WHERE FKEY = 'IS_OrgName_AllowRepeat' AND FVALUE = 'true'");
        return executeQuery.size() > 0;
    }

    public static void refreshOrgSubDepName(Context ctx, String orgId) throws BOSException, EASBizException {
        HashMap<String, Map<Object, Object>> depMap = new HashMap<String, Map<Object, Object>>();
        ArrayList<Object[]> paramList = new ArrayList<Object[]>();
        AdminOrgUnitCollection orgColl = OrgUtils.getSubOrgColl(ctx, orgId);
        for (int i = 0; i < orgColl.size(); ++i) {
            AdminOrgUnitInfo orgInfo = orgColl.get(i);
            Map<Object, Object> depNameMultiLanMap = new HashMap<String, String>();
            if (orgInfo.getUnitLayerType() == null || orgInfo.getUnitLayerType().getAdminAffiliationType() == null || orgInfo.getUnitLayerType().getAdminAffiliationType().getId() == null) continue;
            String adminAffiliationTypeId = orgInfo.getUnitLayerType().getAdminAffiliationType().getId().toString();
            if ("US3TP3eIJgbgU0A+qMDqhoRbQ4A=".equals(adminAffiliationTypeId) || "US3TP3eJJgbgU0A+qMDqhoRbQ4A=".equals(adminAffiliationTypeId)) {
                depNameMultiLanMap.put("displayName_l1", "");
                depNameMultiLanMap.put("displayName_l2", "");
                depNameMultiLanMap.put("displayName_l3", "");
            } else {
                String parentId = null;
                if (orgInfo.getParent() != null && orgInfo.getParent().getId() != null) {
                    parentId = orgInfo.getParent().getId().toString();
                }
                if (StringUtils.isEmpty(parentId) || !depMap.containsKey(parentId)) {
                    depNameMultiLanMap = OrgUtils.getDepDisplayNameMultiLanMapByOrgId(ctx, orgInfo.getId().toString());
                } else {
                    Map parentDepNameMap = (Map)depMap.get(parentId);
                    if (parentDepNameMap != null && parentDepNameMap.size() > 0) {
                        for (String key : parentDepNameMap.keySet()) {
                            String depName = (String)parentDepNameMap.get(key);
                            if (!StringUtils.isEmpty((String)depName)) {
                                depNameMultiLanMap.put(key, depName + "_" + orgInfo.get("name" + key.substring(11)));
                                continue;
                            }
                            depNameMultiLanMap.put(key, String.valueOf(orgInfo.get("name" + key.substring(11))));
                        }
                    } else {
                        depNameMultiLanMap.put("displayName_l1", "");
                        depNameMultiLanMap.put("displayName_l2", "");
                        depNameMultiLanMap.put("displayName_l3", "");
                    }
                }
            }
            depMap.put(orgInfo.getId().toString(), depNameMultiLanMap);
            paramList.add(new Object[]{depNameMultiLanMap.get("displayName_l1"), depNameMultiLanMap.get("displayName_l2"), depNameMultiLanMap.get("displayName_l3"), orgInfo.getId().toString()});
        }
        String sql = "update T_HR_SHRAdminOrgUnitExtend set FDepDisplayName_l1 = ?,FDepDisplayName_l2 = ?,FDepDisplayName_l3 = ? where FAdminOrgUnitID= ?";
        DbUtil.executeBatch((Context)ctx, (String)sql, paramList);
        sql = "update T_HR_SHRAdminOrgUnitExtendhis set FDepDisplayName_l1 = ?,FDepDisplayName_l2 = ?,FDepDisplayName_l3 = ? where FAdminOrgUnitID= ? and fleffdt={ts'2199-12-31'} ";
        DbUtil.executeBatch((Context)ctx, (String)sql, paramList);
    }

    private static AdminOrgUnitCollection getSubOrgColl(Context ctx, String orgId) throws BOSException, EASBizException {
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("parent.id"));
        sic.add(new SelectorItemInfo("unitLayerType.adminAffiliationType.id"));
        view.setSelector(sic);
        if (!StringUtils.isEmpty((String)orgId)) {
            AdminOrgUnitInfo orgInfo = AdminOrgUnitFactory.getLocalInstance((Context)ctx).getAdminOrgUnitInfo((IObjectPK)new ObjectUuidPK(orgId));
            FilterInfo filter = new FilterInfo();
            FilterInfo filter1 = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("longNumber", (Object)orgInfo.getLongNumber()));
            filter1.getFilterItems().add(new FilterItemInfo("longNumber", (Object)(orgInfo.getLongNumber() + "!%"), CompareType.LIKE));
            filter.mergeFilter(filter1, "OR");
            view.setFilter(filter);
        }
        SorterItemCollection sorter = new SorterItemCollection();
        sorter.add(new SorterItemInfo("level"));
        sorter.add(new SorterItemInfo("longNumber"));
        view.setSorter(sorter);
        AdminOrgUnitCollection orgColl = AdminOrgUnitFactory.getLocalInstance((Context)ctx).getAdminOrgUnitCollection(view);
        return orgColl;
    }

    public static String getMulNameCheckSql(Context ctx, DataBaseInfo coreBaseInfo) {
        String l = LocaleUtils.getShortCode((Context)ctx);
        String name = coreBaseInfo.getName();
        String l1 = StringUtils.equalsIgnoreCase((String)l, (String)"l1") ? name : coreBaseInfo.getName(com.kingdee.util.LocaleUtils.locale_l1);
        String l2 = StringUtils.equalsIgnoreCase((String)l, (String)"l2") ? name : coreBaseInfo.getName(com.kingdee.util.LocaleUtils.locale_l2);
        String l3 = StringUtils.equalsIgnoreCase((String)l, (String)"l3") ? name : coreBaseInfo.getName(com.kingdee.util.LocaleUtils.locale_l3);
        return OrgUtils.getMulNameCheckSql(l1, l2, l3);
    }

    public static String getMulNameCheckSql(Context ctx, String nameMap) {
        String checkSql = "";
        if (!StringUtils.isEmpty((String)nameMap) && nameMap.startsWith("{")) {
            HashMap map = JSONUtils.convertJsonToObject((Context)ctx, (String)nameMap);
            checkSql = OrgUtils.getMulNameCheckSql((String)map.get("l1"), (String)map.get("l2"), (String)map.get("l3"));
        }
        return checkSql;
    }

    public static String getMulNameCheckSql(String name_l1, String name_l2, String name_l3) {
        boolean flag = false;
        String sql = "";
        if (!StringUtils.isEmpty((String)name_l1)) {
            sql = sql + " FNAME_l1 = '" + name_l1 + "'";
            flag = true;
        }
        if (!StringUtils.isEmpty((String)name_l2)) {
            sql = sql + (flag ? " or " : "");
            sql = sql + " FNAME_l2 = '" + name_l2 + "'";
            flag = true;
        }
        if (!StringUtils.isEmpty((String)name_l3)) {
            sql = sql + (flag ? " or " : "");
            sql = sql + " FNAME_l3 = '" + name_l3 + "'";
            flag = true;
        }
        sql = sql.indexOf("or") > 0 ? "( " + sql + " )" : sql;
        return sql;
    }

    public static String getAdminOrgUnitNumber(Context ctx, AdminOrgUnitInfo info) throws BOSException, EASBizException {
        String number = "";
        Boolean isAdminRule = false;
        Boolean isExists = false;
        ICodingRuleManager iCodingRuleManager = CodingRuleManagerFactory.getLocalInstance((Context)ctx);
        IAdminOrgUnit iAdminOrgUnit = AdminOrgUnitFactory.getLocalInstance((Context)ctx);
        AdminOrgUnitInfo parentAdminOrg = AdminOrgUnitFactory.getLocalInstance((Context)ctx).getAdminOrgUnitInfo((IObjectPK)new ObjectUuidPK(info.getParent().getId()));
        if (parentAdminOrg != null) {
            String mainOrgID = parentAdminOrg.getCU().getId().toString();
            FullOrgUnitInfo fullOrgUnitInfo = new FullOrgUnitInfo();
            AdminOrgUnitInfo adminOrg = new AdminOrgUnitInfo();
            int count = 0;
            if (iCodingRuleManager.isExist((IObjectValue)adminOrg, mainOrgID)) {
                isExists = true;
                isAdminRule = true;
                adminOrg.setCompany(parentAdminOrg.getCompany());
                adminOrg.setParent(parentAdminOrg);
                if (info.getUnitLayerType() != null && info.getUnitLayerType().getId() != null) {
                    OrgUnitLayerTypeInfo unitLayerType = OrgUnitLayerTypeFactory.getLocalInstance((Context)ctx).getOrgUnitLayerTypeInfo((IObjectPK)new ObjectUuidPK(info.getUnitLayerType().getId()));
                    adminOrg.setUnitLayerType(unitLayerType);
                }
                number = iCodingRuleManager.readNumber((IObjectValue)adminOrg, mainOrgID);
                while (iAdminOrgUnit.exists(" select id where number='" + number + "'")) {
                    iCodingRuleManager.getNonbreakNumber((IObjectValue)adminOrg, mainOrgID);
                    number = iCodingRuleManager.readNumber((IObjectValue)adminOrg, mainOrgID);
                    if (++count <= 1000) continue;
                    throw new EASBizException(EASBizException.CHECKDUPLICATED, new Object[]{number});
                }
            } else if (iCodingRuleManager.isExist((IObjectValue)fullOrgUnitInfo, mainOrgID)) {
                isExists = true;
                FullOrgUnitInfo parentOrgInfo = new FullOrgUnitInfo();
                parentOrgInfo.setNumber(parentAdminOrg.getNumber());
                parentOrgInfo.setName(parentAdminOrg.getName());
                parentOrgInfo.setId(parentAdminOrg.getId());
                fullOrgUnitInfo.setParent(parentOrgInfo);
                number = iCodingRuleManager.readNumber((IObjectValue)fullOrgUnitInfo, mainOrgID);
                while (iAdminOrgUnit.exists(" select id where number='" + number + "'")) {
                    iCodingRuleManager.getNonbreakNumber((IObjectValue)fullOrgUnitInfo, mainOrgID);
                    number = iCodingRuleManager.readNumber((IObjectValue)fullOrgUnitInfo, mainOrgID);
                    if (++count <= 1000) continue;
                    throw new EASBizException(EASBizException.CHECKDUPLICATED, new Object[]{number});
                }
            }
            if (isExists.booleanValue()) {
                if (isAdminRule.booleanValue()) {
                    iCodingRuleManager.recycleNumber((IObjectValue)adminOrg, mainOrgID, number);
                } else {
                    iCodingRuleManager.recycleNumber((IObjectValue)fullOrgUnitInfo, mainOrgID, number);
                }
            }
        }
        return number;
    }

    public static Boolean isExistAdminCodingRule(Context ctx, AdminOrgUnitInfo info) throws BOSException, EASBizException {
        ICodingRuleManager iCodingRuleManager = CodingRuleManagerFactory.getLocalInstance((Context)ctx);
        AdminOrgUnitInfo parentAdminOrg = null;
        if (info.getParent() != null && info.getParent().getId() != null) {
            parentAdminOrg = AdminOrgUnitFactory.getLocalInstance((Context)ctx).getAdminOrgUnitInfo((IObjectPK)new ObjectUuidPK(info.getParent().getId()));
        }
        if (parentAdminOrg != null) {
            String mainOrgID = parentAdminOrg.getCU().getId().toString();
            FullOrgUnitInfo fullOrgUnitInfo = FullOrgUnitFactory.getLocalInstance((Context)ctx).getFullOrgUnitInfo((IObjectPK)new ObjectUuidPK(info.getParent().getId()));
            return iCodingRuleManager.isExist((IObjectValue)info, mainOrgID) || iCodingRuleManager.isExist((IObjectValue)fullOrgUnitInfo, mainOrgID);
        }
        return false;
    }

    public static Set<String> getAdminRange(Context ctx) throws BOSException, EASBizException {
        HashSet<String> set = new HashSet<String>();
        UserInfo userInfo = ContextUtil.getCurrentUserInfo((Context)ctx);
        if (userInfo.getId().toString().equals("00000000-0000-0000-0000-00000000000013B7DE7F")) {
            return set;
        }
        StringBuffer sql = new StringBuffer("SELECT FORGID FROM T_PM_OrgRange WHERE FUserID='");
        sql.append(userInfo.getId().toString());
        sql.append("' AND FType = 20 ");
        try {
            IRowSet rows = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            while (rows.next()) {
                set.add(rows.getString("FORGID"));
            }
        }
        catch (SQLException ex) {
            throw new BOSException((Throwable)ex);
        }
        return set;
    }
}

