/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.ats.abnormal;

import com.kingdee.bos.Context;
import com.kingdee.bos.workflow.service.ormrpc.EnactmentServiceFactory;
import com.kingdee.bos.workflow.service.ormrpc.IEnactmentService;
import com.kingdee.eas.hr.ats.AbnormalAttendanceInfo;
import com.kingdee.eas.hr.ats.AbnormalAttendanceTaskCollection;
import com.kingdee.eas.hr.ats.AbnormalAttendanceTaskFactory;
import com.kingdee.eas.hr.ats.AbnormalAttendanceTaskInfo;
import com.kingdee.eas.hr.ats.AtsControlAsOfNumUnitEnum;
import com.kingdee.eas.hr.ats.AtsShiftInfo;
import com.kingdee.eas.hr.ats.AttenceCycleInfo;
import com.kingdee.eas.hr.ats.AttencePolicyInfo;
import com.kingdee.eas.hr.ats.AttendanceFileInfo;
import com.kingdee.eas.hr.ats.AttendancePeriodInfo;
import com.kingdee.eas.hr.ats.IAbnormalAttendance;
import com.kingdee.eas.hr.ats.ScheduleShiftInfo;
import com.kingdee.eas.hr.ats.calculate.AtsCacheUtil;
import com.kingdee.eas.hr.ats.util.AtsDateUtils;
import com.kingdee.eas.hr.ats.util.common.MLUtile;
import com.kingdee.eas.hr.base.HRBillStateEnum;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.log4j.Logger;

public class AbnormalUtils {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.hr.ats.abnormal.AbnormalUtils");

    public static AbnormalAttendanceTaskInfo selectTask(AbnormalAttendanceTaskCollection tasks, AttendanceFileInfo fileInfo) {
        AbnormalAttendanceTaskInfo realTask = null;
        for (int index = 0; index < tasks.size() && !((realTask = tasks.get(index)).isIncludeSub() ? !(!fileInfo.getAdminOrgUnit().getLongNumber().startsWith(realTask.getAdminOrgUnit().getLongNumber() + "!") && !realTask.getAdminOrgUnit().getId().toString().equalsIgnoreCase(fileInfo.getAdminOrgUnit().getId().toString()) || !realTask.isIncludeEscrow() && !fileInfo.isIsDefaultManage()) : realTask.getAdminOrgUnit().getId().toString().equalsIgnoreCase(fileInfo.getAdminOrgUnit().getId().toString()) && (realTask.isIncludeEscrow() || fileInfo.isIsDefaultManage())); ++index) {
            realTask = null;
        }
        return realTask;
    }

    public static void setRuleAndEndTime(AbnormalAttendanceInfo info, AbnormalAttendanceTaskInfo realTask, AttendanceFileInfo fileInfo, Map<String, List<AttendancePeriodInfo>> attendancePeriodInfoListMap, Map<String, AttencePolicyInfo> policyInfoMap) {
        if (realTask == null) {
            return;
        }
        info.setRuleScheme(realTask);
        if (realTask.getControlCycNumUnit().getValue() == 1) {
            Date monthsCycNumDay = AtsDateUtils.getMonthsNext(AtsDateUtils.getMonthFirstDay(info.getAttendanceDate()), realTask.getControlCycNum());
            Date monthNextFirst = AtsDateUtils.getMonthsNext(AtsDateUtils.getMonthFirstDay(info.getAttendanceDate()), 1);
            int controlAsOfNum = realTask.getControlAsOfNum();
            if (controlAsOfNum <= 1) {
                info.setAsOfDate(AtsDateUtils.getOneDayLastTime(monthNextFirst));
            } else {
                Date nextDay = AtsDateUtils.getNextDay(monthNextFirst, controlAsOfNum - 1);
                if (nextDay.getTime() <= monthsCycNumDay.getTime()) {
                    info.setAsOfDate(AtsDateUtils.getOneDayLastTime(nextDay));
                } else {
                    info.setAsOfDate(AtsDateUtils.getOneDayLastTime(monthsCycNumDay));
                }
            }
        } else {
            AttencePolicyInfo attencePolicy = fileInfo.getAttencePolicy();
            AttencePolicyInfo policyInfo = policyInfoMap.get(attencePolicy.getId().toString());
            AttenceCycleInfo attenceCycle = policyInfo.getAttenceCycle();
            List<AttendancePeriodInfo> attendancePeriodInfos = attendancePeriodInfoListMap.get(attenceCycle.getId().toString());
            AttendancePeriodInfo periodInfo = null;
            long time = info.getAttendanceDate().getTime();
            for (int index = 0; index < attendancePeriodInfos.size(); ++index) {
                periodInfo = attendancePeriodInfos.get(index);
                if (periodInfo == null || time < periodInfo.getStartDate().getTime() || time > periodInfo.getEndDate().getTime()) continue;
                int controlCycNum = realTask.getControlCycNum();
                int controlAsOfNum = realTask.getControlAsOfNum();
                AtsControlAsOfNumUnitEnum controlAsOfNumUnit = realTask.getControlAsOfNumUnit();
                int cyc = index + controlCycNum;
                Date cycDate = null;
                if (cyc < attendancePeriodInfos.size()) {
                    cycDate = attendancePeriodInfos.get(cyc).getStartDate();
                }
                Date asOfDate = null;
                if (controlAsOfNumUnit.getValue() == 1) {
                    asOfDate = AtsDateUtils.getNextDay(periodInfo.getEndDate(), controlAsOfNum);
                } else {
                    int asOfNUm = controlAsOfNum;
                    if ((asOfNUm = index + asOfNUm) < attendancePeriodInfos.size()) {
                        asOfDate = attendancePeriodInfos.get(asOfNUm).getMonthlyStatementDate();
                    }
                }
                if (cycDate == null && asOfDate == null) break;
                if (cycDate == null) {
                    info.setAsOfDate(AtsDateUtils.getOneDayLastTime(asOfDate));
                    continue;
                }
                if (asOfDate == null) {
                    info.setAsOfDate(AtsDateUtils.getOneDayLastTime(cycDate));
                    continue;
                }
                if (cycDate.getTime() <= asOfDate.getTime()) {
                    info.setAsOfDate(AtsDateUtils.getOneDayLastTime(cycDate));
                    continue;
                }
                info.setAsOfDate(AtsDateUtils.getOneDayLastTime(asOfDate));
            }
        }
    }

    public static AtsShiftInfo getAtsShift(List<ScheduleShiftInfo> scheduleShiftInfoList, AttendanceFileInfo atsFile) {
        if (scheduleShiftInfoList != null && scheduleShiftInfoList.size() > 0) {
            return scheduleShiftInfoList.get(0).getDefaultShift();
        }
        return atsFile.getAtsShift();
    }

    public static void setMunthEndDate(AbnormalAttendanceInfo info, Map<String, List<AttendancePeriodInfo>> attendancePeriodInfoListMap, Map<String, AttencePolicyInfo> policyInfoMap, AttendanceFileInfo fileInfo) {
        try {
            AttencePolicyInfo attencePolicy = fileInfo.getAttencePolicy();
            AttencePolicyInfo policyInfo = policyInfoMap.get(attencePolicy.getId().toString());
            AttenceCycleInfo attenceCycle = policyInfo.getAttenceCycle();
            List<AttendancePeriodInfo> attendancePeriodInfos = attendancePeriodInfoListMap.get(attenceCycle.getId().toString());
            AttendancePeriodInfo periodInfo = null;
            long time = info.getAttendanceDate().getTime();
            for (int index = 0; index < attendancePeriodInfos.size(); ++index) {
                periodInfo = attendancePeriodInfos.get(index);
                if (periodInfo == null || time < periodInfo.getStartDate().getTime() || time > periodInfo.getEndDate().getTime() || periodInfo.getMonthlyStatementDate() == null) continue;
                info.setMonthEndDate(periodInfo.getMonthlyStatementDate());
            }
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
    }

    public static AbnormalAttendanceTaskCollection getAbnormalTasks(Context ctx) {
        AbnormalAttendanceTaskCollection tasks = (AbnormalAttendanceTaskCollection)((Object)AtsCacheUtil.get("allAbnormalTask"));
        try {
            if (tasks == null || tasks.size() == 0) {
                tasks = AbnormalAttendanceTaskFactory.getLocalInstance(ctx).getAbnormalAttendanceTaskCollection("select *,adminOrgUnit.number,adminOrgUnit.longnumber,spcialTimes.startTime,spcialTimes.endTime,statCtrs.opStatus,statCtrs.dayValue where status = 2 order by lastUpdateTime desc");
                AtsCacheUtil.put("allAbnormalTask", (Object)tasks);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return tasks;
    }

    public static boolean isCreateSpliteDetail(Context ctx) {
        StringBuilder sb = new StringBuilder();
        sb.append(" SELECT FVALUE" + MLUtile.getMlFlag(ctx) + " VALUE FROM T_BAS_PARAMITEM ITEM ");
        sb.append(" INNER JOIN T_BAS_PARAM PARAM ON PARAM.FID = ITEM.FKEYID ");
        sb.append(" WHERE FKEYID = ? ");
        boolean flag = false;
        try {
            IRowSet row = DbUtil.executeQuery((Context)ctx, (String)sb.toString(), (Object[])new Object[]{"wtSXTEgiLI3gU8gEEazWHqiB8+c="});
            while (row.next()) {
                String value = row.getString("VALUE");
                if (StringUtils.isEmpty((String)value) || value.equalsIgnoreCase("") || value.equalsIgnoreCase("false")) {
                    flag = false;
                    continue;
                }
                flag = true;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return flag;
    }

    public static void closedAbnormal(Context ctx, AbnormalAttendanceInfo info, IAbnormalAttendance localInstance) {
        try {
            System.out.println("info+===============" + info);
            System.out.println("localInstance+===============" + localInstance);
            info.setBillState(HRBillStateEnum.AUDITED);
            localInstance.closeWF(info);
        }
        catch (Exception e) {
            String id = " no id ";
            if (info.getId() != null) {
                id = info.getId().toString();
            }
            e.printStackTrace();
            logger.error((Object)("close abnormal WF error,abnormal id is : " + id + ", error msg is  :"), (Throwable)e);
        }
    }

    public static void abortAbnormal(Context ctx, AbnormalAttendanceInfo info, IAbnormalAttendance localInstance) {
        try {
            if (null != info && null != info.getId()) {
                info.setBillState(HRBillStateEnum.AUDITED);
                IEnactmentService service = EnactmentServiceFactory.createEnactService((Context)ctx);
                service.abortProcessByHoldedObjectId(info.getId().toString());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static String createNumber(AbnormalAttendanceInfo info) {
        return UUID.randomUUID().toString().replace("-", "").toLowerCase();
    }
}

