/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.ats.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.IMetaDataLoader;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.workflow.engine.core.Mutex;
import com.kingdee.bos.workflow.exception.AlreadyInProcessQueueException;
import com.kingdee.eas.base.multiapprove.ApproveResult;
import com.kingdee.eas.base.multiapprove.IMultiApprove;
import com.kingdee.eas.base.multiapprove.MultiApproveFactory;
import com.kingdee.eas.base.multiapprove.MultiApproveInfo;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.org.AdminOrgUnitCollection;
import com.kingdee.eas.basedata.org.AdminOrgUnitFactory;
import com.kingdee.eas.basedata.person.PersonFactory;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.hr.affair.AffairBizException;
import com.kingdee.eas.hr.ats.AtsHolidayFileCollection;
import com.kingdee.eas.hr.ats.AtsHolidayFileFactory;
import com.kingdee.eas.hr.ats.AtsHolidayResEnum;
import com.kingdee.eas.hr.ats.AtsLeaveBillCollection;
import com.kingdee.eas.hr.ats.AtsLeaveBillDetailFactory;
import com.kingdee.eas.hr.ats.AtsLeaveBillEntryCollection;
import com.kingdee.eas.hr.ats.AtsLeaveBillEntryFactory;
import com.kingdee.eas.hr.ats.AtsLeaveBillEntryInfo;
import com.kingdee.eas.hr.ats.AtsLeaveBillFactory;
import com.kingdee.eas.hr.ats.AtsLeaveBillInfo;
import com.kingdee.eas.hr.ats.AtsLeaveBillResEnum;
import com.kingdee.eas.hr.ats.AtsNeedReBilll;
import com.kingdee.eas.hr.ats.AttendFileStateEnum;
import com.kingdee.eas.hr.ats.GetValueMtdEnum;
import com.kingdee.eas.hr.ats.HolidayLimitCollection;
import com.kingdee.eas.hr.ats.HolidayPolicyFactory;
import com.kingdee.eas.hr.ats.HolidayPolicyInfo;
import com.kingdee.eas.hr.ats.IAtsLeaveBill;
import com.kingdee.eas.hr.ats.IsAttendanceEnum;
import com.kingdee.eas.hr.ats.OperActionEnum;
import com.kingdee.eas.hr.ats.OperTypeEnum;
import com.kingdee.eas.hr.ats.ResourceEnum;
import com.kingdee.eas.hr.ats.app.AbstractAtsLeaveBillControllerBean;
import com.kingdee.eas.hr.ats.common.AtsTempTableUtil;
import com.kingdee.eas.hr.ats.decimalPlace.util.DecimalPlaceUtil;
import com.kingdee.eas.hr.ats.holidayLimit.AtsLeaveBillRockBackLimit;
import com.kingdee.eas.hr.ats.holidayLimit.CalculateLeaveBillLengthTool;
import com.kingdee.eas.hr.ats.holidayLimit.CancelHolidayLimit.CancelBillOperateLimitEntrance;
import com.kingdee.eas.hr.ats.holidayLimit.CoreBaseDeductHolidayLimit;
import com.kingdee.eas.hr.ats.holidayLimit.CoreBaseRockBackLimit;
import com.kingdee.eas.hr.ats.holidayLimit.generate.util.HRTimeWebUtils;
import com.kingdee.eas.hr.ats.result.AttendCalculateJob;
import com.kingdee.eas.hr.ats.thread.ExecutorService.TaskPool;
import com.kingdee.eas.hr.ats.thread.executor.Callable;
import com.kingdee.eas.hr.ats.util.AtsBillEntryHandlerUtils;
import com.kingdee.eas.hr.ats.util.AtsDateUtils;
import com.kingdee.eas.hr.ats.util.AtsLeaveBillSplitHelper;
import com.kingdee.eas.hr.ats.util.AtsScheduleShiftUtil;
import com.kingdee.eas.hr.ats.util.AtsServerUtils;
import com.kingdee.eas.hr.ats.util.AtsSetLeaveBillEntryUtil;
import com.kingdee.eas.hr.ats.util.SHRBillServerUtil;
import com.kingdee.eas.hr.ats.util.common.DataSaver;
import com.kingdee.eas.hr.ats.util.common.MLUtile;
import com.kingdee.eas.hr.base.ApproveTypeEnum;
import com.kingdee.eas.hr.base.HRBillBaseInfo;
import com.kingdee.eas.hr.base.HRBillStateEnum;
import com.kingdee.eas.hr.base.IHRBillBase;
import com.kingdee.eas.hr.base.app.BillExtendBeanProcess;
import com.kingdee.eas.hr.base.app.HRBillBeanBizFactory;
import com.kingdee.eas.hr.base.app.IHRBillBizBean;
import com.kingdee.eas.hr.base.app.PlugInBeanFactory;
import com.kingdee.eas.hr.base.app.PlugInBeanProxy;
import com.kingdee.eas.hr.base.app.util.MetaDataServerUtil;
import com.kingdee.eas.hr.base.util.IReflectMethod;
import com.kingdee.eas.rpts.ctrlreport.osf.OSFExecutor;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.shr.base.syssetting.app.osf.OSFAppUtil;
import com.kingdee.shr.base.syssetting.util.LocaleUtils;
import com.kingdee.util.NumericExceptionSubItem;
import com.kingdee.util.StringUtils;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ThreadPoolExecutor;
import org.apache.log4j.Logger;

public class AtsLeaveBillControllerBean
extends AbstractAtsLeaveBillControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.hr.ats.app.AtsLeaveBillControllerBean");
    private static ThreadLocal<Map<String, Boolean>> isCallACJobThreadLocal = new ThreadLocal();
    private IHRBillBizBean bizBean = null;

    public void rollBackHolidayLimit(Context ctx, BOSUuid billId, int forzenType) throws EASBizException, BOSException {
        CoreBaseRockBackLimit coreBaseRollBackLimit = new CoreBaseRockBackLimit(ctx, billId.toString(), forzenType);
        coreBaseRollBackLimit.operateHolidayLimitProcess(ctx);
    }

    public void deductHolidayLimit(Context ctx, BOSUuid billId, int forzenType) throws EASBizException, BOSException {
        CoreBaseDeductHolidayLimit coreBaseDeductLimit = new CoreBaseDeductHolidayLimit(ctx, billId.toString(), forzenType);
        coreBaseDeductLimit.operateHolidayLimitProcess(ctx);
    }

    @Override
    protected void _setApproveState(Context ctx, BOSUuid billId) throws BOSException, EASBizException {
        try {
            Thread.sleep(3000L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        super._setApproveState(ctx, billId);
        ctx.put((Object)(billId.toString() + "_OperType"), (Object)"leaveBill");
        ctx.put((Object)(billId.toString() + "_OperAction"), (Object)"submit");
        this.rollBackHolidayLimit(ctx, billId, 6);
        this.deductHolidayLimit(ctx, billId, 6);
        ctx.remove((Object)(billId.toString() + "_OperType"));
        ctx.remove((Object)(billId.toString() + "_OperAction"));
    }

    @Override
    protected IObjectPK _submitEffect(Context ctx, CoreBaseInfo model) throws BOSException, EASBizException {
        AtsLeaveBillInfo bill = (AtsLeaveBillInfo)model;
        bill = CancelBillOperateLimitEntrance.setBillSourceUnitRequest(ctx, bill);
        bill.setApproveType(ApproveTypeEnum.DIRECT);
        bill.setBillState(HRBillStateEnum.AUDITED);
        IObjectPK objectPK = super.save(ctx, model);
        this.setAudited(ctx, BOSUuid.read((String)objectPK.toString()));
        return objectPK;
    }

    @Override
    protected void _submitEffectBatch(Context ctx, CoreBaseCollection models) throws BOSException, EASBizException {
        AtsLeaveBillFactory.getLocalInstance(ctx).save(models);
        for (int i = 0; i < models.size(); ++i) {
            AtsLeaveBillFactory.getLocalInstance(ctx).setAudited(models.get(i).getId());
        }
    }

    @Override
    public void _setAudited(Context ctx, BOSUuid billID) throws BOSException, EASBizException {
        if (billID == null) {
            return;
        }
        AtsLeaveBillInfo atsLeaveBillInfo = AtsLeaveBillFactory.getLocalInstance(ctx).getAtsLeaveBillInfo("where id = '" + billID.toString() + "'");
        AtsLeaveBillEntryCollection atsLeaveBillEntryCollection = AtsLeaveBillEntryFactory.getLocalInstance(ctx).getAtsLeaveBillEntryCollection("where bill.id = '" + billID.toString() + "'");
        AtsLeaveBillCollection atsLeaveBillCollection = AtsLeaveBillFactory.getLocalInstance(ctx).getAtsLeaveBillCollection("where id = '" + billID.toString() + "'");
        CoreBaseCollection newLimit = new CoreBaseCollection();
        if (atsLeaveBillEntryCollection.size() > 0) {
            for (int i = 0; i < atsLeaveBillEntryCollection.size(); ++i) {
                AtsLeaveBillEntryInfo atsLeaveBillEntry = atsLeaveBillEntryCollection.get(i);
                boolean flag = AtsSetLeaveBillEntryUtil.isRecallLeaveBill(ctx, atsLeaveBillCollection.get(0).getCreateTime(), atsLeaveBillEntry);
                if (flag) {
                    atsLeaveBillEntry.setIsRecallBill(AtsNeedReBilll.yes);
                }
                atsLeaveBillEntry.setLastUpdateUser((UserInfo)ctx.get((Object)"UserInfo"));
                atsLeaveBillEntry.setLastUpdateTime(HRTimeWebUtils.dateToTimestamp(new Date()));
                newLimit.add((CoreBaseInfo)atsLeaveBillEntry);
            }
            DataSaver dataSaver = new DataSaver();
            dataSaver.setCtx(ctx).save(newLimit);
        }
        HRBillBaseInfo model = this.getHRBillBaseInfo(ctx, (IObjectPK)new ObjectUuidPK(billID));
        if (this.bizBean != null) {
            this.bizBean._personPlanChek(ctx, (IObjectValue)model);
        }
        this.initBizBean(ctx);
        this.updateBillState(ctx, billID, HRBillStateEnum.AUDITED);
        if (this.bizBean != null) {
            this.bizBean._setBillState(ctx, billID, HRBillStateEnum.AUDITED);
        }
        if (ApproveTypeEnum.DIRECT.equals((Object)model.getApproveType())) {
            this.saveMultiApproveInfo(ctx, billID);
        }
        ctx.put((Object)(billID + "_OperType"), (Object)"leaveBill");
        ctx.put((Object)(billID + "_OperAction"), (Object)"submitEffect");
        this.deductHolidayLimit(ctx, billID, 4);
        ctx.remove((Object)(billID + "_OperType"));
        ctx.remove((Object)(billID + "_OperAction"));
        int size = atsLeaveBillInfo.getEntries().size();
        AtsLeaveBillEntryCollection billEntryColl = AtsLeaveBillEntryFactory.getLocalInstance(ctx).getAtsLeaveBillEntryCollection(" where bill='" + atsLeaveBillInfo.getId().toString() + "'");
        for (int i = 0; i < size; ++i) {
            AtsLeaveBillSplitHelper atsLeaveBillSplitHelper = new AtsLeaveBillSplitHelper(ctx, atsLeaveBillInfo, billEntryColl.get(i));
            atsLeaveBillSplitHelper.splitLeaveBill();
        }
    }

    private void saveMultiApproveInfo(Context ctx, BOSUuid billId) throws BOSException, EASBizException {
        IMultiApprove im = MultiApproveFactory.getLocalInstance((Context)ctx);
        MultiApproveInfo info = new MultiApproveInfo();
        info.setIsPass(ApproveResult.PASS);
        info.setOpinion(ResourceBase.getString((String)"com.kingdee.eas.hr.base.BASEAutoGenerateResource", (String)"0_HRBillBaseControllerBean", (Locale)ctx.getLocale()));
        info.setBillId(billId);
        info.setBosTypeStr(billId.getType().toString());
        im.addnew((CoreBaseInfo)info);
    }

    private void initBizBean(Context ctx) throws BOSException, EASBizException {
        if (this.bizBean == null) {
            this.bizBean = this.getBizBean();
            if (this.bizBean != null) {
                BillExtendBeanProcess billExtend = BillExtendBeanProcess.getInstance((String)this.bizBean.getExtendBillName(ctx));
                PlugInBeanProxy plugIn = null;
                IMetaDataLoader loader = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx);
                EntityObjectInfo entity = loader.getEntity(this.getBOSType());
                if (entity != null) {
                    String fullName = entity.getFullName();
                    try {
                        plugIn = PlugInBeanFactory.getPlugIn((Context)ctx, (String)fullName);
                    }
                    catch (Exception e) {
                        throw new BOSException("PlugInBean Get Error:" + e.getMessage(), e.getCause());
                    }
                }
                IReflectMethod[] decorators = null;
                if (plugIn != null && billExtend != null) {
                    decorators = new IReflectMethod[]{plugIn, billExtend};
                } else if (billExtend != null) {
                    decorators = new IReflectMethod[]{billExtend};
                } else if (plugIn != null) {
                    decorators = new IReflectMethod[]{plugIn};
                }
                if (decorators != null) {
                    try {
                        this.bizBean = new HRBillBeanBizFactory(this.bizBean).getBizProxy(decorators);
                    }
                    catch (Throwable e) {
                        throw new BOSException("bizBean:" + this.bizBean.getExtendBillName(ctx) + ";plugin:" + plugIn, e);
                    }
                }
            }
        }
    }

    @Override
    protected void _abortBizBill(Context ctx, String billId) throws BOSException, EASBizException {
        if (!StringUtils.isEmpty((String)billId)) {
            IHRBillBase iHRBillBase = (IHRBillBase)MetaDataServerUtil.getBizInterface((Context)ctx, (BOSObjectType)BOSUuid.read((String)billId).getType());
            HRBillBaseInfo billInfo = iHRBillBase.getHRBillBaseInfo((IObjectPK)new ObjectUuidPK(billId));
            HRBillStateEnum billState = billInfo.getBillState();
            if (HRBillStateEnum.SUBMITED.equals((Object)billState) || HRBillStateEnum.AUDITING.equals((Object)billState) || HRBillStateEnum.AUDITEND.equals((Object)billState)) {
                iHRBillBase.setSaved(BOSUuid.read((String)billId));
                this.abortWorkFlow(ctx, billId);
            } else {
                throw new AffairBizException(AffairBizException.BILLSTATECANTSUPPORT);
            }
        }
    }

    @Override
    protected Map _importAtsLeaveBillData(Context ctx, List list, boolean isOverImport, int errorHandleMode) throws BOSException, EASBizException {
        return null;
    }

    @Override
    protected void _invalid(Context ctx, String id) throws BOSException {
    }

    @Override
    protected void _leaveBillTriggerCal(Context ctx, String beginTime, String endTime, String billId, String personId, String hrOrgUnitId) throws BOSException, EASBizException {
        String serviceName = "leaveBillTrigerCalculateOSF";
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("billId", billId);
        param.put("personId", personId);
        param.put("beginTime", beginTime);
        param.put("endTime", endTime);
        param.put("hrOrgUnitId", hrOrgUnitId);
        OSFAppUtil osfUtil = new OSFAppUtil();
        Object osfObject = OSFAppUtil.callService((Context)ctx, (String)serviceName, param);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void _holidayLimitDeduct(Context ctx, String billId) throws BOSException {
        Set<String> holidayLimitIDSet = SHRBillServerUtil.getHolidayLimitInfoByBillID(ctx, billId);
        HashSet<String> hasLock = new HashSet<String>();
        try {
            for (String string : holidayLimitIDSet) {
                if (!Mutex.lock((Context)ctx, (String)string)) continue;
                hasLock.add(string);
            }
            this.rollBackHolidayLimit(ctx, BOSUuid.read((String)billId), 6);
            this.deductHolidayLimit(ctx, BOSUuid.read((String)billId), 4);
            AtsLeaveBillInfo atsLeaveBillInfo = AtsLeaveBillFactory.getLocalInstance(ctx).getAtsLeaveBillInfo((IObjectPK)new ObjectUuidPK(billId.toString()));
            int n = atsLeaveBillInfo.getEntries().size();
            AtsLeaveBillEntryCollection billEntryColl = AtsLeaveBillEntryFactory.getLocalInstance(ctx).getAtsLeaveBillEntryCollection(" where bill='" + atsLeaveBillInfo.getId().toString() + "'");
            for (int i = 0; i < n; ++i) {
                AtsLeaveBillSplitHelper atsLeaveBillSplitHelper = new AtsLeaveBillSplitHelper(ctx, atsLeaveBillInfo, billEntryColl.get(i));
                atsLeaveBillSplitHelper.splitLeaveBill();
            }
        }
        catch (AlreadyInProcessQueueException e) {
            for (String id : hasLock) {
                Mutex.unlock((Context)ctx, (String)id);
            }
            try {
                Thread.sleep(5000L);
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
            this._holidayLimitDeduct(ctx, billId);
        }
        catch (EASBizException e) {
            e.printStackTrace();
        }
        finally {
            for (String string : hasLock) {
                Mutex.unlock((Context)ctx, (String)string);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Could not resolve type clashes
     * Loose catch block
     */
    public void _holidayLimitDeductAlls(Context ctx, String billId) throws BOSException {
        Set<String> holidayLimitIDSet = SHRBillServerUtil.getHolidayLimitInfoByBillID(ctx, billId);
        HashSet<String> hasLock = new HashSet<String>();
        try {
            for (String id : holidayLimitIDSet) {
                if (!Mutex.lock((Context)ctx, (String)id)) continue;
                hasLock.add(id);
            }
            this.rollBackHolidayLimit(ctx, BOSUuid.read((String)billId), 4);
            this.deductHolidayLimit(ctx, BOSUuid.read((String)billId), 4);
        }
        catch (AlreadyInProcessQueueException e) {
            for (String id : hasLock) {
                Mutex.unlock((Context)ctx, (String)id);
            }
            try {
                Thread.sleep(5000L);
            }
            catch (InterruptedException e1) {
                e1.printStackTrace();
            }
            this._holidayLimitDeductAlls(ctx, billId);
        }
        catch (EASBizException e2) {
            e2.printStackTrace();
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            for (Object id : hasLock) {
                Mutex.unlock((Context)ctx, (String)id);
            }
        }
        for (String id : hasLock) {
            Mutex.unlock((Context)ctx, (String)id);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void _setPassState_atsLeaveBill(Context ctx, BOSUuid billId) throws BOSException, EASBizException {
        ctx.put((Object)(billId.toString() + "_OperType"), (Object)"leaveBill");
        ctx.put((Object)(billId.toString() + "_OperAction"), (Object)"approved");
        AtsLeaveBillEntryCollection atsLeaveBillEntryCollection = AtsLeaveBillEntryFactory.getLocalInstance(ctx).getAtsLeaveBillEntryCollection("where bill.id = '" + billId.toString() + "'");
        AtsLeaveBillCollection atsLeaveBillCollection = AtsLeaveBillFactory.getLocalInstance(ctx).getAtsLeaveBillCollection("where id = '" + billId.toString() + "'");
        CoreBaseCollection newLimit = new CoreBaseCollection();
        if (atsLeaveBillEntryCollection.size() > 0) {
            for (int i = 0; i < atsLeaveBillEntryCollection.size(); ++i) {
                AtsLeaveBillEntryInfo atsLeaveBillEntry = atsLeaveBillEntryCollection.get(i);
                boolean flag = AtsSetLeaveBillEntryUtil.isRecallLeaveBill(ctx, atsLeaveBillCollection.get(0).getCreateTime(), atsLeaveBillEntry);
                if (flag) {
                    atsLeaveBillEntry.setIsRecallBill(AtsNeedReBilll.yes);
                }
                atsLeaveBillEntry.setLastUpdateUser((UserInfo)ctx.get((Object)"UserInfo"));
                atsLeaveBillEntry.setLastUpdateTime(HRTimeWebUtils.dateToTimestamp(new Date()));
                newLimit.add((CoreBaseInfo)atsLeaveBillEntry);
            }
            DataSaver dataSaver = new DataSaver();
            dataSaver.setCtx(ctx).save(newLimit);
        }
        IAtsLeaveBill iAtsLeaveBill = AtsLeaveBillFactory.getLocalInstance(ctx);
        Class<AtsLeaveBillControllerBean> clazz = AtsLeaveBillControllerBean.class;
        synchronized (AtsLeaveBillControllerBean.class) {
            iAtsLeaveBill.holidayLimitDeduct(billId.toString());
            this._setState(ctx, billId, HRBillStateEnum.AUDITED);
            // ** MonitorExit[var7_8] (shouldn't be in output)
            ctx.remove((Object)(billId.toString() + "_OperType"));
            ctx.remove((Object)(billId.toString() + "_OperAction"));
            return;
        }
    }

    public void dealAllHolidayLimit(Context ctx, BOSUuid billId) {
        try {
            ThreadPoolExecutor pool = TaskPool.getFixedInstance("updateHolidayLimit", 1, 10L);
            pool.submit((Callable)new Callable<Object>(){

                @Override
                public Object call() throws Exception {
                    return null;
                }
            }.setDependency(billId).setCtx(ctx));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void updateHolidayLimit(Context ctx, BOSUuid billId) throws BOSException, EASBizException {
        StringBuffer buff = new StringBuffer();
        buff.append(" select FLeaveBillID from (select fproposerId as personId,FLeaveBillID,sum(FChangeValue) as FChangeValue,FChangeType from  T_HR_ATS_HolidayLimitDetail where FChangeType='4' group by ");
        buff.append(" fproposerId,FLeaveBillID,FChangeType)detail inner join T_HR_ATS_LeaveBillEntry entry on entry.FPersonID=detail.personId inner join T_HR_ATS_LeaveBill bill on bill.fid=entry.FBillID where bill.FBillState='3' and detail.FLeaveBillID=entry.FBillID  and ");
        buff.append(" detail.FChangeValue <> entry.FRealLeaveLength ");
        long l = System.currentTimeMillis();
        logger.error((Object)("query all limit start------------" + System.currentTimeMillis()));
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)buff.toString());
        long t = System.currentTimeMillis() - l;
        logger.error((Object)("query all limit end------------" + t));
        try {
            while (rowSet.next()) {
                this._holidayLimitDeductAlls(ctx, rowSet.getString("FLeaveBillID"));
                logger.error((Object)("query all limit bill which has problem id------------" + rowSet.getString("FLeaveBillID")));
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void _setEditState(Context ctx, BOSUuid billId) throws BOSException, EASBizException {
        ctx.put((Object)(billId.toString() + "_OperType"), (Object)"leaveBill");
        ctx.put((Object)(billId.toString() + "_OperAction"), (Object)"modify");
        IAtsLeaveBill iAtsLeaveBill = AtsLeaveBillFactory.getLocalInstance(ctx);
        Class<AtsLeaveBillControllerBean> clazz = AtsLeaveBillControllerBean.class;
        synchronized (AtsLeaveBillControllerBean.class) {
            iAtsLeaveBill.holidayLimitRollback(billId.toString());
            // ** MonitorExit[var4_4] (shouldn't be in output)
            super._setEditState(ctx, billId);
            ctx.remove((Object)(billId.toString() + "_OperType"));
            ctx.remove((Object)(billId.toString() + "_OperAction"));
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void _setNoPassState(Context ctx, BOSUuid billId) throws BOSException, EASBizException {
        ctx.put((Object)(billId.toString() + "_OperType"), (Object)"leaveBill");
        ctx.put((Object)(billId.toString() + "_OperAction"), (Object)"noPass");
        AtsLeaveBillEntryCollection atsLeaveBillEntryCollection = AtsLeaveBillEntryFactory.getLocalInstance(ctx).getAtsLeaveBillEntryCollection("where bill.id = '" + billId.toString() + "'");
        CoreBaseCollection newLimit = new CoreBaseCollection();
        if (atsLeaveBillEntryCollection.size() > 0) {
            for (int i = 0; i < atsLeaveBillEntryCollection.size(); ++i) {
                AtsLeaveBillEntryInfo atsLeaveBillEntry = atsLeaveBillEntryCollection.get(i);
                atsLeaveBillEntry.setLastUpdateUser((UserInfo)ctx.get((Object)"UserInfo"));
                atsLeaveBillEntry.setLastUpdateTime(HRTimeWebUtils.dateToTimestamp(new Date()));
                newLimit.add((CoreBaseInfo)atsLeaveBillEntry);
            }
            DataSaver dataSaver = new DataSaver();
            dataSaver.setCtx(ctx).save(newLimit);
        }
        IAtsLeaveBill iAtsLeaveBill = AtsLeaveBillFactory.getLocalInstance(ctx);
        Class<AtsLeaveBillControllerBean> clazz = AtsLeaveBillControllerBean.class;
        synchronized (AtsLeaveBillControllerBean.class) {
            iAtsLeaveBill.holidayLimitRollback(billId.toString());
            // ** MonitorExit[var6_7] (shouldn't be in output)
            super._setNoPassState(ctx, billId);
            ctx.remove((Object)(billId.toString() + "_OperType"));
            ctx.remove((Object)(billId.toString() + "_OperAction"));
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Could not resolve type clashes
     * Loose catch block
     */
    @Override
    protected void _holidayLimitRollback(Context ctx, String billId) throws BOSException {
        System.out.println("_setEditState   unaudit state  rollback start:  " + billId);
        Set<String> holidayLimitIDSet = SHRBillServerUtil.getHolidayLimitInfoByBillID(ctx, billId);
        HashSet<String> hasLock = new HashSet<String>();
        try {
            for (String id : holidayLimitIDSet) {
                if (!Mutex.lock((Context)ctx, (String)id)) continue;
                hasLock.add(id);
            }
            this.rollBackHolidayLimit(ctx, BOSUuid.read((String)billId), 6);
        }
        catch (AlreadyInProcessQueueException e) {
            for (String id : hasLock) {
                Mutex.unlock((Context)ctx, (String)id);
            }
            try {
                Thread.sleep(5000L);
            }
            catch (InterruptedException e1) {
                e1.printStackTrace();
            }
            this._holidayLimitRollback(ctx, billId);
        }
        catch (EASBizException e2) {
            e2.printStackTrace();
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            for (Object id : hasLock) {
                Mutex.unlock((Context)ctx, (String)id);
            }
        }
        for (String id : hasLock) {
            Mutex.unlock((Context)ctx, (String)id);
        }
        System.out.println("_setEditState  unaudit state  rollback end:  " + billId);
    }

    private boolean validate(Context ctx, AtsLeaveBillEntryInfo info, Map<String, Object> parmMap) throws EASBizException, BOSException {
        String holidayPolicyId = info.getPolicy().getId().toString();
        HolidayPolicyInfo holidayPolicyInfo = AtsServerUtils.getHolidayPolicyInfoById(ctx, holidayPolicyId);
        String atsLeaveBillInfoId = info.getBill().getId().toString();
        AtsLeaveBillInfo atsLeaveBillInfo = AtsLeaveBillFactory.getLocalInstance(ctx).getAtsLeaveBillInfo((IObjectPK)new ObjectUuidPK(atsLeaveBillInfoId));
        String atsLeaveBillId = atsLeaveBillInfo.getId().toString();
        String personId = info.getPerson().getId().toString();
        String personName = PersonFactory.getLocalInstance((Context)ctx).getPersonInfo((IObjectPK)new ObjectUuidPK(personId)).getName();
        Boolean isOver = holidayPolicyInfo.isIsOver();
        Boolean isNeedAttachWhenIsOver = holidayPolicyInfo.isIsNeedAttachOver();
        Boolean isBatchUrl = 1 == atsLeaveBillInfo.getBillType().getValue();
        double leaveLength = (Double)parmMap.get("realLen");
        Timestamp startTime = info.getRealBeginTime();
        Timestamp endTime = info.getRealEndTime();
        String holidayType = holidayPolicyInfo.getHolidayType().getId().toString();
        String holidayTypeName = holidayPolicyInfo.getName();
        String atsLeaveBillInfoNumber = atsLeaveBillInfo.getNumber();
        Object _operAction = ctx.get((Object)(atsLeaveBillId.toString() + "_OperAction"));
        if (null != _operAction && _operAction == "schedualRecalculate") {
            isOver = true;
        }
        HolidayLimitCollection holidayLimitCollection = CalculateLeaveBillLengthTool.getHolidayLimitCollectionByPersonIdAndStartOrEndTime(ctx, personId, holidayType, startTime, endTime);
        if (!holidayPolicyInfo.isIsCtrlLimit()) {
            return true;
        }
        if (holidayLimitCollection == null || holidayLimitCollection.size() == 0) {
            if (!isOver.booleanValue()) {
                HolidayLimitCollection holidayLimitColl = CalculateLeaveBillLengthTool.getHolidayLimitCollectionByPersonIdAndStartOrEndTimeAll(ctx, personId, holidayType, startTime, endTime);
                if (holidayLimitColl != null && holidayLimitColl.size() != 0) {
                    parmMap.put("errorString", MLUtile.getRes((ResourceEnum)AtsLeaveBillResEnum.InIneffectiveTimeCycle, ctx, atsLeaveBillInfoNumber + personName + "[" + holidayTypeName + "]") + "\uff01");
                } else {
                    parmMap.put("errorString", atsLeaveBillInfoNumber + personName + "[" + holidayTypeName + "]" + MLUtile.getRes(AtsHolidayResEnum.NoLimitInfo, ctx));
                }
                return false;
            }
            if (isNeedAttachWhenIsOver.booleanValue() && isBatchUrl.booleanValue()) {
                String TempErrorString = CalculateLeaveBillLengthTool.validateIsNeedAttach(ctx, atsLeaveBillId);
                if (!TempErrorString.equals("")) {
                    parmMap.put("errorString", MLUtile.getRes((ResourceEnum)AtsLeaveBillResEnum.OverLeaveUploadAttachmentDesc, ctx, atsLeaveBillInfoNumber + personName + "[" + holidayTypeName + "]") + "\uff01");
                    return false;
                }
                return true;
            }
            return true;
        }
        HolidayLimitCollection holidayLimitCollectionReal = CalculateLeaveBillLengthTool.getHolidayLimitCollectionByPersonIdAndStartEndTime(ctx, personId, holidayType, startTime, endTime);
        if (holidayLimitCollectionReal == null || holidayLimitCollectionReal.size() == 0) {
            parmMap.put("errorString", MLUtile.getRes((ResourceEnum)AtsLeaveBillResEnum.ForbidOverCycleLeave, ctx, atsLeaveBillInfoNumber + personName + "[" + holidayTypeName + "]") + "\uff01");
            return false;
        }
        BigDecimal remainLimitLength = BigDecimal.valueOf(0L);
        holidayLimitCollectionReal.sort("cyclebegindate");
        holidayLimitCollectionReal.sort("delaydate");
        for (int i = 0; i < holidayLimitCollectionReal.size(); ++i) {
            if (i == holidayLimitCollectionReal.size() - 1) {
                remainLimitLength = remainLimitLength.add(holidayLimitCollectionReal.get(i).getRemainLimit());
                continue;
            }
            if (holidayLimitCollectionReal.get(i).getRemainLimit().compareTo(BigDecimal.ZERO) != 1) continue;
            remainLimitLength = remainLimitLength.add(holidayLimitCollectionReal.get(i).getRemainLimit());
        }
        BigDecimal bdleaveLength = BigDecimal.valueOf(leaveLength).setScale(DecimalPlaceUtil.getDecimalPlaceSystem(ctx), RoundingMode.HALF_UP);
        Boolean isOverLimit = bdleaveLength.compareTo(remainLimitLength) == 1;
        if (isOver.booleanValue()) {
            if (isOverLimit.booleanValue() && isNeedAttachWhenIsOver.booleanValue() && isBatchUrl.booleanValue()) {
                String errorString = CalculateLeaveBillLengthTool.validateIsNeedAttach(ctx, atsLeaveBillId);
                if (!errorString.equals("")) {
                    parmMap.put("errorString", MLUtile.getRes((ResourceEnum)AtsLeaveBillResEnum.OverLeaveUploadAttachment, ctx, atsLeaveBillInfoNumber + personName + "[" + holidayTypeName + "]"));
                    return false;
                }
                return true;
            }
            return true;
        }
        if (isOverLimit.booleanValue()) {
            parmMap.put("errorString", atsLeaveBillInfoNumber + personName + "[" + holidayTypeName + "]" + MLUtile.getRes(AtsHolidayResEnum.LeakRemainLimit, ctx));
            return false;
        }
        return true;
    }

    @Override
    protected void _calculateLeaveBillEntry(Context ctx, AtsLeaveBillEntryInfo info, Map parmMap) throws BOSException, EASBizException {
        String leaveBillId = info.getBill().getId().toString();
        String personId = info.getPerson().getId().toString();
        ctx.put((Object)(leaveBillId + "_OperType"), (Object)"leaveBill");
        ctx.put((Object)(leaveBillId + "_OperAction"), (Object)"schedualRecalculate");
        AtsLeaveBillRockBackLimit atsLeaveBillRockBackLimit = new AtsLeaveBillRockBackLimit(ctx, leaveBillId, 4);
        atsLeaveBillRockBackLimit.rockBackLimit(ctx, info, parmMap);
        if (!this.validate(ctx, info, parmMap)) {
            throw new EASBizException(new NumericExceptionSubItem("10", (String)parmMap.get("errorString")));
        }
        CalculateLeaveBillLengthTool.deductHolidayLimit(ctx, info);
        AtsLeaveBillDetailFactory.getLocalInstance(ctx).delete("where leavebillEntry.id='" + info.getString("id") + "' and proposer.id='" + personId + "'");
        String atsLeaveBillInfoId = info.getBill().getId().toString();
        AtsLeaveBillInfo atsLeaveBillInfo = AtsLeaveBillFactory.getLocalInstance(ctx).getAtsLeaveBillInfo((IObjectPK)new ObjectUuidPK(atsLeaveBillInfoId));
        AtsLeaveBillSplitHelper atsLeaveBillSplitHelper = new AtsLeaveBillSplitHelper(ctx, atsLeaveBillInfo, info);
        atsLeaveBillSplitHelper.splitLeaveBill();
        info.setLastUpdateUser((UserInfo)ctx.get((Object)"UserInfo"));
        info.setLastUpdateTime(HRTimeWebUtils.dateToTimestamp(new Date()));
        info.setIsRecallBill(AtsNeedReBilll.no);
        AtsLeaveBillEntryFactory.getLocalInstance(ctx).update((IObjectPK)new ObjectUuidPK(info.getId()), info);
        Map<String, Boolean> isCallACJobMap = isCallACJobThreadLocal.get();
        if (null == isCallACJobMap || null == isCallACJobMap.get(leaveBillId)) {
            Map<String, String> earliestEntryInfo = AtsBillEntryHandlerUtils.getEarliestEntryInfo((CoreBaseInfo)atsLeaveBillInfo, OperTypeEnum.leaveBill);
            String personId1 = earliestEntryInfo.get("personId");
            String beginTime1 = earliestEntryInfo.get("beginTime");
            String endTime1 = earliestEntryInfo.get("endTime");
            Boolean isCallACJob = AtsScheduleShiftUtil.needCalAttendCalculateJob(ctx, beginTime1, endTime1, personId1);
            if (null != isCallACJobMap) {
                isCallACJobMap.put(leaveBillId, isCallACJob);
            }
            if (isCallACJob.booleanValue()) {
                this.triggerAttendCalJob(ctx, atsLeaveBillInfo, info);
            }
        } else if (isCallACJobMap.get(leaveBillId).booleanValue()) {
            this.triggerAttendCalJob(ctx, atsLeaveBillInfo, info);
        }
        ctx.remove((Object)(leaveBillId + "_OperType"));
        ctx.remove((Object)(leaveBillId + "_OperAction"));
    }

    private void triggerAttendCalJob(Context ctx, AtsLeaveBillInfo atsLeaveBillInfo, AtsLeaveBillEntryInfo info) throws BOSException {
        AttendCalculateJob backJob = new AttendCalculateJob();
        String billId = atsLeaveBillInfo.getId().toString();
        String billNumber = atsLeaveBillInfo.getNumber();
        String personId = info.getPerson().getId().toString();
        String beginTime = AtsDateUtils.timestampToString(info.getBeginTime());
        String endTime = AtsDateUtils.timestampToString(info.getEndTime());
        backJob.createLeaveBillTriggerAttendCalJob(ctx, beginTime, endTime, billId, personId, billNumber);
    }

    private void DealExFrezzLimit(Context ctx) throws EASBizException, BOSException, SQLException {
        StringBuilder sb = new StringBuilder();
        sb.append("SELECT leavebill.FID ,limitdetail.FCHANGEVALUE ,limitdetail.FCHANGETYPE  FROM t_hr_ats_holidaylimitdetail  limitdetail  ");
        sb.append("INNER JOIN T_hr_ats_leavebill leavebill on limitdetail.FLEAVEBILLID = leavebill.FID ");
        sb.append("where leavebill.FBILLSTATE  in ('0','3','4') and limitdetail.FCHANGETYPE = 6 ");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sb.toString());
        while (rs.next()) {
            logger.error((Object)("repaire illegal frozon limit,bill id\uff1a" + rs.getString("FID")));
            this.rollBackHolidayLimit(ctx, BOSUuid.read((String)rs.getString("FID")), 6);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void _reLeaveBillEntry(Context ctx, int dayBefore, String adminOrgUnitNum, String personNum, String holidayTypeName) throws BOSException, EASBizException {
        String tempTableName = null;
        try {
            HashMap map = new HashMap();
            StringBuffer sql = new StringBuffer();
            sql.append("select entry.Fid as id from  ").append(" T_HR_ATS_LeaveBill bill left OUTER JOIN T_HR_ATS_LeaveBillEntry entry on  bill.fid=entry.FBillID").append(" inner join T_HR_ATS_HolidayPolicy policy on entry.FPOLICYID = policy.FID  ").append(" inner join T_HR_ATS_HolidayType holidayType on policy.FHOLIDAYTYPEID = holidayType.FID ").append(" inner join T_ORG_BaseUnit orgUnit on entry.FADMINORGUNITID = orgUnit.FID ").append(" inner join T_BD_Person person on entry.FPERSONID = person.FID ").append(" where bill.FBillState IN ('3') ");
            if (!StringUtils.isEmpty((String)adminOrgUnitNum)) {
                String orgUnitNumSql = "select id,longnumber where number in ('" + adminOrgUnitNum.trim().replaceAll(",", "','") + "')";
                AdminOrgUnitCollection admingOrgUnitColl = AdminOrgUnitFactory.getLocalInstance((Context)ctx).getAdminOrgUnitCollection(orgUnitNumSql);
                String adminSql = "";
                if (admingOrgUnitColl.size() > 0) {
                    for (int i = 0; admingOrgUnitColl.size() > i; ++i) {
                        String longNumber = admingOrgUnitColl.get(i).getLongNumber();
                        if (!StringUtils.isEmpty((String)adminSql)) {
                            adminSql = adminSql + " or ";
                        }
                        adminSql = adminSql + " orgUnit.flongNumber = '" + longNumber + "' or orgUnit.flongNumber  like '" + longNumber + "!%' ";
                    }
                    adminSql = " and (" + adminSql + ")";
                    sql.append(adminSql);
                }
            }
            if (!personNum.isEmpty()) {
                sql.append(" and person.FNUMBER in ('" + personNum.trim().replaceAll(",", "','") + "')");
            }
            if (!StringUtils.isEmpty((String)holidayTypeName)) {
                sql.append(" and holidayType.FNAME_" + LocaleUtils.getShortCode((Context)ctx) + "in ('" + holidayTypeName.trim().replaceAll(",", "','") + "')");
            }
            if (dayBefore != 0) {
                Calendar calendar1 = Calendar.getInstance();
                SimpleDateFormat sdf1 = new SimpleDateFormat("yyyy-MM-dd");
                calendar1.add(5, -dayBefore);
                String days_ago = sdf1.format(calendar1.getTime());
                sql.append("  AND entry.FBeginTime >= {TS '" + days_ago + " 00:00:00'}");
                calendar1.add(5, -1);
                String days_ago1 = sdf1.format(calendar1.getTime());
                String tempSql = "SELECT FProposerID,FATTENDDATE,flastupdatetime FROM t_hr_ats_scheduleshift C WHERE C.FATTENDDATE >= { TS '" + days_ago1 + " 00:00:00' }";
                tempTableName = AtsTempTableUtil.createTempTableNotIndex(ctx, tempSql);
            }
            String releateTableName = org.apache.commons.lang3.StringUtils.isBlank(tempTableName) ? "t_hr_ats_scheduleshift" : tempTableName;
            sql.append(" and exists (select 1 from " + releateTableName + " C where C.FProposerID = entry.FPersonID and C.FLastUpdateTime > entry.FLastUpdateTime  and  dateAdd(day,-1,entry.fBeginTime) <= C.FATTENDDATE  and entry.fEndTime >=  C.FATTENDDATE   ) ");
            IRowSet row = null;
            row = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            Map<String, Object> res = null;
            AtsLeaveBillEntryInfo info = null;
            try {
                while (row.next()) {
                    try {
                        this.reCall(ctx, info, res, row.getString("id"));
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (org.apache.commons.lang3.StringUtils.isNotBlank(tempTableName)) {
                AtsTempTableUtil.releaseTable(ctx, tempTableName);
            }
        }
    }

    protected String getScheduleShiftLogSql() {
        return " select 1  from t_hr_ats_attendanceFileHis his  inner join T_HR_ATS_ScheduleShiftDataLog log on his.feffdt <= log.fAttendDate and his.fleffdt >= log.fAttendDate and his.fProposerId = log.fPersonId  where  log.fOperType = '" + OperTypeEnum.scheduleShift.getValue() + "'  and log.fOperAction = '" + OperActionEnum.delete.getValue() + "'  and his.fAttendFileState = '" + AttendFileStateEnum.enable.getValue() + "'  and his.fIsAttendance = '" + IsAttendanceEnum.no.getValue() + "'  and his.fProposerId = entry.FPersonID  and log.FLastUpdateTime > entry.FLastUpdateTime  and dateAdd(day, -1, entry.fBeginTime) <= log.fAttendDate  and entry.fEndTime >= log.fAttendDate";
    }

    protected String getScheduleShiftSql() {
        return "select 1 from t_hr_ats_scheduleshift C  where C.FProposerID = entry.FPersonID  and C.FLastUpdateTime > entry.FLastUpdateTime   and dateAdd(day,-1,entry.fBeginTime) <= C.FATTENDDATE  and entry.fEndTime >= C.FATTENDDATE ";
    }

    protected String getScheduleShiftSql_1() {
        return "select 1 from t_hr_ats_scheduleshift C  where C.FProposerID = entry.FPersonID  and entry.FIsRecallBill = 1";
    }

    public void reCall(Context ctx, AtsLeaveBillEntryInfo info, Map<String, Object> res, String id) throws BOSException, EASBizException {
        double initialValue;
        String bfTypeId;
        AtsLeaveBillEntryCollection leaveBillEntryColl = AtsLeaveBillEntryFactory.getLocalInstance(ctx).getAtsLeaveBillEntryCollection(" where id in ('" + id + "')");
        info = leaveBillEntryColl.get(0);
        String personId = info.getPerson().getId().toString();
        Timestamp beginTime = info.getRealBeginTime();
        Timestamp endTime = info.getRealEndTime();
        String holidayPolicyId = info.getPolicy().getId().toString();
        HolidayPolicyInfo holidayPolicyInfo = this.getHolidayPolicyInfoById(ctx, holidayPolicyId);
        if (holidayPolicyInfo == null) {
            return;
        }
        String holidayTypeId = holidayPolicyInfo.getHolidayType().getId().toString();
        String tempErrorString = this.validateLeaveBill(ctx, personId, holidayTypeId);
        if (!StringUtils.isEmpty((String)tempErrorString)) {
            return;
        }
        HashMap<String, Object> paraMap = new HashMap<String, Object>();
        paraMap.put("personId", personId);
        paraMap.put("timeOffApplyType", holidayTypeId);
        paraMap.put("isElasticCalLen", info.isIsElasticCalLen());
        paraMap.put("timeOffStartDate", beginTime);
        paraMap.put("timeOffEndDate", endTime);
        boolean isHalfDayOff = holidayPolicyInfo.isIsHalfDayOff();
        String amStartWorkTime = "";
        String amEndWorkTime = "";
        String pmStartWorkTime = "";
        String pmEndWorkTime = "";
        String string = bfTypeId = info.getBfType() == null ? null : info.getBfType().getId().toString();
        if (holidayTypeId.equals("8r0AAAAMhrv9LVKY") && bfTypeId != null && bfTypeId != "" && !"8r0AAAA09p9IT3K3".equals(bfTypeId)) {
            paraMap.put("bfTypeId", bfTypeId);
        }
        if (isHalfDayOff) {
            String Am = "";
            String Pm = "";
            amStartWorkTime = holidayPolicyInfo.getHolidayPolicySet().getAmStartWorkTime();
            amEndWorkTime = holidayPolicyInfo.getHolidayPolicySet().getAmEndWorkTime();
            pmStartWorkTime = holidayPolicyInfo.getHolidayPolicySet().getPmStartWorkTime();
            pmEndWorkTime = holidayPolicyInfo.getHolidayPolicySet().getPmEndWorkTime();
            if (AtsDateUtils.timestampToString(beginTime).substring(11, 16).equals(amStartWorkTime)) {
                Am = AtsDateUtils.timestampToString(beginTime).substring(0, 10) + "AM";
            } else if (AtsDateUtils.timestampToString(beginTime).substring(11, 16).equals(pmStartWorkTime)) {
                Am = AtsDateUtils.timestampToString(beginTime).substring(0, 10) + "PM";
            }
            if (AtsDateUtils.timestampToString(endTime).substring(11, 16).equals(amEndWorkTime)) {
                Pm = AtsDateUtils.timestampToString(endTime).substring(0, 10) + "AM";
            } else if (AtsDateUtils.timestampToString(endTime).substring(11, 16).equals(pmEndWorkTime)) {
                Pm = AtsDateUtils.timestampToString(endTime).substring(0, 10) + "PM";
            } else if (AtsDateUtils.timestampToString(endTime).substring(11, 16).equals(pmStartWorkTime)) {
                Pm = AtsDateUtils.timestampToString(endTime).substring(0, 10) + "AM";
            }
            paraMap.put("timeOffStartDate", Am);
            paraMap.put("timeOffEndDate", Pm);
        }
        res = (Map)OSFExecutor.executeOSF((Context)ctx, paraMap, (String)"getLeaveLength_new");
        double realLength = (Double)res.get("leaveLength");
        res.put("realLen", realLength);
        double d = initialValue = holidayPolicyInfo.getInitialValue() == null ? 0.0 : holidayPolicyInfo.getInitialValue().doubleValue();
        if (realLength < initialValue) {
            return;
        }
        if (holidayPolicyInfo.getMinLeaveLengthVMtd() == GetValueMtdEnum.actualValue) {
            BigDecimal minLeaveLength = holidayPolicyInfo.getMinLeaveLength();
            BigDecimal bRealLength = BigDecimal.valueOf(realLength);
            if (bRealLength.remainder(minLeaveLength).compareTo(BigDecimal.ZERO) != 0) {
                return;
            }
        }
        this._calculateLeaveBillEntry(ctx, info, res);
    }

    public String validateLeaveBill(Context ctx, String personId, String holidayTypeId) throws EASBizException, BOSException {
        String errorString = "";
        AtsHolidayFileCollection holidayFileColl = new AtsHolidayFileCollection();
        holidayFileColl = AtsHolidayFileFactory.getLocalInstance(ctx).getAtsHolidayFileCollection(" where proposer.id='" + personId + "' and attendFileState='1' ");
        if (holidayFileColl.size() == 0) {
            errorString = "error";
            return errorString;
        }
        if (holidayFileColl.get(0).getHolidayPolicySet() == null) {
            errorString = "error";
            return errorString;
        }
        HolidayPolicyInfo holidayPolicyInfo = null;
        try {
            holidayPolicyInfo = HolidayPolicyFactory.getLocalInstance(ctx).getHolidayPolicyInfo("  where holidayPolicySet = '" + holidayFileColl.get(0).getHolidayPolicySet().getId().toString() + "' and holidayType='" + holidayTypeId + "' ");
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        if (holidayPolicyInfo == null) {
            errorString = "error";
            return errorString;
        }
        return errorString;
    }

    public HolidayPolicyInfo getHolidayPolicyInfoById(Context ctx, String holidayPolicyId) {
        HolidayPolicyInfo holidayPolicyInfo = null;
        try {
            holidayPolicyInfo = HolidayPolicyFactory.getLocalInstance(ctx).getHolidayPolicyInfo("select *,holidayPolicySet.* where id='" + holidayPolicyId + "'  ");
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        catch (EASBizException e) {
            e.printStackTrace();
        }
        return holidayPolicyInfo;
    }
}

