/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.ats.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.hr.ats.AtsNeedReBilll;
import com.kingdee.eas.hr.ats.AtsOffsiteEntryFactory;
import com.kingdee.eas.hr.ats.AtsOffsiteEntryInfo;
import com.kingdee.eas.hr.ats.AtsOffsiteFactory;
import com.kingdee.eas.hr.ats.AtsOffsiteInfo;
import com.kingdee.eas.hr.ats.AttendFileStateEnum;
import com.kingdee.eas.hr.ats.IsAttendanceEnum;
import com.kingdee.eas.hr.ats.OperActionEnum;
import com.kingdee.eas.hr.ats.OperTypeEnum;
import com.kingdee.eas.hr.ats.ScheduleShiftInfo;
import com.kingdee.eas.hr.ats.ScheduleShiftItemInfo;
import com.kingdee.eas.hr.ats.SegmentUnitEnum;
import com.kingdee.eas.hr.ats.app.AbstractAtsOffsiteControllerBean;
import com.kingdee.eas.hr.ats.result.AttendCalculateJob;
import com.kingdee.eas.hr.ats.util.AtsBillEntryHandlerUtils;
import com.kingdee.eas.hr.ats.util.AtsDateUtils;
import com.kingdee.eas.hr.ats.util.AtsScheduleShiftUtil;
import com.kingdee.eas.hr.ats.util.common.AtsCollectionUtile;
import com.kingdee.eas.hr.ats.validator.BillHelper;
import com.kingdee.eas.hr.base.HRBillStateEnum;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.shr.base.syssetting.app.osf.OSFAppUtil;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class AtsOffsiteControllerBean
extends AbstractAtsOffsiteControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.hr.ats.app.AtsOffsiteControllerBean");
    private static final String effectBillStates = AtsCollectionUtile.joinForSql(Arrays.asList(HRBillStateEnum.SUBMITED.getValue(), HRBillStateEnum.AUDITING.getValue(), HRBillStateEnum.AUDITED.getValue()));

    @Override
    protected void _setBillPassState(Context ctx, BOSUuid billId) throws BOSException, EASBizException {
        this._setState(ctx, billId, HRBillStateEnum.AUDITED);
    }

    @Override
    protected void _invalid(Context ctx, String id) throws BOSException {
    }

    @Override
    public void _reOffsiteBillEntry(Context ctx, int dayBefore) throws BOSException, EASBizException {
        System.out.println("AtsOffsiteControllerBean._reOffsiteBillEntry.start " + dayBefore);
        StringBuffer sql = new StringBuffer();
        sql.append("select entry.Fid as id ").append(" from T_ATS_AtsOffsite bill ").append(" left OUTER JOIN T_ATS_AtsOffsiteEntry entry on bill.fid=entry.FBillID ").append(" where bill.FBillState IN (").append(effectBillStates).append(") ");
        if (dayBefore != 0) {
            String DateBefore = AtsDateUtils.dateShortToString(AtsDateUtils.getPreDay(new Date(), dayBefore));
            sql.append(" AND entry.FStartTime >= {TS '").append(DateBefore).append(" 00:00:00'}");
        }
        sql.append(" and ( ").append(" entry.FIsRecallBill = '").append(AtsNeedReBilll.yes.getValue()).append("' ").append(" or ").append(" exists (").append(this.getScheduleShiftSql()).append(") ").append(" or ").append(" exists (").append(this.getScheduleShiftLogSql()).append(")").append(")");
        IRowSet row = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        HashMap<String, Boolean> isCallACJobMap = new HashMap<String, Boolean>();
        try {
            while (row.next()) {
                try {
                    this.reCall(ctx, null, null, row.getString("id"), isCallACJobMap);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        logger.error((Object)"_reOffsiteBillEntry end");
    }

    @Override
    protected void _offsiteBillTriggerCal(Context ctx, String beginTime, String endTime, String billId, String personId, String hrOrgUnitId) throws BOSException, EASBizException {
        String serviceName = "offsiteBillTrigerCalculateOSF";
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("billId", billId);
        param.put("personId", personId);
        param.put("beginTime", beginTime);
        param.put("endTime", endTime);
        param.put("hrOrgUnitId", hrOrgUnitId);
        OSFAppUtil osfUtil = new OSFAppUtil();
        Object osfObject = OSFAppUtil.callService((Context)ctx, (String)serviceName, param);
    }

    protected String getScheduleShiftSql() {
        return "select 1 from t_hr_ats_scheduleshift C  where C.FProposerID = entry.FPersonID  and C.FLastUpdateTime > bill.FLastUpdateTime   and dateAdd(day,-1, entry.fStartTime) <= C.FATTENDDATE  and entry.fEndTime >= C.FATTENDDATE ";
    }

    protected String getScheduleShiftLogSql() {
        return " select 1  from t_hr_ats_attendanceFileHis his  inner join T_HR_ATS_ScheduleShiftDataLog log on his.feffdt <= log.fAttendDate and his.fleffdt >= log.fAttendDate and his.fProposerId = log.fPersonId  where  log.fOperType = '" + OperTypeEnum.scheduleShift.getValue() + "'  and log.fOperAction = '" + OperActionEnum.delete.getValue() + "'  and his.fAttendFileState = '" + AttendFileStateEnum.enable.getValue() + "'  and his.fIsAttendance = '" + IsAttendanceEnum.no.getValue() + "'  and his.fProposerId = entry.FPersonID  and log.FLastUpdateTime > bill.FLastUpdateTime  and dateAdd(day, -1, entry.fStartTime) <= log.fAttendDate  and entry.fEndTime >= log.fAttendDate";
    }

    private void reCall(Context ctx, AtsOffsiteInfo info, Map<String, Object> res, String id, Map<String, Boolean> tempMap) throws BOSException, EASBizException {
        System.out.println("AtsOffsiteControllerBean.reCall entry.id" + id);
        AtsOffsiteEntryInfo entryInfo = AtsOffsiteEntryFactory.getLocalInstance(ctx).getAtsOffsiteEntryInfo("select *, bill.* where id = '" + id + "'");
        if (null == entryInfo || null == (info = entryInfo.getBill())) {
            return;
        }
        info = AtsOffsiteFactory.getLocalInstance(ctx).getAtsOffsiteInfo((IObjectPK)new ObjectUuidPK(entryInfo.getBill().getId().toString()));
        this.updateBillEntryInfo(ctx, entryInfo);
        if (null == tempMap || null == tempMap.get(entryInfo.getBill().getId().toString())) {
            Map<String, String> map = AtsBillEntryHandlerUtils.getEarliestEntryInfo((CoreBaseInfo)info, OperTypeEnum.outsideBill);
            Boolean isCallACJob = AtsScheduleShiftUtil.needCalAttendCalculateJob(ctx, map.get("beginTime"), map.get("endTime"), map.get("personId"));
            if (null != tempMap) {
                tempMap.put(entryInfo.getBill().getId().toString(), isCallACJob);
            }
            if (isCallACJob.booleanValue()) {
                this.triggerCalculate(ctx, info, entryInfo);
            }
        } else if (tempMap.get(entryInfo.getBill().getId().toString()).booleanValue()) {
            this.triggerCalculate(ctx, info, entryInfo);
        }
    }

    private void updateBillEntryInfo(Context ctx, AtsOffsiteEntryInfo entryInfo) throws BOSException, EASBizException {
        String personId = entryInfo.getPerson().getId().toString();
        if (entryInfo.isIsAllDay()) {
            this.setEntryBeginAndEndTime(ctx, entryInfo, personId);
        }
        BigDecimal realLength = new BillHelper().getBillLength(ctx, entryInfo);
        AtsOffsiteEntryInfo billEntryInfo = new AtsOffsiteEntryInfo();
        billEntryInfo.setId(entryInfo.getId());
        billEntryInfo.setStartTime(entryInfo.getStartTime());
        billEntryInfo.setStartTimeDate(entryInfo.getStartTimeDate());
        billEntryInfo.setStartTimeDateType(entryInfo.getStartTimeDateType());
        billEntryInfo.setStartTimeHMS(entryInfo.getStartTimeHMS());
        billEntryInfo.setRealStartTime(entryInfo.getRealStartTime());
        billEntryInfo.setEndTime(entryInfo.getEndTime());
        billEntryInfo.setEndTimeDate(entryInfo.getEndTimeDate());
        billEntryInfo.setEndTimeDateType(entryInfo.getEndTimeDateType());
        billEntryInfo.setEndTimeHMS(entryInfo.getEndTimeHMS());
        billEntryInfo.setRealEndTime(entryInfo.getRealEndTime());
        billEntryInfo.setRealDays(realLength);
        billEntryInfo.setDays(realLength);
        billEntryInfo.setIsRecallBill(AtsNeedReBilll.no);
        billEntryInfo.setLastUpdateTime(new Timestamp(System.currentTimeMillis()));
        billEntryInfo.setLastUpdateUser((UserInfo)ctx.get((Object)"UserInfo"));
        AtsOffsiteEntryFactory.getLocalInstance(ctx).update((IObjectPK)new ObjectUuidPK(entryInfo.getId()), billEntryInfo);
    }

    private void triggerCalculate(Context ctx, AtsOffsiteInfo info, AtsOffsiteEntryInfo entryInfo) throws BOSException {
        AttendCalculateJob backJob = new AttendCalculateJob();
        String billId = info.getId().toString();
        String billNumber = info.getNumber();
        String beginTime = AtsDateUtils.timestampToString(entryInfo.getStartTime());
        String endTime = AtsDateUtils.timestampToString(entryInfo.getEndTime());
        String personId = entryInfo.getPerson().getId().toString();
        backJob.createOffsiteBillTriggerAttendCalJob(ctx, beginTime, endTime, billId, personId, billNumber);
    }

    private void setEntryBeginAndEndTime(Context ctx, AtsOffsiteEntryInfo entryInfo, String personId) {
        String endTime;
        String beginTime = AtsDateUtils.timestampToShortString(this.getRealAttendDate(entryInfo.getStartTime(), entryInfo.getStartTimeDateType()));
        Map<String, ScheduleShiftInfo> scheduleShiftForPerson = AtsScheduleShiftUtil.getScheduleShiftForPersonByOql(ctx, personId, beginTime, endTime = AtsDateUtils.timestampToShortString(this.getRealAttendDate(entryInfo.getEndTime(), entryInfo.getEndTimeDateType())));
        if (null == scheduleShiftForPerson) {
            return;
        }
        String pTime = AtsScheduleShiftUtil.getKey(personId, beginTime);
        ScheduleShiftInfo scheduleShiftInfo = scheduleShiftForPerson.get(pTime);
        if (AtsCollectionUtile.isEmpty((IObjectCollection)(scheduleShiftInfo == null ? null : scheduleShiftInfo.getItems()))) {
            scheduleShiftForPerson.put(pTime, AtsScheduleShiftUtil.getDefaultSchedule(ctx, personId, beginTime));
        }
        this.setBeginTime(personId, entryInfo, beginTime, scheduleShiftForPerson);
        pTime = AtsScheduleShiftUtil.getKey(personId, endTime);
        scheduleShiftInfo = scheduleShiftForPerson.get(pTime);
        if (AtsCollectionUtile.isEmpty((IObjectCollection)(scheduleShiftInfo == null ? null : scheduleShiftInfo.getItems()))) {
            scheduleShiftForPerson.put(pTime, AtsScheduleShiftUtil.getDefaultSchedule(ctx, personId, endTime));
        }
        this.setEndTime(personId, entryInfo, endTime, scheduleShiftForPerson);
    }

    private void setBeginTime(String personId, AtsOffsiteEntryInfo billEntryInfo, String attendDateStr, Map<String, ScheduleShiftInfo> scheduleShiftForPerson) {
        ScheduleShiftInfo scheduleShiftInfo = scheduleShiftForPerson.get(AtsScheduleShiftUtil.getKey(personId, attendDateStr));
        if (null == scheduleShiftInfo) {
            return;
        }
        if (AtsCollectionUtile.isEmpty((IObjectCollection)scheduleShiftInfo.getItems())) {
            return;
        }
        ScheduleShiftItemInfo itemInfo = scheduleShiftInfo.getItems().get(0);
        billEntryInfo.setStartTimeDate(AtsDateUtils.dateToTimestamp(AtsDateUtils.dateShortFormatToDate(itemInfo.getPreDateTime())));
        billEntryInfo.setStartTimeDateType(itemInfo.getPreTimeDayType());
        billEntryInfo.setStartTimeHMS(itemInfo.getPreDateTime());
        billEntryInfo.setStartTime(itemInfo.getPreDateTime());
        billEntryInfo.setRealStartTime(itemInfo.getPreDateTime());
    }

    private void setEndTime(String personId, AtsOffsiteEntryInfo billEntryInfo, String attendDateStr, Map<String, ScheduleShiftInfo> scheduleShiftForPerson) {
        ScheduleShiftInfo scheduleShiftInfo = scheduleShiftForPerson.get(AtsScheduleShiftUtil.getKey(personId, attendDateStr));
        if (null == scheduleShiftInfo) {
            return;
        }
        if (AtsCollectionUtile.isEmpty((IObjectCollection)scheduleShiftInfo.getItems())) {
            return;
        }
        ScheduleShiftItemInfo itemInfo = scheduleShiftInfo.getItems().get(scheduleShiftInfo.getItems().size() - 1);
        billEntryInfo.setEndTimeDate(AtsDateUtils.dateToTimestamp(AtsDateUtils.dateShortFormatToDate(itemInfo.getNextDateTime())));
        billEntryInfo.setEndTimeDateType(itemInfo.getNextTimeDayType());
        billEntryInfo.setEndTimeHMS(itemInfo.getNextDateTime());
        billEntryInfo.setEndTime(itemInfo.getNextDateTime());
        billEntryInfo.setRealEndTime(itemInfo.getNextDateTime());
    }

    private Timestamp getRealAttendDate(Timestamp time, SegmentUnitEnum dateType) {
        if (null == time) {
            return time;
        }
        Timestamp ret = new Timestamp(time.getTime());
        if (SegmentUnitEnum.nextDay.equals((Object)dateType)) {
            ret.setTime(AtsDateUtils.getPreDay(time).getTime());
        } else if (SegmentUnitEnum.preDay.equals((Object)dateType)) {
            ret.setTime(AtsDateUtils.getNextDay(time).getTime());
        }
        return ret;
    }

    protected void _recalEntry(Context ctx, AtsOffsiteEntryInfo info, Map map) throws BOSException, EASBizException {
    }
}

