/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.ats.app.formula;

import com.kingdee.eas.hr.ats.app.formula.calculate.data.Tools;
import com.kingdee.eas.hr.ats.function.AtsCalFunctionService;
import com.kingdee.eas.hr.ats.util.AtsDateUtils;
import com.kingdee.shr.compensation.CalSchemeInfo;
import com.kingdee.shr.compensation.app.formula.common.FunctionTools;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;

public class ResultCalFunction {
    private String calDate;
    private String schemeID;
    private String condition;
    private int precision = 2;
    private CalSchemeInfo calScheme;
    public AtsCalFunctionService atsFunctionService = new AtsCalFunctionService();
    private HashMap tempMap = new HashMap();
    public Map paramMap = new HashMap();
    public final String MAIN_ID = "T_HR_ATS_AttendanceResult_FID";
    String regL = "(\\d{2}|\\d{4})(?:\\-)?([0]{1}\\d{1}|[1]{1}[0-2]{1})(?:\\-)?([0-2]{1}\\d{1}|[3]{1}[0-1]{1})(?:\\s)?([0-1]{1}\\d{1}|[2]{1}[0-3]{1})(?::)?([0-5]{1}\\d{1})(?::)?([0-5]{1}\\d{1})";
    String regS = "(^[0-9]{4}-(((0[13578]|(10|12))-(0[1-9]|[1-2][0-9]|3[0-1]))|(02-(0[1-9]|[1-2][0-9]))|((0[469]|11)-(0[1-9]|[1-2][0-9]|30)))$)";
    String regHMS = "^(([0-1]?[0-9])|([2][0-3])):([0-5]?[0-9])(:([0-5]?[0-9]))?$";

    public String getCalDate() {
        return this.calDate;
    }

    public CalSchemeInfo getCalScheme() {
        return this.calScheme;
    }

    public String getMainTableRowFilter() {
        return this.condition;
    }

    public double getRound(double v) {
        return Double.parseDouble(FunctionTools.getRound((int)this.precision, (double)v));
    }

    public String getSchemeID() {
        return this.schemeID;
    }

    public HashMap getTempMap() {
        return this.tempMap;
    }

    public boolean isEqual(double a, double b) {
        return a == b;
    }

    public boolean isEqual(int a, double b) {
        return new Double(a) == b;
    }

    public boolean isEqual(int a, int b) {
        return a == b;
    }

    public boolean isEqual(double a, int b) {
        return a == new Double(b);
    }

    public boolean isEqual(Object a, Object b) {
        if (a instanceof String) {
            return ((String)a).equals(b);
        }
        if (b instanceof String) {
            return ((String)b).equals(a);
        }
        if (a instanceof Double) {
            return ((Double)a).equals(b);
        }
        if (b instanceof Double) {
            return ((Double)b).equals(a);
        }
        return a == b;
    }

    public boolean isEqual(String a, String b) {
        if (this.compareTwoValue(a, b, "isEqual") == 0) {
            return true;
        }
        if (a instanceof String) {
            return a.equals(b);
        }
        if (b instanceof String) {
            return b.equals(a);
        }
        return a == b;
    }

    public int compareTwoValue(String a, String b, String methodName) {
        int value = -3;
        if (StringUtils.isEmpty((String)a) || StringUtils.isEmpty((String)b)) {
            return value;
        }
        if (a instanceof String && b instanceof String) {
            Timestamp afterStamp;
            Timestamp beforeStamp;
            if (a.contains(".0")) {
                a = a.replace(".0", "");
            }
            if (b.contains(".0")) {
                b = b.replace(".0", "");
            }
            if (b.matches(this.regHMS)) {
                if (b.length() == 5) {
                    b = b + ":00";
                }
                b = this.calDate + " " + b;
            }
            if (a.matches(this.regHMS)) {
                if (a.length() == 5) {
                    a = a + ":00";
                }
                a = this.calDate + " " + a;
            }
            if (a.matches(this.regL) && b.matches(this.regL)) {
                beforeStamp = AtsDateUtils.stringToTimestamp(a);
                afterStamp = AtsDateUtils.stringToTimestamp(b);
                if (methodName.equals("isEqual") && beforeStamp.getTime() == afterStamp.getTime()) {
                    value = 0;
                }
                if (methodName.equals("isGtOrEql") && beforeStamp.getTime() >= afterStamp.getTime()) {
                    value = 1;
                }
                if (methodName.equals("isGtThn") && beforeStamp.getTime() > afterStamp.getTime()) {
                    value = 2;
                }
                if (methodName.equals("isLsOrEql") && beforeStamp.getTime() <= afterStamp.getTime()) {
                    value = -1;
                }
                if (methodName.equals("isLsThn") && beforeStamp.getTime() < afterStamp.getTime()) {
                    value = -2;
                }
            }
            if (a.matches(this.regS) && b.matches(this.regS)) {
                beforeStamp = AtsDateUtils.stringShortToTimestamp(a);
                afterStamp = AtsDateUtils.stringShortToTimestamp(b);
                if (methodName.equals("isEqual") && beforeStamp.getTime() == afterStamp.getTime()) {
                    value = 0;
                }
                if (methodName.equals("isGtOrEql") && beforeStamp.getTime() >= afterStamp.getTime()) {
                    value = 1;
                }
                if (methodName.equals("isGtThn") && beforeStamp.getTime() > afterStamp.getTime()) {
                    value = 2;
                }
                if (methodName.equals("isLsOrEql") && beforeStamp.getTime() <= afterStamp.getTime()) {
                    value = -1;
                }
                if (methodName.equals("isLsThn") && beforeStamp.getTime() < afterStamp.getTime()) {
                    value = -2;
                }
            }
        }
        return value;
    }

    public int isDateTimeType(String a, String b) {
        int value = -1;
        if (StringUtils.isEmpty((String)a) || StringUtils.isEmpty((String)b)) {
            return value;
        }
        if (a.endsWith(".0")) {
            a = a.substring(0, a.lastIndexOf(".0"));
        }
        if (b.endsWith(".0")) {
            b = b.substring(0, b.lastIndexOf(".0"));
        }
        if ((a.matches(this.regL) || a.matches(this.regS) || a.matches(this.regHMS)) && (b.matches(this.regL) || b.matches(this.regS) || b.matches(this.regHMS))) {
            value = 1;
        }
        return value;
    }

    public boolean isGtOrEql(double a, double b) {
        return a >= b;
    }

    public boolean isGtOrEql(int a, double b) {
        return new Double(a) >= b;
    }

    public boolean isGtOrEql(int a, int b) {
        return a >= b;
    }

    public boolean isGtOrEql(double a, int b) {
        return a >= new Double(b);
    }

    public boolean isGtOrEql(String a, String b) {
        if (this.isDateTimeType(a, b) == 1) {
            return this.compareTwoValue(a, b, "isGtOrEql") == 1;
        }
        if (a == null) {
            return b == null;
        }
        if (b == null) {
            return true;
        }
        return a.compareTo(b) >= 0;
    }

    public boolean isGtThn(double a, double b) {
        return a > b;
    }

    public boolean isGtThn(int a, double b) {
        return new Double(a) > b;
    }

    public boolean isGtThn(int a, int b) {
        return a > b;
    }

    public boolean isGtThn(double a, int b) {
        return a > new Double(b);
    }

    public boolean isGtThn(String a, String b) {
        if (this.isDateTimeType(a, b) == 1) {
            return this.compareTwoValue(a, b, "isGtThn") == 2;
        }
        if (a == null) {
            return false;
        }
        if (b == null) {
            return true;
        }
        return a.compareTo(b) > 0;
    }

    public boolean isLsOrEql(double a, double b) {
        return a <= b;
    }

    public boolean isLsOrEql(double a, int b) {
        return a <= new Double(b);
    }

    public boolean isLsOrEql(int a, double b) {
        return new Double(a) <= b;
    }

    public boolean isLsOrEql(int a, int b) {
        return a <= b;
    }

    public boolean isLsOrEql(String a, String b) {
        if (this.isDateTimeType(a, b) == 1) {
            return this.compareTwoValue(a, b, "isLsOrEql") == -1;
        }
        if (a == null) {
            if (b == null) {
                return true;
            }
            return true;
        }
        if (b == null) {
            return false;
        }
        return a.compareTo(b) <= 0;
    }

    public boolean include(String a, String b) {
        if (null == a) {
            return false;
        }
        return null != b && !"".equals(b.trim()) ? a.contains(b) : true;
    }

    public boolean isLsThn(double a, double b) {
        return a < b;
    }

    public boolean isLsThn(int a, double b) {
        return new Double(a) < b;
    }

    public boolean isLsThn(int a, int b) {
        return a < b;
    }

    public boolean isLsThn(double a, int b) {
        return a < new Double(b);
    }

    public boolean isLsThn(String a, String b) {
        if (this.isDateTimeType(a, b) == 1) {
            return this.compareTwoValue(a, b, "isLsThn") == -2;
        }
        if (a == null) {
            return true;
        }
        if (b == null) {
            return false;
        }
        return a.compareTo(b) < 0;
    }

    public void setCalDate(String calDate) {
        this.calDate = calDate;
    }

    public void setCalScheme(CalSchemeInfo calScheme) {
        this.calScheme = calScheme;
    }

    public void setMainTableRowFilter(String condition) {
        this.condition = condition;
    }

    public void setParamMap(Map paramMap) {
        this.paramMap = paramMap;
    }

    public void setPrecision(int precision) {
        this.precision = precision;
    }

    public void setSchemeID(String schemeID) {
        this.schemeID = schemeID;
    }

    public void setTempMap(HashMap tempMap) {
        this.tempMap = tempMap;
    }

    public double toDouble(Object obj) {
        if (obj == null) {
            return 0.0;
        }
        double v = 0.0;
        try {
            if (obj instanceof Double) {
                v = new BigDecimal(String.valueOf(obj)).doubleValue();
            }
            if (obj instanceof Integer) {
                v = ((Integer)obj).doubleValue();
            }
            if (obj instanceof Float) {
                v = ((Float)obj).doubleValue();
            }
            if (obj instanceof BigDecimal) {
                v = ((BigDecimal)obj).doubleValue();
            }
        }
        catch (Exception e) {
            try {
                v = Double.valueOf(new String(obj.toString()));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return v;
    }

    public String toString(Object obj) {
        try {
            if (obj == null) {
                return "";
            }
            if (obj instanceof String) {
                return obj.toString();
            }
            if (obj instanceof Date || obj instanceof java.sql.Date) {
                if (obj instanceof Timestamp) {
                    return AtsDateUtils.timestampToString((Timestamp)obj);
                }
                return Tools.getInstance().formatDate((Date)obj);
            }
            return obj.toString();
        }
        catch (Exception exception) {
            return null;
        }
    }
}

