/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.ats.app.ruleFormula;

import com.kingdee.eas.hr.ats.app.ruleFormula.HolidayLimitCalculator;
import com.kingdee.eas.hr.ats.app.ruleFormula.IHolidayLimitCalculator;
import com.kingdee.eas.hr.ats.app.ruleFormula.TaskInfo;
import java.util.ArrayList;

public class HolidayLimitCalculatorMgr
extends Thread {
    private static int taskCount = 0;
    public static int maxTasks = 1;
    public static int waitTime = 10;
    private static HolidayLimitCalculatorMgr instance = null;
    private static ArrayList<HolidayLimitCalculator> taskList = new ArrayList();
    private static ArrayList<TaskInfo> taskInfo = new ArrayList();

    public static synchronized void addTask(HolidayLimitCalculator calculator) {
        taskList.add(calculator);
        if (instance == null) {
            instance = new HolidayLimitCalculatorMgr();
            instance.setDaemon(false);
            instance.start();
        } else if (taskCount == 0) {
            try {
                instance.wakeup();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static synchronized HolidayLimitCalculator findTask(String uid) {
        int index;
        if (uid == null || "".equals(uid)) {
            return null;
        }
        for (index = 0; index < taskList.size(); ++index) {
            HolidayLimitCalculator calculator = taskList.get(index);
            if (!uid.equals(calculator.getUID())) continue;
            return calculator;
        }
        for (index = 0; index < taskInfo.size(); ++index) {
            TaskInfo task = taskInfo.get(index);
            if (task.getUid().equals(uid)) {
                StringBuffer info = new StringBuffer();
                info.append(task.getInfo());
                taskInfo.remove(index);
                throw new RuntimeException(info.toString());
            }
            if (System.currentTimeMillis() - task.getEndTime() <= 100000L) continue;
            taskInfo.remove(index);
            --index;
        }
        return null;
    }

    public static synchronized HolidayLimitCalculator getTask() {
        for (int index = 0; index < taskList.size(); ++index) {
            HolidayLimitCalculator calculator = taskList.get(index);
            if (calculator.getStatus() != 0) continue;
            calculator.setStatus(1);
            return calculator;
        }
        return null;
    }

    public static synchronized void removeTask(String uid, String cause) {
        int index;
        if (uid == null || "".equals(uid)) {
            return;
        }
        for (index = 0; index < taskList.size(); ++index) {
            IHolidayLimitCalculator calculator = taskList.get(index);
            if (!uid.equals(calculator.getUID())) continue;
            taskList.remove(index);
            --taskCount;
        }
        for (index = 0; index < taskInfo.size(); ++index) {
            TaskInfo task = taskInfo.get(index);
            if (!task.getUid().equals(uid)) continue;
            task.setEndTime(System.currentTimeMillis());
            task.setInfo(cause);
            return;
        }
    }

    private boolean haveNewTask() {
        for (int index = 0; index < taskList.size(); ++index) {
            IHolidayLimitCalculator calculator = taskList.get(index);
            if (calculator.getStatus() != 0) continue;
            return true;
        }
        return false;
    }

    @Override
    public void run() {
        while (true) {
            if (taskCount >= maxTasks || !this.haveNewTask()) {
                try {
                    HolidayLimitCalculatorMgr.sleep(waitTime * 1000);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                continue;
            }
            try {
                HolidayLimitCalculator calculator = HolidayLimitCalculatorMgr.getTask();
                if (calculator == null) continue;
                ++taskCount;
                calculator.setDaemon(true);
                calculator.start();
                taskInfo.add(new TaskInfo(calculator.getUID()));
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
                continue;
            }
            break;
        }
    }

    public synchronized void wakeup() {
        this.notifyAll();
    }
}

