/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.ats.baseconfig;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.data.ColumnInfo;
import com.kingdee.bos.metadata.data.SQLType;
import com.kingdee.bos.metadata.entity.DataType;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.OwnPropertyInfo;
import com.kingdee.bos.metadata.entity.PropertyInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.hr.ats.common.AtsAttendanceProjectUtil;
import com.kingdee.eas.hr.ats.util.common.MLUtile;
import com.kingdee.eas.hr.base.app.filter.StructureConfigConvertHelper;
import com.kingdee.shr.baseconfig.StructureConfigInfo;
import com.kingdee.shr.baseconfig.service.api.impl.CommonSHRSqlBuilder;
import com.kingdee.util.StringUtils;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class Ats010SHRSqlBuilder
extends CommonSHRSqlBuilder {
    private static Logger logger = Logger.getLogger(Ats010SHRSqlBuilder.class);

    protected String assembleSQLFrom() throws EASBizException, BOSException {
        String SQLFrom = super.assembleSQLFrom();
        if (null != this.param.getSessionId() && this.param.getSessionId().equals("atsSalaryDetailTag_SessionID")) {
            SQLFrom = SQLFrom.replaceAll("T_HR_ATS_ATTENDANCERESULT", "T_HR_ATS_ATTENDANCERESMD");
        } else if (null != this.param.getSessionId() && this.param.getSessionId().equals("014ATS")) {
            SQLFrom = SQLFrom.replaceAll("T_HR_ATS_ATTENDANCERESULT", "T_HR_ATS_AttResultItemToSalary");
        } else if (null != this.param.getSessionId() && this.param.getSessionId().equals("015ATS")) {
            SQLFrom = SQLFrom.replaceAll("T_HR_ATS_ATTENDANCERESULT", "T_HR_ATS_AttResultItem");
        }
        return SQLFrom;
    }

    protected String assembleSQLWhere() throws EASBizException, BOSException {
        long startPrepareTime = System.currentTimeMillis();
        FilterInfo filterInfo = this.param.getFilterInfo();
        int filtersCount = filterInfo.getFilterItems().size();
        StringBuffer whereSql = new StringBuffer("");
        if (filtersCount > 0) {
            int i;
            String format = filterInfo.getMaskString();
            if (!StringUtils.isEmpty((String)format)) {
                format = "(" + format + ")";
                for (i = filtersCount - 1; i >= 0; --i) {
                    format = StringUtils.replace((String)format, (String)("#" + i), (String)("~9^Nz" + i + "~9^Nz"));
                }
            }
            for (i = 0; i < filtersCount; ++i) {
                StringBuffer filter = new StringBuffer("");
                FilterItemInfo filterItemInfo = filterInfo.getFilterItems().get(i);
                Object value = filterItemInfo.getCompareValue();
                CompareType type = filterItemInfo.getCompareType();
                StructureConfigInfo configInfo = StructureConfigConvertHelper.getStructureConfigByKey((Context)this.ctx, (String)filterItemInfo.getPropertyName(), (String)this.param.getScheme());
                if (null == configInfo) continue;
                if (filterItemInfo.getPropertyName().startsWith("ATS_RESULT.S")) {
                    filter.append(filterItemInfo.toString());
                } else {
                    PropertyInfo propInfo = this.getPropertyInfoFullPath(configInfo, filterItemInfo.getPropertyName());
                    if (!CompareType.EXISTS.equals((Object)type) && !CompareType.NOTEXISTS.equals((Object)type)) {
                        if (this.param.isHistoryMode() && "longNumber".equalsIgnoreCase(propInfo.getName()) && "com.kingdee.eas.basedata.org.app.AdminOrgUnit".equalsIgnoreCase(configInfo.getEntityName())) {
                            this.appendQueAdminHis(filter, configInfo, "T", "FLongNumber ", null);
                        } else if (this.param.isHistoryMode() && "displayName".equalsIgnoreCase(propInfo.getName()) && "com.kingdee.eas.basedata.org.app.AdminOrgUnit".equalsIgnoreCase(configInfo.getEntityName())) {
                            this.appendQueAdminHis(filter, configInfo, "T", "FDisplayName" + MLUtile.getMlFlag(this.ctx) + " ", null);
                        } else {
                            filter.append(this.getColumnName(this.historyReplayColumn, configInfo, filterItemInfo.getPropertyName()));
                        }
                    }
                    if (filterItemInfo.isCompareValueIsProperty()) {
                        filter.append(filterItemInfo.getCompareExpression());
                        String propertyValue = filterItemInfo.getCompareValue().toString();
                        StructureConfigInfo propertyConfigInfo = StructureConfigConvertHelper.getStructureConfigByKey((Context)this.ctx, (String)propertyValue, (String)this.param.getScheme());
                        if (this.param.isHistoryMode() && "longNumber".equalsIgnoreCase(propInfo.getName()) && "com.kingdee.eas.basedata.org.app.AdminOrgUnit".equalsIgnoreCase(configInfo.getEntityName())) {
                            this.appendQueAdminHis(filter, configInfo, "T", "FLongNumber ", null);
                        } else if (this.param.isHistoryMode() && "displayName".equalsIgnoreCase(propInfo.getName()) && "com.kingdee.eas.basedata.org.app.AdminOrgUnit".equalsIgnoreCase(configInfo.getEntityName())) {
                            this.appendQueAdminHis(filter, configInfo, "T", "FDisplayName" + MLUtile.getMlFlag(this.ctx) + " ", null);
                        } else {
                            filter.append(this.getColumnName(this.historyReplayColumn, propertyConfigInfo, propertyValue));
                        }
                    } else {
                        this.appendClouse(filter, value, type, filterItemInfo, propInfo);
                    }
                }
                if (StringUtils.isEmpty((String)format)) {
                    whereSql.append(filter);
                    if (i >= filtersCount - 1) continue;
                    whereSql.append(" AND ");
                    continue;
                }
                format = StringUtils.replace((String)format, (String)("~9^Nz" + i + "~9^Nz"), (String)filter.toString());
            }
            if (format != null) {
                whereSql.append(format);
            }
        }
        String permissionFilter = this.generatePermissionRangeFilter();
        if (StringUtils.isEmpty((String)whereSql.toString())) {
            if (!StringUtils.isEmpty((String)permissionFilter)) {
                whereSql.append("\n").append(permissionFilter);
            }
        } else if (!StringUtils.isEmpty((String)permissionFilter)) {
            whereSql.append("\n").append(" AND ").append(permissionFilter);
        }
        long endPrepareTime = System.currentTimeMillis();
        logger.error((Object)("Ats dynamic assembleSQLWhere sql cost: " + (endPrepareTime - startPrepareTime)));
        return whereSql.toString();
    }

    protected String generateOneColumn(String column, String alias) throws EASBizException, BOSException {
        String scheme = this.param.getScheme();
        String[] keys = column.split("\\.");
        StringBuffer selectColumnString = new StringBuffer();
        if (keys.length == 1 || keys[1].matches("(?i)s\\d+")) {
            if ("_row_index".equalsIgnoreCase(alias)) {
                return "";
            }
            selectColumnString.append(" ").append(column).append(" AS ").append(this.appendQuo(alias)).append(" ");
            return selectColumnString.toString();
        }
        return super.generateOneColumn(column, alias);
    }

    protected boolean pupolateColumnAndDateTypesFhandler0(int k, String key, String fieldStr, PropertyInfo[] props, String[] columns, int[] datetypes, Map<String, Integer> dataTypeValueMap, Map<String, String> originMap) {
        if ("010ATS".equalsIgnoreCase(this.param.getScheme())) {
            if (key.equals("ATTENDANCEFILEHIS.PROPOSER.ID")) {
                return Boolean.TRUE;
            }
            if (fieldStr.matches("(?i)s\\d+")) {
                OwnPropertyInfo propInfo = new OwnPropertyInfo();
                propInfo.setName(fieldStr);
                if (null != dataTypeValueMap.get(fieldStr.toLowerCase())) {
                    if (dataTypeValueMap.get(fieldStr.toLowerCase()) == 1) {
                        propInfo.setDataType(DataType.INTEGER);
                    } else if (dataTypeValueMap.get(fieldStr.toLowerCase()) == 2) {
                        propInfo.setDataType(DataType.FLOAT);
                    } else if (dataTypeValueMap.get(fieldStr.toLowerCase()) == 3) {
                        propInfo.setDataType(DataType.STRING);
                    } else if (dataTypeValueMap.get(fieldStr.toLowerCase()) == 4) {
                        propInfo.setDataType(DataType.BOOLEAN);
                    } else if (dataTypeValueMap.get(fieldStr.toLowerCase()) == 5) {
                        propInfo.setDataType(DataType.TIMESTAMP);
                    } else {
                        propInfo.setDataType(DataType.DECIMAL);
                    }
                } else {
                    propInfo.setDataType(DataType.STRING);
                }
                props[k - 1] = propInfo;
                columns[k - 1] = originMap.get(key.toUpperCase().toString());
                datetypes[k - 1] = propInfo.getDataType().getSQLType(true).getSQLType();
                return Boolean.TRUE;
            }
        }
        return Boolean.FALSE;
    }

    protected void pupolateCnSnOSFHandler(Map<String, Object> cnSn, Map<String, Integer> dataTypeValueMap, Map<String, String> labCostTypeNumberFieldMap) throws EASBizException, BOSException {
        if ("010ATS".equalsIgnoreCase(this.param.getScheme())) {
            HashMap<String, String> filterParam = new HashMap<String, String>();
            filterParam.put("permItemId", this.param.getPermItemId());
            try {
                long startCNSNTime = System.currentTimeMillis();
                cnSn = AtsAttendanceProjectUtil.getCnSn(this.ctx, null, filterParam);
                logger.error((Object)("Ats dynamic pupolateCnSnOSF cost: " + (System.currentTimeMillis() - startCNSNTime)));
            }
            catch (EASBizException e) {
                e.printStackTrace();
            }
            catch (BOSException e) {
                e.printStackTrace();
            }
            if (null != cnSn) {
                dataTypeValueMap.putAll((Map)cnSn.get("dataTypeValueMap"));
            }
        }
    }

    protected OwnPropertyInfo getAtsPropertyInfo(StructureConfigInfo clientInfo, String propertyName) throws EASBizException, BOSException {
        Map dataTypeValueMap = new HashMap();
        Map cnMap = new HashMap();
        HashMap filterParam = new HashMap();
        Map cnSn = null;
        try {
            new AtsAttendanceProjectUtil();
            cnSn = AtsAttendanceProjectUtil.getCnSn(this.ctx, this.param.getScheme(), filterParam);
        }
        catch (EASBizException e) {
            e.printStackTrace();
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        if (null != cnSn) {
            dataTypeValueMap = (Map)cnSn.get("dataTypeValueMap");
            cnMap = (Map)cnSn.get("cnMap");
        }
        String alias = "";
        String name = propertyName;
        DataType dataType = DataType.INTEGER;
        SQLType sqlType = SQLType.NUMERIC;
        OwnPropertyInfo propInfo = new OwnPropertyInfo();
        if (propertyName.matches("(?i)s\\d+")) {
            alias = (String)cnMap.get(propertyName);
            name = propertyName;
            if (null == dataTypeValueMap.get(propertyName)) {
                return null;
            }
            if ((Integer)dataTypeValueMap.get(propertyName) == 1) {
                dataType = DataType.STRING;
                sqlType = SQLType.NCLOB;
            } else {
                dataType = DataType.INTEGER;
                sqlType = SQLType.NUMERIC;
            }
        }
        if (StringUtils.isEmpty((String)name) || StringUtils.isEmpty((String)alias)) {
            return null;
        }
        propInfo.setAlias(alias);
        propInfo.setName(name);
        propInfo.setDataType(dataType);
        ColumnInfo mappingField = new ColumnInfo();
        mappingField.setAlias(alias);
        mappingField.setName(name);
        mappingField.setTypeName(sqlType);
        propInfo.setMappingField(mappingField);
        return propInfo;
    }
}

