/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.ats.calculate.time.dataPrepare.impl;

import com.kingdee.eas.hr.ats.AtsShiftInfo;
import com.kingdee.eas.hr.ats.WorkCalendarItemInfo;
import com.kingdee.eas.hr.ats.calculate.AtsCalculateTimeUtil;
import com.kingdee.eas.hr.ats.calculate.time.dataPrepare.DataPrepareService;
import com.kingdee.eas.hr.ats.calculate.time.util.CalTimeUtil;
import com.kingdee.eas.hr.ats.calculate.time.vo.TimeDataVO;
import com.kingdee.eas.hr.ats.function.AtsCalFunctionUtil;
import com.kingdee.eas.hr.ats.result.AttendanceDynamicResInfo;
import com.kingdee.eas.hr.ats.util.AtsDateUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DataPrepareServiceImpl
implements DataPrepareService {
    @Override
    public TimeDataVO getTimeDataVO(Map paramMap, String personId, String attendDate, String label) {
        Map offsiteEntry;
        TimeDataVO dataVO = new TimeDataVO();
        dataVO.setLabel(label);
        String key = personId + "_" + attendDate;
        Map globalMap = (Map)paramMap.get("globalMapKey");
        switch (label) {
            case "leave": {
                Map leaveBillEntryMap = (Map)globalMap.get("T_HR_ATS_LeaveBillEntry");
                if (null != leaveBillEntryMap && leaveBillEntryMap.size() > 0) {
                    List leaveBillEntryList = (List)leaveBillEntryMap.get(key);
                    dataVO.setCoreBaseInfoList(leaveBillEntryList);
                    dataVO.setDate(attendDate);
                    AtsShiftInfo atsShiftInfo = AtsCalFunctionUtil.getAtsShiftInfo(paramMap);
                    HashMap<String, AtsShiftInfo> atsShiftMap = new HashMap<String, AtsShiftInfo>();
                    atsShiftMap.put(personId + "_" + dataVO.getDate(), atsShiftInfo);
                    dataVO.setAtsShiftMap(atsShiftMap);
                }
                return dataVO;
            }
            case "trip": {
                Map tripBillEntryMap = (Map)globalMap.get("T_HR_ATS_TripBillEntry");
                if (null != tripBillEntryMap && tripBillEntryMap.size() > 0) {
                    List tripBillEntryList = (List)tripBillEntryMap.get(key);
                    dataVO.setCoreBaseInfoList(tripBillEntryList);
                    AtsShiftInfo atsShiftInfo = AtsCalFunctionUtil.getAtsShiftInfo(paramMap);
                    HashMap<String, AtsShiftInfo> atsShiftMap = new HashMap<String, AtsShiftInfo>();
                    atsShiftMap.put(personId + "_" + dataVO.getDate(), atsShiftInfo);
                    dataVO.setAtsShiftMap(atsShiftMap);
                    dataVO.setDate(attendDate);
                }
                return dataVO;
            }
            case "outShift": {
                Map tripBillEntryMap = (Map)globalMap.get("T_HR_ATS_TripBillEntry");
                if (null != tripBillEntryMap && tripBillEntryMap.size() > 0) {
                    List tripBillEntryList = (List)tripBillEntryMap.get(key);
                    dataVO.setCoreBaseInfoList(tripBillEntryList);
                    dataVO.setDate(attendDate);
                    dataVO.setHeadTailOutTime(AtsCalculateTimeUtil.getHeadTailOutTimeLableModel(globalMap, personId, attendDate));
                    AtsShiftInfo atsShiftInfo = AtsCalFunctionUtil.getAtsShiftInfo(paramMap);
                    HashMap<String, AtsShiftInfo> atsShiftMap = new HashMap<String, AtsShiftInfo>();
                    atsShiftMap.put(personId + "_" + dataVO.getDate(), atsShiftInfo);
                    dataVO.setAtsShiftMap(atsShiftMap);
                }
                return dataVO;
            }
            case "ot": 
            case "otRest": {
                Map atsOverTimeBillMap = (Map)globalMap.get("T_HR_ATS_OverTimeBillEntry");
                if (null != atsOverTimeBillMap) {
                    List overTimeBillEntryInfoList = (List)atsOverTimeBillMap.get(key);
                    dataVO.setCoreBaseInfoList(overTimeBillEntryInfoList);
                    dataVO.setDate(attendDate);
                }
                return dataVO;
            }
            case "card": {
                AttendanceDynamicResInfo dynamicResInfo = AtsCalFunctionUtil.getAttendanceDynamicResInfo(globalMap, personId, attendDate);
                ArrayList<AttendanceDynamicResInfo> coreBaseInfoList = new ArrayList<AttendanceDynamicResInfo>();
                coreBaseInfoList.add(dynamicResInfo);
                dataVO.setCoreBaseInfoList(coreBaseInfoList);
                dataVO.setDate(attendDate);
                return dataVO;
            }
            case "inSideCard": {
                AttendanceDynamicResInfo dynamicResInfo = AtsCalFunctionUtil.getAttendanceDynamicResInfo(globalMap, personId, attendDate);
                ArrayList<AttendanceDynamicResInfo> coreBaseInfoList = new ArrayList<AttendanceDynamicResInfo>();
                coreBaseInfoList.add(dynamicResInfo);
                dataVO.setCoreBaseInfoList(coreBaseInfoList);
                dataVO.setDate(attendDate);
                dataVO.setPunchCardRecordInfoList(CalTimeUtil.getPunchardRecordList(globalMap, personId, attendDate));
                return dataVO;
            }
            case "outSideCard": {
                AttendanceDynamicResInfo dynamicResInfo = AtsCalFunctionUtil.getAttendanceDynamicResInfo(globalMap, personId, attendDate);
                ArrayList<AttendanceDynamicResInfo> coreBaseInfoList = new ArrayList<AttendanceDynamicResInfo>();
                coreBaseInfoList.add(dynamicResInfo);
                dataVO.setCoreBaseInfoList(coreBaseInfoList);
                dataVO.setDate(attendDate);
                dataVO.setPunchCardRecordInfoList(CalTimeUtil.getPunchardRecordList(globalMap, personId, attendDate));
                return dataVO;
            }
            case "shift": 
            case "rest": {
                AtsShiftInfo atsShiftInfo = AtsCalFunctionUtil.getAtsShiftInfo(paramMap);
                if (null != atsShiftInfo) {
                    ArrayList<AtsShiftInfo> coreBaseInfoList = new ArrayList<AtsShiftInfo>();
                    coreBaseInfoList.add(atsShiftInfo);
                    dataVO.setCoreBaseInfoList(coreBaseInfoList);
                    dataVO.setDate(attendDate);
                }
                return dataVO;
            }
            case "soffday": 
            case "sholidayday": 
            case "sworkday": {
                String preDate = AtsDateUtils.getPreDay(attendDate);
                String nextDate = AtsDateUtils.getNextDay(attendDate);
                AtsShiftInfo atsShiftInfo = AtsCalFunctionUtil.getAtsShiftInfo(paramMap);
                if (null != atsShiftInfo) {
                    HashMap<String, AtsShiftInfo> atsShiftMap = new HashMap<String, AtsShiftInfo>();
                    atsShiftMap.put(personId + "_" + attendDate, atsShiftInfo);
                    dataVO.setAtsShiftMap(atsShiftMap);
                    ArrayList<AtsShiftInfo> coreBaseInfoList = new ArrayList<AtsShiftInfo>();
                    coreBaseInfoList.add(atsShiftInfo);
                    dataVO.setCoreBaseInfoList(coreBaseInfoList);
                    dataVO.setDate(attendDate);
                }
                return dataVO;
            }
            case "coffday": 
            case "cholidayday": 
            case "cworkday": {
                ArrayList<WorkCalendarItemInfo> coreBaseInfoList = new ArrayList<WorkCalendarItemInfo>();
                WorkCalendarItemInfo currentWorkCalendarItemInfo = AtsCalFunctionUtil.getWorkCalendarItemInfo(paramMap, personId, attendDate);
                if (null != currentWorkCalendarItemInfo) {
                    coreBaseInfoList.add(currentWorkCalendarItemInfo);
                }
                dataVO.setCoreBaseInfoList(coreBaseInfoList);
                dataVO.setDate(attendDate);
                return dataVO;
            }
            case "other": {
                return dataVO;
            }
        }
        if (label.startsWith("offsite") && null != (offsiteEntry = (Map)globalMap.get("T_ATS_AtsOffsite")) && offsiteEntry.size() > 0) {
            List offsiteEntryList = (List)offsiteEntry.get(key);
            dataVO.setCoreBaseInfoList(offsiteEntryList);
            AtsShiftInfo atsShiftInfo = AtsCalFunctionUtil.getAtsShiftInfo(paramMap);
            HashMap<String, AtsShiftInfo> atsShiftMap = new HashMap<String, AtsShiftInfo>();
            atsShiftMap.put(personId + "_" + dataVO.getDate(), atsShiftInfo);
            dataVO.setAtsShiftMap(atsShiftMap);
            dataVO.setDate(attendDate);
        }
        return dataVO;
    }
}

