/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.ats.calculate.time.dataProcess.impl;

import com.kingdee.eas.hr.ats.AtsShiftInfo;
import com.kingdee.eas.hr.ats.AtsShiftItemCollection;
import com.kingdee.eas.hr.ats.calculate.time.dataProcess.impl.BaseTimeDataProcess;
import com.kingdee.eas.hr.ats.calculate.time.model.TimeLabelModel;
import com.kingdee.eas.hr.ats.calculate.time.vo.TimeDataVO;
import com.kingdee.eas.hr.ats.util.AtsDateUtils;
import com.kingdee.eas.hr.ats.util.FetchCardUtil;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;

public class ShiftTimeDataProcessImpl
extends BaseTimeDataProcess {
    @Override
    public List<TimeLabelModel> process(TimeDataVO timeDataVO) {
        List coreBaseInfoList = timeDataVO.getCoreBaseInfoList();
        ArrayList<TimeLabelModel> timeLabelModels = new ArrayList<TimeLabelModel>();
        AtsShiftInfo shiftInfo = null;
        if (null == coreBaseInfoList || coreBaseInfoList.size() <= 0) {
            return timeLabelModels;
        }
        shiftInfo = (AtsShiftInfo)coreBaseInfoList.get(0);
        String date = timeDataVO.getDate();
        String oneOnTimeSchedule = FetchCardUtil.getShiftTime(shiftInfo, date, "1,1");
        String oneOffTimeSchedule = FetchCardUtil.getShiftTime(shiftInfo, date, "1,2");
        String twoOnTimeSchedule = FetchCardUtil.getShiftTime(shiftInfo, date, "2,1");
        String twoOffTimeSchedule = FetchCardUtil.getShiftTime(shiftInfo, date, "2,2");
        String threeOnTimeSchedule = FetchCardUtil.getShiftTime(shiftInfo, date, "3,1");
        String threeOffTimeSchedule = FetchCardUtil.getShiftTime(shiftInfo, date, "3,2");
        String oneOnePreRestTime = FetchCardUtil.getShiftRestTime(shiftInfo, date, "1,1");
        String oneOneNextRestTime = FetchCardUtil.getShiftRestTime(shiftInfo, date, "1,2");
        if (null != shiftInfo && shiftInfo.getItems() != null) {
            AtsShiftItemCollection shiftItems = shiftInfo.getItems();
            for (int i = 0; i < shiftItems.size(); ++i) {
                if (timeDataVO.getLabel() != null && timeDataVO.getLabel().equals("rest") && StringUtils.isNotBlank((String)oneOnePreRestTime) && StringUtils.isNotBlank((String)oneOneNextRestTime) && !oneOnePreRestTime.equals(oneOneNextRestTime)) {
                    timeLabelModels.add(new TimeLabelModel(AtsDateUtils.stringToTimestamp(oneOnePreRestTime), AtsDateUtils.stringToTimestamp(oneOneNextRestTime), "rest"));
                }
                if (i == 0 && timeDataVO.getLabel() != null && timeDataVO.getLabel().equals("shift")) {
                    timeLabelModels.add(new TimeLabelModel(AtsDateUtils.stringToTimestamp(oneOnTimeSchedule), AtsDateUtils.stringToTimestamp(oneOffTimeSchedule), "shift"));
                    continue;
                }
                if (i == 1 && timeDataVO.getLabel() != null && timeDataVO.getLabel().equals("shift")) {
                    timeLabelModels.add(new TimeLabelModel(AtsDateUtils.stringToTimestamp(twoOnTimeSchedule), AtsDateUtils.stringToTimestamp(twoOffTimeSchedule), "shift"));
                    continue;
                }
                if (i != 2 || timeDataVO.getLabel() == null || !timeDataVO.getLabel().equals("shift")) continue;
                timeLabelModels.add(new TimeLabelModel(AtsDateUtils.stringToTimestamp(threeOnTimeSchedule), AtsDateUtils.stringToTimestamp(threeOffTimeSchedule), "shift"));
            }
        }
        return timeLabelModels;
    }
}

