/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.ats.calculate.time.factory;

import com.kingdee.eas.hr.ats.calculate.time.dataProcess.TimeDataProcess;
import com.kingdee.eas.hr.ats.calculate.time.dataProcess.impl.CalendarDayTypeDataProcessImpl;
import com.kingdee.eas.hr.ats.calculate.time.dataProcess.impl.CardTimeDataProcessImpl;
import com.kingdee.eas.hr.ats.calculate.time.dataProcess.impl.InSideCardTimeDataProcessImpl;
import com.kingdee.eas.hr.ats.calculate.time.dataProcess.impl.LeaveTimeDataProcessImpl;
import com.kingdee.eas.hr.ats.calculate.time.dataProcess.impl.OffsiteTimeDataProcessImpl;
import com.kingdee.eas.hr.ats.calculate.time.dataProcess.impl.OtherTimeDataProcessImpl;
import com.kingdee.eas.hr.ats.calculate.time.dataProcess.impl.OutSideCardTimeDataProcessImpl;
import com.kingdee.eas.hr.ats.calculate.time.dataProcess.impl.OverTimeDataProcessImpl;
import com.kingdee.eas.hr.ats.calculate.time.dataProcess.impl.ShiftDayTypeDataProcessImpl;
import com.kingdee.eas.hr.ats.calculate.time.dataProcess.impl.ShiftTimeDataProcessImpl;
import com.kingdee.eas.hr.ats.calculate.time.dataProcess.impl.TripOutShiftTimeDataProcessImpl;
import com.kingdee.eas.hr.ats.calculate.time.dataProcess.impl.TripTimeDataProcessImpl;

public class DataProcessFactory {
    public TimeDataProcess createTimeDataProcess(String label) {
        switch (label) {
            case "leave": {
                return new LeaveTimeDataProcessImpl();
            }
            case "trip": {
                return new TripTimeDataProcessImpl();
            }
            case "ot": 
            case "otRest": {
                return new OverTimeDataProcessImpl();
            }
            case "card": {
                return new CardTimeDataProcessImpl();
            }
            case "inSideCard": {
                return new InSideCardTimeDataProcessImpl();
            }
            case "outSideCard": {
                return new OutSideCardTimeDataProcessImpl();
            }
            case "shift": 
            case "rest": {
                return new ShiftTimeDataProcessImpl();
            }
            case "outShift": {
                return new TripOutShiftTimeDataProcessImpl();
            }
            case "other": {
                return new OtherTimeDataProcessImpl();
            }
            case "soffday": 
            case "sholidayday": 
            case "sworkday": {
                return new ShiftDayTypeDataProcessImpl();
            }
            case "coffday": 
            case "cholidayday": 
            case "cworkday": {
                return new CalendarDayTypeDataProcessImpl();
            }
        }
        if (label.startsWith("offsite")) {
            return new OffsiteTimeDataProcessImpl();
        }
        return new OtherTimeDataProcessImpl();
    }

    public static DataProcessFactory getInstance() {
        return new DataProcessFactory();
    }
}

