/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.ats.calculate.time.strategy.impl;

import com.kingdee.eas.hr.ats.calculate.time.label.LabelCalculatorService;
import com.kingdee.eas.hr.ats.calculate.time.label.impl.BaseLabelCalculatorServiceImpl;
import com.kingdee.eas.hr.ats.calculate.time.model.TimeLabelListModel;
import com.kingdee.eas.hr.ats.calculate.time.model.TimeLabelModel;
import com.kingdee.eas.hr.ats.calculate.time.strategy.CalculatorStrategy;
import com.kingdee.eas.hr.ats.util.AtsDateUtils;
import java.util.ArrayList;
import java.util.List;

public class BaseCalculatorStrategy
implements CalculatorStrategy {
    LabelCalculatorService calculatorService;

    @Override
    public double calculate(List<TimeLabelModel> timeLabelModels, List<String> labels, List<String> excludeLabels) {
        List<TimeLabelListModel> timeLabelListModels = this.segmentMark(timeLabelModels, labels, excludeLabels);
        double intersectTime = 0.0;
        if (null != timeLabelListModels && timeLabelListModels.size() > 0) {
            for (TimeLabelListModel timeLabelListModel : timeLabelListModels) {
                intersectTime += AtsDateUtils.getTwoTimeDiffMinutes(timeLabelListModel.getBeginTime(), timeLabelListModel.getEndTime());
            }
        }
        return intersectTime;
    }

    @Override
    public List<TimeLabelListModel> segmentMark(List<TimeLabelModel> timeLabelModels, List<String> labels, List<String> excludeLabels) {
        if (null == timeLabelModels || timeLabelModels.isEmpty()) {
            return null;
        }
        List<TimeLabelListModel> timeLabelListModels = this.getCalculatorService().seperateSegment(timeLabelModels);
        timeLabelListModels = this.getCalculatorService().markSegment(timeLabelModels, timeLabelListModels);
        if (null == timeLabelListModels || timeLabelListModels.isEmpty()) {
            return null;
        }
        ArrayList<TimeLabelListModel> result = new ArrayList<TimeLabelListModel>();
        for (TimeLabelListModel timeLabelListModel : timeLabelListModels) {
            if (null == timeLabelListModel.getLabels() || null == labels || !timeLabelListModel.getLabels().containsAll(labels)) continue;
            boolean excludeLabelsCheck = true;
            if (excludeLabels != null && excludeLabels.size() > 0) {
                for (int i = 0; i < excludeLabels.size(); ++i) {
                    if (!timeLabelListModel.getLabels().contains(excludeLabels.get(i))) continue;
                    excludeLabelsCheck = false;
                    break;
                }
            }
            if (!excludeLabelsCheck) continue;
            result.add(timeLabelListModel);
        }
        return result;
    }

    @Override
    public LabelCalculatorService getCalculatorService() {
        if (this.calculatorService == null) {
            return new BaseLabelCalculatorServiceImpl();
        }
        return this.calculatorService;
    }

    @Override
    public void setCalculatorService(LabelCalculatorService calculatorService) {
        this.calculatorService = calculatorService;
    }
}

