/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.ats.dataLog.service.impl;

import com.kingdee.bos.Context;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.hr.ats.AtsLimitDataLogFactory;
import com.kingdee.eas.hr.ats.AtsLimitDataLogInfo;
import com.kingdee.eas.hr.ats.DataLogBaseInfo;
import com.kingdee.eas.hr.ats.HolidayPolicyInfo;
import com.kingdee.eas.hr.ats.dataLog.observer.LogObserver;
import com.kingdee.eas.hr.ats.dataLog.observer.impl.AtsLimitDataLogObserver;
import com.kingdee.eas.hr.ats.dataLog.pool.AtsDataLogPool;
import com.kingdee.eas.hr.ats.dataLog.service.DataLogService;
import com.kingdee.eas.hr.ats.dataLog.service.impl.AtsBillDataLogServiceImpl;
import com.kingdee.eas.hr.ats.dataLog.util.DataLogUtil;
import com.kingdee.shr.base.syssetting.app.filter.HRFilterUtils;
import java.sql.Timestamp;
import java.util.Date;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class AtsLimitDataLogServiceImpl
implements DataLogService {
    private static Logger logger = Logger.getLogger(AtsBillDataLogServiceImpl.class);

    @Override
    public void recordLog(final LogObserver observer) {
        Runnable logTask = new Runnable(){

            @Override
            public void run() {
                AtsLimitDataLogServiceImpl.this.saveDataLog(observer);
            }
        };
        AtsDataLogPool.getPool().execute(logTask);
    }

    @Override
    public boolean saveDataLog(LogObserver observer) {
        try {
            AtsLimitDataLogInfo dataLogInfo = (AtsLimitDataLogInfo)this.assembleDataLog(observer);
            if (null != dataLogInfo) {
                AtsLimitDataLogFactory.getLocalInstance(observer.getCtx()).addnew((DataLogBaseInfo)dataLogInfo);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error((Object)("save dataLogInfo error, observer objectId:" + observer.getObjectId() + ",error message:" + e.getMessage()));
            return false;
        }
        return true;
    }

    @Override
    public DataLogBaseInfo assembleDataLog(LogObserver observer) {
        if (null == observer.getCtx() || null == observer) {
            return null;
        }
        AtsLimitDataLogObserver logObserver = (AtsLimitDataLogObserver)observer;
        AtsLimitDataLogInfo dataLog = new AtsLimitDataLogInfo();
        try {
            dataLog.setObjectId(logObserver.getObjectId());
            dataLog.setBillId(logObserver.getBillId());
            dataLog.setBillNum(logObserver.getBillNum());
            dataLog.setEntryId(logObserver.getEntryId());
            dataLog.setOperType(logObserver.getOperType());
            dataLog.setOperAction(logObserver.getOperAction());
            dataLog.setObjectOldDesc(logObserver.getObjectOldDesc());
            dataLog.setObjectDesc(logObserver.getObjectDesc());
            if (StringUtils.isNotEmpty((String)logObserver.getPersonId())) {
                PersonInfo person = new PersonInfo();
                person.setId(BOSUuid.read((String)logObserver.getPersonId()));
                dataLog.setPerson(person);
            }
            if (StringUtils.isNotEmpty((String)logObserver.getHolidayPolicyId())) {
                HolidayPolicyInfo holidayPolicy = new HolidayPolicyInfo();
                holidayPolicy.setId(BOSUuid.read((String)logObserver.getHolidayPolicyId()));
                dataLog.setHolidayPolicy(holidayPolicy);
            }
            dataLog.setCreateTime(new Timestamp(System.currentTimeMillis()));
            String creatorId = HRFilterUtils.getCurrentUserId((Context)observer.getCtx());
            UserInfo user = new UserInfo();
            user.setId(BOSUuid.read((String)creatorId));
            dataLog.setCreator(user);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return dataLog;
    }

    @Override
    public boolean deleteDataLogDateAgo(Context ctx, Date date) {
        return DataLogUtil.deleteDataLogDateAgo(ctx, date, "T_HR_ATS_LIMITDATALOG");
    }
}

